
@extends('layouts.app')

@section('title')

Cash Flow Statement Report 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Cash Flow Statement Statement</li>
      </ol>
@stop

@section('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endsection


@section('content')
    <!-- Main content -->
    <section class="container-fluid">
       <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Cash Flow Statement</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                      <form class="form-horizontal" method='post' action="{{route('report.cash-flow-statement.generate')}}">
                                        {{ csrf_field() }}
                                        <div class="form-body">
                                          <div class="row">

                                            @can('isSuperAdmin')
                                            @include('partial.multiproject_forsomereport')
                                              @endcan
                                            <!--/span-->
                                        </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                      <label class="control-label">By Date</label>
                                                        <div class="input-group">
                                                          <div class="input-group-addon">
                                                            <i class="fa fa-calendar"></i>
                                                          </div>
                                                        <input type="text" class="form-control" id="daterange-btn" value='{{old('date_range')}}' name='date_range'>
                                                        @if($errors->has('date_range'))
                                                            <span class="help-block" >
                                                                <strong>{{ $errors->first('date_range') }}</strong>
                                                            </span>
                                                        @endif

                                                      </div>
                                                         </div>
                                                </div>
                                                <!--/span-->

                                                 <div class="clearfix"></div>

                                                <div class="col-md-6">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                      <label class="control-label">Type</label>
                                                        <div class="input-group">
                                                          <div class="input-group-addon">
                                                            <i class="fa fa-calendar"></i>
                                                          </div>
                                                        <select class="form-control chosen-select" name="level">
                                                            <option value="1" selected=""> Level 1</option>
                                                            <option value="2"> Level 2</option>
                                                            <option value="3"> Level 3</option>
                                                            
                                                        </select>
                                                        @if($errors->has('level'))
                                                            <span class="help-block" >
                                                                <strong>{{ $errors->first('level') }}</strong>
                                                            </span>
                                                        @endif

                                                      </div>
                                                         </div>
                                                </div>
                                                
                                            </div>
                                            
                                        </div>
                                        <div class="form-actions">
                                            <button type="submit" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Generate</button>
                                            </form>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->
                @stop

    @section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script>
const year = new Date().getFullYear();

  const this_fiscal_year_start_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const last_fiscal_year_end_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  


$('#daterange-btn').daterangepicker(
        {
           
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Fiscal Year' : [this_fiscal_year_start_date,this_fiscal_year_end_date],
            'Last Fiscal Year' : [last_fiscal_year_start_date,last_fiscal_year_end_date]
          },
          startDate: moment().subtract(29, 'days'),
          endDate: moment()
        },
        function (start, end) {
          $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }
    );
</script>
    <!--Accordian-->


   @stop