@extends('layouts.app')

@section('title')
Cash Flow Statement
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Cash Flow Statement</li>
      </ol>
@stop
@section('css')
<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<style type="text/css">

    .bg-grey {
        background-color: #efefef;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }

    @media print {
        
     .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        color: black !important;
        }
        
    .bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
     table.dataTable tbody td, table.dataTable tbody th {
    padding: 2px 4px !important;
    font-size: 12px;
    }
    table.dataTable{
        border:none;
        border-collapse: collapse !important;
    }

    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }
    table.dataTable thead td, table.dataTable thead th {
    border-bottom: none !important;
    }
  table.dataTable.no-footer {
    border-bottom: none !important;
    }
    a{
        color: black !important
    }
     h3 strong{
        text-transform: uppercase;
        color: black !important
    }
    h4 strong{
        text-transform: uppercase;
        color: black !important
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    .white-box1{
        padding: 0;
    }
    }
</style>

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop
@section('content')

<div class="container-fluid">


    

    <div class="white-box  printableArea" style="text-align: center;" id="update-report">
        <h3><strong>
            @foreach($project_names as $key => $project_name)
            {{ $project_name }}
            @if($key < count($project_names) - 1)
                , 
            @endif
        @endforeach    
        
        </strong></h3>
        <h4 ><strong>Statement of Cash Flows</strong></h4>
        <h6>{{date('d/m/Y',strtotime($from))}} - {{date('d/m/Y',strtotime($to))}}</h6>
        

     

        <div class="row">
        

        <div class="col-md-12 pro-cart" >
        	<table id="example1"  cellpadding="3" cellspacing="3">
                     <thead>
                        <th></th>
                        <th width="100"></th>
                     </thead>
                     <tbody>
                     <tr class="bg-grey btm-margin">
                            <th class="pd-5"   >OPERATING ACTIVITES</th> 
                            <th></th>
                         </tr>

                         <?php $oper_total = 0;?>

                         <tr >
                            <td class="pd-5"  style=" text-align: left;">Net Income</td> 
                            <td class="text-right">
                                @if($netIncome < 0)
                                ({{number_format(abs($netIncome))}})
                                @else
                                {{$netIncome > 0? number_format($netIncome) : '-'}}
                                @endif</td>
                            
                         </tr>

                         <tr class="bg-grey btm-margin">
                            <td class="pd-5"  style=" text-align: left;"><b>to net cash provided by operations:</b></td> 
                            <td></td>
                        
                         </tr>

                         @foreach($accountReceivable as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5"  style=" text-align: left;">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $oper_total += ($account['sum'] * -1);?>
                         @endif

                         @endforeach

                         @foreach($otherCurrentAsset as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5"  style=" text-align: left;">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $oper_total += ($account['sum'] * -1);?>
                         @endif

                         @endforeach

                         @foreach($accountPayable as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5"  style=" text-align: left;">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">@if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif</a></td>
                         </tr>
                         <?php $oper_total += ($account['sum'] * -1);?>
                         @endif

                         @endforeach

                         @foreach($otherCurrentLiability as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5"  style=" text-align: left;">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $oper_total += ($account['sum'] * -1);?>
                         @endif

                         @endforeach


                         <?php $oper_total = $netIncome + $oper_total;?>


                          <tr class="bg-green btm-margin" >
                            <td class="pd-5 text-left" ><b>Net Cash Provided by Operating Activities</b></td> 
                            <td class="text-right" style="border-top:1px solid;border-bottom: double;"><b>
                                @if($oper_total < 0)
                                ({{number_format(abs($oper_total))}})
                                @else
                                {{$oper_total> 0? number_format($oper_total) : '-'}}
                                @endif</b></td>
                            
                         </tr>


                         <tr class="bg-grey btm-margin">
                            <th class="pd-5"   >INVESTING ACTIVITES</th> 
                            <th></th>
                         </tr>

                         <?php $invest_total = 0;?>

                         @foreach($fixedAsset as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5"  style=" text-align: left;">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $invest_total += ($account['sum'] * -1);?>
                         @endif

                         @endforeach

                         


                         <tr class="bg-green btm-margin" >
                            <td class="pd-5 text-left"><b>Net Cash Provided by Investing Activities</b></td> 
                            <td class="text-right" style="border-bottom: double;border-top: 1px solid"><b>
                                @if($invest_total < 0)
                                ({{number_format(abs($invest_total))}})
                                @else
                                {{$invest_total> 0? number_format($invest_total) : '-'}}
                                @endif</b></td>
                            
                         </tr>



                         <tr class="bg-grey btm-margin">
                            <th class="pd-5">FINANCING ACTIVITES</th> 
                            <th></th>
                         </tr>

                         <?php $fin_total = 0;?>

                         @foreach($equity as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5 text-left">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $fin_total += ($account['sum'] * -1);?>
                         @endif

                         @endforeach

                         @foreach($longTermLiability as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5 text-left">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $fin_total += ($account['sum'] * -1);?>
                         @endif

                         @endforeach


                         <tr class="bg-green btm-margin">
                            <td class="pd-5 text-left"><b>Net Cash Provided by Financing Activities</b></td> 
                            <td class="text-right"  style="border-bottom: double;border-top: 1px solid"><b>
                                @if($fin_total < 0)
                                ({{number_format(abs($fin_total))}})
                                @else
                                {{$fin_total> 0? number_format($fin_total) : '-'}}
                                @endif
                            </b></td>
                        
                         </tr>

                         <tr class="bg-grey btm-margin">
                            <td class="pd-5 text-left" ><b>Net Cash increase for period</b></td> 
                            <td class="text-right"  style="border-top:1px solid;border-bottom: double;"><b>{{number_format($fin_total + $invest_total + $oper_total)}}</b></td>
                        
                         </tr>
				 </tbody>
			</table>

        </div>
    </div>
    </div>
    <div class="text-right" style="height:70px;">
                                         <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>
</div>



@stop

@section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>



<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>

    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );

    $('#daterange-btn').daterangepicker(
        {
          

            ranges: {
                'Today': [moment(), moment()],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
          },
        
        );

    
     $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });

     $('.update-report').on('click',function(){

        $('.preloader').fadeIn();
            
            date_range = $('#daterange-btn').val();

            var data = {'date_range':date_range};
            $.get('/report/update-cash-flow-statement',data,function(data){
                document.getElementById('update-report').innerHTML = data;

                $('#myTable').DataTable({
                    'paging':false,
                    'searching':false,
                    'info':true
                });
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });
     
    </script>


@stop

