@extends('layouts.app')

@section('title')
General Ledger Detail 
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">General Ledger</li>
      </ol>
@stop
@section('css')
<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<style type="text/css">
@page {
    size: landscape;
   }
    .btm-margin{
        border-bottom: 3px solid white;
    }
   /* .bg-grey {
        background-color: #efefef;
    }*/
    .bg-green {
        background-color: #ecf5eb;
    }
    /*.pd-5{
        padding:5px;
    }*/
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }

    @media print {
        .panel .panel-body{
        font-size: 12px;
        font-family: "time-new-roman",Arial,sans-serif;
    }
        .btm-margin{
        border-bottom: 3px solid white;
    }
   .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
   /* table.dataTable thead th, table.dataTable thead td {
    border: 1px solid #f2f2f2 !important;
    }*/
    .table>tbody>tr>td {
     border: 1px solid #f2f2f2 !important; 
    }
    .bor .border-d{
        border-bottom: double !important;
        border-top: 1px solid !important;
    }
    h3 strong{
        text-transform: uppercase;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
     .bdr thead tr th  {
    border: 1px solid #2e3233;
    background: #eee;
    }
    .table>thead:first-child>tr:first-child>th {
    border-top: 1px solid !important;
}
    }
</style>
<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop
@section('content')

<div class="container-fluid">
    <div class="white-box  printableArea" id="update-report">
        <div class="text-center">
        <h3><strong>
            @foreach($project_names as $key => $project_name)
            {{ $project_name }}
            @if($key < count($project_names) - 1)
                , 
            @endif
        @endforeach    
        
        </strong></h3>
        <h4><strong>General Ledger</strong></h4>
        <h6>{{date(('d/m/Y'),strtotime($from))}} - {{date(('d/m/Y'),strtotime($to))}}</h6>
        </div>
        <div class="text-right">User ID:&nbsp; {{Auth::user()->name}}</div>
        
        <div class="row">
        

        <div class="col-md-12 pro-cart">
         <table id="example1" class="table border bdr" style="font-size:12px;">
                     <thead>
                        <tr>
                            <th>Voucher No.</th>
                            <th width="40">Date</th>
                            <th>Name</th>
                            <th width="500px">Narration</th>
                            <th class="text-center">Debit</th>
                            <th class="text-center">Credit</th>
                            <th class="text-center">Balance</th>
                        </tr>

                     </thead>
                     <tbody>

                        <?php $parentBalance = 0; $currentTypeId = 0;?>

                        @foreach($ledger as $account)


                        @if($account['info']->account_type_id != $currentTypeId)

                       <!--  <tr class="bg-green">
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            
                        </tr>

                        <tr class="bg-green">
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            <td class="bg-green"></td>
                            
                        </tr> -->

                        <?php $currentTypeId = $account['info']->account_type_id;?>

                        @endif

                        @if(!$account['leafAccount'])
                        <tr>

                            <td class="bg-grey"  style="text-align:left; padding-left: 2%; font-size: 12px;"><b style="font-weight:700;">{{$account['info']->number}} - {{$account['info']->name}}</b> </td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td class="text-right"><b style="font-weight: 700px;">{{number_format($account['sum'])}}<b></td>
                            
                        </tr>
                        @else

                        <tr >
                            <?php  $balance = $account['openingBalance']; $debit = $credit = 0;?>
                            <td class="bg-grey"  style="text-align:left; padding-left: 2%; font-size: 12px;"><b>{{$account['info']->number}} - {{$account['info']->name}}</b> </td>
                            <td></td>
                         
                            <td></td>
                            <td>Opening Balance</td>
                            <td></td>
                            <td ></td>
                            <td class="bg-grey text-right" ><b>{{number_format(abs($balance))}}</b></td>
                            
                            
                        </tr>

                        @foreach($account['transactions'] as $t)

                        <tr>
                           <td >
                            @if($t->voucher_type == \App\GeneralJournalEntry::CRV)
                                            CRV-{{$t->voucher_no}}
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BRV)
                                            BRV-{{$t->voucher_no}}
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::CPV)
                                            CPV-{{$t->voucher_no}}
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BPV)
                                            BPV-{{$t->voucher_no}}
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::JV)
                                            JV-{{$t->voucher_no}}
                                            @else
                                            
                                            @endif

                            </td>

                            <td >{{date('d/m/Y',strtotime($t->date))}}</td>
                           
                            <td >{{$t->controlAccount ? $t->controlAccount->name : ''}}
                            </td>
                            <td class="text-left" >{{$t->memo}}</td>
                           
                           
                            <td class="text-right" >{{$t->amount > 0 ? number_format(abs($t->amount)) : ''}} 
                                <?php $debit += $t->amount > 0 ? abs($t->amount) : 0;?>
                            </td>
                            <td class="text-right" >{{$t->amount < 0 ? number_format(abs($t->amount)) : ''}}
                                <?php $credit += $t->amount < 0 ? abs($t->amount) : 0;?>
                            </td>

                            <?php $balance += $t->amount;?>
                              
                            <td class="text-right" >{{number_format($balance)}}</td>
                            
                        </tr>
                        @endforeach

                        <tr class="bg-grey bor">
                            <td></td>
                            <td class="bg-grey"></td>
                            <td class="bg-grey"></td>
                            <td class="bg-grey"></td>
                            
                            <td class="text-right border-d">{{number_format($debit)}}</td>
                            <td class="text-right border-d">{{number_format($credit)}}</td>
                            <td class="text-right border-d"><b>{{number_format($balance)}}</b></td>

                        </tr>
                        
                        @endif

                        @endforeach
                        

                    
             </tbody>
         </table>

        </div>
    </div>
    </div>
    <div class="text-right" style="height:70px;">
                                        <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>
</div>

@stop

@section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<!-- <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script> -->
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>



<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>

    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'csv', 'excel', 'pdf'
        ]
    } );

    $('#daterange-btn').daterangepicker(
        {
          

            ranges: {
                'Today': [moment(), moment()],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
          },
        
        );

    
     $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });

     
    </script>


@stop

