@extends('layouts.app')
 @section('title') Employees Benevolent Fund Report 
 @stop 
 @section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
	<li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
	<li class="active">All Employees Salary </li>
</ol>
 @stop
  @section('css')
<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">
<style>
table.dataTable thead .sorting_asc {
	background-image: none !important;
}

.table.dataTable,
table.dataTable {
	width: 99.8%!important;
}

#myTable tbody tr td {
	text-align: left;
}

.us_sty {
	text-align: center;
	top: 9rem;
	z-index: 999;
}
.dt-buttons{
	margin-top: 3rem;
}
.dataTables_filter{
  margin-top: 3rem;
}

 .dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: gray;
    color: #fff !important;
    white-space: nowrap;
    border-color: #d4af37;
}
.badge {
    text-transform: uppercase;
    font-weight: 500 !important;
    padding: 7px 7px !important;
    font-size: 13px !important;
    margin-top: 4px !important;

  }    
</style>
 @stop 
 @section('content')
<div class="container-fluid">
	<!-- /row -->
	<div class="row">
		<div class="col-sm-12">
			<div class="white-box">
				<div class="pull-right"> </div>
				<center><h3 class="box-title">Employees Benevolent Fund Report </h3></center>
				<br>
				<br>
				<div class="col-lg-12">
				<div class="table-responsive"> 
				@if(Session::has('success'))
				<div id="successMessage" class="alert alert-success" role="alert"> 
				{{ Session::get('success') }} 
				</div>
				@endif
				<div class="table-responsive">
					<table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table hoverTable" role="grid" aria-describedby="myTable_info" class="table table-striped">
						<thead>
							
								
                            <tr role="row">
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Name</th>
                                {{-- <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month/Year: </th> --}}
                                
                                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 60px;">Employee Benevolent Fund </th>
                                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 63px;">Employer Benevolent Fund </th>
                                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 63px;">Total </th>
                                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 63px;">Status </th>
                            </tr>
                        </thead>
						<tbody> 
						
							@php

							$total_fund = 0; 
							$total_employees_bf_fund = 0; 


							@endphp

							@foreach($employees_benevolent_funds as $employees_benevolent_fund )

							@php

							$total = \App\HrmEmployeeBenevolentFound::getData($employees_benevolent_fund->id , $month , $curent_year );

							@endphp

							@if( $total[0] > 0 && !empty($employees_benevolent_fund->benevolent_fund)) 


							@foreach($employees_benevolent_fund->benevolent_fund  as $list )


							@if( $list->is_approved == 1)

							<tr style="text-align: center;" role="row" class="odd">
								<td>{{$employees_benevolent_fund->name}}</td>
								<td>{{number_format($total[0],2)}}</td>
								<td>{{number_format($total[3],2)}}</td>
								<td>{{number_format($total[0] + $total[0],2)}}</td>
								<td>
								  @if($total[2] == 1 )
                                        <li id="notreceived" class="badge badge-success">Not Received</a></li>
                                      @elseif($total[2] == 0) 
                                         <li id="notreceived" class="badge badge" class="badge badge" style="background: #15df19 !important; ">Received</li>
                                   @endif   
                                </td>

							</tr>

							@php
                             
                             $total_fund += $total[0];
							 $total_employees_bf_fund += $total[3] + $total[0];
                            
							@endphp

								@endif

							@endforeach

							@endif

							@endforeach

							<tr>
								<td><strong>Total</strong></td>
								<td><strong>{{number_format($total_fund,2)}}</strong></td>
								<td><strong>{{number_format($total_fund,2)}}</strong></td>
								<td><strong>{{number_format($total_employees_bf_fund,2)}}</strong></td>
								<td><strong></strong></td>
							</tr>
							
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
		
</div>
</div>
</div>
</div> 
@stop 
@section('js')
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
            "ordering": false,
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
</script> 
@stop