@extends('layouts.app')
 @section('title') List of Employee Report  
 @stop 
 @section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
  <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
  <li class="active">All Employees Salary </li>
</ol>
 @stop
  @section('css')
<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">
<style>
table.dataTable thead .sorting_asc {
  background-image: none !important;
}

.table.dataTable,
table.dataTable {
  width: 99.8%!important;
}

#myTable tbody tr td {
  text-align: left;
}

.us_sty {
  text-align: center;
  top: 9rem;
  z-index: 999;
}
.dt-button{
  margin-top: 4rem;
}
.
element.style {
    margin-top: 4rem;
}
.dataTables_filter{
  margin-top: 4rem;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: gray;
    color: #fff !important;
    white-space: nowrap;
    border-color: #d4af37;   
</style>
 @stop 
 @section('content')
<div class="container-fluid">
  <!-- /row -->
  <div class="row">
    <div class="col-sm-12">
      <div class="white-box">
        <div class="pull-right"> </div>
        <center><h3 class="box-title"> List of Employees Report </h3></center>
        <br>
        
        <div class="col-lg-12">
            <div class="table-responsive"> @if(Session::has('success'))
        <div id="successMessage" class="alert alert-success" role="alert"> {{ Session::get('success') }} 
        </div>
         @endif
        <div class="table-responsive">
          <table id="myTable" class="table-responsive table table-striped table-bordered dataTable color-table primary-table hoverTable" role="grid" aria-describedby="myTable_info">
            <thead>  
              <tr role="row">
                  <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Code No:</th>
                  <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name:</th>
                  <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Department:</th>
                  <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Designation: </th>
                  <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Gender: </th>
                  <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Address: </th>
                  <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Phone No: </th>
                  <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 220px;">Date of Joining: </th>
                  <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 220px;">Date of Birth: </th>
                  <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 220px;"> Contract Type : </th>
                  <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 220px;">Basic Salary: </th>
              </tr>
            </thead>
            <tbody>     
                  @foreach($HrmEmployees as $HrmEmployee)
                 <tr>
                  <td>{{$HrmEmployee->company_detail->employee_code}}</td>
                  <td>{{$HrmEmployee->name}}</td>
                  <td>{{$HrmEmployee->company_detail->department->department_name}}</td>
                  <td>{{$HrmEmployee->company_detail->designation->name}}</td>
                  <td>{{$HrmEmployee->gender}}</td>
                  <td>{{$HrmEmployee->pemanent_address}}</td>
                  <td>{{$HrmEmployee->phone_no}}</td>
                  <td>{{date("d-m-Y", strtotime($HrmEmployee->company_detail ? $HrmEmployee->company_detail->date_of_joining : ''))}}</td>
                  <td>{{date("d-m-Y", strtotime($HrmEmployee->dob ))}}</td>
                  @if($HrmEmployee->company_detail->contract_type =='full_time')
                     <td>Full Time</td>
                     @else
                     <td>Contract</td>
                   @endif
                   <td>{{number_format($HrmEmployee->company_detail->monthly_salary)}}</td>
                 </tr>
                 @endforeach
            </tbody>
          </table>
          <button id="print" class="btn btn-success no-print" style="margin-top: 1rem; float: right;" type="button" style="float: right;"> <span style="color: white; float: right;"><i class="fa fa-print"></i> Print</span> </button>
        </div>
      </div>
      </div>
      </div>
    </div>
  </div>
</div> 
@stop 
@section('js')
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>
  <script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>

$(function () {
$("#print").on("click", function () {
window.print();
});
});
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
            "ordering": false,
        'buttons': [
            'copy', 'csv', 'excel', 'print'
        ]
        });
    });

        
    </script>
</script> 
@stop