@extends('layouts.app')
 @section('title') Tax Deduction Report 
 @stop 
 @section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
	<li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
	<li class="active">All Employees Salary </li>
</ol>
 @stop
  @section('css')
<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">
<style>
table.dataTable thead .sorting_asc {
	background-image: none !important;
}

.table.dataTable,
table.dataTable {
	width: 99.8%!important;
}

#myTable tbody tr td {
	text-align: left;
}

.us_sty {
	text-align: center;
	top: 9rem;
	z-index: 999;
}


.dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: gray;
    color: #fff !important;
    white-space: nowrap;
    border-color: #d4af37;    

</style>
 @stop 
 @section('content')
<div class="container-fluid">
	<!-- /row -->
	<div class="row">
		<div class="col-sm-12">
			<div class="white-box">
				<div class="pull-right"> </div>
				<center><h3 class="box-title"> Tax Deduction Monthly Report </h3></center>
				<br>
				<br>
				<br>
				<br>
				<br>
				<div class="col-lg-12 no-print">
					<form method="GET" style="margin-top: -7rem;" action="{{ route('employee.tax.report')}}">
						<div class="row">
							<div class="col-sm-6">
								<div class="form-group">
									<label for="recipient-name" class="col-form-label">Month:</label>
									<select id="month" class="form-control " name="month">
										<option value="">All</option>
										<option <?=( $month == 1) ? 'selected' : '' ?> value="1">January</option>
										<option <?=( $month == 2) ? 'selected' : '' ?> value="2">February</option>
										<option <?=( $month == 3) ? 'selected' : '' ?> value="3">March</option>
										<option <?=( $month == 4) ? 'selected' : '' ?> value="4">April</option>
										<option <?=( $month== 5) ? 'selected' : '' ?> value="5">May</option>
										<option <?=( $month == 6) ? 'selected' : '' ?> value="6">June</option>
										<option <?=( $month == 7) ? 'selected' : '' ?> value="7">July</option>
										<option <?=( $month == 8) ? 'selected' : '' ?> value="8">August</option>
										<option <?=( $month == 9) ? 'selected' : '' ?> value="9">September</option>
										<option <?=( $month == 10) ? 'selected' : '' ?> value="10">October</option>
										<option <?=( $month == 11) ? 'selected' : '' ?> value="11">November</option>
										<option <?=( $month == 12) ? 'selected' : '' ?> value="12">December</option>> </select>
								</div>
							</div>
							<div class="col-sm-5">
								<label for="recipient-name" class="col-form-label">Year:</label>
								<select class="form-control" name="year">
									<?php
										for ($year = (int)date('Y'); 1900 <= $year; $year--): ?>
										<option <?=( $curent_year == $year) ? 'selected' : '' ?> value="
											<?=$year;?>">
												<?=$year;?>
										</option>
										<?php endfor; ?>
								</select>
							</div>
							<button type="submit" style="margin-top: 2.5rem;" class="btn btn-info">Filter</button>
						</div>
					</form>
				</div>

				<div class="col-lg-12">
				<div class="table-responsive"> 
				@if(Session::has('success'))
				<div id="successMessage" class="alert alert-success" role="alert"> 
				{{ Session::get('success') }} 
				</div>
				@endif
				<div class="table-responsive">
					<table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table hoverTable" role="grid" aria-describedby="myTable_info" class="table table-striped" >
						<thead>
							
								
                            <tr role="row">
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name:</th>
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month/Year: </th>
                                
                                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Tax: </th>
                            </tr>
                        </thead>
						<tbody> 
						
								@php
								$total_net_salary = 0;
								$total_tax_monthly = 0;
								@endphp

								@foreach($hrmemployees_salaries as $employees_salary )

								@php

                                 $total = \App\HrmEmployeeMonthlyEarningDeduction::getData($employees_salary->id , $month , $curent_year );
                              
								@endphp
								@if($total[3] > 0 )
								<tr style="text-align: center;" role="row" class="odd">
									
									<td>{{$employees_salary->name}}</td>
									<td>{{date('F', mktime(0, 0, 0, $month))}} / {{$curent_year}}</td> 
									<td>{{number_format($total[3])}}</td>
								     
						
								</tr>
								@php

							
								$total_tax_monthly += $total[3];

								@endphp
								@endif
									@endforeach
									
									
							<tr>
								<td><strong>Total</strong></td>
								<td>&nbsp;</td>
								<td><strong>{{number_format($total_tax_monthly)}}</td>
							</tr>
							
							
						</tbody>
					</table>
				</div>
			</div>
				</div>
			</div>
		
		</div>
	</div>
</div>
</div> 
@stop 
@section('js')
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
            "ordering": false,
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
</script> 
@stop