@extends('layouts.app')

@section('title')
 Loan List
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Loans</li>
      </ol>
@stop
@section('css')
<style type="text/css">

table.dataTable thead .sorting_asc {
   background-image: none !important;
}

.table.dataTable,
table.dataTable {
   width: 99.8%!important;
}

button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    background: gray;
    color: #fff;
    white-space: nowrap;
    /* border-color: #d4af37; */
    background: rgb(153 142 142 / 15%);
    color: #2b2b2b;
    border-color: #fff;
    border: 1px solid rgb(0 0 0 / 24%);
    border-radius: 2px;
    cursor: pointer;
    font-size: .88em;
    line-height: 1.6em;
    padding: 0.5em 1em;
    overflow: hidden;
}
   .fa {
    font-size: 20px !important;
        } 


.dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: gray;
    color: #fff !important;
    white-space: nowrap;
    border-color: #d4af37;
  }

   .badge {
    text-transform: none !important; 
    font-weight: 450 !important;
    padding: 7px 7px !important;
    font-size: 13px !important;
    margin-top: 4px !important;

  }

    
 </style>   
@stop
@section('content')
  <div class="container-fluid">
    <div class="row">
                    
<div class="col-sm-12">
                        <div class="white-box">

                   
                           
                             <h3  class="box-title m-b-0">
                                <span style="">Employees Loan  Report </span>
                                
                                  </h3>

                            <div class="table-responsive" style="margin-top: 3rem;">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                                <table id="myTableData" class="table table-striped table-bordered dataTable color-table primary-table hoverTable"  aria-describedby="myTable_info">
                                    <thead>
                                        <tr>

                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">S.No</th>
                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>
                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Total Advance </th>
                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Received Advance </th>
                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Remaining Advance</th>
                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Total Loan </th>
                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Recived Loan</th>
                                            
                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Remaining Loan</th>
                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Status </th>
                                           

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Action</th>


                                        </tr>
                                    </thead>
                                    <tbody>

                                        @php
                                          
                                          $count= 1;

                                        @endphp
  
                                    @foreach( $employees as $list )

                                      @php
                                         
                                      $total = \App\HrmEmployeeLoan::getData($list->id);
                                

                                      @endphp

                                      @if($total[0] + $total[3] > 0)
                                        <tr class="odd">

                                            <td>{{$count++}}</td>
                                            <td>{{$list->name}}</td>
                                            <td>{{number_format($total[3])}}</td>
                                            <td>{{number_format($total[4])}}</td>
                                            <td>{{number_format($total[5])}}</td>
                                            <td>{{number_format($total[0])}}</td>
                                            <td>{{number_format($total[2])}}</td>
                                            <td>{{number_format($total[1])}}</td>
                                            <td>
                                             
                                            @if($total[1] + $total[5] == 0 )

                                                <li id="notreceived" class="badge badge-success" style="background: green;"> Completed </a></li>
                                                @elseif($total[1] + $total[5] != 0)
                                                 <li id="notreceived" class="badge badge-success">Pending  </a></li>
                                            @endif

                                           </td>
                                            
                                             <td>
                                                <a href="{{route('detail.loan',[$list->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a> &nbsp;
                                                
                                            </td>

                                        </tr>
                                        @endif
                                     @endforeach   

                                      
                                    </tbody>
                                </table>
                                
                            </div>
                            </div>
                        </div>
                    </div>


    </div>

</div>

<!-- /.container-fluid -->
<div class="modal fade" id="add-employee" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog" role="document">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title" id="exampleModalLabel"><strong>Employee Information </strong></h5>
<button type="button" class="close" data-dismiss="modal" aria-label="Close">
<span aria-hidden="true">&times;</span>
</button>
</div>
<div class="modal-body">
<form method="get" action="{{route('loan.letter')}}">
<div class="form-group">

{{-- <input type="hidden" value="{{round($total_net_salary)}}"  name="total_amount" id="total_amount">

<input type="hidden" value="{{round($total_bf)}}"  name="total_bf" id="total_bf"> --}}
<div class="form-group">
<label for="recipient-name" class="col-form-label"><strong> Employee Name <span style="color: red;">*</span></strong></label>
<select id="name" class="form-control" name="name" required> 

<option value="" selected>Employee Name </option> 
@foreach($employees as $employee)
<option value="{{ $employee->name}}">{{ $employee->name }}</option> 
@endforeach 
</select>

<label >
<strong> Type <span style="color: red;">*</span></strong>
</label>
<select class="form-control chosen-select" name="type" required="true"> 

<option value="Loan">Loan</option>
<option value="Advance">Advance </option>

</select>
<br>
<div class="form-group">
<label for="amount" class="col-form-label"><strong>Amount <span style="color: red;">*</span></strong></label>
<input type="number" class="form-control" id="amount" name="amount" placeholder="Enter amount" required>
</div>
</div>
<div class="modal-footer">
<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
<button type="submit" class="btn btn-primary">Save</button>
</div>
</form>
</div>

</div>
</div>
</div>
@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTableData').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

    function AddEmployee(self ) 
    {

     $('#add-employee').modal('show');

    return false;
    }
</script>
@stop