@extends('layouts.app')

@section('title')
Inventory Report
@stop


@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Inventory Statement</li>
      </ol>
@stop

@section('css')
<style type="text/css">
     @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        padding-top: 0px !important;
        color:black;
    }
   .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    /*.br-right {
         border-right: 1px solid #e6e3e3;
    }*/
    .txt-c {
        text-align: center;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
    table.dataTable thead th {
    border: 1px solid #f2f2f2 !important;
    }
    .table>tbody>tr>td {
     border: 1px solid #f2f2f2 !important; 
    }
    .bor .border-d{
        border-bottom: double !important;
        border-top: 1px solid !important;
    }
    h3 strong{
        text-transform: uppercase;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    .white-box1{
        padding: 0;
    }
      .bdr thead tr th  {
    border: 1px solid #2e3233 !important;
    background: #eee;
    }
    .table>thead:first-child>tr:first-child>th {
    border-top: 1px solid !important;
}
    }
</style>

<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop

@section('content')

<div class="container-fluid">

    <!--.row-->
                <div class="row no-print">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Customize Report</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">

                                            <div class="col-md-6">
                                            
                                            
                                            <div class="form-group">
                                            <label class="col-sm-3 control-label">Item</label>
                                            <div class="col-sm-9">
                                            <div class="input-group" >
                                            <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                            </div>
                                            <select class="form-control chosen-select" name="item[]" multiple="" id="item_list">
                                            
                                            @foreach($items as $i)
                                            <option value="{{$i->id}}">{{$i->item_code}} - {{$i->item_name}}
                                            </option>
                                            
                                            @endforeach
                                            </select>
                                            
                                            </div>
                                            
                                            </div>
                                            <!-- /.input group -->
                                            </div>
                                            </div>

                                            <div class="col-md-6">
                                            
                                            
                                            <div class="form-group">
                                            <label class="col-sm-3 control-label">Date range</label>
                                            <div class="col-sm-9">
                                            <div class="input-group" >
                                            <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                            </div>
                                             <input type="text" class="form-control "id="daterange-btn" value='{{old('date_range')}}' name='date_range'>
                                            
                                            </div>
                                            @if($errors->has('date_range'))
                                            <span class="help-block" >
                                            <strong>{{ $errors->first('date_range') }}</strong>
                                            </span>
                                            @endif
                                            </div>
                                            <!-- /.input group -->
                                            </div>
                                            </div>
              <div class="form-actions">
                                            <button type="button" class="btn btn-success update-report"> <i class="fa fa-check" ></i> Update</button>
                                            
                                        </div>
                
                                            </div>
                                            
                                        </div>

                                        
                                        
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->
                <div class="row printableArea" id="update-report">
                    <div class="col-lg-12  ">
                    <div class="white-box">

                         <div class="text-center">
                            <h3><strong>{{env('APP_NAME')}}</strong></h3>
                            <h4><strong>Inventory In/Out </strong></h4>
                             <h6>{{date(('d/m/Y'),strtotime($from_date))}} - {{date(('d/m/Y'),strtotime($to_date))}}</h6>
                        </div>


                        <div class="pull-right printFV" style="margin-bottom: 2rem;">
                            <span>Date: <b>{{date('d/m/Y')}}</b></span><br>

                            <span>User ID: &nbsp; {{Auth::user()->name}}</span>
                        </div>
                           <div class="table-responsive" style="clear: both;">
                                <table id="example1"  class="table bdr">
                                    <thead>
                                        <tr>
                                            <th >Product Name</th>
                                            <th class="text-right">Received Qty </th>
                                            <th class="text-right">Issue Qty </th>
                                            <th class="text-right">Balance Qty </th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php $inT = 0 ;$outT = 0; $remT = 0;?>
                                        
                                        @foreach($items as $i)
                                        <tr>
                                            
                                            <td class="printFV">{{$i->item_code}} - {{$i->item_name}}  ({{$i->unit}})</td>
                                             
                                            <td class="printFV text-right">{{number_format($in[$i->id])}}
                                                <?php  $inT +=$in[$i->id];?></td>
                                            <td class="printFV text-right">
                                                {{number_format($out[$i->id])}}
                                                <?php  $outT +=$out[$i->id];?>
                                            </td>

                                            <td class="text-right">
                                                {{number_format($remaining[$i->id])}}
                                                <?php  $remT +=$remaining[$i->id];?>
                                            </td>
                                        </tr>
                                        @endforeach

                                        <tr>
                                            <td class="text-right"><b>Total</b></td>
                                            
                                            <td class="text-right"><b>{{number_format($inT)}}</b></td>
                                            <td class="text-right"><b>{{number_format($outT)}}</b></td>
                                            <td class="text-right"><b>{{number_format($remT)}}</b></td>
                                        </tr>
                                    </tbody>
                                </table>
                              
                        </div>
                    </div>
                </div>
</div>
           
            <!-- /.container-fluid -->

            <div class="text-right" style="height:70px;">
                                         <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>
 </div>
@stop

@section('js')

    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script>
    
    $(function() {
        $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });
    });
    
    
    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
             'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );

    const year = new Date().getFullYear();

  const this_fiscal_year_start_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const last_fiscal_year_end_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

    $('#daterange-btn').daterangepicker(
        {
            
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Fiscal Year' : [this_fiscal_year_start_date,this_fiscal_year_end_date],
            'Last Fiscal Year' : [last_fiscal_year_start_date,last_fiscal_year_end_date]
          },
          startDate: moment(),
          endDate: moment()
        },
        function (start, end) {
          $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }
    );

    $('.update-report').on('click',function(){

        $('.preloader').fadeIn();
            
            date_range = $('#daterange-btn').val();
            item_list = $('#item_list').val();
            
            var data = {'date_range':date_range,'item_list': item_list};
            $.get('/report/update-inventory',data,function(data){
                document.getElementById('update-report').innerHTML = data;

                $('#myTable').DataTable({
                    'paging':false,
                    'searching':false,
                    'info':true
                });
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });
    </script>

   @stop