@extends('layouts.app')

@section('title')
Item Valuation Report 
@stop


@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Item Valuation Statement</li>
      </ol>
@stop

@section('css')
<style type="text/css">
     @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        padding-top: 0px !important;
        color:black;
    }
   .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    /*.br-right {
         border-right: 1px solid #e6e3e3;
    }*/
    .txt-c {
        text-align: center;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
    table.dataTable thead th {
    border: 1px solid #f2f2f2 !important;
    }
    .table>tbody>tr>td {
     border: 1px solid #f2f2f2 !important; 
    }
    .bor .border-d{
        border-bottom: double !important;
        border-top: 1px solid !important;
    }
    h3 strong{
        text-transform: uppercase;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    .white-box1{
        padding: 0;
    }
      .bdr thead tr th  {
    border: 1px solid #2e3233 !important;
    background: #eee;
    }
    .table>thead:first-child>tr:first-child>th {
    border-top: 1px solid !important;
}
    }
</style>

<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop

@section('content')

<div class="container-fluid">

   
                <div class="row printableArea" >
                	<div class="col-lg-12  ">
                            <br>
                    <div class="white-box">
                        <div class="text-center">
                            <h3><strong>{{env('APP_NAME')}}</strong></h3>
                            <h4><strong>Item Valuation Statement</strong></h4>
                          
                        </div>


                        <div class="pull-right printFV" >
                            <span>Date: <b>{{date('d/m/Y')}}</b></span><br>

                            <span>User ID: &nbsp; {{Auth::user()->name}}</span>
                        </div>
                           <div class="table-responsive" style="clear: both;">
                                <table id="example1"  class="table bdr">
                                    <thead>
                                        <tr>
                                            <th >Item Name</th>
                                            <th >Last Purchase Price</th>
                                            <th >Available Quantity</th>
                                            <th >Total Price</th>

                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php $quanT = 0 ;$priceT = 0; ?>
                                        
                                        @foreach($items as $i)
                                        <tr>
                                            
                                            <td class="printFV">{{$i->item_code}} - {{$i->item_name}}</td>
                                            <td class="printFV">{{number_format($lastPrice[$i->id])}}
                                                </td>
                                            

                                          
                                            <td>
                                                {{number_format($remaining[$i->id])}}
                                                <?php  $quanT +=$remaining[$i->id];?>
                                            </td>

                                            

                                            <td class="printFV text-right">
                                                {{number_format($remaining[$i->id] * $lastPrice[$i->id])}}
                                                <?php  $priceT += ($remaining[$i->id] * $lastPrice[$i->id]);?>
                                            </td>
                                           

                                            
                                        </tr>
                                        @endforeach

                                        <tr>
                                            <td colspan="2" class="text-right"><b>Total</b></td>
                                            <td><b>{{number_format($quanT)}}</b></td>
                                            <td><b>{{number_format($priceT)}}</b></td>
                                        </tr>




                                    </tbody>
                                </table>
                              
                        </div>
                    </div>
                </div>

            </div>
            <!-- /.container-fluid -->

            <div class="text-right" style="height:70px;">
                                       <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>

@stop

@section('js')

<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
 <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });
    });
    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );

    const year = new Date().getFullYear();

  const this_fiscal_year_start_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const last_fiscal_year_end_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

    $('#daterange-btn').daterangepicker(
        {
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Fiscal Year' : [this_fiscal_year_start_date,this_fiscal_year_end_date],
            'Last Fiscal Year' : [last_fiscal_year_start_date,last_fiscal_year_end_date]
          },
          startDate: moment().subtract(29, 'days'),
          endDate: moment()
        },
        function (start, end) {
          $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }
    );

    
    </script>

   @stop