@extends('layouts.app')

@section('title')

Monthly Recovery Sheet &nbsp;&nbsp;&nbsp;&nbsp; From {{$from_date}}&nbsp;&nbsp;To&nbsp;&nbsp;{{$to_date}}



@stop
@section('css')
<style type="text/css" media="print">
  @page {
    size: landscape;
   }


</style>

<style>

    .us_table_bdr>td, .us_table_bdr>th, .us_table_bdr>td, .us_table_bdr>th {
        border: 1px solid black !important;
    }
</style>

<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop


@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Account Statement</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <div class="row ">
                  <div class="col-lg-12  ">
                    <div class="white-box">
                        <div class="text-center">
                            <h3><strong>@foreach($project_names as $key => $project_name)
                                {{ $project_name }}
                                @if($key < count($project_names) - 1)
                                    , 
                                @endif
                            @endforeach</strong></h3>
                            <h4><strong>Monthly Recovery Sheet</strong></h4>
                        </div>
                        <div class="pull-left">
                        <span>Recovery Sheet(Due, Received & OS As On)</span><br>
                            <span><b>FROM&nbsp;&nbsp;{{$from_date}}&nbsp;&nbsp;To&nbsp;&nbsp;{{$to_date}}</b></span>
                        </div>

                        <div class="pull-right" style="    margin-bottom: 2rem;padding-right: 3rem;" >
                            <span>Date: <b>{{date('d-m-y')}}</b></span><br>
                        <!--<span>Report No: &nbsp;202030</span><br>-->
                            <span>User ID: &nbsp; {{Auth::user()->name}}</span>
                        </div>

                <br>
                 <br>
                  <br>
                    <div class="table-responsive" style="clear: both;position: relative;bottom: 0rem;">
                                <div style="overflow-y: scroll;height: 565px;">

                      
                                    
                         
                                    
                                <table id="example1"  class="table bdr table-responsive table-bordered" style="border: 1px solid black;">
                                    <thead>
                                        
                                     
                                        <tr >
                            
                            
                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Sr No.</th>
                           
                           <th style="border-top: 1px solid;border-bottom: 1px solid;">Month</th>

                            <th style="border-top: 1px solid;border-bottom: 1px solid;">No of Units</th>
                            
                
                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Booked(Gross)</th>

                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Discount</th>
                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Booked Net</th>
                            
                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Recovery</th>
                            
                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Balance Receivables</th>
                         
                            
                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Cancelled Unit</th>

                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Cancel Unit Refunded</th>


                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Transfer Unit</th>

                            <th style="border-top: 1px solid;border-bottom: 1px solid;">Transfer Unit Refunded</th>
                             
                            </tr>
                                                  
                        </thead>
                    <tbody>
                    
                            
                        <?php 
                        $count =1; 
                        
                        $total_no_of_unit = 0;
                        
                        $total_booked_gross = 0;
                        
                        $total_discount = 0;
                        
                        $total_net_pay = 0;
                        
                        $total_recovery = 0;
                        
                        $total_receivable = 0;
                        
                        $total_cancel_unit = 0;
                        
                        $total_cancel_unit_refund = 0;
                        
                        $total_transfer_unit = 0;
                        
                        $total_transfer_unit_refund = 0;
                        
                        ?> 
                        
                            
                        @foreach ($period as $key=> $parentDT) 

                     
                        <?php 
                        $no_of_unit = 0; $receivable= 0;$recovery=0; $discount = 0; $net_pay = 0; $booked_gross = 0;  

                        $CancelUnits = \App\CustomerProperty::getCancelUnitDetail($parentDT->format("M Y"));
                        $TransferUnits = \App\CustomerProperty::getTransferUnitDetail($parentDT->format("M Y"));
                        ?>                       
                        @foreach($properties as $property)


                        @if( $parentDT->format("M Y") == date('M Y' , strtotime($property->booking_date)))

                        <?php 

                        $no_of_unit++;

                        $booked_gross +=  $property->inventory->total_price;

                        $discount +=  ($property->inventory->total_price - $property->net_pay);

                        $net_pay +=  $property->net_pay;

                        $recovery += $receivedAmt[$property->id];

                        $receivable += ($property->net_pay - $receivedAmt[$property->id]);

                        ?>
                      
                        @endif
                        @endforeach


                          <tr >
                            
                            <td style="min-width: 15rem;">{{$count++}}</td>

                            <td style="min-width: 15rem;">{{$parentDT->format("M Y")}}</td>
                            
                            <td style="min-width: 15rem;">{{$no_of_unit}}</td>

                            <td style="min-width: 15rem;">{{number_format($booked_gross)}}</td>
                             
                            <td style="min-width: 15rem;">{{number_format($discount)}}</td>

                            <td style="min-width: 15rem;">{{number_format($net_pay)}}</td>

                            <td style="min-width: 15rem;">{{number_format($recovery)}}</td>

                            <td style="min-width: 15rem;">{{$receivable>0 ?number_format($receivable) : 0 }}</td>

                            <td style="min-width: 15rem;">{{number_format($CancelUnits[0])}}</td>

                            <td style="min-width: 15rem;">{{number_format($CancelUnits[1])}}</td>

                            <td style="min-width: 15rem;">{{number_format($TransferUnits[0])}}</td>

                            <td style="min-width: 15rem;">{{number_format($TransferUnits[1])}}</td>


                        </tr>
                        
                        <?php
                                $total_no_of_unit += $no_of_unit;
                                $total_booked_gross += $booked_gross;
                                $total_discount += $discount;
                                $total_net_pay += $net_pay;
                                $total_recovery += $recovery;
                                $total_receivable += $receivable;
                                $total_cancel_unit += $CancelUnits[0];
                                $total_cancel_unit_refund += $CancelUnits[1];
                                $total_transfer_unit += $TransferUnits[0];
                                $total_transfer_unit_refund += $TransferUnits[1];
                                
                        ?>

  @endforeach
                                      
                                       
    <tr >
        
       
        <td style="min-width: 15rem;"></td>
    
        <td style="min-width: 15rem;">Total</td>
        
        <td style="min-width: 15rem;">{{$total_no_of_unit}}</td>
    
        <td style="min-width: 15rem;">{{number_format($total_booked_gross)}}</td>
         
        <td style="min-width: 15rem;">{{number_format($total_discount)}}</td>
    
        <td style="min-width: 15rem;">{{number_format($total_net_pay)}}</td>
    
        <td style="min-width: 15rem;">{{number_format($total_recovery)}}</td>
    
        <td style="min-width: 15rem;">{{number_format($total_receivable)}}</td>
    
        <td style="min-width: 15rem;">{{number_format($total_cancel_unit)}}</td>
    
        <td style="min-width: 15rem;">{{number_format($total_cancel_unit_refund)}}</td>
    
        <td style="min-width: 15rem;">{{number_format($total_transfer_unit)}}</td>
    
        <td style="min-width: 15rem;">{{number_format($total_transfer_unit_refund)}}</td>
    
    
    </tr>

                
       
            
            
                </tbody>
            </table>
            
                         
            </div>
            
            <a href="#" style="float: right; margin-top: 1rem;" onclick="openReminderModal2(this)" class="btn btn-success" data-toggle="tooltip" data-original-title="Assign Units"> Assign&nbsp;&nbsp; <i class="fa fa-bell text-inverse m-r-10"></i> </a>
            
            </div>
            </div>
            
            </div>

            <!-- /.container-fluid -->
<div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>


@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>

<!-- <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script> -->
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

      <script>
      
      // A $( document ).ready() block.
$( document ).ready(function() {
    
$( ".us_hack" ).each(function() 
{
    $month = $(this).data("month");
    $block = $(this).data("block");
    $amount = $(this).data("amount");
    $('#'+$block+'_'+$month).html($amount)

});



$( ".us_grand_hack" ).each(function() 
{
    $month = $(this).data("month");
    $amount = $(this).data("amount");
    
    $('#grand_'+$month).html($amount)

});

   $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
             'copy', 'csv', 'excel', 'print',
             {
            extend : 'pdfHtml5',
            title : function() {
                return "{{env('APP_NAME')}}\nAccount Statement & Recovery Sheet";
            },
            orientation : 'landscape',
            pageSize : 'A0', // You can also use "A1","A2" or "A3", most of the time "A3" works the best.
            text : '<i class=""> PDF</i>',
            titleAttr : 'PDF'
        }
        ]
    } );



});



    $(function() {
        $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });
    });
    </script>



 <script>
 
 


    function openReminderModal(property_id) {
        
        
        var data={'property_id':property_id};
        $.get('/update_chat_history', data, function (data) {
            document.getElementById('exampleModal1').innerHTML = data;
            $('#exampleModal1').modal();
        });
    }

    function updateChat() {
     
      var property_id = []; 
    $.each($(".chlid_checkbox:checked"), function(){
        
        property_id.push(Number($(this).val())) ;
      
    });
    
    
        
    data = {'property_id':property_id,'remarks':$('#remarks').val(),'next_follow_up':$('#next_follow_up').val(),'status':$('#status').val(),'user_assign':$('#user_assign').val()};

    $.get('/update_history', data, function (data) {

        
        
         if(data.remarks || data.next_follow_up || data.status || data.user_assign ){

           $("#remarks_eror").text(data.remarks);
           $("#next_follow_up_error").text(data.next_follow_up);
           $("#status_error").text(data.status);
           $("#user_error").text(data.user_assign);
            
          }
          else if(data.success == true){
                        

           toastr.success(data.message);
            $("#exampleModal1").click();
     } 

      

    } , 'json');
}

function deleteFollowup(id) {

    data = {'id':id};

    $.get('/delete_followup', data, function (data) {

        document.getElementById('exampleModal1').innerHTML = data;

        toastr.success("Follow up Deleted Successfully.");

    });
}

   
    $(document).ready(function(){

     $('#select_all').on('click',function(){

     if(this.checked){
      
      $('.checkbox').each(function(){
      this.checked = true;
    });

    }
    else
    {
      $('.checkbox').each(function(){
      this.checked = false;
    });
    }
    });

    $('.checkbox').on('click',function(){

     if($('.checkbox:checked').length == $('.checkbox').length){
     $('#select_all').prop('checked',true);
    }
    else 
    {
     $('#select_all').prop('checked',false);
    }
    });
    });
    
    
     function openReminderModal2(self ) 
    {
    
    var property_id = []; 
    $.each($(".chlid_checkbox:checked"), function(){
        
        property_id.push(Number($(this).val())) ;
      
    });
    var data={'property_id':property_id};
        $.get('/update_chat_historyy', data, function (data) {
        document.getElementById('exampleModal1').innerHTML = data;
        $('#exampleModal1').modal();
        });
    }



 </script>
@stop