@extends('layouts.app')

@section('title')
Paid Rebate Statement  &nbsp; &nbsp; &nbsp; {{date(('d/m/Y'),strtotime($from_date))}} to {{date(('d/m/Y'),strtotime($to_date))}}
@stop


@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Paid Rebate Statement</li>
      </ol>
@stop

@section('css')
<style type="text/css">
     @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        padding-top: 0px !important;
        color:black;
    }
   .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    /*.br-right {
         border-right: 1px solid #e6e3e3;
    }*/
    .txt-c {
        text-align: center;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
    table.dataTable thead th {
    border: 1px solid #f2f2f2 !important;
    }
    .table>tbody>tr>td {
     border: 1px solid #f2f2f2 !important; 
    }
    .bor .border-d{
        border-bottom: double !important;
        border-top: 1px solid !important;
    }
    h3 strong{
        text-transform: uppercase;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .bdr thead tr th  {
    border: 1px solid #2e3233 !important;
    background: #eee;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    .white-box1{
        padding: 0;
    }
    }
</style>

<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop

@section('content')

<div class="container-fluid">
                <div class="row printableArea">
                     <div class="col-lg-12">
                    	<div class="white-box">
                            <div class="text-center">
                            <h3><strong>
                                @foreach($project_names as $key => $project_name)
						{{ $project_name }}
						@if($key < count($project_names) - 1)
							, 
						@endif
					@endforeach
                            </strong></h3>
        <h4><strong>Paid Rebate Statement</strong></h4>
        <h6>{{date(('d/m/Y'),strtotime($from_date))}} - {{date(('d/m/Y'),strtotime($to_date))}}</h6>
        
                        </div> 

                        <div class="pull-right printFV" >
                            <span>Date: <b>{{date('d/m/Y')}}</b></span><br>

                            <span>User ID: &nbsp; {{Auth::user()->name}}</span>
                        </div>
                           <div class="table-responsive" style="clear: both;">
                            <br>
                                <table id="example1"  class="table bdr">
                                    <thead>
                                        <tr>
                                            <th>Sr No.</th>
                                            
                                            <th>Date</th>
                                            <th >Unit No.</th>
                                            <th class="text-center">Dealer Name</th>
                                             <th class="text-center">Customer</th>
                                            
                                            
                                            <th class="text-center">Unit Cost</th>
                                            <th class="text-center">Discount</th>
                                            <th class="text-center">Net Price</th>
                                            
                                            <th class="text-center">Rebate Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $total_amount = 0; $count = 1;  $discount_total = 0; $unit_cost_total = 0; $net_total = 0; $rebate_total = 0; ?>                                       
                                        
                                        @foreach($rebates as $rebate)
                                        
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td class="printFV"> {{date('d/m/Y', strtotime($rebate->date)) }}</td>
                                            
                                             <td >
                                                 <b>{{$rebate->property ? $rebate->property->inventory->unit_number : '' }}</b>
                                            </td>
                                        
                                            <td class="printFV">{{$rebate->dealer ? $rebate->dealer->name : ''}}</td>
                                             
                                            <td class="printFV">
                                                @if($rebate->property)
                                                {{$rebate->property->customer->name}}
                                               
                                                
                                            @endif
                                            </td>
                                            
                                             <td  class="text-center">
                                                 <?php
                                                 if($rebate->property){
                                                     $unit_cost_total  +=$rebate->property->inventory->total_price;  
                                                 }
                                                 else {
                                                    $unit_cost_total  += 0;
                                                 }
                                                     ?>
                                              
                                              @if($rebate->property)
                                                 {{number_format($rebate->property->inventory->total_price)}}
                                                 @endif
                                            </td>
                                            
                                            <td class="text-center">
                                                         <?php
                                                           if($rebate->property){
                                                             $discount_total  +=$rebate->property->inventory->total_price - $rebate->property->net_pay; 
                                                           }
                                                           else{
                                                            $discount_total  +=0;
                                                           }
                                                              ?>
                                                              @if($rebate->property)
                                             {{ number_format($rebate->property->inventory->total_price - $rebate->property->net_pay )}} 
                                                               @endif
                                            </td>
                                            
                                            <td class="text-center">
                                                        <?php
                                                        if($rebate->property){
                                                             $net_total  +=$rebate->property->net_pay; 
                                                        }
                                                              ?>
                                                @if($rebate->property){{number_format($rebate->property->net_pay)}}
                                                @endif
                                            </td>
                                            

                                            <td class="printFV text-center">
                                                  <?php $rebate_total  +=$rebate->amount;  ?>
                                                {{number_format($rebate->amount)}}
                                            </td>
                                            
                                            
                                        </tr>
                                        <?php $total_amount +=$rebate->amount;?>
                                        
                                        @endforeach
                                        
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                            
                                             <td></td>
                                            <td class="printFV text-center"><b>{{number_format($unit_cost_total)}}</b></td>
                                            <td class="printFV text-center"><b>{{number_format($discount_total)}}</b></td>
                                            <td class="printFV text-center"><b>{{number_format($net_total)}}</b></td>
                                            
                                            
                                             <td class="printFV text-center"><b>{{number_format($rebate_total)}}</b></td>
                                          
                                            
                                            
                                        </tr>
                                    </tbody>
                                </table>
                                <!-- <div class="marginTop" style="display: flex;">
                                <div class="belowTableTotal1" style="width: 196px;"><span >Total  Paid Amount</span></div>
                                <div class="belowTablePP" style="width: 196px; text-align: center"><span  >{{number_format($total_amount)}}</span></div>

                            </div> -->

                        </div>
                    </div>
                </div>

            </div>
            <!-- /.container-fluid -->

            <div class="text-right" style="height:70px;">
                                        <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>

@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });
    });

    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
             'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
    </script>
@stop