@extends('layouts.app')

@section('title')
Profit Loss Statement 
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Profit/Loss Statement</li>
      </ol>
@stop
@section('css')
<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<style type="text/css">
   
    .bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }

    @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        color: black !important
        }
        
    .bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
     table.dataTable tbody td, table.dataTable tbody th {
    padding: 2px 4px;
    font-size: 12px;
    }
    table.dataTable{
        border:none;
        border-collapse: collapse;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }
    table.dataTable thead td, table.dataTable thead th {
    border-bottom: none !important;
    }
     h3 strong{
        text-transform: uppercase;
        color: black !important
    }
    h4 strong{
        text-transform: uppercase;
        color: black !important
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    a{
        color: black !important
    }
    .page-wrapper {
    padding-top: 0px;
    }

    }
</style>

<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop
@section('content')

<div class="container-fluid">

    <div class="white-box  printableArea">
        <div class="text-center">
        <h3><strong>
            @foreach($project_names as $key => $project_name)
            {{ $project_name }}
            @if($key < count($project_names) - 1)
                , 
            @endif
        @endforeach 
        </strong></h3>
        <h4><strong>Profit or Loss Statement</strong></h4>
        <h6>{{date('d/m/Y', strtotime($from_date))}} - {{date('d/m/Y', strtotime($to_date))}}</h6>
        </div>
        <div class="row">
        

        <div class="col-md-12 pro-cart">
        	<table id="example1"  width="100%" cellpadding="3" cellspacing="3" >
                <thead>
                        <th></th>
                        <th style="width: 100px">&nbsp;</th>
                        
                     </thead>
                     
                     <tbody>
                     <tr class="bg-grey btm-margin">
                            <td class="pd-5 pull-left" ><b>Income</b></td> 
                            <td></td>
                         </tr>

                         <?php $income_t = 0;?>

                         @foreach($income as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5"  style="text-align: left;">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $income_t += ($account['sum'] * -1);?>
                         @endif

                         @endforeach

                         <tr class="bg-green btm-margin" >
                            <td  class="pd-5 pull-left" ><b>Total Income</b></td> 
                            <td class="pd-5 text-right" style="border-top: 1px solid"><b>
                                @if($income_t < 0)
                                ({{number_format(abs($income_t))}})
                                @else
                                {{$income_t > 0 ? number_format($income_t) : '-'}}
                                @endif
                            </b></td>
                         </tr>

                         <tr class="bg-grey">
                            <td class="pd-5 pull-left"  ><b>Cost of Goods Sold</b></td> 
                            <td></td>
                         </tr>

                         <?php $cgs_t = 0;?>

                         @foreach($cgs as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5"  style="text-align: left;"><b>{{$account['account']->number}} - {{$account['account']->name}}</b></td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $cgs_t += ($account['sum'] * -1);?>
                         @endif

                         @endforeach

                         

                         <tr class="bg-green btm-margin" >
                            <td class="pd-5 pull-left"  ><b>Total COGS</b></td> 
                            <td class="pd-5 text-right" style="border-bottom: 1px solid"><b>
                                 @if($cgs_t < 0)
                                ({{number_format(abs($cgs_t))}})
                                @else
                                {{$cgs_t> 0? number_format($cgs_t) : '-'}}
                                @endif</b></td>
                         </tr>

                         <tr class="bg-green btm-margin" >
                            <td class="pd-5 pull-left"  ><b>Gross Profit</b></td> 
                            <td class="pd-5 text-right" ><b>{{number_format($income_t + $cgs_t)}}</b></td>
                         </tr>

                         <tr class="bg-grey btm-margin">
                            <td class="pd-5 pull-left"  ><b>Expense</b></td> 
                            <td></td>
                         </tr>

                      

                         <?php $expense_t = 0;?>

                         @foreach($expense as $account)
                         @if($account['sum'] != 0 )
                         <tr class="">
                            <td class="pd-5"  style="text-align: left;">{{$account['account']->number}} - {{$account['account']->name}}</td> 
                            <td class="text-right"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$account['account']->id])}}">
                                @if($account['sum'] > 0)
                                ({{number_format(abs($account['sum']))}})
                                @else
                                {{number_format(abs($account['sum']))}}
                                @endif
                            </a></td>
                         </tr>
                         <?php $expense_t += ($account['sum'] * -1);?>
                         @endif

                         @endforeach

                         <tr class="bg-green btm-margin" >
                            <td class="pd-5 pull-left"  ><b>Total Expense</b></td> 
                            <td class="pd-5 text-right" style="border-bottom: 1px solid">
                                @if($expense_t < 0)
                                ({{number_format(abs($expense_t))}})
                                @else
                                {{$expense_t> 0? number_format($expense_t) : '-'}}
                                @endif
                            </td>
                         </tr>

                         <tr class="bg-green btm-margin" >
                            <td class="pd-5 pull-left"  ><b>Net Income</b></td> 
                            <td class="pd-5 text-right" style="border-bottom: double;"><b>{{number_format(($income_t + ($cgs_t ) + $expense_t))}}</b></td>
                         </tr>
                         
                     

				 </tbody>
			</table>
        	
           

        </div>
    </div>
    </div>
    <div class="text-right" style="height:70px;">
                                        <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>
</div>



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>

    
     $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });
      $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
    </script>

     @stop

