@extends('layouts.app')

@section('title')
    Received Amount Statement
@stop


@section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Cash Flow Statement</li>
    </ol>
@stop

@section('css')
    <style type="text/css">
        @media print {
            .page-wrapper {
                font-size: 12px !important;
                font-family: "time-new-roman", Arial, sans-serif !important;
                padding-top: 0px !important;
                color: black;
            }

            .printableArea {
                color: black;
            }

            strong {
                color: black;
            }

            .pd-5 {
                padding: 5px;
            }

            .br-btm {
                border-bottom: 1px solid #e6e3e3;
            }

            /*.br-right {
             border-right: 1px solid #e6e3e3;
        }*/
            .txt-c {
                text-align: center;
            }

            .white-box {
                border: none !important;
                padding: 0 3px 0 0px;
            }

            .dataTables_info {
                display: none;
            }

            .dataTables_filter {
                display: none;
            }

            div.dt-buttons {
                display: none;
            }

            table.dataTable thead th {
                border: 1px solid #f2f2f2 !important;
            }

            .table>tbody>tr>td {
                border: 1px solid #f2f2f2 !important;
            }

            .bor .border-d {
                border-bottom: double !important;
                border-top: 1px solid !important;
            }

            h3 strong {
                text-transform: uppercase;
            }

            h4 strong {
                text-transform: uppercase;
            }

            h3 {
                margin-bottom: -10px;
            }

            table.dataTable.no-footer {
                border-bottom: none !important;
            }

            .table>tbody>tr>td,
            .table>tbody>tr>th {
                font-size: 12px;
            }

            .page-wrapper {
                padding-top: 0px;
            }

            .white-box1 {
                padding: 0;
            }

            .bdr thead tr th {
                border: 1px solid #2e3233 !important;
                background: #eee;
            }

            .table>thead:first-child>tr:first-child>th {
                border-top: 1px solid !important;
            }
        }
    </style>

    <!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">
@stop

@section('content')

    <div class="container-fluid">
        <div class="row printableArea">
            <div class="col-lg-12  ">
                <div class="white-box">
                    <div class="text-center">
                        <h3><strong>
                            
                            @foreach($project_names as $key => $project_name)
                            {{ $project_name }}
                            @if($key < count($project_names) - 1)
                                , 
                            @endif
                        @endforeach
                        
                        </strong></h3>
                        <h4><strong>Received Amount Statement</strong></h4>
                        <h6>{{ date('d/m/Y', strtotime($from_date)) }} - {{ date('d/m/Y', strtotime($to_date)) }}</h6>
                    </div>

                    <div class="pull-right printFV">
                        <span>Date: <b>{{ date('d/m/Y') }}</b></span><br>

                        <span>User ID: &nbsp; {{ Auth::user()->name }}</span>
                    </div>

                    <div class="table-responsive" style="clear: both;">
                        @if (empty($type) && $type != 'all')
                            <form method="post" style="width: 60%;z-index: 999;left: 35rem;top: 3.5rem;position: relative;"
                                action="{{ route('report.received-amount-generate') }}" class="no-print">
                                {{ csrf_field() }}
                                <div class="row">
                                    <div class="col-lg-5">

                                        <input type="hidden" value="{{ $selected_date_range }}" name="date_range">
                                        <input type="hidden" value="{{ $multipro_id }}" name="multipro_id">
                                        <select class="form-control chosen-select" name="block">
                                            <option value="">All Blocks</option>
                                            @foreach ($unit_blocks as $unit_block)
                                                <option <?= $block == $unit_block->id ? 'selected' : '' ?>
                                                    value="{{ $unit_block->id }}">{{ $unit_block->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-lg-2">
                                        <input type="submit" value="Filter" class="btn btn-success">
                                    </div>


                                </div>
                            </form>
                        @endif

                        <table id="example1" class="table bdr">
                            <thead>
                                <tr>
                                    <th>Sr No.</th>
                                    <th>Date</th>
                                    <th>Receipt No.</th>
                                    <th>Customer</th>
                                    <th>Unit No.</th>
                                    <th>Unit Floor.</th>
                                    <th>Unit Block.</th>
                                    <th>Payment Mode</th>
                                    <th>Payment Head</th>
                                    <th class="text-center">Amount</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $total_amount = 0;
                                $count = 1; ?>
                                @foreach ($receipts as $receipt)
                    
                                @if( $receipt->property->inventory->floor)
                           @if (
                                        ($filter_type == 'filter' && $block > 0 && $block == 
                                            $receipt->property->inventory->floor->unitBlock->id
                                             ) || $filter_type == 'all')
                                            
                                           
         
                                        <tr>
                                            <td>{{ $count++ }}</td>
                                            <td class="printFV"> {{ date('d/m/Y', strtotime($receipt->receipt_date)) }}
                                            </td>
                                            <td class="printFV">{{ $receipt->receipt_no }}</td>
                                            <td class="printFV">{{ $receipt->customer ? $receipt->customer->name : '' }}
                                            </td>

                                            <td class="printFV">
                                                @if ($receipt->property)
                                                    @if ($receipt->property->inventory->registration)
                                                        {{ $receipt->property->inventory->registration->registrationNo->number }}
                                                    @endif
                                                    -
                                                    {{ $receipt->property->inventory->unit_number }}
                                                @endif
                                            </td>


                                            <td class="printFV">
                                                @if ($receipt->property)
                                                    @if ($receipt->property->inventory)
                                                        {{ $receipt->property->inventory->floor ? $receipt->property->inventory->floor->name : '' }}
                                                    @endif
                                                @endif
                                            </td>

                                            <td class="printFV">
                                                @if ($receipt->property)
                                                    {{ $receipt->property->inventory->floor ? $receipt->property->inventory->floor->unitBlock->name : '' }}
                                                @endif
                                            </td>



                                            @if ($receipt->payment_mode == \App\Receipt::cash)
                                                <td>Cash</td>
                                            @elseif($receipt->payment_mode == \App\Receipt::bank)
                                                <td>Bank transfer</td>
                                            @elseif($receipt->payment_mode == \App\Receipt::cheque)
                                                <td>Cheque</td>
                                            @elseif($receipt->payment_mode == \App\Receipt::adjustment)
                                                <td>Adjustment </td>
                                            @else
                                                <td></td>
                                            @endif

                                            @if ($receipt->payment_head == \App\Receipt::down_payment)
                                                <td>Down Payment</td>
                                            @elseif($receipt->payment_head == \App\Receipt::possession_fee)
                                                <td>Possession Fee</td>
                                            @elseif($receipt->payment_head == \App\Receipt::installment)
                                                <td>Installment</td>
                                            @elseif($receipt->payment_head == \App\Receipt::other)
                                                <td>Other</td>
                                            @elseif($receipt->payment_head == \App\Receipt::transfer_fee)
                                                <td>Transfer Fee</td>
                                            @else
                                                <td></td>
                                            @endif

                                            <td class="printFV text-right">
                                                {{ number_format($receipt->amount) }}
                                            </td>

                                            <?php $total_amount += $receipt->amount; ?>
                                        </tr>
                                    @endif
                                    @endif
                                @endforeach
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>

                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>

                                    <td class="text-right"><b>Total Received Amount</b></td>
                                    <td class="text-right"><b>{{ number_format($total_amount) }}</b></td>
                                </tr>



                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
        <!-- /.container-fluid -->

        <div class="text-right" style="height:70px;">
            <button class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button">
                <span><i class="fa fa-print"></i> Print</span> </button>
        </div>

    @stop

    @section('js')
        <script src="{{ asset('js/jquery.PrintArea.js') }}" type="text/JavaScript"></script>
        <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

        <script>
            $(function() {
                $("#print").on("click", function() {
                    var mode = 'iframe'; //popup
                    var close = mode == "popup";
                    var options = {
                        mode: mode,
                        popClose: close
                    };
                    $("div.printableArea").printArea(options);
                });
            });
            $('#example1').DataTable({
                sorting: false,
                paging: false,
                ordering: false,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        </script>

    @stop
