
@extends('layouts.app')

@section('title')

Report
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Account Statement</li>
      </ol>
@stop
@section('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style type="text/css">
  .daterangepicker{
    right: 695px !important
  }
</style>
@endsection


@section('content')

 
  <!-- Main content -->
    <!-- Main content -->
    <section class="container-fluid">
      <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Account Statement Report</div>
                           
      <!-- /.box -->
          <!-- START CUSTOM TABS -->
          <!-- Custom Tabs -->
          <div class="nav-tabs-custom">
            <div class="tab-content">
              <div class="tab-pane active">
     <div class="row">
            <div class="col-md-6">
         <!-- Horizontal Form -->
            <!-- form start -->
            
                    @if($type == 'aging')
                    <form class="form-horizontal" method='post' action="{{route('aging.receivable')}}">
                    @else
                    <form class="form-horizontal" method='post' action="{{route('recovery.receivable')}}">
                    @endif  
                    
                {{ csrf_field() }}
                <div class="box-body">

               

                <div class="form-group">
                <label class="col-sm-3 control-label">Date range</label>
                <div class="col-sm-9">
                <div class="input-group" id="date-div">
                <div class="input-group-addon">
                <i class="fa fa-calendar"></i>
                </div>
                <input type="text" class="form-control pull-right" id="daterange-btn" value='{{old('date_range')}}' name='date_range'>

                </div>
                @if($errors->has('date_range'))
                <span class="help-block" >
                <strong>{{ $errors->first('date_range') }}</strong>
                </span>
                @endif
                </div>
                <!-- /.input group -->
                </div>
                <div class="form-group">
                <label class="col-sm-3 control-label"><input type='submit' class="btn btn-success" value='Generate'></label>

                </div>
                </div>
                </form>
          <!-- /.box -->
                </div>
        </div>
          <!-- /.row -->
              </div>
              <!-- /.tab-pane -->
            </div>
            <!-- /.tab-content -->
          </div>
          <!-- nav-tabs-custom -->
      <!-- END CUSTOM TABS -->
</div>
</div>
</div>
     </section>
    <!-- /.content -->
    <div class="clearfix"></div>

    @stop

    @section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script>

  const year = new Date().getFullYear();

  const this_fiscal_year_start_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const last_fiscal_year_end_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  


$('#daterange-btn').daterangepicker(
        {
            
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Fiscal Year' : [this_fiscal_year_start_date,this_fiscal_year_end_date],
            'Last Fiscal Year' : [last_fiscal_year_start_date,last_fiscal_year_end_date]
          },
          startDate: moment().subtract(29, 'days'),
          endDate: moment()
        },
        function (start, end) {
          $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }
    );


</script>
    <!--Accordian-->


   @stop