@extends('layouts.app')

@section('title')
Sold  Inventory Statement
@stop


@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Sold Inventory Statement</li>
      </ol>
@stop

@section('css')
<style type="text/css">
     @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        padding-top: 0px !important;
        color:black;
    }
   .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    /*.br-right {
         border-right: 1px solid #e6e3e3;
    }*/
    .txt-c {
        text-align: center;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
    table.dataTable thead th {
    border: 1px solid #f2f2f2 !important;
    }
    .table>tbody>tr>td {
     border: 1px solid #f2f2f2 !important; 
    }
    .bor .border-d{
        border-bottom: double !important;
        border-top: 1px solid !important;
    }
    h3 strong{
        text-transform: uppercase;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    .white-box1{
        padding: 0;
    }
      .bdr thead tr th  {
    border: 1px solid #2e3233 !important;
    background: #eee;
    }
    .table>thead:first-child>tr:first-child>th {
    border-top: 1px solid !important;
}


    }
</style>

<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop

@section('content')
@php
$society = false;
$highrise = false;
$size = '';

if ($projectType->id == App\ProjectType::society) {
    $society = true;
    $size = \App\ProjectType::society_size;
}

if ($projectType->id == App\ProjectType::high_rise) {
    $highrise = true;
    $size = \App\ProjectType::high_rise_size;
}

@endphp
<div class="container-fluid">
                <div class="row printableArea">
                    <div class="col-lg-12  ">
                    <div class="white-box">

                        <div class="text-center">
                            <h3><strong>
                                
                                @foreach($project_names as $key => $project_name)
                                {{ $project_name }}
                                @if($key < count($project_names) - 1)
                                    , 
                                @endif
                            @endforeach
                            </strong></h3>
                            <h4><strong>Sold Inventory Statement</strong></h4>
                             <h6>{{date(('M d,Y'),strtotime($from_date))}} - {{date(('M d,Y'),strtotime($to_date))}}</h6>
                        </div>


                        <div class="pull-right printFV" >
                            <span>Date: <b>{{date('d-m-Y')}}</b></span><br>
                            <span>User ID: &nbsp; {{Auth::user()->name}}</span>
                        </div>

                    <div class="table-responsive" style="clear: both;">
                        
                        @if($type == 'with_filter')
                        <form method="post" style="position: relative;left: 35rem;top: 3.5rem;z-index: 9999;width: 65%;" action="{{route('report.sold-inventory-generate')}}" class="no-print">
                              {{ csrf_field() }}
                                <div class="row">
                                    <div class="col-lg-5">
                                      
                                        <input type="hidden" value="{{$selected_date_range}}" name="date_range">
                                        <input type="hidden" value="{{$multipro_id}}" name="multipro_id">
                                        <select class="form-control chosen-select" name="block">
                                        <option value="">All Blocks</option>
                                        @foreach($unit_blocks as $unit_block)
                                        <option <?= ($block == $unit_block->id) ? 'selected' : '' ?> value="{{$unit_block->id}}">{{$unit_block->name}}</option>
                                        @endforeach
                                        </select>
                                    </div>


                                    <div class="col-lg-2">
                                       <input type="submit" value="Filter" class="btn btn-success">
                                    </div>


                                </div>
                            </form>
                        @endif

                                <table id="example1"  class="table bdr ">
                                    <thead>
                                        <tr>
                                            <th >Sr No.</th>
                                            <th >Date</th>
                                            <th >Unit No.</th>
                                            <th >Unit Floor.</th>
                                            <th >Unit Block.</th>
                                            <th >Customer</th>
                                            <th >Size</th>
                                            <th >Category</th>
                                            <th >Inventory Price</th>
                                            <th >Discount</th>
                                            <th >Net Price</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $total_amount = 0;   $inventory_price = 0; $discount_price = 0; $net_price = 0; $sqrt = 0; $count=1;?>
                                        
                                        @foreach($inventories as $inventory)
                                      
                                        @if($inventory->floor)
                                        @if( ($filter_type == 'filter' && $block > 0 && $block == $inventory->floor->unit_block->id) || $filter_type == 'all' ) 
                                       
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td class="printFV"> {{date('d-m-Y', strtotime($inventory->customer_property->booking_date)) }}</td>
                                            
                                            <td class="printFV">{{$inventory->unit_number}}</td>

                                            <td class="printFV">{{$inventory->floor ? $inventory->floor->name : ''}}</td>

                                            <td class="printFV">
                                                @if(!empty($inventory->floor))
                                                @if(!empty($inventory->floor->unit_block))
                                                {{$inventory->floor->unit_block->name}}
                                                @endif
                                                @endif

                                                
                                            </td>
                                            
                                             <td class="printFV">{{$inventory->customer_property->customer->name}}</td> 
                                            
                                    
                                            <td class="printFV">
                                               <?php
                                                 if($inventory->size){
                                                 $sqrt +=$inventory->size->name;
                                                 }
                                                 ?>
                                                   @if($inventory->size)
                                                    {{$inventory->size->name}}  {{$size}}
                                                    @endif
                                            </td>
                                            <?php $sum =0;?>
                                                    <td>@foreach($inventory->categories as $c)
                                                        <?php $sum += $c->category->percent;?>
                                                        @if($loop->last)
                                                        {{$c->category->name}} ({{$c->category->percent}} %)
                                                        @else
                                                        {{$c->category->name}} ({{$c->category->percent}} %),
                                                        @endif
                                                    @endforeach</td>
                                                    
                                            <td >
                                                <?php $inventory_price+=$inventory->total_price;  ?>
                                             {{ number_format($inventory->total_price)}} 
                                            </td>
                                            
                                            <td >
                                            
                                            @if(($inventory->total_price - $inventory->customer_property->net_pay) > 0 ) 
                                            {{ number_format( $inventory->total_price - $inventory->customer_property->net_pay ) }} 
                                            
                                            @else
                                            {{'-'}} 
                                            @endif
                                            <?php $discount_price +=($inventory->total_price - $inventory->customer_property->net_pay);?>
                                            
                                            </td>
                                            
                                            <td >
                                                      <?php $net_price+=$inventory->customer_property->net_pay;  ?>
                                                @if($inventory->customer_property){{number_format($inventory->customer_property->net_pay)}}
                                                @endif
                                            </td>
                                            
                                        </tr>
                                        @endif 
                                        @endif

                                        @endforeach
                                        
                                        
                                         <tr>
                                             <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                            <td></td>
                                            <td><b>{{$sqrt}} {{$size}}</b></td>
                                            <td></td>
                                           
                                            
                                            <td><b>{{number_format($inventory_price)}}</b></td>
                                            <td  ><b>{{number_format($discount_price)}}</b></td>
                                            <td><b>{{number_format($net_price)}}</b></td>
                                        </tr>
                                        
                                        
                                        
                                        
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                         
                                            
                                            <td  class="text-right"><b>Sold Inventory Amount</b></td>
                                            <td class="text-right"><b>{{number_format($net_price)}}</b></td>
                                        </tr>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                          
                                            
                                            <td  class="text-right"><b>Received Amount</b></td>
                                            <td class="text-right"><b>{{number_format($receivedAmt)}}</b></td>
                                        </tr>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                         
                                            
                                            <td  class="text-right"><b>Remaining Amount</b></td>
                                            <td class="text-right"><b>{{number_format($net_price - $receivedAmt)}}</b></td>
                                        </tr>
                                        
                                    </tbody>
                                </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
            <!-- /.container-fluid -->

                <div class="text-right" style="height:70px;">
                                        <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>

@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>

     <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });
    });
    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
    </script>
@stop