@extends('layouts.app')

@section('title')
Trial Balance Detail 
@stop

@section('css')
<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<style type="text/css">
   /* .btm-margin{
        border-bottom: 3px solid white;
    }*/
   /* .bg-grey {
        background-color: #efefef;
    }
    .bg-green {
        background-color: #ecf5eb;
    }*/
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }

    @media print {
       .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        }
        
    /*.bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }*/
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
     table.dataTable tbody td, table.dataTable tbody th {
    padding: 2px 4px !important;
    font-size: 12px;
    }
    table.dataTable{
        border:none;
        border-collapse: collapse !important;
    }

    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }

    }
</style>
<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop
@section('content')

<div class="container-fluid">

     <!--.row-->
                <div class="row no-print">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Customize Report</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">

                                                <div class="col-md-6">
                                                
                                                
                                               <div class="form-group">
                <label class="col-sm-3 control-label">Date range</label>
        <div class="col-sm-9">
                <div class="input-group" id="date-div">
                  <div class="input-group-addon">
                    <i class="fa fa-calendar"></i>
                  </div>
                  <input type="text" class="form-control pull-right" id="daterange-btn"   name='date_range' >
                
                </div>
                @if($errors->has('date_range'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('date_range') }}</strong>
                                    </span>
                                @endif
        </div>
                <!-- /.input group -->
              </div>
              </div>
              <div class="form-actions">
                                            <button type="button" class="btn btn-success update-report"> <i class="fa fa-check" ></i> Update</button>
                                            
                                        </div>
                
                                            </div>
                                            
                                        </div>

                                        
                                        
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->



    <div class="white-box  printableArea" style="text-align: center;" id="update-report">
        <h3>{{env('APP_NAME')}}</h3>
        <h4>{{$account->number}} - {{$account->name}} - Ledger</h4>
        <h6>As of {{date('M d,Y')}}</h6>
        
        <div class="row">
        

        <div class="col-md-12 pro-cart" >
        	<table id="example1" class="table table-bordered" style="font-size:12px;">
                     <thead style="    border-top: 1px solid #f2f2f2;">
                        <tr>
                            <!-- <th>Type</th> -->
                            <th>Date</th>
                            <th>Voucher #</th>
                            <!-- <th>Num</th>
                            <th>Adj</th> -->
                            <th>Name</th>
                            <th>Narration</th>
                            <!-- <th>Class</th> -->
                            
                            <th>Debit</th>
                            <th>Credit</th>
                            <th>Balance</th>
                        </tr>

                     </thead>
                     <tbody>
                        <tr>
                           <!--  <?php $balance = $pre_balance; $debit = $credit = 0;?>
                            <td class="bg-grey"  style="text-align:left; padding-left: 2%; font-size: 12px;"><b>{{$account->number}} - {{$account->name}}</b> </td> -->
                            <td></td>
                            <!-- <td></td> -->
                            <!-- <td></td> -->
                            <td></td>
                            <td></td>
                            <!-- <td></td> -->
                            <td></td>
                            <td></td>
                            <td></td>
                            


                            @if($balance < 0)
                            <td class="bg-grey text-right" style="color: red;font-size: 11px;"><b>{{number_format($balance)}}</b></td>
                            @else
                            <td class="bg-grey text-right" style="font-size: 11px;"><b>{{number_format($balance)}}</b></td>
                            @endif
                            
                        </tr>

                        @foreach($transactions as $t)
                        <tr>
                            <!-- <td style="font-size:11px;">{{$t->type}}</td> -->
                            <td style="font-size:11px;">{{date('d/m/Y',strtotime($t->date))}}</td>

                            <td style="font-size:11px;"> @if($t->voucher_type == \App\GeneralJournalEntry::CRV)
                           <span>CRV-{{$t->voucher_no}}</span>
                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BRV)
                           <span> BRV-{{$t->voucher_no}}</span>
                            @elseif($t->voucher_type == \App\GeneralJournalEntry::CPV)
                            <span>CPV-{{$t->voucher_no}}</span>
                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BPV)
                            <span>BPV-{{$t->voucher_no}}</span>
                            @elseif($t->voucher_type == \App\GeneralJournalEntry::JV)
                            <span>JV-{{$t->voucher_no}}</span>
                            @endif</td>
                           <!-- <td style="font-size:11px;">{{$t->entry_no}}</td>
                             <td style="font-size:11px;">@if($t->adjusting_entry)
                                <i class="fa fa-check"></i>
                                @endif
                            </td> -->
                            <td style="font-size:11px;">{{$t->controlAccount ? $t->controlAccount->name : ''}}
                            </td>
                            <td style="font-size:11px;">{{$t->memo}}</td>
                            <!-- <td style="font-size:11px;"></td> -->
                            
                            <td class="text-right" style="font-size: 11px;">{{$t->amount > 0 ? number_format(abs($t->amount)) : ''}} 
                                <?php $debit += $t->amount > 0 ? abs($t->amount) : 0;?>
                            </td>
                            <td class="text-right" style="font-size: 11px;">{{$t->amount < 0 ? number_format(abs($t->amount)) : ''}}
                                <?php $credit += $t->amount < 0 ? abs($t->amount) : 0;?>
                            </td>

                            @if($t->account->type->name == 'Other Current Liability' || $t->account->type->name == 'Long Term Liability' || $t->account->type->name == 'Current Liability' || $t->account->type->name == 'Equity')

                            @if($t->amount > 0)
                            <?php $balance += -$t->amount;?>
                            @else
                            <?php $balance += abs($t->amount);?>
                            @endif

                            @else
                            <?php $balance += $t->amount;?>
                            @endif

                            @if($balance < 0)
                            <td class="text-right" style="color: red;font-size: 11px;">{{number_format($balance)}}</td>
                            @else
                            <td class="text-right" style="font-size: 11px;">{{number_format($balance)}}</td>
                            @endif
                        </tr>
                        @endforeach

                        <tr class="bg-grey">
                            <!-- <td   style="text-align:left; padding-left: 2%; font-size: 12px;"><b>Total {{$account->number}} - {{$account->name}}</b> </td> -->
                            <td class="bg-grey"></td>
                            <!-- <td class="bg-grey"></td>
                            <td class="bg-grey"></td> -->
                            <td class="bg-grey"></td>
                            <td class="bg-grey"></td>
                            <!-- <td class="bg-grey"></td> -->
                            <td class="bg-grey text-right"><b>Total:</b>&nbsp;&nbsp;</td>
                            
                            <td class="text-right"  style="font-size:12px;border-top: 2px solid;    border-bottom: double;">{{number_format($debit)}}</td>
                            <td class="text-right" style="font-size:12px;border-top: 2px solid; border-bottom: double;">{{number_format($credit)}}</td>
                            <td class="text-right" style="font-size:12px;border-top: 2px solid;border-bottom: double;">{{number_format($balance)}}</td>

                        </tr>


                        <!-- <tr class="bg-grey">
                            <td class="bg-grey"  style="text-align:left; font-size: 12px;"><b>Total</b> </td> 
                            <td class="bg-grey"></td>
                             <td class="bg-grey"></td>
                            <td class="bg-grey"></td> 
                            <td class="bg-grey"></td>
                            <td class="bg-grey"></td>
                            <td class="bg-grey"></td>
                            <td class="bg-grey"></td>
                            <td class="text-right" style="font-size:12px;border-top: 2px solid; border-bottom: double;"><b>{{number_format($debit)}}</b></td>
                            <td class="text-right" style="font-size:12px;border-top: 2px solid;border-bottom: double;"><b>{{number_format($credit)}}</b></td>
                            <td class="text-right" style="font-size:12px;border-top: 2px solid;    border-bottom: double;"><b>{{number_format($balance)}}</b></td>
                        </tr> -->
				 </tbody>
			</table>

        </div>
    </div>
    </div>
    <div class="text-right" style="height:70px;">
                                        <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>
</div>

<input type="hidden" name="account_id" id="account_id" value="{{$account->id}}">

@stop

@section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>



<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>

    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );

    $('#daterange-btn').daterangepicker(
        {
          

            ranges: {
                'Today': [moment(), moment()],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
          },
        
        );

    
     $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });

     $('.update-report').on('click',function(){

        $('.preloader').fadeIn();
            
            date_range = $('#daterange-btn').val();
            account_id = $('#account_id').val();

            var data = {'date_range':date_range,'account_id':account_id};
            $.get('/report/update-trial-balance-detail',data,function(data){
                document.getElementById('update-report').innerHTML = data;

                
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });
     
    </script>


@stop

