@extends('layouts.app')

@section('title')
Trial Balance &nbsp;&nbsp; &nbsp;&nbsp; {{date('M d,Y',strtotime($from))}} - {{date('M d,Y',strtotime($to))}}
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Trial Balance</li>
      </ol>
@stop
@section('css')
<!-- <link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" /> -->


<style type="text/css">
@media print {
    @page {
        margin-top: 0;
        
          size: A4;
           size: landscape;
    }
    body {
        padding-top: 72px;
  
    }
    
      a[href]:after {
        content: none !important;
    }
    
}

tbody:not(:last-child):after {
    1px solid black !important;
}


table td:last-child {
     border-right: 1px solid black !important;
}


 tr td:first-child {
   border-left: 1px solid black !important;
}

   table.dataTable thead th, table.dataTable thead td {
    padding: 10px 18px;
    border: 1px solid #111 !important;
    }
    .bg-grey {
        background-color: #efefef;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }

    @media print {
       .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        }
    a {
        color: #000000;
    }
    .bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
     table.dataTable tbody td, table.dataTable tbody th {
    padding: 2px 4px !important;
    font-size: 12px;
    }
    table.dataTable{
        border:none;
        border-collapse: collapse !important;
    }

    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }
    h3 strong{
        text-transform: uppercase;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
    .fix-header .page-wrapper {
    margin-top: 0px !important;
    }
       .table>thead>tr>th, .user-table .table tbody>tr:last-child td {
    border-bottom: 1px solid #2e3233;
    line-height: 2.2;
    background: #eee;
    border-right: 1px solid;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    table.dataTable thead th {
    padding: 0 5px 0px 5px !important;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
}
    }

    b {
    font-weight: 700 !important;
}



</style>

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop
@section('content')

<div class="container-fluid">

     

    <div class="white-box  printableArea" id="update-report">
        <div class="text-center">
        <h3><strong>
            @foreach($project_names as $key => $project_name)
            {{ $project_name }}
            @if($key < count($project_names) - 1)
                , 
            @endif
        @endforeach    
        </strong></h3>
        <h4><strong>Trial Balance</strong></h4>
        <h6>{{date('M d,Y',strtotime($from))}} - {{date('M d,Y',strtotime($to))}}</h6>
        </div>
         <div class="text-right">User ID:&nbsp; {{Auth::user()->name}}</div>
        <div class="row">

            <button class="dt-button buttons-print no-print" style="z-index: 999;position: relative;left: 255px;top: 39px;" onclick="return printDoc()" tabindex="0" aria-controls="example1" type="button"><span>Print</span></button>

        
        @if($level == 0)

        <div class="col-md-12 pro-cart table-responsive" >
            
            <table id="example1" class="table table-bordered" width="100%" cellpadding="3" cellspacing="3" >
                
            

                     <thead >
                        <tr>
                            <th class="text-center"  width="100" style="border-bottom: none !important;min-width:10rem;">Code</th>
                            
                            <th class="text-center" style="border-bottom: none !important;min-width:40rem;">Accounts</th>
                            <td style="border-right: none !important;"></td>
                            <th class="text-center" style="border-left: none !important;border-right: none !important;" >Opening Balance</th>
                            
                            <td style="border-left: none !important;"></td>

                            <td style="border-right: none !important;"></td>
                            <th class="text-center ccc" style="border-left: none !important;border-right: none !important;">Current Activity(For the Period)</th>
                            
                            <td style="border-left: none !important;"></td>

                            <td style="border-right: none !important;"></td>
                            <th class="text-center"  style="border-left: none !important;border-right: none !important;">Closing Balance</th>
                            
                            <td style="border-left: none !important;"></td>

                        </tr>
                        <tr style="border: 1px solid;">
                             <th style="border-top: none !important;"></th>
                        <th style="border-top: none !important;"></th>
                        <th class="text-left">Debit</th>
                        <th class="text-left">Credit</th>
                        <th class="text-left">Balance</th>
                        <th class="text-left">Debit</th>
                        <th class="text-left">Credit</th>
                        <th class="text-left">Balance</th>
                        <th class="text-left">Debit</th>
                        <th class="text-left">Credit</th>
                        <th class="text-left">Balance</th>
                       
                    </tr>
                     </thead>
                     <tbody>
                     <!-- <tr class="bg-grey btm-margin">
                        <td class="pd-5">Accounts</td>
                            <td class="pd-5 text-right"  ><b>Debit</b></td> 
                            <td class="pd-5 text-right"  ><b>Credit</b></td>
                    </tr> -->

                    <?php $debit = $credit = $openBalance = $openDebit = $openCredit =  $periodDebit = $periodCredit = 0; 
                    $pdebit = $pcredit = $popenBalance = $popenDebit = $popenCredit =  $pperiodDebit = $pperiodCredit = 0;
                    $sdebit = $scredit = $sopenBalance = $sopenDebit = $sopenCredit = $speriodDebit = $speriodCredit = 0;
                    ?>

                    @foreach($accounts as $acc)
                    
                    @if($accountBalance[$acc->id])
                    
                    <?php $pdebit = $pcredit = $popenBalance = $popenDebit = $popenCredit =  $pperiodDebit = $pperiodCredit = 0; ?>
                    <tr class=" btm-margin" id="{{$acc->number}}">
                        <td class="text-left" style="font-size:14px;color: #4c4c4c;border-left: 1px solid black;"><b style="font-weight: bolder !important;">{{$acc->number}}</b></td>
                         <td class="text-left an" style="font-size:14px;color: #4c4c4c;"><b style="font-weight: bolder !important;"> {{$acc->name}}</b></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                        
                    </tr>
                    @foreach($subChild[$acc->id] as $sA)
                    
                    @if($subAccountBalance[$sA->id])
                    <?php $sdebit = $scredit = $sopenBalance = $sopenDebit = $sopenCredit =  $speriodDebit = $speriodCredit = 0;
                    ?>
                    
                    <tr class=" btm-margin"  id="{{$sA->number}}">
                         <td class="" style="font-size:13px;color:  #4c4c4c;border-left: 1px solid black;"><b style="font-weight: bolder !important;">{{$sA->number}} </b></td>
                         <td class="" style="font-size:13px;color:  #4c4c4c;"><b style="font-weight: bolder !important;">{{$sA->name}}</b></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                        
                    </tr>
                    
                    @foreach($child[$sA->id] as $c)
                    <?php $opening_credit=$current_credit=$current_debit = $opening_debit=0; ?>
                           
                   @if($childBalance[$c->id])
                    
                    <tr class=" btm-margin">
                         <td class="" style="font-size:12px;border-left: 1px solid black;"><b>{{$c->number}}</b></td>
                        <td class="" style="font-size:12px;"><b>{{$c->name}}</b></td>
                       @if($openingBalance[$c->id] > 0)
                       <?php $opening_debit= (float)$openingBalance[$c->id];?>
                       <td class="pd-5 text-right" id='te1'>{{number_format($openingBalance[$c->id])}}</td>
                       <td class="pd-5 text-right" id='te2'></td>
                       <td class="pd-5 text-right" id='te3'>{{number_format($openingBalance[$c->id])}}</td>
                       <?php $openDebit += $openingBalance[$c->id] ;?>
                       <?php $sopenDebit += $openingBalance[$c->id] ;?>
                       <?php $popenDebit += $openingBalance[$c->id] ;?>
                       @elseif($openingBalance[$c->id] < 0)
                       <td class="pd-5 text-right" id='te4'></td>
                       
                       <td class="pd-5 text-right"  id='te5'>{{number_format(abs($openingBalance[$c->id]))}}</td>
                        <?php $opening_credit= (float)$openingBalance[$c->id];?>
                       <td class="pd-5 text-right" id='te6'>({{number_format(abs($openingBalance[$c->id]))}})</td>
                       
                       <?php $openCredit += abs($openingBalance[$c->id]) ;?>
                       <?php $sopenCredit += abs($openingBalance[$c->id]) ;?>
                       <?php $popenCredit += abs($openingBalance[$c->id]) ;?>
                       @else
                       <td class="pd-5 "  id='te7'></td>
                       <td class="pd-5 "  id='te8'></td>
                       <td class="pd-5 "  id='te9'></td>
                       @endif
                       
                       <?php $openBalance += $openingBalance[$c->id];?>
                       <?php $popenBalance += $openingBalance[$c->id];?>
                       <?php $sopenBalance += $openingBalance[$c->id];?>
                       
                       
                       
                       <td class="pd-5 text-right" id='te10'>{{ $totalDebit[$c->id] != 0 ? number_format($totalDebit[$c->id]) : ''}}</td>
                       <?php $current_debit=  $totalDebit[$c->id] != 0 ? (float)$totalDebit[$c->id] : ''; ?>
                       @if($totalCredit[$c->id] != 0)
                       
                       <td class="pd-5 text-right" id='te11'>{{number_format(abs($totalCredit[$c->id]))}}</td>
                       <?php $current_credit =   (float)$totalCredit[$c->id];?>
                       @else
                       <td class="pd-5 text-right" id='te12'>-</td>
                       @endif
                       
                       <?php $bln = $totalDebit[$c->id] + $totalCredit[$c->id];?>
                       
                       @if($bln > 0)
                       <td class="pd-5 text-right" id='te13'>{{number_format($bln)}}</td>
                       @elseif($bln < 0)
                       <td class="pd-5 text-right ttt" id='te14'>({{number_format(abs($bln))}})</td>
                       @else
                       <td class="pd-5 text-right" id='te15'>-</td>
                       @endif
                       
                       
                       <?php $periodDebit += $totalDebit[$c->id];?>
                       <?php $pperiodDebit += $totalDebit[$c->id];?>
                       <?php $speriodDebit += $totalDebit[$c->id];?>
                       
                       <?php $periodCredit += abs($totalCredit[$c->id]);?>
                       
                       <?php $pperiodCredit += abs($totalCredit[$c->id]);?>
                       <?php $speriodCredit += abs($totalCredit[$c->id]);?>
                       
                       
                       <?php $total = $openingBalance[$c->id] + $accountRecord[$c->id];?>
                       
                        
                        @if($total > 0)
                            <td class="pd-5 text-right" id='te16'>{{number_format($total)}}</td> 
                            <td class="pd-5 text-right" id='te17'>-</td>
                            <td class="pd-5 text-right" id='te18'>{{number_format($total)}}</td> 
                            <?php $debit += $total;?>
                            <?php $pdebit += $total;?>
                            <?php $sdebit += $total;?>
                            @elseif($total < 0)

                            <td class="pd-5 txt-c"  ></td> 
                            <td class="pd-5 text-right"  >{{number_format(abs($total))}}</td>
                            
                            <td class="pd-5 text-right"  >({{number_format(abs($total))}})</td>
                            <?php $credit += abs($total);?>
                            <?php $pcredit += abs($total);?>
                            <?php $scredit += abs($total);?>
                            @else
                           <?php $closing_debits= (int)$current_debit + (int)$opening_debit; ?>
                           <?php $closing_credits= (int)$current_credit +   (int)$opening_credit;?>
                          
                            <td class="pd-5 txt-c"  >{{number_format(abs($closing_debits))}}  </td> 
                            <td class="pd-5 txt-c"  >{{number_format(abs($closing_credits))}} </td>
                           
                            <td class="pd-5 txt-c"  > ({{$total}})</td>


                            @endif
                    </tr>
                    
                    
                   @endif
                    @endforeach
                <!--second level value-->
                    <tr class=" btm-margin">
                          <td class="text-left" style="font-size:14px;margin-left:5%;border-right:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                        
                    </tr>
                    <?php $openDebt= $openCred=$currentDebt=$currentCred=0; ?>
                    <tr class=" btm-margin sub_account" style="display: none;" data-account-number="{{$sA->number}}">

                         <td class="" style="font-size:14px; font-weight: bolder !important;border-left: 1px solid black;"><b>{{$sA->number}}</b></td>
                         <td class="" style="font-size:14px; font-weight: bolder !important;"><b> {{$sA->name}}</b></td>
                         
                      
                         @if($sopenDebit > 0)
                            <?php  $openDebt = $sopenDebit; ?>
                        <td class="pd-5  text-right" style=" "><b>{{number_format($sopenDebit)}}</b></td> 
                        @elseif($sopenDebit < 0)
                           <?php  $openDebt = $sopenDebit; ?>
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($sopenDebit))}})</b></td> 
                        @else
                        <td class="text-right" style=" ">-</td>
                        @endif 
                         
                          @if($sopenCredit > 0)
                            <?php $openCred=$sopenCredit;  ?>
                        <td class="pd-5  text-right" style=" "><b>{{number_format($sopenCredit)}}</b></td> 
                        @elseif($sopenCredit < 0)
                          <?php $openCred=$sopenCredit;  ?>
                        <td class="pd-5  text-right" style=" "><b>({{number_format(abs($sopenCredit))}})</b></td> 
                        @else
                        <td class="text-right" style=" ">-</td>
                        @endif 
                        
                          <?php $bln = $sopenDebit - $sopenCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="text-right" style="">-</td>
                        @endif 
                           
                        @if($speriodDebit > 0)
                         <?php $currentDebt=$speriodDebit;  ?>
                        <td class="pd-5  text-right" style=""><b>{{number_format($speriodDebit)}}</b></td> 
                        @elseif($speriodDebit < 0)
                         <?php $currentDebt=$speriodDebit;  ?>
                        <td class="pd-5  text-right" style=" "><b>({{number_format(abs($speriodDebit))}})</b></td> 
                        @else
                        <td class="text-right" style=" ">-</td>
                        @endif
                     
                        @if($speriodCredit > 0)
                          <?php $currentCred=$speriodCredit;  ?>
                        <td class="pd-5  text-right" style=" "><b>{{number_format($speriodCredit)}}</b></td> 
                        @elseif($speriodCredit < 0)
                          <?php $currentCred=$speriodCredit;  ?>
                        <td class="pd-5  text-right" style=" "><b>({{number_format(abs($speriodCredit))}})</b></td> 
                        @else
                        <td class="text-right" style=" ">-</td>
                        @endif
                          <?php $sbln = $speriodDebit - $speriodCredit;?>
                        @if($sbln > 0)
                        <td class="pd-5  text-right" style=" "><b>{{number_format($sbln)}}</b></td> 
                        @elseif($sbln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($sbln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style=""><b>-</b></td> 
                        @endif
                       <?php $closingDebt = (float)$openDebt + (float)$currentDebt;?>
                       <?php $closingCredit = (float)$openCred + (float)$currentCred; ?>
                        <!--@if($sdebit > 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>{{number_format($sdebit)}}</b></td> -->
                        <!--@elseif($sdebit < 0)-->
                        <!--<td class="pd-5  text-right" style=" "><b>({{number_format(abs($sdebit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style=" "><b>-</b></td> -->
                        <!--@endif-->
                         @if($closingDebt > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($closingDebt)}}</b></td> 
                        @elseif($closingDebt < 0)
                        <td class="pd-5  text-right" style=" "><b>({{number_format(abs($closingDebt))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style=" "><b>-</b></td> 
                        @endif
                        
                        <!--    @if($scredit > 0)-->
                        <!--<td class="pd-5  text-right" style=" "><b>{{number_format($scredit)}}</b></td> -->
                        <!--@elseif($scredit < 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($scredit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style=""><b>-</b></td> -->
                        <!--@endif-->
                        
                            @if($closingCredit > 0)
                        <td class="pd-5  text-right" style=" "><b>{{number_format($closingCredit)}}</b></td> 
                        @elseif($closingCredit < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($closingCredit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style=""><b>-</b></td> 
                        @endif

                            <!--<?php $bln = $sdebit - $scredit;?>-->
                              <?php $bln = $closingDebt - $closingCredit;?>
                        @if($bln >= 0)
                        <td class="pd-5  text-right" style=" "><b>{{number_format($bln)}}</b></td> 
                        @else
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @endif
                            
                        
                    </tr>
                    
                    
                    @endif
                    @endforeach
                    
        
                     <tr class=" btm-margin">
                         <td class="text-left" style="font-size:14px;margin-left:5%;border-right:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                        
                    </tr>
                    <!--Level 1-->
                    <tr class=" btm-margin parent_account" style="display:none;" data-acc-number="{{$acc->number}}">
                        <!--<td></td>-->
                       <td class="text-left" style="font-size:15px;font-weight: bolder !important;border-left: 1px solid black;"><b>{{$acc->number}}</b></td>
                         <td class="text-left" style="font-size:15px;font-weight: bolder !important;"><b> {{$acc->name}}</b></td>
                     <?php $level1_open_cred = $level1_open_debt = $level1_current_cred = $level1_current_debt = $level1_close_debt = $level1_close_cred=0 ?>
                     
                          @if($popenDebit > 0)
                          <?php $level1_open_debt = $popenDebit;?>
                          <td class="pd-5  text-right" style=""><b>{{number_format($popenDebit)}}</b></td> 
                          @elseif($popenDebit < 0)
                           <?php $level1_open_debt = $popenDebit;?>
                          <td class="pd-5  text-right" style=""><b>({{number_format(abs($popenDebit))}})</b></td> 
                          @else
                          <td class="pd-5  text-right" style=""><b>-</b></td> 
                          @endif

                          @if($popenCredit > 0)
                           <?php $level1_open_cred = $popenCredit;?>
                          <td class="pd-5  text-right" style=""><b>{{number_format($popenCredit)}}</b></td> 
                          @elseif($popenCredit < 0)
                           <?php $level1_open_cred = $popenCredit;?>
                          <td class="pd-5  text-right" style=""><b>({{number_format(abs($popenCredit))}})</b></td> 
                          @else
                          <td class="pd-5  text-right" style=""><b>-</b></td> 
                          @endif

                         <?php $bln = $popenDebit - $popenCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($bln)}} </b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}}) </b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td>
                        @endif

                         @if($pperiodDebit > 0)
                          <?php $level1_current_debt = $pperiodDebit;?>
                        <td class="pd-5  text-right" style=""><b>{{number_format($pperiodDebit)}}</b></td> 
                        @elseif($pperiodDebit < 0)
                         <?php $level1_current_debt = $pperiodDebit;?>
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($pperiodDebit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td>
                        @endif

                         @if($pperiodCredit > 0)
                          <?php $level1_current_cred = $pperiodCredit;?>
                        <td class="pd-5  text-right" style=""><b>{{number_format($pperiodCredit)}}</b></td> 
                        @elseif($pperiodCredit < 0)
                         <?php $level1_current_cred = $pperiodCredit;?>
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($pperiodCredit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td>
                        @endif
                        
                         <?php $bln = $pperiodDebit - $pperiodCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @else 
                        <td class="pd-5  text-right" style="">-</td>
                        @endif
   
                     
                        <!--   <?php  $level1_close_debt = (float)$level1_open_debt+(float)$level1_current_debt; ?>-->
                        <!--@if($pdebit > 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>{{number_format($pdebit)}}</b></td> -->
                        <!--@elseif($pdebit < 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($pdebit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style="">-</td>-->
                        <!--@endif-->
                             <?php  $level1_close_debt = (float)$level1_open_debt+(float)$level1_current_debt; ?>
                        @if($level1_close_debt > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($level1_close_debt)}}</b></td> 
                        @elseif($level1_close_debt < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($level1_close_debt))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td>
                        @endif
                        
                          <?php $level1_close_cred  = (float)$level1_open_cred+(float)$level1_current_cred;?>
                        <!--@if($pcredit > 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>{{number_format($pcredit)}}</b></td> -->
                        <!--@elseif($pcredit < 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($pcredit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style="">-</td>-->
                        <!--@endif    -->
                          @if($level1_close_cred > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($level1_close_cred)}}</b></td> 
                        @elseif($level1_close_cred < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($level1_close_cred))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td>
                        @endif  

                        <?php $bln = $pdebit - $pcredit;?>
                        <?php $bln = $level1_close_debt - $level1_close_cred;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td> 
                        @endif
                        
                    </tr>
                    
                @endif
                @endforeach

                 

                    <tr class="bg-grey" >
                        <td></td>
                        <td class="text-right" style="font-size: 16px"><b>Total &nbsp;</b></td>


                        @if($openDebit > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($openDebit)}}</b></td> 
                        @elseif($openDebit < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($openDebit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif
                         @if($openCredit > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($openCredit)}}</b></td> 
                        @elseif($openCredit < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($openCredit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif
                         
                        <?php $bln = $openDebit - $openCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif
                        
                        @if($periodDebit > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($periodDebit)}}</b></td> 
                        @elseif($periodDebit < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($periodDebit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif

                        @if($periodCredit > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($periodCredit)}}</b></td> 
                        @elseif($periodCredit < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($periodCredit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif 
                        <?php $bln = $periodDebit - $periodCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif

                        @if($debit > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($debit)}}</b></td> 
                        @elseif($debit < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($debit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif
                        @if($credit > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($credit)}}</b></td> 
                        @elseif($credit < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($credit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif

                           <?php $bln = $debit - $credit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif
                    </tr>
                 </tbody>
            </table>

        </div>
        
        @elseif($level == 4)
        
        <div class="col-md-12 pro-cart table-responsive" >
            <table id="example1" class="table table-bordered" width="100%" cellpadding="3" cellspacing="3" >
                
            

                     <thead >
                        <tr>
                            <th class="text-center"  width="100" style="border-bottom: none !important;min-width:10rem;">Code</th>
                            
                            <th class="text-center" style="border-bottom: none !important;min-width:40rem;">Accounts</th>
                            <!--<td style="border-right: none !important;"></td>-->
                            <th class="text-center" style="border-left: none !important;border-right: none !important;" >Opening Balance</th>
                            
                            <!--<td style="border-left: none !important;"></td>-->

                            <td style="border-right: none !important;"></td>
                            <th class="text-center" style="border-left: none !important;border-right: none !important;">Current Activity(For the Period)</th>
                            
                            <td style="border-left: none !important;"></td>

                            <!--<td style="border-right: none !important;"></td>-->
                            <th class="text-center"  style="border-left: none !important;border-right: none !important;">Closing Balance</th>
                            
                            <!--<td style="border-left: none !important;"></td>-->

                        </tr>
                        <tr style="border: 1px solid;">
                             <th style="border-top: none !important;"></th>
                        <th style="border-top: none !important;"></th>
                        <!--<th class="text-left">Debit</th>-->
                        <!--<th class="text-left">Credit</th>-->
                        <th class="text-left">Balance</th>
                        <th class="text-left">Debit</th>
                        <th class="text-left">Credit</th>
                        <th class="text-left">Balance</th>
                        <!--<th class="text-left">Debit</th>-->
                        <!--<th class="text-left">Credit</th>-->
                        <th class="text-left">Balance</th>
                       
                    </tr>
                     </thead>
                     <tbody>
                     <!-- <tr class="bg-grey btm-margin">
                        <td class="pd-5">Accounts</td>
                            <td class="pd-5 text-right"  ><b>Debit</b></td> 
                            <td class="pd-5 text-right"  ><b>Credit</b></td>
                    </tr> -->

                    <?php $debit = $credit = $openBalance = $openDebit = $openCredit =  $periodDebit = $periodCredit = 0; 
                    $pdebit = $pcredit = $popenBalance = $popenDebit = $popenCredit =  $pperiodDebit = $pperiodCredit = 0;
                    $sdebit = $scredit = $sopenBalance = $sopenDebit = $sopenCredit = $speriodDebit = $speriodCredit = 0;
                    ?>

                    @foreach($accounts as $acc)
                    
                    @if($accountBalance[$acc->id])
                    
                    <?php $pdebit = $pcredit = $popenBalance = $popenDebit = $popenCredit =  $pperiodDebit = $pperiodCredit = 0; ?>
                    <tr class=" btm-margin" id="{{$acc->number}}">
                        <td class="text-left" style="font-size:14px;color: #4c4c4c;border-left: 1px solid black;"><b style="font-weight: bolder !important;">{{$acc->number}}</b></td>
                         <td class="text-left" style="font-size:14px;color: #4c4c4c;"><b style="font-weight: bolder !important;"> {{$acc->name}}</b></td>
                         <!--<td></td>-->
                         <!--<td></td>-->
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <!--<td></td>-->
                         <!--<td></td>-->
                         <td></td>
                        
                    </tr>
                    @foreach($subChild[$acc->id] as $sA)
                    
                    @if($subAccountBalance[$sA->id])
                    <?php $sdebit = $scredit = $sopenBalance = $sopenDebit = $sopenCredit =  $speriodDebit = $speriodCredit = 0;
                    ?>
                    
                    <tr class=" btm-margin"  id="{{$sA->number}}">
                         <td class="" style="font-size:13px;color:  #4c4c4c;border-left: 1px solid black;"><b style="font-weight: bolder !important;">{{$sA->number}} </b></td>
                         <td class="" style="font-size:13px;color:  #4c4c4c;"><b style="font-weight: bolder !important;">{{$sA->name}}</b></td>
                         <!--<td></td>-->
                         <!--<td></td>-->
                         <td></td>
                         <td></td>
                         <td></td>
                         <td></td>
                         <!--<td></td>-->
                         <!--<td></td>-->
                         <td></td>
                        
                    </tr>
                    
                    @foreach($child[$sA->id] as $c)
                   
                   @if($childBalance[$c->id])
                    
                    <tr class=" btm-margin">
                         <td class="" style="font-size:12px;border-left: 1px solid black;"><b>{{$c->number}}</b></td>
                        <td class="" style="font-size:12px;"><b>{{$c->name}}</b></td>
                        
                       @if($openingBalance[$c->id] > 0)
                       <!--<td class="pd-5 text-right">{{number_format($openingBalance[$c->id])}}</td>-->
                       <!--<td class="pd-5 text-right"></td>-->
                       <td class="pd-5 text-right">{{number_format($openingBalance[$c->id])}}</td>
                       <?php $openDebit += $openingBalance[$c->id] ;?>
                       <?php $sopenDebit += $openingBalance[$c->id] ;?>
                       <?php $popenDebit += $openingBalance[$c->id] ;?>
                       @elseif($openingBalance[$c->id] < 0)
                       <!--<td class="pd-5 text-right"></td>-->
                       <!--<td class="pd-5 text-right"  >{{number_format(abs($openingBalance[$c->id]))}}</td>-->
                       
                       <td class="pd-5 text-right">({{number_format(abs($openingBalance[$c->id]))}})</td>
                       
                       <?php $openCredit += abs($openingBalance[$c->id]) ;?>
                       <?php $sopenCredit += abs($openingBalance[$c->id]) ;?>
                       <?php $popenCredit += abs($openingBalance[$c->id]) ;?>
                       @else
                       <!--<td class="pd-5 "  ></td>-->
                       <!--<td class="pd-5 "  ></td>-->
                       <td class="pd-5 "  ></td>
                       @endif
                       
                       <?php $openBalance += $openingBalance[$c->id];?>
                       <?php $popenBalance += $openingBalance[$c->id];?>
                       <?php $sopenBalance += $openingBalance[$c->id];?>
                       
                       
                       
                       <td class="pd-5 text-right">{{ $totalDebit[$c->id] != 0 ? number_format($totalDebit[$c->id]) : ''}}</td>
                       @if($totalCredit[$c->id] != 0)
                       <td class="pd-5 text-right">{{number_format(abs($totalCredit[$c->id]))}}</td>
                       @else
                       <td class="pd-5 text-right">-</td>
                       @endif
                       
                       <?php $bln = $totalDebit[$c->id] + $totalCredit[$c->id];?>
                       
                       @if($bln > 0)
                       <td class="pd-5 text-right aaa">{{number_format($bln)}}</td>
                       @elseif($bln < 0)
                       <td class="pd-5 text-right">({{number_format(abs($bln))}})</td>
                       @else
                       <td class="pd-5 text-right">-</td>
                       @endif
                       
                       
                       <?php $periodDebit += $totalDebit[$c->id];?>
                       <?php $pperiodDebit += $totalDebit[$c->id];?>
                       <?php $speriodDebit += $totalDebit[$c->id];?>
                       
                       <?php $periodCredit += abs($totalCredit[$c->id]);?>
                       
                       <?php $pperiodCredit += abs($totalCredit[$c->id]);?>
                       <?php $speriodCredit += abs($totalCredit[$c->id]);?>
                       
                       
                       <?php $total = $openingBalance[$c->id] + $accountRecord[$c->id];?>
                       
                        
                        @if($total > 0)
                            <!--<td class="pd-5 text-right">{{number_format($total)}}</td> -->
                            <!--<td class="pd-5 text-right">-</td>-->
                            <td class="pd-5 text-right">{{number_format($total)}}</td> 
                            <?php $debit += $total;?>
                            <?php $pdebit += $total;?>
                            <?php $sdebit += $total;?>
                            @elseif($total < 0)

                            <!--<td class="pd-5 txt-c"  ></td> -->
                            <!--<td class="pd-5 text-right"  >{{number_format(abs($total))}}</td>-->
                            
                            <td class="pd-5 text-right"  >({{number_format(abs($total))}})</td>
                            <?php $credit += abs($total);?>
                            <?php $pcredit += abs($total);?>
                            <?php $scredit += abs($total);?>
                            @else
                            <!--<td class="pd-5 txt-c"  ></td> -->
                            <!--<td class="pd-5 txt-c"  ></td>-->
                            <td class="pd-5 txt-c"  ></td>

                            @endif
                    </tr>
                    
                    
                   @endif
                    @endforeach
                    
                    <tr class=" btm-margin">
                          <td class="text-left" style="font-size:14px;margin-left:5%;border-right:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <!--<td style="border-right:none;border-left:none;"></td>-->
                         <!--<td style="border-right:none;border-left:none;"></td>-->
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <!--<td style="border-right:none;border-left:none;"></td>-->
                         <!--<td style="border-right:none;border-left:none;"></td>-->
                         <td style="border-right:none;border-left:none;"></td>
                        
                    </tr>
                    
                    <tr class=" btm-margin sub_account" style="display: none;" data-account-number="{{$sA->number}}">

                         <td class="" style="font-size:14px; font-weight: bolder !important;border-left: 1px solid black;"><b>{{$sA->number}}</b></td>
                         <td class="" style="font-size:14px; font-weight: bolder !important;"><b> {{$sA->name}}</b></td>
                        <!-- @if($sopenDebit > 0)-->
                        <!--<td class="pd-5  text-right" style=" "><b>{{number_format($sopenDebit)}}</b></td> -->
                        <!--@elseif($sopenDebit < 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($sopenDebit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="text-right" style=" ">-</td>-->
                        <!--@endif -->

                        <!--  @if($sopenCredit > 0)-->
                        <!--<td class="pd-5  text-right" style=" "><b>{{number_format($sopenCredit)}}</b></td> -->
                        <!--@elseif($sopenCredit < 0)-->
                        <!--<td class="pd-5  text-right" style=" "><b>({{number_format(abs($sopenCredit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="text-right" style=" ">-</td>-->
                        <!--@endif -->
                          <?php $bln = $sopenDebit - $sopenCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="text-right" style="">-</td>
                        @endif 

                        @if($speriodDebit > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($speriodDebit)}}</b></td> 
                        @elseif($speriodDebit < 0)
                        <td class="pd-5  text-right" style=" "><b>({{number_format(abs($speriodDebit))}})</b></td> 
                        @else
                        <td class="text-right" style=" ">-</td>
                        @endif

                        @if($speriodCredit > 0)
                        <td class="pd-5  text-right" style=" "><b>{{number_format($speriodCredit)}}</b></td> 
                        @elseif($speriodCredit < 0)
                        <td class="pd-5  text-right" style=" "><b>({{number_format(abs($speriodCredit))}})</b></td> 
                        @else
                        <td class="text-right" style=" ">-</td>
                        @endif

  <?php $sbln = $speriodDebit - $speriodCredit;?>
                        @if($sbln > 0)
                        <td class="pd-5  text-right" style=" "><b>{{number_format($sbln)}}</b></td> 
                        @elseif($sbln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($sbln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style=""><b>-</b></td> 
                        @endif

                        <!--@if($sdebit > 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>{{number_format($sdebit)}}</b></td> -->
                        <!--@elseif($sdebit < 0)-->
                        <!--<td class="pd-5  text-right" style=" "><b>({{number_format(abs($sdebit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style=" "><b>-</b></td> -->
                        <!--@endif-->
                        <!--    @if($scredit > 0)-->
                        <!--<td class="pd-5  text-right" style=" "><b>{{number_format($scredit)}}</b></td> -->
                        <!--@elseif($scredit < 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($scredit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style=""><b>-</b></td> -->
                        <!--@endif-->

                            <?php $bln = $sdebit - $scredit;?>
                        @if($bln >= 0)
                        <td class="pd-5  text-right" style=" "><b>{{number_format($bln)}}</b></td> 
                        @else
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @endif
                            
                        
                    </tr>
                    
                    
                    @endif
                    @endforeach
                    
        
                     <tr class=" btm-margin">
                         <td class="text-left" style="font-size:14px;margin-left:5%;border-right:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <!--<td style="border-right:none;border-left:none;"></td>-->
                         <!--<td style="border-right:none;border-left:none;"></td>-->
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <td style="border-right:none;border-left:none;"></td>
                         <!--<td style="border-right:none;border-left:none;"></td>-->
                         <!--<td style="border-right:none;border-left:none;"></td>-->
                         <td style="border-right:none;border-left:none;"></td>
                        
                    </tr>
                    
                    <tr class=" btm-margin parent_account" style="display:none;" data-acc-number="{{$acc->number}}">
                        <!--<td></td>-->
                       <td class="text-left" style="font-size:15px;font-weight: bolder !important;border-left: 1px solid black;"><b>{{$acc->number}}</b></td>
                         <td class="text-left" style="font-size:15px;font-weight: bolder !important;"><b> {{$acc->name}}</b></td>
                          <!--@if($popenDebit > 0)-->
                          <!--<td class="pd-5  text-right" style=""><b>{{number_format($popenDebit)}}</b></td> -->
                          <!--@elseif($popenDebit < 0)-->
                          <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($popenDebit))}})</b></td> -->
                          <!--@else-->
                          <!--<td class="pd-5  text-right" style=""><b>-</b></td> -->
                          <!--@endif-->

                          <!--@if($popenCredit > 0)-->
                          <!--<td class="pd-5  text-right" style=""><b>{{number_format($popenCredit)}}</b></td> -->
                          <!--@elseif($popenCredit < 0)-->
                          <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($popenCredit))}})</b></td> -->
                          <!--@else-->
                          <!--<td class="pd-5  text-right" style=""><b>-</b></td> -->
                          <!--@endif-->

                         <?php $bln = $popenDebit - $popenCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td>
                        @endif

                         @if($pperiodDebit > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($pperiodDebit)}}</b></td> 
                        @elseif($pperiodDebit < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($pperiodDebit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td>
                        @endif

                         @if($pperiodCredit > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($pperiodCredit)}}</b></td> 
                        @elseif($pperiodCredit < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($pperiodCredit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td>
                        @endif
                        
                         <?php $bln = $pperiodDebit - $pperiodCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @else 
                        <td class="pd-5  text-right" style="">-</td>
                        @endif

                        <!--@if($pdebit > 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>{{number_format($pdebit)}}</b></td> -->
                        <!--@elseif($pdebit < 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($pdebit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style="">-</td>-->
                        <!--@endif-->

                        <!--@if($pcredit > 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>{{number_format($pcredit)}}</b></td> -->
                        <!--@elseif($pcredit < 0)-->
                        <!--<td class="pd-5  text-right" style=""><b>({{number_format(abs($pcredit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style="">-</td>-->
                        <!--@endif    -->

                        <?php $bln = $pdebit - $pcredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style=""><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style=""><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="">-</td> 
                        @endif
                        
                    </tr>
                    
                @endif
                @endforeach

                 

                    <tr class="bg-grey" >
                        <td></td>
                        <td class="text-right" style="font-size: 16px"><b>Total &nbsp;</b></td>


                        <!--@if($openDebit > 0)-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($openDebit)}}</b></td> -->
                        <!--@elseif($openDebit < 0)-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($openDebit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> -->
                        <!--@endif-->
                        <!-- @if($openCredit > 0)-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($openCredit)}}</b></td> -->
                        <!--@elseif($openCredit < 0)-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($openCredit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> -->
                        <!--@endif-->
                         
                        <?php $bln = $openDebit - $openCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif
                        
                        @if($periodDebit > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($periodDebit)}}</b></td> 
                        @elseif($periodDebit < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($periodDebit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif

                        @if($periodCredit > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($periodCredit)}}</b></td> 
                        @elseif($periodCredit < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($periodCredit))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif 
                        <?php $bln = $periodDebit - $periodCredit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif

                        <!--@if($debit > 0)-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($debit)}}</b></td> -->
                        <!--@elseif($debit < 0)-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($debit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> -->
                        <!--@endif-->
                        <!--@if($credit > 0)-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($credit)}}</b></td> -->
                        <!--@elseif($credit < 0)-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($credit))}})</b></td> -->
                        <!--@else-->
                        <!--<td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> -->
                        <!--@endif-->

                           <?php $bln = $debit - $credit;?>
                        @if($bln > 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($bln)}}</b></td> 
                        @elseif($bln < 0)
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>({{number_format(abs($bln))}})</b></td> 
                        @else
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;">-</td> 
                        @endif
                    </tr>
                 </tbody>
            </table>

        </div>
        
        @else
        
        <div class="col-md-12 pro-cart table-responsive" >
            <table id="example1" class="table table-bordered" width="100%" cellpadding="3" cellspacing="3" >
                
            

                     <thead >
                        <tr style="border: 1px solid;">
                        <th class="text-center"  width="100">Code</th>
                        <th class="text-center">Accounts</th>
                        <th class="text-center">Opening Balance</th>
                        <th class="text-center">Period Debit</th>
                        <th class="text-center">Period Credit</th>
                        <th class="text-center">Debit</th>
                        <th class="text-center">Credit</th>
                    </tr>
                     </thead>
                     <tbody>
                     <!-- <tr class="bg-grey btm-margin">
                        <td class="pd-5">Accounts</td>
                            <td class="pd-5 text-right"  ><b>Debit</b></td> 
                            <td class="pd-5 text-right"  ><b>Credit</b></td>
                    </tr> -->

                    <?php $debit = $credit = $openBalance =  $periodDebit = $periodCredit = 0; ?>

                    @foreach($accounts as $acc)
                    @if($openingBalance[$acc->id] != 0 || $totalDebit[$acc->id] != 0 || $totalCredit[$acc->id] != 0)

                    <tr class=" btm-margin">
                        <td class="text-left" style="font-size:14px;color: #4c4c4c;border-left: 1px solid black;border-left: 1px solid black;"><b>{{$acc->number}}</b></td>
                         <td class="text-left" style="font-size:14px;color: #4c4c4c;"><b> {{$acc->name}}</b></td>
                       @if($openingBalance[$acc->id] > 0)
                       <td class="pd-5 text-right">{{number_format($openingBalance[$acc->id])}}</td> 
                       @elseif($openingBalance[$acc->id] < 0)
                       <td class="pd-5 text-right"  >({{number_format(abs($openingBalance[$acc->id]))}})</td>
                       @else
                       <td class="pd-5 "  ></td>
                       @endif
                       
                       <?php $openBalance += $openingBalance[$acc->id];?>
                       
                       
                       
                       <td class="pd-5 text-right">{{ $totalDebit[$acc->id] != 0 ? number_format($totalDebit[$acc->id]) : ''}}</td>
                       @if($totalCredit[$acc->id] != 0)
                       <td class="pd-5 text-right">{{number_format(abs($totalCredit[$acc->id]))}}</td>
                       @else
                       <td class="pd-5 "  ></td>
                       @endif
                       
                       <?php $periodDebit += $totalDebit[$acc->id];?>
                       
                       <?php $periodCredit += abs($totalCredit[$acc->id]);?>
                       
                       <?php $total = $openingBalance[$acc->id] + $accountRecord[$acc->id];?>
                       
                        
                        @if($total > 0)
                            <td class="pd-5 text-right">{{number_format($total)}}</td> 
                            <td class="pd-5 "  ></td>
                            <?php $debit += $total;?>
                            @elseif($total < 0)

                            <td class="pd-5 txt-c"  ></td> 
                            <td class="pd-5 text-right"  >{{number_format(abs($total))}}</td>
                            <?php $credit += abs($total);?>
                            @else
                            <td class="pd-5 txt-c"  ></td> 
                            <td class="pd-5 txt-c"  ></td>

                            @endif
                    </tr>
                    @endif
                    @endforeach

                    <tr class="bg-grey" >
                          <td></td>
                        <td class="text-right"><b>Total &nbsp;</b></td>
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($openBalance)}}</b></td> 
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($periodDebit)}}</b></td> 
                        <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($periodCredit)}}</b></td> 
                            <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($debit)}}</b></td> 
                            <td class="pd-5  text-right" style="border-top: 1px solid; border-bottom: double;"><b>{{number_format($credit)}}</b></td>
                    </tr>
                 </tbody>
            </table>

        </div>
        
        
        @endif
    </div>
    </div>
    <div class="text-right" style="height:70px;">
    <button  class="btn btn-default btn-outline no-print" onclick="return printDoc()" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
    </div>
</div>



@stop

@section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

 <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>

    function printDoc()
    {
    
        var curURL = window.location.href;
history.replaceState(history.state, '', '/');
window.print();
history.replaceState(history.state, '', curURL);
        return false;
    }

        $( document ).ready(function() {

        $( ".sub_account" ).each(function() {

            $('#'+$(this).data("account-number")).html($(this).html()) 
            $(this).remove()
        });

        $( ".parent_account" ).each(function() {

            $('#'+$(this).data("acc-number")).html($(this).html()) 
            $(this).remove()
        });


      $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
           'copy', 'csv', 'excel',
            {
                extend : 'pdfHtml5',
                title : function() 
                {
                    return "{{env('APP_NAME')}}\nTrial Balance";
                },
                orientation : 'landscape',
                pageSize : 'A0', // You can also use "A1","A2" or "A3", most of the time "A3" works the best.
                text : '<i class=""> PDF</i>',
                titleAttr : 'PDF'
            }
        ]
    } );
 

});


  

    const year = new Date().getFullYear();

  const this_fiscal_year_start_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const last_fiscal_year_end_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  


$('#daterange-btn').daterangepicker(
        {
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Fiscal Year' : [this_fiscal_year_start_date,this_fiscal_year_end_date],
            'Last Fiscal Year' : [last_fiscal_year_start_date,last_fiscal_year_end_date]
          },
          startDate: moment().subtract(29, 'days'),
          endDate: moment()
        },
        function (start, end) {
          $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }
    );

    
     $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });

     $('.update-report').on('click',function(){

        $('.preloader').fadeIn();
            
            date_range = $('#daterange-btn').val();

            var data = {'date_range':date_range};
            $.get('/report/update-trial-balance',data,function(data){
                document.getElementById('update-report').innerHTML = data;

                $('#example1').DataTable({
                    'paging':false,
                    'searching':false,
                    'info':true,
                    dom: 'Bfrtip',
        buttons: [
            'csv', 'excel'
        ]
                });
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });
     
    </script>


@stop