        <h5 class="box-title">{{env('APP_NAME')}}</h5>
        <h4 class="box-title">Transactions by Account</h4>
        <h6>As of {{date('d/m/Y',strtotime($to))}}</h6>
        
        <div class="row">
        

        <div class="col-md-12 pro-cart" >
        	<table class="table table-bordered" style="font-size:12px;">
                     <thead>
                        <tr>
                            <th>Type</th>
                            <th>Date</th>
                            <th>Num</th>
                            <th>Adj</th>
                            <th>Name</th>
                            <th>Memo</th>
                            <th>Class</th>
                            <th>Account</th>
                            <th>Debit</th>
                            <th>Credit</th>
                            <th>Balance</th>
                        </tr>

                     </thead>
                     <tbody>
                        <tr>
                            <?php $balance = $pre_balance; $debit = $credit = 0;?>
                            <td class="bg-grey" colspan="10" style="text-align:left; padding-left: 2%; font-size: 12px;"><b>{{$account->number}} - {{$account->name}}</b> </td>
                            @if($balance < 0)
                            <td class="bg-grey" style="color: red;font-size: 11px;"><b>{{number_format($balance)}}</b></td>
                            @else
                            <td class="bg-grey" style="font-size: 11px;"><b>{{number_format($balance)}}</b></td>
                            @endif
                            
                        </tr>

                        @foreach($transactions as $t)
                        <tr>
                            <td style="font-size:11px;">General Journal</td>
                            <td style="font-size:11px;">{{date('d/m/Y',strtotime($t->date))}}</td>
                            <td style="font-size:11px;">{{$t->entry_no}}</td>
                            <td style="font-size:11px;">@if($t->adjusting_entry)
                                <i class="fa fa-check"></i>
                                @endif
                            </td>
                            <td style="font-size:11px;">{{$t->controlAccount ? $t->controlAccount->name : ''}}
                            </td>
                            <td style="font-size:11px;">{{$t->memo}}</td>
                            <td style="font-size:11px;"></td>
                            
                            <td style="font-size: 11px;">{{$t->amount > 0 ? number_format(abs($t->amount)) : ''}} 
                                <?php $debit += $t->amount > 0 ? abs($t->amount) : 0;?>
                            </td>
                            <td style="font-size: 11px;">{{$t->amount < 0 ? number_format(abs($t->amount)) : ''}}
                                <?php $credit += $t->amount < 0 ? abs($t->amount) : 0;?>
                            </td>
                            @if($t->account->type->name == 'Other Current Liability' || $t->account->type->name == 'Long Term Liability' || $t->account->type->name == 'Current Liability' || $t->account->type->name == 'Equity')

                            @if($t->amount > 0)
                            <?php $balance += -$t->amount;?>
                            @else
                            <?php $balance += abs($t->amount);?>
                            @endif

                            @else
                            <?php $balance += $t->amount;?>
                            @endif
                            
                            @if($balance < 0)
                            <td style="color: red;font-size: 11px;">{{number_format($balance)}}</td>
                            @else
                            <td style="font-size: 11px;">{{number_format($balance)}}</td>
                            @endif
                        </tr>
                        @endforeach

                        <tr class="bg-grey">
                            <td  colspan="8" style="text-align:left; padding-left: 2%; font-size: 12px;"><b>Total {{$account->number}} - {{$account->name}}</b> </td>
                            <td  style="font-size:12px;border-top: 2px solid;    border-bottom: double;">{{number_format($debit)}}</td>
                            <td style="font-size:12px;border-top: 2px solid; border-bottom: double;">{{number_format($credit)}}</td>
                            <td style="font-size:12px;border-top: 2px solid;border-bottom: double;">{{number_format($balance)}}</td>

                        </tr>


                        <tr class="bg-grey">
                            <td class="bg-grey" colspan="8" style="text-align:left; font-size: 12px;"><b>Total</b> </td>
                            <td style="font-size:12px;border-top: 2px solid; border-bottom: double;"><b>{{number_format($debit)}}</b></td>
                            <td style="font-size:12px;border-top: 2px solid;border-bottom: double;"><b>{{number_format($credit)}}</b></td>
                            <td style="font-size:12px;border-top: 2px solid;    border-bottom: double;"><b>{{number_format($balance)}}</b></td>

                        </tr>


                        

                    
				 </tbody>
			</table>

        </div>
    </div>
    