
@extends('layouts.app')

@section('title')

Report 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Expense By Vendor</li>
      </ol>
@stop
@section('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endsection


@section('content')

	<!-- Main content -->
    <!-- Main content -->
    <section class="container-fluid">
      <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Expense By Vendor</div>
                           
      <!-- /.box -->
          <!-- START CUSTOM TABS -->
          <!-- Custom Tabs -->
          <div class="nav-tabs-custom">
            <div class="tab-content">
              <div class="tab-pane active">
     <div class="row">
            <div class="col-md-6">
         <!-- Horizontal Form -->
            <!-- form start -->
            <form class="form-horizontal" method='post' action="{{route('report.vendor-expense.generate')}}">
                {{ csrf_field() }}
              <div class="box-body">

				<div class="form-group">
                <label class="col-sm-3 control-label">Date range</label>
				<div class="col-sm-9">
                <div class="input-group">
                  <div class="input-group-addon">
                    <i class="fa fa-calendar"></i>
                  </div>
                  <input type="text" class="form-control pull-right" id="daterange-btn" value='{{old('date_range')}}' name='date_range'>
                @if($errors->has('date_range'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('date_range') }}</strong>
                                    </span>
                                @endif
                </div>
				</div>
                <!-- /.input group -->
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Vendor</label>
        <div class="col-sm-9">
                <div class="input-group">
                  <div class="input-group-addon">
                    <i class="fa fa-person"></i>
                  </div>
                  <select class="form-control chosen-select" multiple="" name="vendor[]">
                    <option value="">None</option>
                    @foreach($vendors as $v)
                    <option value="{{$v->id}}">{{$v->name}}</option>
                    @endforeach
                  </select>
                @if($errors->has('vendor'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('vendor') }}</strong>
                                    </span>
                                @endif
                </div>
        </div>
                <!-- /.input group -->
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Category</label>
        <div class="col-sm-9">
                <div class="input-group">
                  <div class="input-group-addon">
                    <i class="fa fa-"></i>
                  </div>
                  <select class="form-control chosen-select" multiple="" name="category[]">
                    <option value="">None</option>
                    @foreach($categories as $c)
                    <option value="{{$c->id}}">{{$c->name}}</option>
                    @endforeach
                  </select>
                @if($errors->has('category'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('vendor') }}</strong>
                                    </span>
                                @endif
                </div>
        </div>
                <!-- /.input group -->
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Account</label>
        <div class="col-sm-9">
                <div class="input-group">
                  <div class="input-group-addon">
                    <i class="fa fa-cash"></i>
                  </div>
                  <select class="form-control chosen-select" name="account">
                    <option value="">None</option>
                    @foreach($accounts as $a)
                    <option value="{{$a->id}}">{{$a->name}}</option>
                    @endforeach
                  </select>
                @if($errors->has('account'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('account') }}</strong>
                                    </span>
                                @endif
                </div>
        </div>
                <!-- /.input group -->
              </div>

              
			  <div class="form-group">
                  <label class="col-sm-3 control-label"><input type='submit' class="btn btn-success" value='Generate'></label>

                </div>
              </div>
            </form>
          <!-- /.box -->
                </div>
        </div>
          <!-- /.row -->
              </div>
              <!-- /.tab-pane -->
            </div>
            <!-- /.tab-content -->
          </div>
          <!-- nav-tabs-custom -->
      <!-- END CUSTOM TABS -->
</div>
</div>
</div>
     </section>
    <!-- /.content -->
    <div class="clearfix"></div>

    @stop

    @section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script>
const year = new Date().getFullYear();

  const this_fiscal_year_start_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_START}} + '-01');

  const last_fiscal_year_end_date = new Date(year + '-' + {{\App\ChartOfAccount::FISCAL_YEAR_END}} + '-30');

  


$('#daterange-btn').daterangepicker(
        {
            
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Fiscal Year' : [this_fiscal_year_start_date,this_fiscal_year_end_date],
            'Last Fiscal Year' : [last_fiscal_year_start_date,last_fiscal_year_end_date]
          },
          startDate: moment().subtract(29, 'days'),
          endDate: moment()
        },
        function (start, end) {
          $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        }
    );
</script>
<script type="text/javascript">
 if (performance.navigation.type == 2) {
        window.location.reload();
    }
</script>
    <!--Accordian-->


   @stop