@extends('layouts.app')

@section('title')
Expense By Vendor Report 
@stop
@section('css')
<style type="text/css" media="print">
  @page {
    size: landscape;
   }
</style>

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Expense By Vendor</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <div class="row printableArea">
                	<div class="col-lg-12 headerF ">
                            <br>
                    <div class="white-box1">
                        <div class="text-center"><span style="font-size: 25px;">Expense By Vendor Report</span></div><br>
                        <div class="pull-left">
                        <br>

                            <span><b>FROM&nbsp;&nbsp;{{$from_date}}&nbsp;&nbsp;To&nbsp;&nbsp;{{$to_date}}</b></span>
                        </div>

                        <div class="pull-right" >
                            <span>Date: <b>{{date('d/m/y')}}</b></span><br>
<!--                            <span>Report No: &nbsp;202030</span><br>-->
                            <span>User ID: &nbsp; {{Auth::user()->name}}</span>
                        </div>
                    </div><div class="clear"></div>
                    </div>

                     <div class="col-lg-12 marginT">
                    	<div class="white-box1">
                           <div class="table-responsive" style="clear: both;">
                                <table id="example1" class="table table-bordered">
                                    <thead class="printFH11">
                                        <tr>
                                            <th style="color:white;">Date</th>
                                            <th style="color:white;">Category</th>
                                            <th style="color:white;">Description</th>
                                            <th style="color:white;">Account</th>
                                            <th style="color:white;">Debit</th>
                                            <th style="color:white;">Credit</th>
                                            <th style="color:white;">Balance</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $vendor = 0;$vendor_name = '';$debit = 0;$balance = 0;$count =0;$total = 0;?>
                                    @foreach($payments as $p)

                                    @if($complete_report)

                                    @if($p->bill->vendor_id != $vendor)
                                        

                                        @if($count != 0)
                                        <tr style="background-color: #dbeae3;">
                                                <td >Total {{$vendor_name}}</td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td>{{number_format($debit)}}</td>
                                                <td></td>
                                                <td>{{number_format($balance)}}</td>
                                            </tr>
                                        @endif
                                        
                                        <?php $vendor = $p->bill->vendor_id;?>
                                        <?php $vendor_name = $p->bill->vendor->name;?>
                                        <?php $debit = 0;$balance = $p->bill->vendor->opening_balance;?>


                                        <tr style="background-color: #ecd9d9;">
                                            <td ><b>{{$p->bill->vendor->name}}</b></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>

                                            <td>{{$balance}}</td>
                                        </tr>
                                        <tr>
                                            
                                            <td class="printFV">{{date('d/m/Y',strtotime($p->date))}}</td>
                                            <td class="printFV">
                                            {{$p->bill->category->name}}</td>
                                            <td class="printFV">{{$p->bill->notes}}</td>
                                            <td class="printFV">{{$p->account ? $p->account->name : ''}}</td>
                                            <td class="printFV">{{number_format($p->amount)}}</td>
                                            <?php $debit += $p->amount;?>
                                            <?php $balance += $p->amount;?>
                                            <?php $total += $p->amount;?>
                                            <td class="printFV"></td>
                                            <td class="printFV">{{number_format($balance)}}</td>
                                        </tr>
                                            @else

                                        
                                            <tr>
                                            
                                            <td class="printFV">{{date('d/m/Y',strtotime($p->date))}}</td>
                                            <td class="printFV">
                                            {{$p->bill->category->name}}</td>
                                            <td class="printFV">{{$p->notes}}</td>
                                            <td class="printFV">{{$p->account ? $p->account->name : ''}}</td>
                                            <td class="printFV">{{number_format($p->amount)}}</td>
                                            <?php $debit += $p->amount;?>
                                            <?php $balance += $p->amount;?>
                                            <?php $total +=$p->amount;?>
                                            <td class="printFV"></td>
                                            <td class="printFV">{{$balance}}</td>
                                        </tr>
                                            
                                        @endif

                                        <?php $count++;?>




                                    @else


                                   

                                    @if($p->bill->vendor_id != $vendor)
                                        

                                        @if($count != 0)
                                        <tr style="background-color: #dbeae3;">
                                                <td >Total {{$vendor_name}}</td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td>{{number_format($debit)}}</td>
                                                <td></td>
                                                <td>{{number_format($balance)}}</td>
                                            </tr>
                                        @endif
                                        
                                        <?php $vendor = $p->bill->vendor_id;?>
                                        <?php $vendor_name = $p->bill->vendor->name;?>
                                        <?php $debit = 0;$balance = 0;?>


                                        <tr style="background-color: #ecd9d9;">
                                            <td ><b>{{$p->bill->vendor->name}}</b></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>

                                        </tr>
                                        <tr>
                                            
                                            <td class="printFV">{{date('d/m/Y',strtotime($p->date))}}</td>
                                            <td class="printFV">
                                            {{$p->bill->category->name}}</td>
                                            <td class="printFV">{{$p->bill->notes}}</td>
                                            <td class="printFV">{{$p->account ? $p->account->name : ''}}</td>
                                            <td class="printFV">{{number_format($p->amount)}}</td>
                                            <?php $debit += $p->amount;?>
                                            <?php $balance += $p->amount;?>
                                            <?php $total += $p->amount;?>
                                            <td class="printFV"></td>
                                            <td class="printFV">{{number_format($balance)}}</td>
                                        </tr>
                                            @else

                                        
                                            <tr>
                                            
                                            <td class="printFV">{{date('d/m/Y',strtotime($p->date))}}</td>
                                            <td class="printFV">
                                            {{$p->bill->category->name}}</td>
                                            <td class="printFV">{{$p->notes}}</td>
                                            <td class="printFV">{{$p->account ? $p->account->name : ''}}</td>
                                            <td class="printFV">{{number_format($p->amount)}}</td>
                                            <?php $debit += $p->amount;?>
                                            <?php $balance += $p->amount;?>
											<?php $total +=$p->amount;?>
                                            <td class="printFV"></td>
                                            <td class="printFV">{{$balance}}</td>
                                        </tr>
                                            
                                        @endif

                                        <?php $count++;?>

                                        @endif
                                        
                                        @endforeach

                                        

                                       
                                        <tr style="background-color: #dbeae3;">
                                                <td >Total {{$vendor_name}}</td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td>{{number_format($debit)}}</td>
                                                <td></td>
                                                <td>{{number_format($balance)}}</td>
                                            </tr>
                                            
                                            
                                             <tr style="background-color: #dbeae3;">
                                                <td  style="text-align:centre;"><b>Total Expense </b> </td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td><b>{{number_format($total)}}</b></td>
                                                <td></td>
                                                <td><b>{{number_format($total)}}</b></td>
                                            </tr>
                                            
                                    </tbody>
                                </table>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-right" style="height:70px;">
                                        <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
                                    </div>
            </div>
            <!-- /.container-fluid -->



@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
     <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

      <script>

    $(function() {
        $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });
    });
    </script>
 <script>
 	$('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
 </script>
@stop