@extends('layouts.app') 

@section('title') Payment Receipt @stop 

@section('css')
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media print {
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    h3 {
        margin: 0;
        line-height: 1;
    }
    .white-box {
        border: none !important;
    }
}
</style> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
    <li><a href="#">Payment Receipt</a></li> 
    @endpermission
    <li class="active">Receipt Detail</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>

                
        <div class="col-lg-12">
            <div class="white-box">
                <br>
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                   <div class="col-md-1"></div>
                    <div class="col-md-10" style="background: #D9E1F2;margin-top:3rem;">
                        
                        <div class="col-md-12" >
                            <center><h3><strong>Buy Back form</strong></h3></center>
                        </div>
                        
                         <div class="col-md-6 col-xs-6">
                            <p>Ref# <span style="margin-left:15px;">{{$buyback->ref_no}}</span></p>
                            <p>Party code: <span style="margin-left:15px;">{{$buyback->party_code}}</span></p>
                            <p>Unit details </p>
                            <p>Project: <span style="margin-left:15px;">AAA</span></p>
                            <p>Unit: <span style="margin-left:15px;">{{$buyback->inventory->unit_number}}</span></p>
                        </div>
                        <div class="col-md-6 col-xs-6">
                            <p>Date: <span style="margin-left:15px;">{{$buyback->date}}</span></p>
                            <p>Name: <span style="margin-left:15px;">{{$buyback->inventory->property->customer->name}}</span></p>
                            <p>&nbsp;</p>
                            <p>Floor: <span style="margin-left:15px;">{{$buyback->inventory->floor->name}}</span></p>
                            <p>Unit area: <span style="margin-left:15px;">{{$buyback->inventory->area}}</span></p>
                        </div>
                        
                        <div class="col-md-6 col-xs-6">
                            <p>Investment Details</p>
                            <p>Total Amount invested:<span style="margin-left:15px;">{{$buyback->total_amount_invested}}</span></p>
                            <p>Total Amount Received: <span style="margin-left:15px;">{{$buyback->total_amount_received}}</span></p>
                            <p>If merging then value of merging: <span style="margin-left:15px;">{{$buyback->if_merging_then_value_of_merging}}</span></p>
                            <p>ROI Terms: <span style="margin-left:15px;">{{$buyback->roi_terms}}</span></p>
                            
                        </div>
                        <div class="col-md-6 col-xs-6">
                            <p>&nbsp;</p>
                            <p>Payment mode: <span style="margin-left:15px;">
                            
                            @if($buyback->payment_mode == \App\Receipt::cash)
                            Cash
                            @elseif($buyback->payment_mode == \App\Receipt::bank)
                            Bank
                            @elseif($buyback->payment_mode == \App\Receipt::cheque)
                            Cheque
                            @endif
                            
                            </span></p>
                            <p>Buy Back Option <span style="margin-left:15px;">{{$buyback->buy_back_option}}</span></p>
                            <p>Merging sold   @if($buyback->merging_sold == 'yes') {{'YES'}} @else {{'NO'}} @endif</p>
                            <p>Sales Agents <span style="margin-left:15px;">{{$buyback->sales_agents}}</span></p>
                        </div>
                        
                        
                        
                        <div class="col-md-12">
                            <br>
                            <p>Buy Back Value requested by client: <span style="margin-left:15px;">{{$buyback->buy_back_value_requested_by_client}}</span></p>
                        </div>
                        
                        <div class="col-md-12">
                            <br>
                            <p>Merging Reciepts: <span style="margin-left:15px;">{{$buyback->merging_receipts}}</span></p>
                            <br>
                            <p>Rental(discount) paid to customer for unit : <span style="margin-left:15px;">{{$buyback->rental_discount_paid_to_customer_for_unit}}</span></p>
                            <p>Loss/Profit on Merging : <span style="margin-left:15px;">{{$buyback->loss_or_profit_on_merging}}</span></p>
                            <p>Total Rebate Payable : <span style="margin-left:15px;">{{$buyback->total_rebate_payable}}</span></p>
                            <p>Rebate Paid : <span style="margin-left:15px;">{{$buyback->rebate_paid}}</span></p>
                            <p>Merging Selling Expenses : <span style="margin-left:15px;">{{$buyback->merging_selling_expenses}}</span></p>
                            <p>Rebate on Buy Back : <span style="margin-left:15px;">{{$buyback->rebate_on_buy_back}}</span></p>
                            <br>
                            <p>Value of Appreciation in PKR & %age : <span style="margin-left:15px;">{{$buyback->value_of_appreciation_in_pkr}}</span></p>
                            <br>
                            <br>
                            <p>ROI as per Customer : <span style="margin-left:15px;">{{$buyback->roi_as_per_customer}}</span></p>
                            <br>
                            <p>ROI as per Company : <span style="margin-left:15px;">{{$buyback->roi_as_per_company}}</span></p>
                             <br>
                            <p>Finance</p>
                        </div>
                        
                        <div class="col-md-5 col-xs-5">
                            <p>Compliance</p>
                        </div>
                        <div class="col-md-7 col-xs-7">
                            <p>CM/MD</p>
                        </div>
                        
                        <!--<p style="border-bottom: 1px solid #4a5256;"></p>-->
                    </div>    
                    <div class="col-md-1"></div>
                </div>
                <br>
                
            </div>
        </div>
        

  


                
    </div>
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
$('#upload_btn').html('Uploading...')
$('#upload_btn').prop('disabled' , true)

 var form_data = new FormData();

       // Read selected files
   var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

    form_data.append("receipt_id", receipt_id);


   $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
   $.ajax({
     url:"{{ route('receipt.document') }}",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>


@stop