@extends('layouts.app') 

@section('title') Payment Receipt @stop 

@section('css')
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media print {
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    h3 {
        margin: 0;
        line-height: 1;
    }
    .white-box {
        border: none !important;
    }
}
</style> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
    <li><a href="#">Payment Receipt</a></li> 
    @endpermission
    <li class="active">Receipt Detail</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>

                
        <div class="col-lg-12">
            <div class="white-box">
                <br>
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                   <div class="col-md-1"></div>
                    <div class="col-md-10" style="background: #D9E1F2;">
                        
                        <div class="col-md-12" >
                            <center><h3><strong>Buy Back Payment Form</strong></h3></center>
                        </div>
                        
                         <div class="col-md-6 col-xs-6">
                            <p>Ref# <span style="margin-left:15px;">{{$buyback->ref_no}}</span></p>
                            <p>Party code: <span style="margin-left:15px;">{{$buyback->party_code}}</span></p>
                            <p>Unit details </p>
                            <p>Project: <span style="margin-left:15px;">AAA</span></p>
                            <p>Unit: <span style="margin-left:15px;">{{$buyback->inventory->unit_number}}</span></p>
                        </div>
                        <div class="col-md-6 col-xs-6">
                            <p>Date: <span style="margin-left:15px;">{{$buyback->date}}</span></p>
                            <p>Name: <span style="margin-left:15px;">{{$buyback->inventory->property->customer->name}}</span></p>
                            <p>&nbsp;</p>
                            <p>Floor: <span style="margin-left:15px;">{{$buyback->inventory->floor->name}}</span></p>
                            <p>Unit area: <span style="margin-left:15px;">{{$buyback->inventory->area}}</span></p>
                        </div>
                        
                        <div class="col-md-4 col-xs-4">
                            <br><br>
                            <p>Total Amount:  <span style="margin-left:15px;">{{$buyback->total_amount}}</span></p>
                            <br>
                            <p>Payment Type</p>
                        </div>  
                        <div class="col-md-8 col-xs-8">
                            <br><br>
                            <br>
                            <br>
                            <br>
                                <p>
                                    
                                     @if($buyback->payment_mode == \App\Receipt::cash)
                                            <span>Cash</span>
                                            @elseif($buyback->payment_mode == \App\Receipt::bank)
                                            <span>Bank</span>
                                            @elseif($buyback->payment_mode == \App\Receipt::cheque)
                                            <span>Cheque</span>
                                            @else
                                            <span></span>
                                            @endif
                                            
                                </p>
                        </div>
                        
                        <div class="col-md-12">
                            <br>
                            <p>Payee Details</p>
                            <p>Name : <span style="margin-left:15px;">{{$buyback->payee_name}}</span></p>
                            <p>CNIC : <span style="margin-left:15px;">{{$buyback->payee_cnic}}</span></p>
                            <p>Address : <span style="margin-left:15px;">{{$buyback->payee_address}}</span></p>
                        </div>
                        
                        <div class="col-md-4">
                            <p>Banking details</p>
                        </div>
                        <div class="col-md-8">
                            <p>if cheque or bank transfer</p>
                        </div>
                        
                        <div class="col-md-12">
                            <p style="border-bottom: 2px solid black;"><strong>Term & Conditions</strong></p>
                            <br>
                            <br>
                            <br>
                            <p><center><strong>{{$buyback->term_and_conditions}}</strong></center></p>
                            <br>
                            <br>
                            <br>
                            <p style="border-bottom: 2px solid black;"></p>
                            <br>
                            <br>
                            <br>
                            <p><strong>Customer Sign</strong> <span style="display:inline-block; width:200px; margin-left:40px; border-bottom: 2px solid black;">&nbsp;</span> </p>
                        </div>
                        <!--<p style="border-bottom: 1px solid #4a5256;"></p>-->
                    </div>    
                    <div class="col-md-1"></div>
                </div>
                <br>
                
            </div>
        </div>
        

  


                
    </div>
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
$('#upload_btn').html('Uploading...')
$('#upload_btn').prop('disabled' , true)

 var form_data = new FormData();

       // Read selected files
   var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

    form_data.append("receipt_id", receipt_id);


   $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
   $.ajax({
     url:"{{ route('receipt.document') }}",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>


@stop