@extends('layouts.app')


@section('title')
Add New Buy Back 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('buy-back-requisition')
        <li ><a href="{{route('buy.back.list.requisition')}}">All Buy Back </a></li>
        @endpermission
        <li class="active">Add Buy Back </li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        @if($errors->any())
                        <div class="white-box1"><h2>Errors</h2><ul>
                        {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul></div>
                        @endif
                        
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Buy Back REQUISITION FORM: MR - 001</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" action="{{route('buy.back.requisition')}}" method="post" autocomplete="off">
                               {{csrf_field()}}
                               
                               
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">Ref No <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" name="ref_no" value="@if(old('ref_no')) {{old('ref_no')}}@else {{'REF-'.rand(100,999)}}@endif" id="exampleInputuname" placeholder="Enter mrf  no">
                                @if ($errors->has('ref_no'))
                                <span class="help-block">
                                <strong>{{ $errors->first('ref_no') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                                
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">Date</label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="date" class="form-control" name="date" value="@if(old('date')) {{old('date')}}@else {{date('d-m-Y')}}@endif" >
                                @if ($errors->has('date'))
                                <span class="help-block">
                                <strong>{{ $errors->first('date') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                                

                                <div class="form-group">
                                <label for="cnic" class="col-sm-2 control-label">Party Code <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                <input type="text"  class="form-control" value="@if(old('party_code')) {{old('party_code')}}@else {{rand(1000,9999)}}@endif" name="party_code" id="party_code"   placeholder="Requested By"  >
                                
                                
                                @if ($errors->has('party_code'))
                                <span class="help-block">
                                <strong>{{ $errors->first('party_code') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>

                                
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label"> Name</label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" readonly name="cus_name"  id="cus_name" value="{{old('cus_name')}}" placeholder="Enter  customer name">
                                @if ($errors->has('cus_name'))
                                <span class="help-block">
                                <strong>{{ $errors->first('cus_name') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                            
                                

                                <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">Unit Number <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-world"></i></div>
                                <select class="form-control chosen-select" id="unit_number" name="inventory_id" onchange="return getUnitDetail(this)">
                                <option value="" selected="">None</option>
                                @foreach($unitNumbers as $un)
                                <option value="{{$un->id}}">{{$un->name}}</option>
                                @endforeach
                                </select>
                                @if ($errors->has('inventory_id'))
                                <span class="help-block">
                                <strong>{{ $errors->first('inventory_id') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                        
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Floor </label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-email"></i></div>
                                <input type="text"  class="form-control" readonly name="floor" value="{{old('floor')}}" id="floor" placeholder="Enter floor">
                                @if ($errors->has('floor'))
                                <span class="help-block">
                                <strong>{{ $errors->first('floor') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                               
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Area</label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control" readonly type='text' name="area" value="{{old('area')}}" id="area"  placeholder="Enter area">
                                @if ($errors->has('area'))
                                <span class="help-block">
                                <strong>{{ $errors->first('area') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Total Amount invested </label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="total_amount_invested" value="{{old('total_amount_invested')}}"  placeholder="Enter total amount invested">
                                @if ($errors->has('total_amount_invested'))
                                <span class="help-block">
                                <strong>{{ $errors->first('total_amount_invested') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Total Amount Received </label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="total_amount_received" value="{{old('total_amount_received')}}"  placeholder="Enter total amount received">
                                @if ($errors->has('total_amount_received'))
                                <span class="help-block">
                                <strong>{{ $errors->first('total_amount_received') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">If merging then value of merging </label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="if_merging_then_value_of_merging" value="{{old('if_merging_then_value_of_merging')}}"  placeholder="Enter if merging then value of merging">
                                @if ($errors->has('if_merging_then_value_of_merging'))
                                <span class="help-block">
                                <strong>{{ $errors->first('if_merging_then_value_of_merging') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Buy Back Option </label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="buy_back_option" value="{{old('buy_back_option')}}"  placeholder="Enter buy back option">
                                @if ($errors->has('buy_back_option'))
                                <span class="help-block">
                                <strong>{{ $errors->first('buy_back_option') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">Payment Method <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-world"></i></div>
                                 <select class="form-control chosen-select" id="payment_method" name='payment_mode' onchange="changeFunc(this.value)" >


                                    @if(old('payment_method') == \App\Receipt::cash)
                                    <option selected value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                   

                                    @elseif(old('payment_method') == \App\Receipt::bank)
                                    
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option selected value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                   

                                    @elseif(old('payment_method') == \App\Receipt::cheque)
                                    
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option selected value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                  

                                    @elseif(old('payment_method') == \App\Receipt::adjustment)
                                    
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                   
                                    @else
                                    
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                   
                                    @endif

                                </select> 
                                @if ($errors->has('payment_method')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('payment_method') }}</strong>
                                </span> 
                                @endif 
                                
                                
                                </div>
                                </div>
                                </div>
                               
                                
                                
                                 <div class="col-md-6" id='bank' style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4">Depositor Bank Name <span style="color:red;">*</span></label>
                            <div class="col-md-8">
                                <select name="bank_name" class="form-control chosen-select">
                                    <option value="" selected="">None</option> 

                                    @foreach($banks as $bank) 

                                    @if(old('bank_name') == $bank->id)
                                    <option selected="" value="{{$bank->id}}">{{$bank->name}}</option> @else
                                    <option value="{{$bank->id}}">{{$bank->name}}</option> 
                                    @endif 

                                    @endforeach 
                                    </select> 

                                    @if ($errors->has('bank_name')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                    </span> 
                                    @endif 
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6" id='company-bank' style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4">Company Account <span style="color:red;">*</span></label>
                            <div class="col-md-8">
                                <select name="company_account" class="form-control chosen-select">
                                    <option value="" selected="">None</option> 
                                    
                                    @foreach($cBanks as $bank) 
                                    
                                    @if(old('company_account') == $bank->id)
                                    <option selected="" value="{{$bank->id}}">{{$bank->name}} - {{$bank->account_number}}</option> 
                                    @else
                                    <option value="{{$bank->id}}">{{$bank->name}} - {{$bank->account_number}}</option> 
                                    @endif 
                                    @endforeach 

                                </select> 

                                @if ($errors->has('company_account')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('company_account') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                    </div>
                        
                    <div class="col-md-6" id="cheque-dd-po-drawn-date" style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4"> Drawn Date <span style="color:red;">*</span></label>
                            <div class="col-md-8">
                                <input type="date" class="form-control" name='drawn_date' value="" id="exampleInputEmail1" placeholder="Enter Receipt Date" > 
                                @if ($errors->has('drawn_date')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('drawn_date') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6" id="cheque-dd-po-instrument-no" style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4"> Instrument No <span style="color:red;">*</span></label>
                            <div class="col-md-8">
                                <input type="text" name='cheque_number' value="" class="form-control" id="exampleInputEmail1" placeholder="Enter Instrument Number"> 
                                @if ($errors->has('cheque_number')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('cheque_number') }}</strong>
                                </span> 
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    
                                
                                 <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">ROI Terms  </label>
                                <div class="col-sm-10">
                              
                                <textarea class="form-control" name="roi_terms" rows="4">{{old('roi_terms')}} </textarea>
                             
                                </div>
                                </div>
                                
                                
                                
                            <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">buy back value requested by client </label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="buy_back_value_requested_by_client" value="{{old('buy_back_value_requested_by_client')}}"  placeholder="Enter buy back value requested by client">
                                @if ($errors->has('buy_back_value_requested_by_client'))
                                <span class="help-block">
                                <strong>{{ $errors->first('buy_back_value_requested_by_client') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                            
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Sales Agents</label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="sales_agents" value="{{old('sales_agents')}}"  placeholder="Enter sales agents">
                                @if ($errors->has('sales_agents'))
                                <span class="help-block">
                                <strong>{{ $errors->first('sales_agents') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Merging sold:   </label>
                                <div class="col-sm-5">
                                
                                <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;"> Yes : </span><input type="radio" class="form-control" checked  name="merging_sold" value="yes"  >
                                
                                </div>
                                
                                <div class="col-sm-5">
                                
                                <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;">  No:  </span><input type="radio" class="form-control"   name="merging_sold" value="no"  >
                            
                                </div>
                                
                                @if ($errors->has('merging_sold'))
                                <span class="help-block">
                                <strong>{{ $errors->first('merging_sold') }}</strong>
                                </span>
                                @endif
                                
                                </div>
                            
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                 <div class="form-group">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
    
    
      function changeFunc(a)
      {
            if(a == {{\App\Receipt::cash}})
            {
              $('#bank').css('display', 'none');
              $('#company-bank').css('display', 'none');
              $('#cheque').css('display', 'none');
              $('#cheque-dd-po-drawn-date').css('display', 'none');
              $('#cheque-dd-po-instrument-no').css('display', 'none');
            }
            else if(a == {{\App\Receipt::bank}})
            {
              $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
            }
            else if(a == {{\App\Receipt::cheque}})
            {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
            }
  }
  
    
    function getUnitDetail(self)
    {
        var unitId = $(self).val();
        
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        
        $.ajax({
        url:"{{ route('getUnitDetail') }}",
        method:'GET',
        dataType:'json',
        data: {unitId:unitId},
        success:function(data)
        {
            if(data.output != '')
            {
              $('#cus_name').val(data.output.property.customer.name); 
              $('#floor').val(data.output.floor.name);  
              $('#area').val(data.output.name); 
            }
            else
            {
                $('#cus_name').val(''); 
                $('#floor').val('');  
                $('#area').val(''); 
            }
        }
        })
        
        return false;
    }

         function validateCnic(self) 
        {
           var cnic = $(self).val().replaceAll('-', '');

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('validate.dnfbp.cnic') }}",
        method:'POST',
        dataType:'json',
        data: {cnic:cnic},
        success:function(data)
        {
          if (data.response == 'invalid') 
          {
                $(self).closest('.input-group').find('#cnic_error1').show();
          }

        }
        })



        return false;
        }


    $(":input").inputmask();
$('#country_id').change(function() {
    $('.preloader').fadeIn();
        var data = { 'country_id': $(this).val() };

        $.get('/getCitiesByCountry', data, function (data) {
           var model = $('#city_id');
                    model.empty();

                     model.append("<option value='' disabled selected>" + '' + "</option>");


                    $.each(data, function(index, element) {
                        model.append("<option value='"+ element.id +"'>" + element.name + "</option>");
                    });
        });
         $('.preloader').fadeOut();
    });

function percentCheckbox() {

        if($('#rebate_in_percent').prop("checked") == false) {
            document.getElementById('rebate_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('rebate_input').innerHTML = '%';
        }
    }
   </script>
@stop