@extends('layouts.app')


@section('title')
Schedule
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    
    <li class="active">Schedule Print</li>
</ol>
@stop

@section('css')

<style type="text/css">

     .bg-color{
        background-color: #1c3752;
    }
    .anchor-link
    {
        display: none;
    }

     @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        color: black !important;
        }
        h3{
            line-height: 1px;
        }

          h3 strong{
        text-transform: uppercase;
        color: black !important
    }
    h4 strong{
        text-transform: uppercase;
        color: black !important
    }
    .printFH11 {
    font-size: 13px;
    font-weight: 800;
    background-color: #000000;
    }
    .white-box .box-title {
    margin: 0px 0px 4px 0px;
    font-weight: 700;
    font-size: 14px;
    color: #1c3752;
    background-color: #000000 !important;
    }
    .white-box {
    padding: 0px 0px 2px 0px;
    margin-bottom: 0px;
    margin-bottom: 0;
    border-radius: inherit;
    }
    .table {
    width: 100% !important;
    margin-bottom: 5px;
    margin-top: -2px;
    }
    .table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th {
    vertical-align: top;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    }
</style>
<style type="text/css" media="print">
    @page {
        @bottom-right {
            content: counter(page) " of " counter(pages);
            }
        }
        #content {
            display: table;
        }
        #pageFooter {
            display: table-footer-group;
        }
        #pageFooter:after {
            counter-increment: page;
            content:"Page " counter(page);
            left: 0;
            top: 100%;
            white-space: nowrap;
            z-index: 20;
            -moz-border-radius: 5px;
            -moz-box-shadow: 0px 0px 4px #222;
            background-image: -moz-linear-gradient(top, #eeeeee, #cccccc);
        }
</style>

@stop

@section('content')

<div class="container-fluid">
    <div class="row printableArea"  id="content">

        <div class="col-lg-12 text-center">
   
            <!-- <div class="pull-left hidden-lg">-->



        </div><div class="clear"></div>
            <div class="text-center">
                <h3><strong>{{env('APP_NAME')}}</strong></h3>
                <h3>Payment Schedule</h3>
            </div>
        
        <div class="col-lg-12">
            <div class="white-box">
                <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px">&nbsp;&nbsp;Unit's Details</h4>

                <div class="table-responsive pull-left" style="width: 25%;">
                    <table class="table bottom-table" >

                        <tbody>
                            <tr>
                                <td style="font-weight: 600;">Floor:</td>
                                <td >@if($inventory->floor) {{$inventory->floor->name}}@endif </td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Category:</td>
                                <td>@foreach($inventory->categories as $c)

                                                        @if($loop->last)
                                                        {{$c->category->name}} ({{$c->category->percent}} )
                                                        @else
                                                        {{$c->category->name}} ({{$c->category->percent}} ),
                                                        @endif
                                                    @endforeach</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Size:</td>
                                <td>
                                                    {{$inventory->size->name}}  {{env('SIZE')}}
                                                    </td>

                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Total Price:</td>
                                <td > {{ number_format($inventory->total_price - $inventory->extra_amount) }} </td>
                            </tr>
                            

                        </tbody>
                    </table>
                </div>
                <div class="table-responsive pull-right"  style="width: 25%;">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td style="font-weight: 600;" >Unit #:</td>
                                <td>{{$inventory->unit_number}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Unit Type:</td>
                                <td>{{$inventory->type->name}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Category Cost:</td>
                                <td> {{ number_format($inventory->extra_amount) }} </td>
                            </tr>
                             <tr>
                                <td style="font-weight: 600;">Discount:</td>
                                <td class=""> {{ number_format(($inventory->total_price * ($payment_schedule->discount_app/100))) }} ( {{$payment_schedule->discount_app}} %) </td>
                            </tr>

                            <tr>
                                <td style="font-weight: 600;">Net Amount:</td>
                                <td> {{ number_format($inventory->total_price - ($inventory->total_price * ($payment_schedule->discount_app/100))) }} </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="clear"></div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="white-box">
                <div class="table-responsive" style="clear: both;">
                    <table  class="table table-bordered printFW1">
                        <thead class="printFH11">
                            <tr style="text-align: center">
                                <th style="color: #fff;font-size: 13px;">Payment Head</th>
                                <th style="color: #fff;font-size: 13px;">Due Date</th>
                                <th style="color: #fff;font-size: 13px;">Due Amt.</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $due = 0;
                           
                            $count = 1;
                            $total = 100;
                            ?>
                            @if($payment_schedule->down_payment_app > 0 )
                            <tr>
                            <td>Down Payment</td>
                            <td>{{date('d-m-Y')}}</td>
                            <td class="text-right">{{number_format($payment_schedule->down_payment_app)}}
                            <?php $due += $payment_schedule->down_payment_app;?> </td>
                            </tr>
                            @endif

                            <?php $date = \Carbon\Carbon::today();?>


                            @for($i = 1; $i <= $payment_schedule->total_months_app ; $i++)

                            @if($i % $payment_schedule->annual_select == 0)

                            @if(($payment_schedule->monthly_installment_app + $payment_schedule->annual_installment_app) > 0)
                            <tr>
                                <td>Installment - {{ $count++}}</td>
                                <td>
                                    @if($payment_schedule->annual_select == 3 && $payment_schedule->monthly_installment_app == 0 )
                                    {{date('d-m-Y',strtotime($date->addMonth(3)))}}
                                    @elseif($payment_schedule->annual_select == 6 && $payment_schedule->monthly_installment_app == 0)
                                    {{date('d-m-Y',strtotime($date->addMonth(6)))}}
                                    @elseif($payment_schedule->annual_select == 12 && $payment_schedule->monthly_installment_app == 0)
                                    {{date('d-m-Y',strtotime($date->addMonth(12)))}}
                                    @else
                                    {{date('d-m-Y',strtotime($date->addMonth(1)))}}
                                    @endif
                                </td>
                                <td class="text-right">{{number_format($payment_schedule->monthly_installment_app + $payment_schedule->annual_installment_app)}}
                                    
                                    <?php $due += $payment_schedule->monthly_installment_app + $payment_schedule->annual_installment_app;?> </td>
                            </tr>
                            @endif

                            @else

                            @if($payment_schedule->monthly_installment_app > 0)

                            <tr>
                            <td>Installment - {{ $count++}}</td>
                            <td>
                                @if($payment_schedule->annual_select == 3 && $payment_schedule->monthly_installment_app == 0 )
                                    {{date('d-m-Y',strtotime($date->addMonth(3)))}}
                                    @elseif($payment_schedule->annual_select == 6 && $payment_schedule->monthly_installment_app == 0)
                                    {{date('d-m-Y',strtotime($date->addMonth(6)))}}
                                    @elseif($payment_schedule->annual_select == 12 && $payment_schedule->monthly_installment_app == 0)
                                    {{date('d-m-Y',strtotime($date->addMonth(12)))}}
                                    @else
                                    {{date('d-m-Y',strtotime($date->addMonth(1)))}}
                                    @endif
                            </td>
                            <td class="text-right">{{number_format($payment_schedule->monthly_installment_app) }}
                                <?php $due += $payment_schedule->monthly_installment_app;?> </td>
                            </tr>
                            @endif

                            @endif


                            @endfor

                                @if($payment_schedule->possession_app > 0 )
                                <tr>
                                <td>Possession</td>
                                <td>{{date('d-m-Y',strtotime($date->addMonth(1)))}}</td>
                                <td class="text-right">{{number_format($payment_schedule->possession_app)}}
                                <?php $due += $payment_schedule->possession_app;?> </td>
                                </tr>
                                @endif
                            <tr>
                                <td colspan="2" class="printFV text-right"><b>Total</b></td>
                                <td class="printFV text-right"><b>{{number_format($due)}}</b></td>
                                
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <br>
       
        </div>
        

    </div>
    <div style="display: inline-block;    margin-bottom: 70px;">   

    <div class="text-right" style="display: inline-block;">
        <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
    </div>
    
</div>
</div>
<!-- /.container-fluid -->



@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>
$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>
@stop