@extends('layouts.app')

@section('title')
    All Adjust Units
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Adjust Units</li>
    </ol>
@stop
@section('css')

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

@stop

@section('content')


    <div class="container-fluid">
        <!-- /row -->



        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">

                    </div>

                    <h3 class="box-title">Adjust Units </h3>

                    <!-- Nav tabs -->
                    <div class="container">


                        <ul class="nav customtab nav-tabs" role="tablist">

                            <li role="presentation" class="active"><a href="#close_file" aria-controls="home" role="tab"
                                    data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i
                                            class="ti-home"></i></span><span class="hidden-xs">Close Unit</span></a>
                            </li>
                            

                        </ul>



                        <div class="tab-content">

                            <div id="close_file" class="tab-pane fade in active">
                                <ul class="nav nav-tabs">
                                    <li class="active"><a data-toggle="tab" href="#home">Adjusted
                                            ({{ number_format($statement_count_adjusted) }})</a></li>
                                    <li><a data-toggle="tab" href="#menu1">Pending Adjusts
                                            ({{ number_format($statementCount) }})
                                        </a></li>
                                    <li><a data-toggle="tab"
                                            href="#menu2">Decline({{ number_format($statement_count_decline) }})
                                        </a></li>

                                </ul>

                                <div class="tab-content">
                                    <div id="home" class="tab-pane fade in active">
                                        <h3>Adjusted Units </h3>
                                        <div class="table-responsive">
                                            <table id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>UA No</th>
                                                        <th>Unit #</th>
                                                        <th>Member Name</th>
                                                        <th>Received Amount</th>

                                                        <th>Status</th>
                                                        <th>
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $count = 1; ?>



                                                    @permission('view-cancellation')
                                                        <?php $view_membership = true; ?>
                                                    @else
                                                        <?php $view_membership = false; ?>
                                                    @endpermission

                                                    @permission('edit-adjust')
                                                        <?php $edit_refund = true; ?>
                                                    @else
                                                        <?php $edit_refund = false; ?>
                                                    @endpermission



                                                    @foreach ($allStatementsAdjust as $statementadjust)
                                                        <tr>
                                                            <td>{{ $count++ }}</td>
                                                            <td>{{ !empty($statementadjust->unitAdjustHistory) ? $statementadjust->unitAdjustHistory->ua_no : 'dsdfd' }}
                                                            </td>


                                                            <td>{{ $statementadjust->inventory->unit_number }}</td>

                                                            <td>{{ $statementadjust->customer ? $statementadjust->customer->name : '' }}<br><b>Dealer:
                                                                </b>{{ $statementadjust->dealer ? $statementadjust->dealer->name : '' }}
                                                            </td>


                                                            <td><b>{{ $statementadjust->unitAdjustHistory->total_received_amount }}</b>
                                                            </td>



                                                            @if ($statementadjust->cancelProperty->after_cancellation_status == 'pending')
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#4871c6;;">Pending</span>
                                                                </td>
                                                            @elseif($statementadjust->cancelProperty->after_cancellation_status == 'adjust-pending')
                                                                <td><span class="label label-success">Adjust/Pending</span>
                                                                </td>
                                                            @elseif($statementadjust->cancelProperty->after_cancellation_status == 'refund-pending')
                                                                <td><span class="label label-success">Refund/Pending</span>
                                                                </td>
                                                            @elseif($statementadjust->cancelProperty->after_cancellation_status == 'adjusted')
                                                                <td><span class="label label-success">Adjusted</span></td>
                                                            @elseif($statementadjust->cancelProperty->after_cancellation_status == 'refunded')
                                                                <td><span class="label label-success">Refunded</span></td>
                                                            @endif




                                                            <td class="text-nowrap">
                                                                <center>

                                                                    @if ($view_membership)
                                                                        <a href="{{ route('property.adjust.history', ['id' => $statementadjust->id]) }}"
                                                                            data-toggle="tooltip"
                                                                            data-original-title="View"> <i
                                                                                class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                    @endif


                                                                    @if ($edit_refund && $statementadjust->cancelProperty->after_cancellation_status == 'pending')
                                                                        <a href="{{ route('property.adjust.edit', ['id' => $statementadjust->id]) }}"
                                                                            data-toggle="tooltip"
                                                                            data-original-title="Edit"> <i
                                                                                class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                    @endif





                                                                </center>
                                                            </td>

                                                        </tr>
                                                    @endforeach




                                                </tbody>
                                            </table>
                                            <div style="float: right;">{{ $allStatementsAdjust->links() }} </div>
                                        </div>
                                    </div>
                                    <div id="menu1" class="tab-pane fade">
                                        <h3>Pending Adjust Units</h3>
                                        <div class="table-responsive">
                                            <table id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>


                                                        <th>Unit #</th>
                                                        {{-- <th>Size</th> --}}
                                                        <th>Member Name</th>
                                                        <th>Net Amount</th>

                                                        <th>Received Amount</th>

                                                        {{-- <th>Booking Date</th> --}}
                                                        <th>Cancel Date</th>
                                                        <th>Cancel Fee(pkr)</th>
                                                        <th>Request Status</th>
                                                        <th>Unit Status</th>
                                                        <th>After Cancellation Decision Request</th>
                                                        <th>
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $count = 1; ?>



                                                    @permission('view-cancellation')
                                                        <?php $view_membership = true; ?>
                                                    @else
                                                        <?php $view_membership = false; ?>
                                                    @endpermission

                                                    @permission('edit-adjust')
                                                        <?php $edit_refund = true; ?>
                                                    @else
                                                        <?php $edit_refund = false; ?>
                                                    @endpermission





                                                    @foreach ($allStatements as $statement)
                                                        <tr>
                                                            <td>{{ $count++ }}</td>


                                                            <td>{{ $statement->inventory->unit_number }}</td>
                                                            {{-- <td>
                                                    @if ($statement->inventory)
                                                        @if ($statement->inventory->size)
                                                            {{ $statement->inventory->size->name }} {{ env('SIZE') }}
                                                        @endif
                                                    @endif
                                                </td> --}}
                                                            <td>{{ $statement->customer ? $statement->customer->name : '' }}<br><b>Dealer:
                                                                </b>{{ $statement->dealer ? $statement->dealer->name : '' }}
                                                            </td>

                                                            <td><b>{{ number_format($statement->net_pay) }}</b></td>


                                                            <td><b>{{ number_format($receivedAmt[$statement->id]) }}</b>
                                                            </td>



                                                            {{-- <td>{{ date('d-m-Y', strtotime($statement->booking_date)) }}</td> --}}

                                                            <td>{{ date('d-m-Y', strtotime($statement->cancel_date)) }}
                                                            </td>
                                                            <td>{{ $statement->cancelProperty->fee }} </td>

                                                            @if ($statement->cancelProperty->status == 0)
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#4871c6;;">Pending</span>
                                                                </td>
                                                            @elseif($statement->cancelProperty->status == 1)
                                                                <td><span class="label label-success">Approved</span></td>
                                                            @else
                                                                <td></td>
                                                            @endif


                                                            @if ($statement->status == \App\CustomerProperty::pending)
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#cd703d;">Pending</span>
                                                                </td>
                                                            @elseif($statement->status == \App\CustomerProperty::approved)
                                                                <td><span class="label label-success">Approved</span></td>
                                                            @elseif($statement->status == \App\CustomerProperty::cancel)
                                                                <td><span class="label label-danger">Canceled</span></td>
                                                            @else
                                                                <td></td>
                                                            @endif

                                                            @if ($statement->cancelProperty->after_cancellation_status == 'pending')
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#4871c6;;">Pending</span>
                                                                </td>
                                                            @elseif($statement->cancelProperty->after_cancellation_status == 'adjust-pending')
                                                                <td><span class="label label-success">Adjust/Pending</span>
                                                                </td>
                                                            @elseif($statement->cancelProperty->after_cancellation_status == 'refund-pending')
                                                                <td><span class="label label-success">Refund/Pending</span>
                                                                </td>
                                                            @elseif($statement->cancelProperty->after_cancellation_status == 'adjusted')
                                                                <td><span class="label label-success">Adjusted</span></td>
                                                            @elseif($statement->cancelProperty->after_cancellation_status == 'refunded')
                                                                <td><span class="label label-success">Refunded</span></td>
                                                            @endif




                                                            <td class="text-nowrap">
                                                                <center>

                                                                    @if ($view_membership)
                                                                        <a href="{{ route('statement.detail', ['id' => $statement->id]) }}"
                                                                            data-toggle="tooltip"
                                                                            data-original-title="View"> <i
                                                                                class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                    @endif


                                                                    @if ($edit_refund)
                                                                        <a href="{{ route('property.adjust.edit', ['id' => $statement->id]) }}"
                                                                            data-toggle="tooltip"
                                                                            data-original-title="Edit"> <i
                                                                                class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                    @endif





                                                                </center>
                                                            </td>

                                                        </tr>
                                                    @endforeach

                                                </tbody>
                                            </table>
                                            <div style="float: right;">{{ $allStatements->links() }}</div>
                                        </div>
                                    </div>

                                    <div id="menu2" class="tab-pane fade">
                                        <h3>Decline Refunds Units</h3>
                                        <div class="table-responsive">
                                            <table id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>


                                                        <th>Unit #</th>
                                                        {{-- <th>Size</th> --}}
                                                        <th>Member Name</th>
                                                        <th>Net Amount</th>


                                                        {{-- <th>Booking Date</th> --}}
                                                        <th>Cancel Date</th>
                                                        <th>Cancel Fee(pkr)</th>
                                                        <th>Request Status</th>
                                                        <th>Unit Status</th>
                                                        <th>After Cancellation Decision Request</th>
                                                        <th>
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $count = 1; ?>



                                                    @permission('view-cancellation')
                                                        <?php $view_membership = true; ?>
                                                    @else
                                                        <?php $view_membership = false; ?>
                                                    @endpermission

                                                    @permission('edit-adjust')
                                                        <?php $edit_refund = true; ?>
                                                    @else
                                                        <?php $edit_refund = false; ?>
                                                    @endpermission


                                                    @foreach ($allStatementsdecline as $statementdecline)
                                                        <tr>
                                                            <td>{{ $count++ }}</td>


                                                            <td>{{ $statementdecline->inventory->unit_number }}</td>
                                                            {{-- <td>
                                               @if ($statement->inventory)
                                                   @if ($statement->inventory->size)
                                                       {{ $statement->inventory->size->name }} {{ env('SIZE') }}
                                                   @endif
                                               @endif
                                           </td> --}}
                                                            <td>{{ $statementdecline->customer ? $statementdecline->customer->name : '' }}<br><b>Dealer:
                                                                </b>{{ $statementdecline->dealer ? $statementdecline->dealer->name : '' }}
                                                            </td>

                                                            <td><b>{{ number_format($statementdecline->net_pay) }}</b></td>





                                                            {{-- <td>{{ date('d-m-Y', strtotime($statement->booking_date)) }}</td> --}}

                                                            <td>{{ date('d-m-Y', strtotime($statementdecline->cancel_date)) }}
                                                            </td>
                                                            <td>{{ $statementdecline->cancelProperty->fee }} </td>

                                                            @if ($statementdecline->cancelProperty->status == 0)
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#4871c6;;">Pending</span>
                                                                </td>
                                                            @elseif($statementdecline->cancelProperty->status == 1)
                                                                <td><span class="label label-success">Approved</span></td>
                                                            @else
                                                                <td></td>
                                                            @endif


                                                            @if ($statementdecline->status == \App\CustomerProperty::pending)
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#cd703d;">Pending</span>
                                                                </td>
                                                            @elseif($statementdecline->status == \App\CustomerProperty::approved)
                                                                <td><span class="label label-success">Approved</span></td>
                                                            @elseif($statementdecline->status == \App\CustomerProperty::cancel)
                                                                <td><span class="label label-danger">Canceled</span></td>
                                                            @else
                                                                <td></td>
                                                            @endif

                                                            @if ($statementdecline->cancelProperty->after_cancellation_status == 'pending')
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#4871c6;;">Pending</span>
                                                                </td>
                                                            @elseif($statementdecline->cancelProperty->after_cancellation_status == 'adjust-pending')
                                                                <td><span class="label label-success">Adjust/Pending</span>
                                                                </td>
                                                            @elseif($statementdecline->cancelProperty->after_cancellation_status == 'refund-pending')
                                                                <td><span class="label label-success">Refund/Pending</span>
                                                                </td>
                                                            @elseif($statementdecline->cancelProperty->after_cancellation_status == 'adjusted')
                                                                <td><span class="label label-success">Adjusted</span></td>
                                                            @elseif($statementdecline->cancelProperty->after_cancellation_status == 'refunded')
                                                                <td><span class="label label-success">Refunded</span></td>
                                                            @elseif($statementdecline->cancelProperty->after_cancellation_status == 'decline')
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#f80808;;">Decline</span>
                                                                </td>
                                                            @endif




                                                            <td class="text-nowrap">
                                                                <center>

                                                                    @if ($view_membership)
                                                                        <a href="{{ route('statement.detail', ['id' => $statementdecline->id]) }}"
                                                                            data-toggle="tooltip"
                                                                            data-original-title="View"> <i
                                                                                class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                    @endif


                                                                    @if ($edit_refund)
                                                                        <a href="{{ route('property.adjust.edit', ['id' => $statementdecline->id]) }}"
                                                                            data-toggle="tooltip"
                                                                            data-original-title="Edit"> <i
                                                                                class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                    @endif





                                                                </center>
                                                            </td>

                                                        </tr>
                                                    @endforeach




                                                </tbody>
                                            </table>
                                            <div style="float: right;">{{ $allStatementsdecline->links() }}</div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            
                        </div>
                    </div>
                    <!-- Tab panes -->


                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->


@stop

@section('js')

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script>
        function confirmReopen(val) {

            var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');



            Swal.fire({
                    title: "Are you sure?",
                    text: "You want to reopen the Unit!",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, Sure!'
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        $('.preloader').fadeIn();
                        $.ajax({
                            /* the route pointing to the post function */
                            url: '{{ route('reopen.cancel') }}',
                            type: 'POST',
                            /* send the csrf-token and the input to the controller */
                            data: {
                                _token: CSRF_TOKEN,
                                id: val
                            },
                            dataType: 'JSON',
                            /* remind that 'data' is the response of the AjaxController */
                            success: function(data) {
                                $('.preloader').fadeOut();
                                Swal.fire("Poof! Unit Reopened Successfully!", {

                                    confirmButtonColor: '#3085d6',
                                    cancelButtonColor: '#d33',
                                    confirmButtonText: 'Yes, Sure!'
                                }).then((result) => {
                                    location.reload();
                                });
                            }
                        });
                    } else {
                        $('.preloader').fadeOut();
                        Swal.fire("OK! Action Revert");
                    }
                });




            // return false;
            // if (confirm('Are you sure you want to reopen this property.')) 
            // {
            //    return true; 
            // }
            // else
            // {
            //     return false;
            // }
            $('.preloader').fadeOut();
        }
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'info': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });
    </script>

@stop
