@extends('layouts.app')

@section('title')
    Create Block Unit
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-cancellation')
            <li><a href="{{ route('statement.cancel') }}">All Block Units</a></li>
        @endpermission
        <li class="active">Create Block Unit </li>
    </ol>
@stop
@section('content')

    <div class="container-fluid">
        <div class="row">

            <div class="col-md-12">
                <div class="white-box">
                    <h3 class="box-title m-b-0">Block Property </h3>
                    <hr>
                </div>
            </div>
        </div>

        <div class="container-fluid" style='background: white;
                         border: 1px solid #e5ebec;'>
            <h2>Select Property</h2>
            <form method='post' action="{{ route('property.block.store') }}" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="form-group">
                    <label class="control-label col-sm-2" for="property_no">Property No <span
                            style="color: red">*</span>:</label>
                    <div class="col-sm-10">
                        <div class="input-group">
                            <select name="property_no[]" class="form-control js-example-basic-multiple" multiple="multiple">
                                @foreach ($allStatements as $s)
                                    <option value="{{ $s->id }}">{{ $s->customer->name }} -
                                        {{ $s->inventory->unit_number }} - {{ $s->membership_no }}</option>
                                @endforeach
                            </select>
                            @if ($errors->has('property_no'))
                                <span class="help-block">
                                    {{ $errors->first('property_no') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-sm-offset-2 col-sm-10">
                        <button type="submit" class="btn btn-info  waves-effect waves-light "
                            style='    margin-top: 10px;'>Save</button>
                    </div>
                </div>
            </form>
        </div>





      
    </div>


    </div>

@stop
@section('js')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-multiple').select2();
        });
    </script>
@stop
