@extends('layouts.app')

@section('title')
Customer Booking Form
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-membership')
            <li><a href="{{ route('statement.all') }}">Statements</a></li>
        @endpermission
        <li class="active">Booking Form</li>
    </ol>
@stop

@section('css')

<style type="text/css">

    .body { 
        background-image: url('/images/bluearc.png');
        background-repeat: no-repeat;
        background-size: cover;
    }
           

    .empty {
        width: 15px;
        height: 20px;
        text-align:center;
        margin: auto;
        display: inline-block;
        border: 1px solid gray;
        vertical-align: middle;
        border-radius: 2px;
    }
    
    .p1 {
        padding: 0;
    }
    
    .id {
        font-weight: 600;
        white-space: pre;
    }

   

    .cnic-box {
        display: inline-block;
        width: 21px;
        height: 24px;
        border: 1px solid;
        text-align: center;
        line-height: 25px;
        margin-right: -4px;
    }
</style>

@stop

@section('content')

    <div class="container-fluid">
        <div class="row printableArea" id="content" style="">
            <div class="col-lg-12">
                <div class="white-box border-none" style="font-size: 13px;">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row" style="">
                                <div class="col-xs-4 col-sm-4">
                                    <img src="{{asset('/images/logo.png')}}" width="150" height="150">
                                </div>

                                <div class="col-xs-4 col-sm-4">
                                    <h2 style="font-weight: bold; text-align: center; padding-top: 118px; font-size: 28px">BOOKING FORM</h2>
                                </div>
                                
                                <div class="col-xs-4 col-sm-4" style="height: 174px;width: 140px;float: right;overflow: hidden;font-size: 37px;text-decoration: underline;">
                                    <img width="120px" height="150px" src="{{ asset('uploads/'.$statement->customer->img_url) }}">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-6 col-sm-6"><p><b>Form #: </b></p></div>
                                <div class="col-xs-6 col-sm-6"><b>Date: {{date('d-m-Y', strtotime($statement->original_boooking_date)) }}</b></div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">I.</div>
                                <div class="col-xs-11 col-sm-11"><p>I/WE, the undersigned, request you to book for me/us the following Unit in your Captioned.</p></div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-2" style="float: left; ">
                                        <p class="id">TYPE: </p>
                                    </div>
                                    <div class="col-xs-10" style="float: left; padding: 0 20px;">
                                        <?php $c = isset($statement->inventory->type->name) ? str_split($statement->inventory->type->name, 1) : null; ?>

                                            <?php
                                            for($i=0; $i<count($c); $i++)
                                            {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                            }
                                            ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">UNIT NUMBER: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <?php $c = isset($statement->inventory->unit_number) ? str_split($statement->inventory->unit_number, 1) : null; ?>

                                    <?php
                                    
                                    if(count($c) > 1 )
                                    {
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    }
                                    else
                                    {
                                            for($i=1; $i<=5; $i++)
                                        {
                                            echo '<span class="empty">&nbsp;</span>&nbsp;';
                                        }
                                    }
                                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-5" style="float: left;">
                                        <p class="id">SIZE (IN SQUARE FEET): </p>
                                    </div>
                                    <div class="col-xs-7" style="float: left;">
                                        <?php $c = str_split($statement->inventory->size->name, 1);?>
                                        <?php
                                            for($i=0; $i<count($c); $i++)
                                            {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                            }
                                            ?>
                                    </div>
                                </div>
                            </div>
                            <!-- passport starts here-->
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-2" style="float: left;">
                                        <p class="id">FLOOR: </p>
                                    </div>
                                    <div class="col-xs-10" style="float: left;">
                                        <?php if(isset($statement->inventory->floor->name)){
                                        $c = str_split($statement->inventory->floor->name, 1); }?>
                                    <?php
                                    
                                    if(count($c) > 1 )
                                    {
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    }
                                    else
                                    {
                                            for($i=1; $i<=11; $i++)
                                        {
                                            echo '<span class="empty">&nbsp;</span>&nbsp;';
                                        }
                                    }
                                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-2" style="float: left;">
                                        <p class="id">II. </p>
                                    </div>
                                    <div class="col-xs-10" style="float: left;">
                                        <p>My/Our particulars are as follows:</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-6" style="float: left;">
                                        <p class="id">Purchaser’s share in %: </p>
                                    </div>
                                    <div class="col-xs-6" style="float: left;">
                                            <?php 
                                            $c = str_split('100%', 1);?>
                                            
                                            <?php
                                            for($i=0; $i<count($c); $i++)
                                            {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                            }
                                            ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-2" style="float: left;">
                                    <p class="id">Name: </p>
                                </div>
                                <div class="col-xs-10" style="float: left;">
                                    <?php $c = str_split($statement->customer->name, 1);?>
                                    <?php
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-3" style="float: left;">
                                    <p class="id">Father’s/Husband’s Name: </p>
                                </div>
                                <div class="col-xs-9" style="float: left;">
                                    <?php $c = str_split($statement->customer->father_name, 1);?>
                                    <?php
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-6" style="float: left;">
                                    <p class="id">Computerised National Identity Card Number: </p>
                                </div>
                                <div class="col-xs-6" style="float: left;">
                                    <?php $c = str_split($statement->customer->cnic, 1);?>
                                        <?php for($i =0;$i<count($c) ; $i++) {?>
                                        @if($i == 5 || $i == 12)
                                            <span class="cnic-box">-</span>
                                        @endif

                                        <span class="cnic-box">{{ $c[$i] }}</span>

                                        <?php }?>

                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-4" style="float: left;">
                                    <p class="id">Address for Communication: </p>
                                </div>
                                <div class="col-xs-8" style="float: left;">
                                    <?php $c = str_split($statement->customer->mailing_address, 1);?>
                                    <?php
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-4" style="float: left;">
                                    <p class="id">Telephone Numbers: (residence): </p>
                                </div>
                                <div class="col-xs-8" style="float: left;">
                                    <?php $c = str_split($statement->customer->res_number, 1);?>
                                    @if ($statement->customer->res_number)
                                        <?php
                                            for($i=0; $i<count($c); $i++)
                                            {
                                                echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                            }
                                        ?>
                                    @else
                                        <?php
                                            for($i=0; $i<12; $i++)
                                            {
                                                echo '<span>&nbsp;</span>&nbsp;';
                                            }
                                        ?>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left; ">
                                        <p class="id">Mobile No: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left; padding: 0 20px;">
                                        <?php $c = isset($statement->customer->mobile_number) ? str_split($statement->customer->mobile_number, 1) : null; ?>

                                        <?php
                                            for($i=0; $i<count($c); $i++)
                                            {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                            }
                                            ?>
                                    </div>
                                </div>
                            </div>
                            <!-- passport starts here-->
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">Email: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <?php $c = isset($statement->customer->email) ? str_split($statement->customer->email, 1) : array();
                                                var_dump($statement->customer->email);
                                                var_dump($c); ?>

                                        <?php
                                    
                                    if(count($c) > 1 )
                                    {
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    }
                                    else
                                    {
                                            for($i=1; $i<=5; $i++)
                                        {
                                            echo '<span class="empty">&nbsp;</span>&nbsp;';
                                        }
                                    }
                                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <p style="font-size: 15px"><b>NEXT OF KIN</b></p>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">Name:</p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <p style="display: inline-block; border-bottom: 1px solid">
                                            {{ $statement->customer->nominee_name }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">Relationship:</p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <p style="display: inline-block; border-bottom: 1px solid">
                                            {{ $statement->customer->nominee_relation }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">CNIC:</p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <p style="display: inline-block; border-bottom: 1px solid">
                                            {{ $statement->customer->nominee_cnic }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">Contact:</p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <p style="display: inline-block; border-bottom: 1px solid">
                                            {{ $statement->customer->nominee_mobile_number ? $statement->customer->nominee_mobile_number : 'NIL' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-2" style="float: left;">
                                        <p class="id">III. </p>
                                    </div>
                                    <div class="col-xs-10" style="float: left;">
                                        <p>Joint Purchaser: <span style="border:1px solid black">
                                                &nbsp;&nbsp; N/A &nbsp;&nbsp;
                                            </span>&nbsp;&nbsp; YES
                                            &nbsp; <span style="border:1px solid black">
                                                &nbsp;&nbsp; N/A &nbsp;&nbsp; </span>
                                                &nbsp;&nbsp; NO
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-6" style="float: left;">
                                        <p class="id">Purchaser’s share in %: </p>
                                    </div>
                                    <div class="col-xs-6" style="float: left;">
                                        <?php 
                                            $c = str_split('N/A', 1);?>

                                        <?php
                                            for($i=0; $i<count($c); $i++)
                                            {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                            }
                                            ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-12 col-sm-12">
                                    <p>Particulars of joint Purchaser (if applicable) are as follows:</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-2" style="float: left;">
                                    <p class="id">Name: </p>
                                </div>
                                <div class="col-xs-10" style="float: left;">
                                    <?php $c = str_split('NA', 1);?>
                                    <?php
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-3" style="float: left;">
                                    <p class="id">Father’s/Husband’s Name: </p>
                                </div>
                                <div class="col-xs-9" style="float: left;">
                                    <?php $c = str_split('NA', 1);?>
                                    <?php
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-6" style="float: left;">
                                    <p class="id">Computerised National Identity Card Number: </p>
                                </div>
                                <div class="col-xs-6" style="float: left;">
                                    <?php $c = str_split('NA', 1);?>
                                        <?php for($i =0;$i<count($c) ; $i++) {?>
                                        @if($i == 5 || $i == 12)
                                            <span class="cnic-box">-</span>
                                        @endif

                                        <span class="cnic-box">{{ $c[$i] }}</span>

                                        <?php }?>

                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-4" style="float: left;">
                                    <p class="id">Address for Communication: </p>
                                </div>
                                <div class="col-xs-8" style="float: left;">
                                    <?php $c = str_split('NA', 1);?>
                                    <?php
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-4" style="float: left;">
                                    <p class="id">Telephone Numbers: (residence): </p>
                                </div>
                                <div class="col-xs-8" style="float: left;">
                                    <?php $c = str_split('NA', 1);?>
                                        <?php
                                            for($i=0; $i<count($c); $i++)
                                            {
                                                echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                            }
                                        ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left; ">
                                        <p class="id">Mobile No: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left; padding: 0 20px;">
                                        <?php $c = str_split('NA', 1); ?>

                                        <?php
                                            for($i=0; $i<count($c); $i++)
                                            {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                            }
                                            ?>
                                    </div>
                                </div>
                            </div>
                            <!-- passport starts here-->
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">Email: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <?php $c = isset($statement->customer->email) ? str_split($statement->customer->email, 1) : "'NA'"; ?>

                                        <?php
                                    
                                    if(count($c) > 1 )
                                    {
                                        for($i=0; $i<count($c); $i++)
                                        {
                                            echo '<span class="empty">'.$c[$i].'</span>&nbsp;';
                                        }
                                    }
                                    else
                                    {
                                            for($i=1; $i<=5; $i++)
                                        {
                                            echo '<span class="empty">&nbsp;</span>&nbsp;';
                                        }
                                    }
                                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <p style="font-size: 15px"><b>NEXT OF KIN</b></p>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">Name: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <p style="display: inline-block; border-bottom: 1px solid">N/A</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">Relationship: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <p style="display: inline-block; border-bottom: 1px solid">N/A </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">CNIC: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <p style="display: inline-block; border-bottom: 1px solid">N/A</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-6 p1">
                                <div class="row">
                                    <div class="col-xs-4" style="float: left;">
                                        <p class="id">Contact: </p>
                                    </div>
                                    <div class="col-xs-8" style="float: left;">
                                        <p style="display: inline-block; border-bottom: 1px solid">N/A</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-6 col-sm-6"><b>on Behalf of Blue Arc Design & Developments: </b></div>
                                <div class="col-xs-6 col-sm-6"  ><b>Sign and thumb of Purchaser(s)</b></div>
                            </div>
                        </div> 

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <br><br>
                                <div class="col-xs-6 col-sm-6">__________________________________________________</div>
                                <div class="col-xs-6 col-sm-6"  >__________________________________</div>
                            </div>
                        </div>
                        
                        @include('statement.footer-booking')
                    </div>
                </div>
                <br>
                <div class="white-box border-none ">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-sm-12 col-xs-12">
                                    <div class="row" style="">
                                        <div class="col-xs-4 col-sm-4">
                                            <img src="{{ asset('/images/logo.png') }}" width="150"
                                                height="150">
                                        </div>

                                        <div class="col-xs-6 col-sm-6">
                                            <p style="font-weight: bold; text-align: center; padding-top: 118px; font-size: 10px">(TERMS & CONDITIONS BY & BETWEEN DEVELOPER & PURCHASER)</p>
                                        </div>

                                        <div class="col-xs-2 col-sm-2" style=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">1.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Developer, at its sole and absolute
                                    discretion, shall has the right to construct/develop the project/unit,
                                    by its own or by engaging any other entity or person, in accordance with the plans,
                                    designs and specifications approved
                                    by the relevant authorities and Developer shall be entitled to make such variations
                                    and modifications as he may consider necessary or as may be required by the
                                    concerned authority or department.</div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">2.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Buyer(s) shall pay all the
                                    installments towards the price of development charges against his/her provisionally
                                    booked unit, in favor of Developer, strictly in accordance with payment
                                    schedule/plan, annexed herewith, without any delay or default whatsoever.</div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">3.</div>
                                <div class="col-xs-11  col-sm-11" style=""> That in case of joint provisional booking,
                                    Buyer(s) shall be liable jointly and severally to fulfill and discharge all
                                    obligations applicable on the subject and breach of any condition by anyone of them,
                                    the Developer shall be at liberty
                                    to recourse and redress against anyone or all the Buyer(s) as he deems fit and
                                    proper.</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">4.</div>
                                <div class="col-xs-11  col-sm-11" style=""> In the event the installment payments are
                                    delayed by more than 30 (thirty) days after they become due, the
                                    Buyer(s) shall be liable to pay the overdue installment with surcharge @ 5% per
                                    month. Under no circumstances the
                                    Buyer(s) shall delay the payment of consecutive two installments from the due date.
                                    In case of delay in payment of
                                    consecutive two installments from the due date, this agreement shall stand cancelled
                                    ‘suo-moto’, unilaterally without
                                    any recourse to the Buyers and the Developer need not give any prior notice or
                                    intimation to the Buyers of such action
                                    of cancellation of the Agreement. In such event, the amount paid by the Buyer(s)
                                    shall be refunded after the completion
                                    of project subject to deduction of 35% of total price as compensation. If the amount
                                    paid is less than 35% of the total
                                    price then the same shall be forfeited and the remaining shall be recovered through
                                    due course of law. The Developer
                                    shall be entitled to re-book / sell the said cancelled unit in favour of any other
                                    person. No notice from the Developer shall
                                    be necessary to the defaulting Buyer(s) to take action as stated herein, and such
                                    action shall be the sole
                                    prerogative and discretion of the Developer and the defaulting Buyer(s) shall have
                                    no say in or to object to the same.</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">5.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the price shall include all the charges
                                    except for any tax, transfer charges, possession charges and any
                                    utility charges including electricity, water, gas, fiber optics etc which have to be
                                    paid by the Buyer(s).</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">6.</div>
                                <div class="col-xs-11  col-sm-11" style=""> That the Developer will make reasonable
                                    efforts to obtain utilities i.e. electricity, water, gas and telephone
                                    connection in the name of Buyer provided that he/she has fulfilled all her
                                    obligations. However, Developer accepts no
                                    responsibility if the connection and or supply of any of the above mentioned
                                    services is delayed.</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">7</div>
                                <div class="col-xs-11  col-sm-11" style="">The Buyer(s) hereby declares and undertakes
                                    that he shall have no claim, save and except in respect of the said
                                    unit hereby agreed to be booked by him and the Developer shall continue to be
                                    entitled to the
                                    property in all the structures, exterior walls, common areas, open spaces, parking
                                    places, lobbies, staircases, lifts, terrace,
                                    etc.</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">8.</div>
                                <div class="col-xs-11 col-sm-11" style="">That if an event of Force Majeure or erratic
                                    market condition occurs or uncontrollable delay, in the opinion of the
                                    Developer, it shall have the liberty to extend the completion date.</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1  col-sm-1">9.</div>
                                <div class="col-xs-11  col-sm-11" style=""> That the possession of the unit shall remain
                                    with the Developer until full and final payment made by the
                                    Buyer(s) towards the total price of the unit along with any utility charges, fees,
                                    expenses, levies, taxes etc.
                                </div>
                            </div>
                        </div>


                        <br>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">10.</div>
                                <div class="col-xs-11  col-sm-11" style=""> That the Buyer(s) shall be obliged to take
                                    the physical possession of the unit within 30 (Thirty) days from the
                                    issuance of intimation letter of possession by the Developer subject to the
                                    condition that he has fulfilled all his obligations including payment of total
                                    price, taxes, levies, dues, duties, charges, expenses etc. After such intimation,
                                    the Developer shall not be liable or responsible for any loss, theft, breakage,
                                    damages, trespass etc and the Buyer(s) shall also be obliged to pay for additional
                                    amount and
                                    maintenance there of to the Developer or management company or as the case may be
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">11.</div>
                                <div class="col-xs-11  col-sm-11" style="">Once the Project is completed, Developer
                                    shall manage and maintain the Project and charge a
                                    maintenance fee that may be determined at the completion of the project or as the
                                    case may be, whereupon the
                                    Buyer(s) has no objection. Developer may assign its responsibility of management to
                                    other parties which shall operate
                                    as agents or assignees of the Developer while managing the Project.
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">12.</div>
                                <div class="col-xs-11  col-sm-11" style="">Developer may make reasonable efforts for the
                                    completion of all formalities and approval
                                    requirements relating to the transfer of title of the unit to Buyers from the
                                    concerned authority on the expense of Buyer(s).</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">13.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Buyer(s) shall not sell, transfer or
                                    create any third party interests of whatsoever nature in the unit before or
                                    after taking over the possession, without prior written approval of the Developer
                                    and subject to payments of all outstanding
                                    dues/payments and transfer charges by the Buyer(s).
                                </div>
                            </div>
                        </div>
                        
@include('statement.footer-booking')

                        <div class="col-sm-12 col-xs-12">
                            <div class="row" style="">
                                <div class="col-xs-4 col-sm-4">
                                    <img src="{{ asset('/images/logo.png') }}" width="150" height="150">
                                </div>
                                <div class="col-xs-4 col-sm-4"></div>
                                <div class="col-xs-4 col-sm-4"></div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">14.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Developer shall in any case have a
                                    first lien, claim and charge upon rights of Buyer(s) over the unit, any
                                    amount paid, its fixtures, fittings and facilities etc.</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">15.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Buyer(s) shall use the unit for
                                    designated and permitted purposes only and shall not misuse the unit or
                                    amenities/facilities provided by the Developer nor shall he/she encroach upon any
                                    area of the
                                    project. For avoidance of doubt, Buyer(s) shall use the apartment or any part
                                    thereof or permit the same to be used only for
                                    purpose of residence only</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">16.</div>
                                <div class="col-xs-11  col-sm-11" style=""> That the covered area of the unit may
                                    include ancillary and services area, wall, passages, corridors, staircase, car
                                    parking, balcony, common area etc.</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">17.</div>
                                <div class="col-xs-11  col-sm-11" style="">
                                    That in case the area of unit is more than approximate size, Buyer(s) shall pay
                                    the price for excess covered area as per
                                    rate on demand made by the Developer at the time of possession.</div>
                            </div>
                        </div>



                        


                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">18.</div>
                                <div class="col-xs-11  col-sm-11" style=""> That the Buyer(s) shall not cause any
                                    obstruction or hindrance, to the Developer and shall give
                                    reasonable access, permission, assistance to him or his nominated contractors or
                                    their agents, nominees etc., or body that
                                    may be set up by Developer to construct, repair, examine, survey the building or
                                    make such
                                    additions, alterations, etc., that may be necessary and such other acts and things
                                    that may be necessary</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">19.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Buyer(s) shall not cut, maim,
                                    injure, tamper or damage any part of the structure or any part of the building
                                    nor shall he/she make any additions or alterations in the building including
                                    elevation.
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">20.</div>
                                <div class="col-xs-11  col-sm-11" style="">20. That the Buyer(s) shall not cause or
                                    allowed to be caused any nuisance to
                                    occupants in the premises nor shall he/she
                                    cause or allow to be caused any littering of rubbish in common areas of the building
                                    or
                                    premises.
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">21.</div>
                                <div class="col-xs-11  col-sm-11" style="">Each of the provisions is severable and
                                    distinct from the others. The invalidity, illegality or unenforceability of any
                                    provisions shall not affect the continuation in force of the remainder of these
                                    terms and conditions.
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">22.</div>
                                <div class="col-xs-11  col-sm-11" style="">
                                    That the Buyer(s) confirms that he/she has fully read and understood the above
                                    mentioned terms and conditions
                                    and hereby agrees to abide the same strictly.
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">23.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Buyers or any of his
                                    successors shall comply with and abide by all rules, regulations, bye-laws and
                                    such other orders instructions by Developer. 
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">24.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Buyer(s) declares that
                                    all the information given by him/her is true and correct and in case any of the
                                    particulars/information is found to be incorrect, the Developer shall have right
                                    to cancel/terminate the booking or allocation or allotment as the case may be by
                                    giving him 15 days notice in writing</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">25.</div>
                                <div class="col-xs-11  col-sm-11" style="">All terms and conditions set out herein are an essential part of the Agreement and the understanding on which
                                    the Parties have agreed.</div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">26.</div>
                                <div class="col-xs-11  col-sm-11" style="">That the Developer reserves the right to amend, change or renumber the unit or transfer the rights of Buyer from
                                    one unit of similar category and Buyer shall have no objection in this regards.
                                    IN WITNESS WHEREOF the Parties have set their respective hands to there terms and conditions at 07/01/2023 on the date
                                    month and year first above written after fully understanding the contents of the same without undue influence, pressure,
                                    threat or coercion.
                                </div>
                            </div>
                        </div>


                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-sm-6 col-xs-6">
                                    <span>For and on behalf of Seller </span><br><br>
                                    <span>____________________________</span><br>
                                    <span>YASAR MAQSOOD </span><br>
                                    <span>CEO </span><br>
                                    <span>Safari View Heights </span><br>
                                </div>
                                <div class="col-sm-6 col-xs-6">
                                    <span>For and on behalf of Buyer</span><br><br>
                                    <span>____________________________</span><br>
                                    <span>Buyer: {{ $statement->customer->name }}</span><br>
                                    <span>S/O: {{ $statement->customer->father_name }}</span><br>
                                    <span>CNIC: {{ $statement->customer->cnic }}</span><br><br><br>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-12  col-sm-12" style="">Please  ensure following documents are attached:
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">1.</div>
                                <div class="col-xs-11  col-sm-11" style="">Photocopies of the CNICs of the Purchaser(s).</div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">2.</div>
                                <div class="col-xs-11  col-sm-11" style="">Photocopies of the CNICs of the joint Purchaser(s) if any.
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-1 col-sm-1">3.</div>
                                <div class="col-xs-11  col-sm-11" style="">Payment Plan. <br><br>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <div class="col-xs-6 col-sm-6"><b>on Behalf of Blue Arc Design & Developments: </b>
                                </div>
                                <div class="col-xs-6 col-sm-6" style="text-align: right"><b>Sign and thumb of
                                        Purchaser(s)</b></div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <br><br>
                                <div class="col-xs-6 col-sm-6">__________________________________________________</div>
                                <div class="col-xs-6 col-sm-6" style="text-align: right">
                                    __________________________________</div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <br><br>
                                <div class="col-xs-6 col-sm-6">
                                    <p style="background-color: black; display: inline; color: white;">Witness 1</p>
                                </div>
                                <div class="col-xs-6 col-sm-6">
                                    <p style="background-color: black; display: inline; color: white;">Witness 2</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <br>
                                <div class="col-xs-6 col-sm-6">Name _____________________ S/O _____________________</div>
                                <div class="col-xs-6 col-sm-6">Name _____________________ S/O _____________________</div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <br>
                                <div class="col-xs-6 col-sm-6">CNIC: ________________________________________________</div>
                                <div class="col-xs-6 col-sm-6">CNIC: ________________________________________________</div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <br>
                                <div class="col-xs-12 col-sm-12">Remarks: ____________________________________________________________________________________________________________</div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <br>
                                <div class="col-xs-6 col-sm-6">Signature: ___________________________________________</div>
                                <div class="col-xs-6 col-sm-6">Signature: ___________________________________________</div>
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12  ">
                            <div class="row">
                                <br>
                                <div class="col-xs-12 col-sm-12">Date: ____________________________________________________________________________________________________________</div>
                            </div>
                        </div>
<br>
                        @include ('statement.footer-booking')

                    </div>
                </div>
            </div>
        </div>
        <div style="display: inline-block;    margin-bottom: 70px;">
            <div class="text-right" style="display: inline-block;">
                <button id="print" class="btn btn-default btn-outline no-print" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
            </div>
        </div>
    </div>

@stop

@section('js')
    <script src="{{ asset('js/jquery.PrintArea.js') }}" type="text/JavaScript"></script>
    <script>
        $(function () {
            $("#print").on("click", function () {
                window.print();
            });
        });
    </script>
    <script>
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    </script>
@stop