@extends('layouts.app')

@section('title')
All Cancel Statements 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Cancel Statements</li>
      </ol>
@stop
@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">
                                @permission('list-membership')
                                <a href="{{route('statement.cancel.add')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add new Cancellation
                                </a>
                                @endpermission
                            </div>
                        	
                            <h3 class="box-title">Cancel Statements ({{number_format($statementCount)}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                           
                                            
                                            <th>Unit #</th>
                                            <th>Size</th>
                                            <th>Member Name</th>
                                            <th>Net Amount</th>

                                            <th>Received Amount</th>
                                            
                                            <th>Booking Date</th>
                                            <th>Cancel Date</th>
                                            <th>Status</th>
                                            <th style="width: 185px!important;"><center>Action</center></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        

                                        @permission('reopen-membership')
                                            <?php $reopen_membership = true;?>
                                        @else
                                            <?php $reopen_membership = false;?>
                                        @endpermission

                                         @permission('view-membership')
                                            <?php $view_membership = true;?>
                                        @else
                                            <?php $view_membership = false;?>
                                        @endpermission

                                        

                                        @foreach($allStatements as $statement)
                                        <tr >
                                            <td>{{$count++}}</td>
                                           
                                           
                                            <td>{{$statement->inventory->unit_number}}</td>
                                              <td>@if($statement->inventory)
                                                @if($statement->inventory->size)
                                                
                                                {{$statement->inventory->size->name}} {{env('SIZE')}}
                                                @endif
                                                @endif
                                            </td>
                                            <td>{{$statement->customer ? $statement->customer->name: ''}}<br><b>Dealer: </b>{{$statement->dealer ? $statement->dealer->name: ''}}</td>

                                            <td><b>{{number_format($statement->net_pay)}}</b></td>


                                            <td><b>{{number_format($receivedAmt[$statement->id])}}</b></td>

                                            

                                            <td>{{date('d-m-Y', strtotime($statement->booking_date)) }}</td>

                                            <td>{{date('d-m-Y', strtotime($statement->cancel_date)) }}</td>

                                            @if($statement->status == \App\CustomerProperty::pending)
                                            <td><span class="label label-primary" style="background-color:#cd703d;">Pending</span></td>

                                            @elseif($statement->status == \App\CustomerProperty::approved)
                                            <td><span class="label label-success">Approved</span></td>
                                            @elseif($statement->status == \App\CustomerProperty::cancel)
                                            <td><span class="label label-danger">Canceled</span></td>
                                            @else
                                            <td></td>
                                            @endif



                                            <td class="text-nowrap">
                                                <center>

                                                    @if($view_membership)
                                                    <a href="{{route('statement.detail',['id'=>$statement->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                    @endif

                                                    @if($reopen_membership)
                                                    <a href="{{route('reopen.cancel',['id'=>$statement->id])}}" data-toggle="tooltip" data-original-title="ReOpen Canceled Statement"  onclick="return confirmReopen()"> <i class="fa fa fa-repeat text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                    @endif
                                                 </center>
                                            </td>

                                        </tr>

                                        @endforeach

                                    </tbody>
                                </table>
                                <div style="float: right;">{{$allStatements->links()}}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->


@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>

    function confirmReopen() 
    {
        
        if (confirm('Are you sure you want to reopen this property.')) 
        {
           return true; 
        }
        else
        {
            return false;
        }
        
    }
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'info':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

    </script>
@stop