@extends('layouts.app')

@section('title')
    Create Cancellation Request
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-cancellation')
            <li><a href="{{ route('statement.cancel') }}">All Cancelled Units</a></li>
        @endpermission
        <li class="active">Create Cancellation Request </li>
    </ol>
@stop
@section('content')

<div class="container-fluid">
    <div class="row">

        <div class="col-md-12">
            <div class="white-box">
                <h3 class="box-title m-b-0">Cancel Property Request </h3>
                <hr>
            </div>
        </div>
    </div>

<div class="container-fluid" style='background: white;
    border: 1px solid #e5ebec;'>
      
      <h2>Add Information</h2>
      <ul class="nav customtab nav-tabs" role="tablist">

        <li role="presentation" class="active"><a href="#close_file" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Close Unit</span></a></li>
        @if ($projectType->id == \App\ProjectType::society)
        <li role="presentation" class=""><a href="#open_file" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Open File </span></a></li>
        @endif
    </ul>
  

      <div class="tab-content">
        <div id="close_file" class="tab-pane fade in active">
    <form method='post' action="{{ route('statement.cancel.new') }}" enctype="multipart/form-data">
        {{ csrf_field() }}
      <div class="form-group">
        <label class="control-label col-sm-2" for="property_no">Property No <span style="color: red">*</span>:</label>
        <div class="col-sm-10">
            <div class="input-group">
            <select name="property_no[]" class="form-control js-example-basic-multiple" multiple="multiple"  >
                @foreach ($allStatements as $s)
                    <option value="{{ $s->id }}">{{ $s->customer->name }} -
                        {{ $s->inventory->unit_number }} - {{ $s->membership_no }}</option>
                @endforeach
            </select>
            @if ($errors->has('property_no'))
                <span class="help-block">
                    {{ $errors->first('property_no') }}
                </span>
            @endif
            </div>
        </div>
      </div>
      <div class="form-group" >
        <label class="control-label col-sm-2" for="pwd" style='margin-top: 15px;'>Request<span
            style="color: red">*</span></label>
        <div class="col-sm-10">          
            <div class="input-group" style='margin-top: 10px; width: 231px;'>
                <select class="form-control chosen-select" style="width:300px; " name="status">

                    <option value="{{ \App\CustomerProperty::cancel }}">Cancel</option>

                </select>

                @if ($errors->has('status'))
                    <span class="help-block">
                       {{ $errors->first('status') }}
                    </span>
                @endif
            </div>
        </div>
      </div>
      


      <div class="form-group" >
        <label class="control-label col-sm-2" for="pwd" style='    margin-top: 10px;'>Fee/Charges<span
            style="color: red">*</span></label>
        <div class="col-sm-10">          
            <div class="input-group" style='margin-top: 10px; width: 231px;'>
                 
                <input type="number" class="form-control" placeholder="Add fee" name='fee'>
                @if ($errors->has('status'))
                    <span class="help-block">
                        {{ $errors->first('status') }}
                    </span>
                @endif
            </div>
        </div>
      </div>

      <div class="form-group">        
        <div class="col-sm-offset-2 col-sm-10">
            <button type="submit" class="btn btn-info  waves-effect waves-light " style='margin-top: 10px; width: 90px; margin-left: 60px;'>Save</button>
        </div>
      </div>
    </form>
        </div>
        @if ($projectType->id == \App\ProjectType::society)
        <div id="open_file" class="tab-pane fade  ">
            <form method='post' action="{{route('openfile.cancel.new')}}" enctype="multipart/form-data">
                {{ csrf_field() }}
              <div class="form-group">
                <label class="control-label col-sm-2" for="property_no">Unit Number <span style="color: red">*</span></label>
                <div class="col-sm-10">
                    <div class="input-group">
                    <select name="openfiledealerinfo_no[]" class="form-control js-example-basic-multiple" multiple="multiple"  >
                        @foreach ($OpenFileDealerInfo as $o)
                            <option value="{{ $o->id }}">{{ $o->dealer->code }} ---
                                {{ $o->inventory->unit_number }} </option>
                        @endforeach
                    </select>
                    @if ($errors->has('openfiledealerinfo_no'))
                        <span class="help-block">
                            {{ $errors->first('openfiledealerinfo_no') }}
                        </span>
                    @endif
                    </div>
                </div>
              </div>
              <div class="form-group" >
                <label class="control-label col-sm-2" for="pwd" style='margin-top: 15px;'>Request<span
                    style="color: red">*</span></label>
                <div class="col-sm-10">          
                    <div class="input-group" style='margin-top: 10px; width: 231px;'>
                        <select class="form-control chosen-select" style="width:300px; " name="openfile_status">
        
                            <option value="{{ \App\CustomerProperty::cancel }}">Cancel</option>
        
                        </select>
        
                        @if ($errors->has('openfile_status'))
                            <span class="help-block">
                               {{ $errors->first('openfile_status') }}
                            </span>
                        @endif
                    </div>
                </div>
              </div>
              
        
        
              <div class="form-group" >
                <label class="control-label col-sm-2" for="pwd" style='margin-top: 10px;'>Fee/Charges<span
                    style="color: red">*</span></label>
                <div class="col-sm-10">          
                    <div class="input-group" style='margin-top: 10px; width: 231px;'>
                         
                        <input type="number" class="form-control" placeholder="Add fee" name='openfile_cancelfee'>
                        @if ($errors->has('openfile_cancelfee'))
                            <span class="help-block">
                                {{ $errors->first('openfile_cancelfee') }}
                            </span>
                        @endif
                    </div>
                </div>
              </div>
        
              <div class="form-group">        
                <div class="col-sm-offset-2 col-sm-10">
                    <button type="submit" class="btn btn-info  waves-effect waves-light " style='margin-top: 10px; width: 90px; margin-left: 60px;'>Save</button>
                </div>
              </div>
            </form>
        </div>
        @endif

      </div>
  </div>


</div>

@stop
@section('js')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
   
$(document).ready(function() {
    $('.js-example-basic-multiple').select2(
        {
             width: '231px' }

    );
});
</script>
@stop