@php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphp

    @php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    @endphp
    

    <div class="row" id="update-table" style="margin-top: 25px;">
        <div class="col-sm-12">
            <div class="white-box">
                <div class="pull-right">
                    @permission('create-cancellation')
                        <a href="{{ route('statement.cancel.add') }}" class="btn  btn-primary">
                            <i class="fa fa-plus-square"></i>&nbsp; Apply For Cancellation
                        </a>
                    @endpermission
                </div>

                <h3 class="box-title">Cancel Units </h3>



                <ul class="nav customtab nav-tabs" role="tablist">

                    <li role="presentation" class="active"><a href="#close_file" aria-controls="home" role="tab"
                            data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i
                                    class="ti-home"></i></span><span class="hidden-xs">Close Unit @if (count($allStatements) > 0)
                                    <span class="label label-rounded pull-right"
                                        style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($allStatements) }}</span>
                                @endif
                            </span>
                        </a></li>

                        @if ($projectType->id == \App\ProjectType::society)    
                    <li role="presentation" class=""><a href="#open_file" aria-controls="profile"
                            role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                    class="ti-user"></i></span> <span class="hidden-xs">Open File @if (count($allopenfile) > 0)
                                    <span class="label label-rounded pull-right"
                                        style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($allopenfile) }}</span>
                                @endif
                            </span></a></li>
                            @endif

                </ul>
                <div class="tab-content">
                    <div id="close_file" class="tab-pane fade in active">
                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>

                                        <th>Project</th>
                                        <th>Unit #</th>
                                        {{-- <th>Size</th> --}}
                                        <th>Member Name</th>
                                        <th>Net Amount</th>

                                        <th>Received Amount</th>

                                        {{-- <th>Booking Date</th> --}}
                                        <th>Cancel Date</th>
                                        <th>Cancel Fee(pkr)</th>
                                        <th>Request Status</th>
                                        <th>Unit Status</th>
                                        <th>After Cancellation Decision Request</th>
                                        <th>
                                        <!-- style="width: 185px!important;" -->
                                            <center>Action</center>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1; ?>


                                    @permission('approve-cancellation')
                                        <?php $reopen_membership = true; ?>
                                    @else
                                        <?php $reopen_membership = false; ?>
                                    @endpermission

                                    @permission('view-cancellation')
                                        <?php $view_membership = true; ?>
                                    @else
                                        <?php $view_membership = false; ?>
                                    @endpermission

                                    @permission('edit-cancellation')
                                        <?php $edit_membership = true; ?>
                                    @else
                                        <?php $edit_membership = false; ?>
                                    @endpermission

                                    @permission('delete-cancellation')
                                        <?php $delete_membership = true; ?>
                                    @else
                                        <?php $delete_membership = false; ?>
                                    @endpermission



                                    @foreach ($allStatements as $statement)
                                        <tr>
                                            <td>{{ $count++ }}</td>

                                            <td>{{ $statement->multiProject->name }}</td>
                                            <td>{{ $statement->inventory->unit_number }}</td>
                                            {{-- <td>
                                        @if ($statement->inventory)
                                            @if ($statement->inventory->size)
                                                {{ $statement->inventory->size->name }} {{ env('SIZE') }}
                                            @endif
                                        @endif
                                    </td> --}}
                                            <td>{{ $statement->customer ? $statement->customer->name : '' }}<br><b>Dealer:
                                                </b>{{ $statement->dealer ? $statement->dealer->name : '' }}</td>

                                            <td><b>{{ number_format($statement->net_pay) }}</b></td>


                                            <td><b>{{ number_format($receivedAmt[$statement->id]) }}</b></td>



                                            {{-- <td>{{ date('d-m-Y', strtotime($statement->booking_date)) }}</td> --}}

                                            <td>
                                                @if (empty($statement->cancel_date))
                                                    {{ date('d-m-Y', strtotime($statement->cancelProperty->created_at)) }}
                                                @else
                                                    {{ date('d-m-Y', strtotime($statement->cancel_date)) }}
                                                @endif

                                            </td>
                                            <td>{{ $statement->cancelProperty->fee }} </td>

                                            @if ($statement->cancelProperty->status == 0)
                                                <td><span class="label label-primary"
                                                        style="background-color:#4871c6;;">Pending</span></td>
                                            @elseif($statement->cancelProperty->status == 1)
                                                <td><span class="label label-success">Approved</span></td>
                                            @else
                                                <td></td>
                                            @endif


                                            @if ($statement->status == \App\CustomerProperty::pending)
                                                <td><span class="label label-primary"
                                                        style="background-color:#cd703d;">Pending</span></td>
                                            @elseif($statement->status == \App\CustomerProperty::approved)
                                                <td><span class="label label-success">Approved</span></td>
                                            @elseif($statement->status == \App\CustomerProperty::cancel)
                                                <td><span class="label label-danger">Canceled</span></td>
                                            @else
                                                <td></td>
                                            @endif

                                            @if ($statement->cancelProperty->after_cancellation_status == 'pending')
                                                <td><span class="label label-primary"
                                                        style="background-color:#4871c6;;">Pending</span></td>
                                            @elseif($statement->cancelProperty->after_cancellation_status == 'adjust-pending')
                                                <td><span class="label label-success">Adjust/Pending</span></td>
                                            @elseif($statement->cancelProperty->after_cancellation_status == 'refund-pending')
                                                <td><span class="label label-success">Refund/Pending</span></td>
                                            @elseif($statement->cancelProperty->after_cancellation_status == 'adjusted')
                                                <td><span class="label label-success">Adjusted</span></td>
                                            @elseif($statement->cancelProperty->after_cancellation_status == 'refunded')
                                                <td><span class="label label-success">Refunded</span></td>
                                            @elseif($statement->cancelProperty->after_cancellation_status == 'decline')
                                                <td><span class="label label-primary"
                                                        style="background-color:#f80808;;">Decline</span></td>
                                            @endif




                                            <td class="text-nowrap">
                                                <center>

                                                    @if ($view_membership)
                                                        <a href="{{ route('statement.detail', ['id' => $statement->id]) }}"
                                                            data-toggle="tooltip" data-original-title="View"> <i
                                                                class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                    @endif


                                                    @if (
                                                        $edit_membership &&
                                                            $statement->cancelProperty->after_cancellation_status != 'adjusted' &&
                                                            $statement->cancelProperty->after_cancellation_status != 'refunded' &&
                                                            $statement->cancelProperty->after_cancellation_status != 'decline')
                                                        <a href="{{ route('statement.cancel.edit', ['id' => $statement->id]) }}"
                                                            data-toggle="tooltip" data-original-title="Edit"> <i
                                                                class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                    @endif
                                                    @if (
                                                        $reopen_membership &&
                                                            $statement->cancelProperty->status == 1 &&
                                                            $statement->cancelProperty->after_cancellation_status == 'pending')
                                                        <a type='button'
                                                            onclick="confirmReopen('{{ $statement->id }}')"> <i
                                                                class="fa fa fa-repeat text-inverse m-r-10"
                                                                data-toggle="tooltip"
                                                                data-original-title="ReOpen"></i>&nbsp;&nbsp;</a>
                                                    @endif

                                                    @if ($delete_membership && $statement->cancelProperty->status == 0 && empty($statement->cancelProperty))
                                                        {{-- <form action="{{ route('statement.cancel.delete', [$statement->id]) }}" method="post"
                                                            style='display: inline;'>
                                                            {!! method_field('delete') !!}
                                                            {!! csrf_field() !!}
                                                            <a class=" btn-link btn-s" style="color:red;" type="submit"
                                                                name="action" value="delete" data-toggle="confirmation"
                                                                data-title="Are you sure to delete?">
                                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                        </a>
                                                        </form> --}}
                                                        <form
                                                            action="{{ route('statement.cancel.delete', [$statement->id]) }}"
                                                            method="post" style='display: inline;'>
                                                            {!! method_field('delete') !!}
                                                            {!! csrf_field() !!}


                                                            <button class="btn btn-link btn-s" style="color:red;"
                                                                type="submit" name="action" value="delete"
                                                                data-toggle="confirmation"
                                                                data-title="Are you sure to delete?">
                                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                            </button>
                                                        </form>
                                                    @endif




                                                </center>
                                            </td>

                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                            <div style="float: right;">{{ $allStatements->links() }}</div>
                        </div>
                    </div>
                    @if ($projectType->id == \App\ProjectType::society)  
                    <div id="open_file" class="tab-pane fade  ">
                        <div class="table-responsive">
                            <table id="myTable2" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Project</th>
                                        <th>Package Name</th>
                                        <th>Unit #</th>

                                        <th>Dealer Name</th>
                                        <th>Dealer Code</th>
                                        {{-- <th>Net Amount</th> --}}

                                        {{--     <th>Received Amount</th> --}}


                                        <th>Cancel Date</th>
                                        <th>Cancel Fee(pkr)</th>
                                        <th>Request Status</th>
                                        <th>Open File Status</th>
                                        <th>After Cancellation Decision Request</th>
                                        <th>
                                        <!-- style="width: 185px!important;" -->
                                            <center>Action</center>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1; ?>


                                    @permission('approve-cancellation')
                                        <?php $reopen_membership = true; ?>
                                    @else
                                        <?php $reopen_membership = false; ?>
                                    @endpermission

                                    @permission('view-cancellation')
                                        <?php $view_membership = true; ?>
                                    @else
                                        <?php $view_membership = false; ?>
                                    @endpermission

                                    @permission('edit-cancellation')
                                        <?php $edit_membership = true; ?>
                                    @else
                                        <?php $edit_membership = false; ?>
                                    @endpermission

                                    @permission('delete-cancellation')
                                        <?php $delete_membership = true; ?>
                                    @else
                                        <?php $delete_membership = false; ?>
                                    @endpermission



                                    @foreach ($allopenfile as $openfile)
                                        <tr>
                                            <td>{{ $count++ }}</td>

                                            <td>{{ $openfile->inventory->multiProject->name }}</td>
                                            <td>
                                                @if ($openfile->dealerPackage)
                                                    <a
                                                        href='{{ route('openfile.detail', $openfile->dealerPackage->id) }}'>
                                                        {{ $openfile->dealerPackage->package ? $openfile->dealerPackage->package->name : '' }}
                                                    </a>
                                                @endif

                                            </td>
                                            <td>{{ $openfile->inventory->unit_number }}</td>
                                            <td>{{ $openfile->dealer->name }}</td>
                                            <td>{{ $openfile->dealer->code }}</td>





                                            <td>{{ date('d-m-Y', strtotime($openfile->cancelOpenFile->created_at)) }}
                                            </td>
                                            <td>{{ $openfile->cancelOpenFile->fee }} </td>

                                            @if ($openfile->cancelOpenFile->status == 0)
                                                <td><span class="label label-primary"
                                                        style="background-color:#4871c6;;">Pending</span></td>
                                            @elseif($openfile->cancelOpenFile->status == 1)
                                                <td><span class="label label-success">Approved</span></td>
                                            @else
                                                <td></td>
                                            @endif



                                            @role('admin')
                                                <?php $admin = true; ?>
                                            @else
                                                <?php $admin = false; ?>
                                            @endrole
                                            @if ($admin)
                                                @if ($openfile->inventory->status == \App\Inventory::open)
                                                    <td><span class="label label-success">Open</span></td>
                                                @elseif($openfile->inventory->status == \App\Inventory::package_open_file)
                                                    <td><span class="label label-success">Open/Dealer Package
                                                            File</span></td>
                                                @elseif($openfile->inventory->status == \App\Inventory::sold)
                                                    <td><span class="label label-danger">Sold</span></td>
                                                @elseif($openfile->inventory->status == \App\Inventory::hold_client)
                                                    <td><span class="label label-primary">Client Hold</span></td>
                                                @elseif($openfile->inventory->status == \App\Inventory::hold_company)
                                                    <td><span class="label label-primary"
                                                            style="background-color:#cd703d;">Company Hold</span></td>
                                                            @elseif($openfile->inventory->status == \App\Inventory::package_open_file_refunded)
                                                            <td><span class="label label-success">Open/Dealer Package Refunded</span>
                                                            </td>
                                                @elseif($openfile->inventory->status == \App\Inventory::token_hold)
                                                    <td><span class="label label-primary">Token Hold</span></td>
                                                @else
                                                    <td></td>
                                                @endif
                                            @else
                                                @if ($openfile->inventory->status == \App\Inventory::open)
                                                    <td><span class="label label-success">Open</span></td>
                                                @else
                                                    <td><span class="label label-danger">Sold</span></td>
                                                @endif
                                            @endif

                                            @if ($openfile->cancelOpenFile->after_cancellation_status == 'pending')
                                                <td><span class="label label-primary"
                                                        style="background-color:#4871c6;;">Pending</span></td>
                                            @elseif($openfile->cancelOpenFile->after_cancellation_status == 'adjust-pending')
                                                <td><span class="label label-success">Adjust/Pending</span></td>
                                            @elseif($openfile->cancelOpenFile->after_cancellation_status == 'refund-pending')
                                                <td><span class="label label-success">Refund/Pending</span></td>
                                            @elseif($openfile->cancelOpenFile->after_cancellation_status == 'adjusted')
                                                <td><span class="label label-success">Adjusted</span></td>
                                            @elseif($openfile->cancelOpenFile->after_cancellation_status == 'refunded')
                                                <td><span class="label label-success">Refunded</span></td>
                                            @elseif($openfile->cancelOpenFile->after_cancellation_status == 'decline')
                                                <td><span class="label label-primary"
                                                        style="background-color:#f80808;;">Decline</span></td>
                                            @elseif($openfile->cancelOpenFile->after_cancellation_status == 'swap-pending')
                                                <td><span class="label label-success">Swap/Pending</span></td>
                                            @endif




                                            <td class="text-nowrap">
                                                <center>

                                                    {{-- @if ($view_membership)
                                        <a href="{{ route('statement.detail', ['id' => $openfile->id]) }}"
                                            data-toggle="tooltip" data-original-title="View"> <i
                                                class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                    @endif --}}


                                                    @if (
                                                        $edit_membership &&
                                                            $openfile->cancelOpenFile->after_cancellation_status != 'adjusted' &&
                                                            $openfile->cancelOpenFile->after_cancellation_status != 'refunded' &&
                                                            $openfile->cancelOpenFile->after_cancellation_status != 'decline')
                                                        <a href="{{ route('openfile.cancel.edit', ['id' => $openfile->id]) }}"
                                                            data-toggle="tooltip" data-original-title="Edit"> <i
                                                                class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                    @endif
                                                    @if (
                                                        $reopen_membership &&
                                                            $openfile->cancelOpenFile->status == 1 &&
                                                            $openfile->cancelOpenFile->after_cancellation_status == 'pending')
                                                        <a type='button'
                                                            onclick="confirmReopen('{{ $openfile->id }}')"> <i
                                                                class="fa fa fa-repeat text-inverse m-r-10"
                                                                data-toggle="tooltip"
                                                                data-original-title="ReOpen"></i>&nbsp;&nbsp;</a>
                                                    @endif

                                                    @if ($delete_membership && $openfile->cancelOpenFile->status == 0 && empty($openfile->cancelOpenFile))
                                                        <form
                                                            action="{{ route('statement.cancel.delete', [$openfile->id]) }}"
                                                            method="post" style='display: inline;'>
                                                            {!! method_field('delete') !!}
                                                            {!! csrf_field() !!}


                                                            <button class="btn btn-link btn-s" style="color:red;"
                                                                type="submit" name="action" value="delete"
                                                                data-toggle="confirmation"
                                                                data-title="Are you sure to delete?">
                                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                            </button>
                                                        </form>
                                                    @endif




                                                </center>
                                            </td>

                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                            <div style="float: right;">{{ $allStatements->links() }}</div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>