@extends('layouts.app')

@section('title')
    Edit Cancellation Request
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-cancellation')
            <li><a href="{{ route('statement.cancel') }}">All Cancelled Units</a></li>
        @endpermission
        <li class="active">Edit Cancellation Request </li>
    </ol>
@stop
@section('content')
    <style>

    </style>
    <div class="container-fluid">
        <div class="row">

            <div class="col-md-12">
                <div class="white-box">
                    <h3 class="box-title m-b-0">Edit Cancel Property Request </h3>
                    <hr>
                </div>
            </div>
        </div>

        <div class="container-fluid" style='background: white;
                     border: 1px solid #e5ebec;'>
            <h2>Update Information</h2>
            <form method='post' action="{{ route('statement.cancel.update') }}" enctype="multipart/form-data">
                {{ csrf_field() }}
                <input type='hidden' value={{ $allStatements->id }} name='property_no'>
                <div class="form-group">
                    <label class="control-label col-sm-2" for="property_no">Property No <span
                            style="color: red">*</span>:</label>
                    <div class="col-sm-10">
                        <div class="input-group">
                            <select class="form-control js-example-basic-multiple" multiple="multiple">

                                <option value="{{ $allStatements->id }}" selected>{{ $allStatements->customer->name }} -
                                    {{ $allStatements->inventory->unit_number }} - {{ $allStatements->membership_no }}
                                </option>

                            </select>
                            @if ($errors->has('property_no'))
                                <span class="help-block">
                                    {{ $errors->first('property_no') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='    margin-top: 15px;'>Request<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px;'>
                            <select class="form-control chosen-select" style="width:300px; " name="status">

                                <option value="{{ \App\CustomerProperty::cancel }}" selected>Cancel</option>

                            </select>

                            @if ($errors->has('status'))
                                <span class="help-block">
                                    {{ $errors->first('status') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>



                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='    margin-top: 10px;'>Fee/Charges<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px;'>

                            <input type="number" class="form-control" placeholder="Add fee" name='fee'
                                value='{{ $allStatements->cancelProperty->fee }}'>
                            @if ($errors->has('fee'))
                                <span class="help-block">
                                    {{ $errors->first('fee') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='    margin-top: 10px;'>Status<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px;'>

                            <select class="form-control chosen-select" style="width:300px; " name="property_status"  onchange="getval(this)">
                                @if ($allStatements->cancelProperty->status == 0)
                                    <option value="0" selected style=" background: red;">Pending</option>

                                    <option value="1" style=" background: green;">Approve</option>
                                @elseif($allStatements->cancelProperty->status == 1)
                                    <option value="0" style=" background: red;">Pending</option>

                                    <option value="1" selected style=" background: green;">Approve</option>
                                @endif

                            </select>
                            @if ($errors->has('status'))
                                <span class="help-block">
                                    {{ $errors->first('status') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>





                {{-- Adjust or Refund Property  --}}
                <div class="form-group" id='adjust_refund' style='display:none'>
                    <h2>Refund or Adjust Paid Amount</h2>  
                    <select id='adjust_refund_select' name="adjust_refund" onchange="adjusOrRefund(this)" class="custom-select mb-3">
                        <option selected> Select Menu</option>
                        <option value="0">Refund</option>
                        <option value="1">Adjust</option>
                        
                      </select>
                     
                      {{--Refund Div --}}
                      <div class="form-horizontal" id='refunded_portion' style='display:none'>
                      
                            <div class="form-group">
                              <label class="control-label col-sm-2" for="email">Total Received Amount:</label>
                              <div class="col-sm-10">
                                <input type="text" class="form-control" id="total_paid_amount" value={{$received_amount}} style='width:59%' readonly>
                              </div>
                            </div>
                            <div class="form-group">
                              <label class="control-label col-sm-2" for="pwd">Add Deduction Charges:</label>
                              <div class="col-sm-10" style='display: flex'>
                                <input type="number" class="form-control" id="refund_amount_deducted" placeholder="Enter..." style='width:50%' oninput="getPerIf(this)">
                                <select id='refund_deduction_type' name="refund_deduction_type" onchange="refundValueType(this)"  class="custom-select mb-3">
                                    
                                    <option value="0">Rs</option>
                                    <option value="1">%</option>
                                    
                                  </select>
                                 
                            </div>
                            <div style='display:none' id='per_for_refund_deduction'>
                            <label class="control-label col-sm-2" for="pwd">Your Percentage Amount:</label>
                            <div class="col-sm-10" >
                            <input type="number" class="form-control" id="refund_amount_deducted_per"  style='width:30%' readonly>
                            </div>
                        </div>   
                        </div>
                           
                           

                       
                      </div>
                      {{-- End Refund Div --}}







                </div>
                {{-- End Adjust or Refund Property --}}

         


       















        <div class="form-group">
            <div class="col-sm-offset-2 col-sm-10">
                <button type="submit" class="btn btn-info  waves-effect waves-light "
                    style='    margin-top: 10px;'>Save</button>
            </div>
        </div>
        </form>
    </div>


    </div>



@stop
@section('js')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-multiple').select2({
                disabled: true
            });
        });

        function findPercentage(value,totalpaidamount){

return (value /100) * totalpaidamount;
}

        function getval(sel)
{
   
           if(sel.value == 1){
           
            $("#adjust_refund").show();

           }
           else if(sel.value == 0){
            $("#adjust_refund").hide();
           }
}
function adjusOrRefund(sel){

    if(sel.value == 1){
        $("#refunded_portion").hide();
        //    $("#adjust_refund").show();

          }
          else if(sel.value == 0){
        //    $("#refunded_portion").hide();
           $("#refunded_portion").show();
          }
}
function refundValueType(sel){

    if(sel.value == 0){
        $("#per_for_refund_deduction").hide();
        //    $("#adjust_refund").show();
        $("#refund_amount_deducted_per").val(0);

          }
          else if(sel.value == 1){
        //    $("#refunded_portion").hide();
           $("#per_for_refund_deduction").show();

          

           var totalpaidamount = $("#total_paid_amount").val();//total paid value
        var value=   $("#refund_amount_deducted").val();
           
    result= findPercentage(value,totalpaidamount);
//    (sel.value /100) * totalpaidamount;
    $("#refund_amount_deducted_per").val(result);
          }
}
function getPerIf(sel){
    //refund_deduction_type
    var deductiontype = $('#refund_deduction_type').find(":selected").val();

if(deductiontype == 1){
    // '#refund_amount_deducted_per';
    var totalpaidamount = $("#total_paid_amount").val();//total paid value
    result= findPercentage(sel.value ,totalpaidamount);
//    (sel.value /100) * totalpaidamount;
    $("#refund_amount_deducted_per").val(result);
     
}


}


    </script>
@stop
