@extends('layouts.app')


@section('title')
Detail of Customer Statement
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-membership')
            <li><a href="{{ route('statement.all') }}">Statements</a></li>
        @endpermission
        <li class="active">Statement Detail</li>
    </ol>
    @stop

@section('css')
    <style type="text/css">
        .bg-color{
            background-color: #1c3752;
        }
        #us_Table
        {
            margin-top:35px;
        }
        .anchor-link
        {
            display:none !important;
        }
        
            .row, h3 {
            font-family: Century Gothic !important;
        }

        .font-size {
            font-size: 14.5px !important;
        }

        .td-bg {
            background: #D9D9D9 !important;
        }

        .box-title {
            font-size: 27px !important;
            font-weight: normal !important;
        }
        
        /*	table, th, td {*/
        /*  border: 1px solid black !important;*/
        /*}*/
        table {
            border-collapse: collapse !important;
        }
        
        
        .usm_table>tbody>tr>td, .usm_table>tbody>tr>th, .usm_table>tfoot>tr>td, .usm_table>tfoot>tr>th {
        border: 1px solid black !important;
        /*border-collapse: collapse !important;*/
        }
        
    </style>
    <style type="text/css" media="print">
    
    @media print {
        #us_title
        {
                margin-top: 1.5rem;
        }
        
         #us_Table
        {
            margin-top:20px !important;
        }
        .us_box_titl{
            margin-top:2.5rem;
        }
        /*#APP_NAME*/
        /*{*/
        /*    display:none !important;*/
        /*}*/
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        color: black !important;
        }
        h3{
            line-height: 1px;
        }

          h3 strong{
        text-transform: uppercase;
        color: black !important
        }
        h4 strong{
            text-transform: uppercase;
            color: black !important
        }
        .printFH11 {
        font-size: 13px;
        font-weight: 800;
        background-color: #000000;
        }
        .white-box .box-title {
        margin: 0px 0px 4px 0px;
        font-weight: 700;
        font-size: 14px;
        color: #1c3752;
        background-color: #000000 !important;
        }
        .white-box {
        padding: 0px 0px 2px 0px;
        margin-bottom: 0px;
        margin-bottom: 0;
        border-radius: inherit;
        }
        .table {
        width: 100% !important;
        margin-bottom: 5px;
        margin-top: -2px;
        }
        .table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th {
        vertical-align: top;
        }
        .page-wrapper {
        padding-top: 0px;
        }
        }
    
    

    </style>

@stop

            @section('content')

            @php
                $size= '';

                if($projectType->id == \App\ProjectType::society){

                $size= \App\ProjectType::society_size;
                }

                else
                {
                $size= \App\ProjectType::high_rise_size;
                }

            @endphp

            @php
                $map= ' ';

                if($projectType->id == \App\ProjectType::society){

                $map= \App\ProjectType::society_map;
                }

                else
                {
                $map= \App\ProjectType::high_rise_map;
                }

            @endphp

            <div class="container-fluid">
                <div class="row printableArea" id="htmlContent">

                    <div class="col-lg-12 text-center no-print">

                        <!-- <div class="pull-left hidden-lg">-->



                    </div>
                    <div class="row no-print">
                        <div class="col-sm-6 col-xs-6">
                            <img src="{{ asset('images/logo.png') }}"
                                style="margin-left: 42px;width:91px;margin-bottom: -49px;">
                        </div>

                    </div>
                    <div class="clear"></div>
                    <div class="text-center no-print">
                        <h3><strong>{{ env('APP_NAME') }}</strong></h3>
                        <h3><strong>
                                @if($property->inventory)
                                    @if($property->inventory->multiProject)
                                        {{ $property->inventory->multiProject->name }}

                                    @endif
                                @endif
                            </strong></h3>
                        <h4><strong>Account Statement</strong></h4>
                    </div>
                    <div class="col-lg-12 no-print">
                        <div class="white-box1 ">
                            <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px"
                                id="text_detail">&nbsp;&nbsp;Member Information</h4>
                            @php

                                $ownerArray[] = $property->customer->name;

                                if(!empty($property->customer->first_owner))
                                {
                                $ownerArray[] = $property->customer->first_owner;
                                }

                                if(!empty($property->customer->second_owner))
                                {
                                $ownerArray[] = $property->customer->second_owner;
                                }

                            @endphp
                            <div class="pull-left" style="width:100%">
                                <div class="table-responsive">
                                    <table class="table bottom-table" id="main_customer_info">
                                        <tbody class="printFW">

                                            <tr>
                                                <td style="font-weight: 600; width: 150px">Ref No:</td>
                                                <td>{{ $property->membership_no }}</td>
                                                <td style="font-weight: 600; width: 140px">
                                                    <?= ( $property->customer->type  == 1) ? 'Incorporation no' : 'CNIC No.' ?>
                                                </td>
                                                <td style="width:240px">


                                    @if(count($ownerArray) > 1)
                                    {{str_replace('_' , ''  , $property->customer->cnic)}},  {{$property->customer->first_owner_cnic}}, 
                                    {{$property->customer->second_owner_cnic}} 
                                    @else
                                    <?php $c = str_split($property->customer->cnic, 1);?>
                                    <?php 
                                    for($i =0;$i<count($c) ; $i++) 
                                    {
                                    ?>
                                    @if(($i == 5 || $i == 12) &&  $property->customer->type  == 0)
                                    -
                                    @endif
                                    <?= ( $property->customer->type  == 1) ? str_replace('_' , '' , $c[$i] ) : $c[$i] ?> 
                                    <?php 
                                    }
                                    ?> 
                                    @endif




                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;">
                                                    <?= ( $property->customer->type  == 1) ? 'Company Name:' : 'Member Name:' ?>
                                                </td>
                                                <td>
                                                    @if(count($ownerArray) > 1)
                                                        {{ $property->customer->name }},
                                                        {{ $property->customer->first_owner }},
                                                        {{ $property->customer->second_owner }}
                                                    @else
                                                        {{ $property->customer->name }}
                                                    @endif

                                                </td>

                                                <td
                                                    style="font-weight: 600; width: 140px; display: <?= ( $property->customer->type  == 1) ? 'none' : '' ?>">
                                                     @if($property->customer->father_type == 1) {{'S/O:'}} @elseif($property->customer->father_type == 2) {{'D/O:'}} @elseif($property->customer->father_type == 3) {{'W/O:'}} @else {{ 'Company Name' }} @endif
                                               <td
                                                    style="width:240px;display: <?= ( $property->customer->type  == 1) ? 'none' : '' ?>">

                                                    @if(count($ownerArray) > 1)
                                                        {{ $property->customer->father_name }},
                                                        {{ $property->customer->first_owner_father }},
                                                        {{ $property->customer->second_owner_father }}
                                                    @else
                                                        {{ $property->customer->father_name }}
                                                    @endif

                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;">Contact #:</td>
                                                <td> {{ $property->customer ? $property->customer->mobile_number : '' }}
                                                </td>
                                                <td style="font-weight: 600;">Address:</td>
                                                <td> {{ $property->customer->mailing_address }} </td>
                                            </tr>

                                        </tbody>
                                    </table>



                                    <table class="table bottom-table" style="display:none;" id="summary_customer_info">
                                        <tbody class="printFW">

                                            <tr>
                                                <td style="font-weight: 600;">
                                                    <?= ( $property->customer->type  == 1) ? 'Company Name:' : 'Member Name:' ?>
                                                </td>
                                                <td> {{ $property->customer->name }} </td>


                                            </tr>

                                            <tr>

                                                <td style="font-weight: 600;">Unit No.:</td>
                                                <td>{{ $property->inventory ? $property->inventory->unit_number : '' }}
                                                </td>

                                            </tr>

                                            <tr>
                                                <td class="block_id" style="font-weight: 600;">Block:</td>
                                                @if($property->inventory->floor)
                                                    <td class="block_id">
                                                        {{ $property->inventory->floor->unitBlock ? $property->inventory->floor->unitBlock->name : '' }}
                                                    </td>
                                                @endif
                                                <td style="font-weight: 600;">Unit Type:</td>
                                                <td>{{ $property->inventory->type->name }}</td>
                                            </tr>

                                            <tr>
                                                <td style="font-weight: 600;" class="Category">Category:</td>
                                                <td class="Category">
                                                    @foreach($property->inventory->categories as $c)
                                                        @if($c->category)
                                                            @if($loop->last)
                                                                {{ $c->category->name }}
                                                                ({{ $c->category->percent }} )
                                                            @else
                                                                {{ $c->category->name }}
                                                                ({{ $c->category->percent }} ),
                                                            @endif

                                                        @endif
                                                    @endforeach</td>

                                                <td style="font-weight: 600;" class="area">Area:</td>
                                                <td class="area">{{ $property->inventory->area }}</td>

                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;">Size:</td>
                                                <td>
                                                    {{ $property->inventory->size ? $property->inventory->size->name : '' }}
                                                    {{ $size }}
                                                </td>

                                                <td style="font-weight: 600;" class="discount">Discount:</td>
                                                <td class="discount"> {{ number_format($property->discount ) }}
                                                </td>

                                            </tr>
                                            <tr>

                                                <td style="font-weight: 600;" class="category_cost">Category Cost:</td>
                                                <td class="category_cost">
                                                    {{ number_format($property->inventory->extra_amount) }} </td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;" class="net_amount">Net Amt.:</td>
                                                <td class="net_amount"> {{ number_format($property->net_pay) }} </td>

                                                <td style="font-weight: 600;">Booking Date:</td>

                                                <td> {{ date('d-m-Y', strtotime($property->original_boooking_date)) }}
                                                </td>
                                            </tr>

                                            <tr>
                                                <td style="font-weight: 600;">Over Due Amt.</td>
                                                <td> {{ number_format($overDue) }}</td>

                                            </tr>


                                        </tbody>
                                    </table>


                                </div>
                                <div class="clear"></div>
                            </div>

                        </div>
                    </div>
                    <div class="col-lg-12 no-print" id="main_unit_details">
                        <div class="white-box1">
                            <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px">
                                &nbsp;&nbsp;Unit's Details</h4>
                            <div class="col-md-4 col-xs-6">
                                <div class="table-responsive">
                                    <table class="table bottom-table">

                                        <tbody>
                                            <tr>
                                                <td style="font-weight: 600;">Project:</td>
                                                <td>
                                                    @if($property->inventory)
                                                        @if($property->inventory->multiProject)
                                                            {{ $property->inventory->multiProject->name }}

                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;">{{ $map }}:</td>
                                                <td>@if($property->inventory->floor)
                                                    {{ $property->inventory->floor->name }}

        @endif</td>
        </tr>

        <tr>
            <td style="font-weight: 600;">Block:</td>
            @if($property->inventory->floor )
                <td> {{ $property->inventory->floor->unitBlock ? $property->inventory->floor->unitBlock->name : '' }}
                </td>
            @endif
        </tr>

        <tr>
            <td style="font-weight: 600;">Category:</td>
            <td>
                @foreach($property->inventory->categories as $c)
                    @if($c->category)
                        @if($loop->last)
                            {{ $c->category->name }} ({{ $c->category->percent }} )
                        @else
                            {{ $c->category->name }} ({{ $c->category->percent }} ),
                        @endif
                    @endif
                @endforeach
            </td>
        </tr>
        <tr>
            <td style="font-weight: 600;">Size:</td>
            <td>
                {{ $property->inventory->size ? $property->inventory->size->name : '' }}
                {{ $size }}
            </td>

        </tr>

        @if($projectType->id == \App\ProjectType::society)
            <tr>
                <td style="font-weight: 600;">Cost Of Land:</td>
                <td>PKR {{ number_format($property->inventory->total_price) }}</td>
            </tr>
            <tr>
                <td style="font-weight: 600;">Development Charges:</td>
                <td>PKR {{ number_format($developmentcharges) }}</td>
            </tr>
        @endif

        @if($projectType->id == \App\ProjectType::high_rise)
            <tr>
                <td style="font-weight: 600;">Total Price:</td>
                <td>PKR {{ number_format($property->inventory->total_price) }} </td>
            </tr>

        @endif
        <tr>

            <td style="font-weight: 600;">Net Amt:</td>
            <td>PKR {{ number_format($property->net_pay) }} </td>
        </tr>

        @if($property->down_payment_note)
            <tr class="no-print">
                <td style="font-weight: 600;">Notes:</td>
                <td>{{ $property->down_payment_note }}</td>
            </tr>
        @endif
        <!--  <tr class="no-print">
                                <td style="font-weight: 600;">Automatic Sms Alerts</td>
@if($property->sms_alert == true)
                                <td>On</td>
@else
                                <td>Off</td>
@endif
                            </tr>
                            <tr class="no-print">
                                <td style="font-weight: 600;">Automatic Email Alerts</td>
@if($property->email_alert == true)
                                <td>On</td>
@else
                                <td>Off</td>
@endif
                            </tr> -->


        <tr class="no-print">
            @permission('print-membership')
                <td><a style="font-size: 10px;" target="_blank"
                        href="{{ route('statement.booking',['id'=>$property->id]) }}"
                        class="btn btn-primary" data-toggle="tooltip"
                        data-original-title="Print - {{ $property->print_count_m }}"><i class="fa fa-print "></i>
                        Application Form</a></td>
            @endpermission
            <!--                              @permission('print-membership')-->
            <!--                              <td><a  style="font-size: 10px;pointer-events: none;-->
            <!--cursor: default;" href="#" class="btn btn-primary" data-toggle="tooltip" data-original-title="Print - {{ $property->print_count_c }}" ><i class="fa fa-print "></i> Allotment Letter </a></td>-->
            <!--                              @endpermission-->
        </tr>
        <tr class="no-print">
            @permission('print-membership')
                <td><a style="font-size: 10px;" target="_blank"
                        href="{{ route('statement.sale-agreement',['id'=>$property->id]) }}"
                        class="btn btn-primary"><i class="fa fa-print "></i>Agreement Form </a></td>
            @endpermission

        </tr>



        <!-- <tr>
                                <td>Discount:</td>
                                <td> {{ $property->discount }} </td>
                            </tr> -->

        </tbody>
        </table>
        </div>
        </div>
        <!-- 
                <div class="col-md-4">&nbsp;</div> -->
        <div class="col-md-4 col-xs-6">
            <div class="table-responsive">
                <table class="table">
                    <tbody>
                        <tr>
                            <td style="font-weight: 600;">Unit/Plot No.:</td>
                            <td>{{ $property->inventory ? $property->inventory->unit_number : '' }}
                            </td>
                        </tr>
                        <tr>
                            <td style="font-weight: 600;">Unit Type:</td>
                            <td>{{ $property->inventory->type->name }}</td>
                        </tr>
                        <tr>
                            <td style="font-weight: 600;">Area:</td>
                            <td>{{ $property->inventory->area }}</td>
                        </tr>
                        <tr>
                            <td style="font-weight: 600;">Discount:</td>
                            <td> {{ number_format($property->discount ) }} </td>
                        </tr>
                        <tr>
                            <td style="font-weight: 600;">Category Cost:</td>
                            <td> {{ number_format($property->inventory->extra_amount) }} </td>
                        </tr>
                        <tr>
                            <td style="font-weight: 600;">Booking Type : </td>
                            @if($property->booking_type == \App\CustomerProperty::normal)
                                <td>Installment</td>

                            @elseif($property->booking_type == \App\CustomerProperty::full_payment)
                                <td>Full Payment</td>
                            @endif
                        </tr>
                        <tr>
                            <td style="font-weight: 600;">Booking Date:</td>

                            <td> {{ date('d-m-Y', strtotime($property->original_boooking_date)) }}
                            </td>


                        </tr>
                        <tr>
                            <td style="font-weight: 600;">Schedule Start Date:</td>
                            <td> @if($property->schedule_start_date)
                                {{ date('d-m-Y', strtotime($property->schedule_start_date)) }}
    @endif</td>
    </tr>

    <!-- <tr class="no-print">
                                <td  style="font-weight: 600;">Sale By : </td>
                                <td>{{ $property->saleBy ? $property->saleBy->name : '' }}</td>
                            </tr> -->

    </tbody>
    </table>
    </div>
    </div>


    <div class="clear"></div>
    </div>
    </div>

    <div class="col-lg-12 no-print">
        <div class="white-box1 ">
            <h6 class="box-title " style=" color: white; background-color:#1c3752; line-height: 30px">
                &nbsp;&nbsp;Rebate's Info <span
                    style="float: right;margin-right: 2rem;font-size: 3rem;font-weight: bolder;cursor: pointer;"
                    onclick="showDealerDiv()">+</span></h6>

            <div class="col-xs-4 col-sm-4" style="display:none;" id="data_div">
                <div class="table-responsive">
                    <table class="table bottom-table">
                        <tbody class="printFW">

                            @foreach($dealers as $d)

                                <tr>
                                    <td style="font-weight: 600;">Name :</td>
                                    <td> {{ $d->dealer->name }} </td>

                                    <td style="font-weight: 600;">Rebate : </td>
                                    <td> {{ number_format($d->amount) }} </td>


                                </tr>

                            @endforeach



                        </tbody>
                    </table>
                </div>
                <div class="clear"></div>
            </div>

        </div>
    </div>




    <div class="col-lg-12 no-print" id="payment_div">
        <div class="white-box1 ">
            <h4 class="box-title " style=" color: white; background-color:#1c3752; line-height: 30px">
                &nbsp;&nbsp;Payment Detail</h4>

            <div class="col-md-12 col-xs-12">
                <div class="table-responsive">
                    <table class="table bottom-table">
                        <tbody class="printFW">

                            <tr>
                                <td style="font-weight: 600;">Net Price: </td>
                                <td>PKR {{ number_format($property->net_pay) }} </td>


                                <td style="font-weight: 600;">Received Amount: </td>
                                <td>PKR {{ number_format($amount) }} &nbsp;
                                    &nbsp;({{ number_format($receivedAmtPer , 2) }} % ) </td>


                                <td style="font-weight: 600;">Outstanding Amt: </td>
                                <td>PKR {{ number_format($outstandingAmt) }} &nbsp;
                                    &nbsp;({{ number_format($outstandingAmtPer , 2) }} % )</td>

                            </tr>


                            <tr>

                                <td style="font-weight: 600;">Over Due Amt.</td>
                                <td>PKR {{ number_format($overDue) }} &nbsp; &nbsp;
                                    ({{ number_format($overDuePer , 2) }} % )</td>


                                <td style="font-weight: 600;">PDC.</td>
                                <td>PKR {{ number_format($pdc_receipt) }} &nbsp;
                                    &nbsp;({{ number_format($pdcReceiptPer , 2) }} % )</td>

                                <td style="font-weight: 600;">Paid Surcharge</td>
                                <td>PKR {{ number_format($paidSurcharge) }} </td>

                            </tr>


                        </tbody>
                    </table>
                </div>
                <div class="clear"></div>
            </div>

        </div>
    </div>

    <div class="col-lg-12">
        <div class="white-box1 printableArea">
            
        <div class="row">
            <div class="col-sm-3 col-xs-3">
                <img src="{{asset('images/logo.png')}}" style="width:60%; margin:15px auto 0; display:block;"> 
            </div>
            <div class="col-sm-9 col-xs-9" style="padding-left: 0rem;">
                <div class="row" style="margin-top: 7rem; margin-left: 0; margin-right: 0; border: 1px solid black; display: flex;">
                    <div style="margin: auto;text-align: center;">
                    <center>
                        <h3 class="box-title us_box_titl" style="margin-bottom: 0;">
                            <span style="color:black">{{ env('APP_NAME') }}</span>
                        </h3>
                        <p id="us_title"></p>	
                        </center>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <table style="width: 100%; margin-top: 5px; margin-bottom: 10px;" id="myTable" class="table table-bordered dataTable color-table primary-table no-spacing usm_table" role="grid" >
                    <tbody>
                        <tr>
                            <td>Name</td>
                            <td  >@if($property->customer->father_type == 1) {{'Mr.'}} @elseif($property->customer->father_type == 2) {{'Ms.'}} @elseif($property->customer->father_type == 3) {{'Mrs.'}} @else {{ 'Company Name' }} @endif  {{$property->customer->name}}</td>
                            <td rowspan="2" >Address: {{$property->customer->mailing_address}}</td>
                        </tr>
                        
                        
                        <tr>
                            <td>@if($property->customer->type == 0) {{ 'CNIC No:' }} @else {{ 'Incorporation no' }} @endif </td>
                            <td> <?php $c = str_split($property->customer->cnic, 1);?>
                            <?php for($i =0;$i<count($c) ; $i++) {?>
                            @if(($i == 5 || $i == 12) && $property->customer->type == 0)
                            <span class="">-</span>
                            @endif
                            
                            <span class="">
                                    <?= ( $property->customer->type  == 1) ? str_replace('_' , '' , $c[$i] ) : $c[$i] ?> 
                                </span> 
                            
                            <?php }?> </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        
        
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <p style="margin-bottom: 0;"><u>Apartment Details:</u></p>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6 col-xs-6">
                <table style="width: 100%; margin-top: 0; margin-bottom: 10px;border-top: none;border-right: none;border-bottom:none;" id="myTable" class="table table-bordered dataTable color-table primary-table table-spacing usm_table" role="grid" >
                    <tbody>
                        <tr>
                            <td class="td-bg" width="50%">File No:</td>
                            <td style="border-left: 0 !important;"><center>{{$property->inventory->unit_number}}</center></td>
                        </tr>
                        <tr>
                            <td class="td-bg">Block:</td>
                            <td style="border-left: 0 !important;"><center>
                                
                                <?php
                                $block = explode(' ' , isset($property->inventory->floor) ? $property->inventory->floor->unitBlock->name : '');
                                if(!empty($block[1])) { echo $block[1]; }
                                ?>
                                
                                </center></td>
                        </tr>
                        
                        <tr>
                            <td class="td-bg">Floor:</td>
                            <td style="border-left: 0 !important;"><center> 
                            <?php
                                $tier = explode(' ' , isset($property->inventory->floor) ? $property->inventory->floor->name : '');
                                    if(!empty($tier[0])) { echo $tier[0]; }
                                ?>
                            </center></td>
                        </tr>
                        
                        <tr>
                            <td class="td-bg">Type:</td>
                            <td style="border-left: 0 !important;"><center>{{$property->inventory->type->name}}</center></td>
                            <td style="color:white;border:none !important;min-width: 1.85rem;"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-sm-1 col-xs-1"></div>
            <div class="col-sm-5 col-xs-5">
                <table style="width: 100%; margin-top: 0; margin-bottom: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table table-spacing usm_table" role="grid" >
                    <tbody> 
                        <tr>
                            <td class="td-bg">Reference No::</td>
                            <td style="text-align: right; border-left: 0 !important;"><center>{{$property->membership_no}}</center></td>
                        </tr>
                        <tr>
                            <td class="td-bg" width="50%">Category:</td>
                            <td style="border-left: 0 !important;">
                                <center>
                                    @foreach($property->inventory->categories as $c)

                                                    @if($loop->last)
                                                    {{$c->category->name}} 
                                                    @else
                                                    {{$c->category->name}}
                                                    @endif
                                    @endforeach
                                </center>
                            </td>
                        </tr>
                        
                        <tr>
                            <td class="td-bg">Apartment No:</td>
                            <td style="text-align: right; border-left: 0 !important;"><center>{{$property->inventory->unit_number}}</center> </td>
                        </tr>
                        
                        <tr>
                            <td class="td-bg">Gross Area (Sft.):</td>
                            <td style="text-align: right; border-left: 0 !important;"><center>{{number_format($property->inventory->size->name)}}</center> </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        
        
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <p style="margin-bottom: 0;"><u>Payment Plan:</u></p>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6 col-xs-6">

                <table style="width: 100%; margin-top: 0; margin-bottom: 10px;border-right: none !important;border-bottom: none !important;border-top: none !important;" id="myTable" class="table table-bordered dataTable color-table primary-table table-spacing usm_table" role="grid" >
                    <tbody>
                        <tr>
                            <td class="td-bg" width="50%" style="    border-top: 1px solid #e5ebec;">Sale Price:</td>
                            <td style="text-align: right; border-left: 0 !important;    border-top: 1px solid #e5ebec;">{{number_format($property->inventory->total_price - $property->inventory->extra_amount)}}</td>
                        </tr>
                        <tr>
                            <td class="td-bg">Discount:</td>
                            <td style="text-align: right; border-left: 0 !important;">{{number_format($property->discount )}}</td>
                        </tr>
                        <tr>
                            <td class="td-bg">Final Unit Price:</td>
                            <td style="text-align: right; border-left: 0 !important;">{{number_format($property->net_pay)}}</td>
                        </tr>
                            <tr>
                            <td class="td-bg">Received Amount:</td>
                            <td style="text-align: right; border-left: 0 !important;">{{number_format($amount)}}</td>
                            <td style="    border-top: 1px solid #e5ebec;">({{ number_format($receivedAmtPer , 2) }} % )</td>
                        </tr>
                            <tr>
                            <td class="td-bg">Outstanding Amount:</td>
                            <td style="text-align: right; border-left: 0 !important;">{{number_format($property->net_pay - $amount)}}</td>
                            <td style="border-top: 1px solid #e5ebec;">({{ number_format($outstandingAmtPer , 2) }} % )</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-sm-1 col-xs-1"></div>
            <div class="col-sm-5 col-xs-5">
                <table style="width: 100%; margin-top: 0; margin-bottom: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table table-spacing usm_table" role="grid" >
                    <tbody>
                        <tr>
                            <td class="td-bg" width="50%">Price / Sft.:</td>
                            <td style="text-align: right; border-left: 0 !important;"><center>{{number_format(($property->inventory->total_price - $property->inventory->extra_amount ) /$property->inventory->size->name)}}</center></td>
                        </tr>
                        
                        
                            @php
                        
                        $inst_counter=0;
                        @endphp
                        @foreach($property->statement as $st)
                        
                        @if($st->payment_head == \App\CustomerStatement::installment)
                        
                        @php
                        $inst_counter++;
                        @endphp    
                        
                        @endif
                                
                                
                                
                                
                        @endforeach
                        
                        <tr>
                            <td class="td-bg">No. of Installments:</td>
                            <td style="text-align: right; border-left: 0 !important;"><center>Down  + {{$inst_counter}} Inst.</center></td>
                        </tr>
                        <tr>
                    </tbody>
                </table>
                
                
                
                <table style="width: 100%;  margin-bottom: 0;" id="us_Table" class="table table-bordered dataTable color-table primary-table table-spacing usm_table" role="grid" >
                    <tbody>                        
                        <tr>
                            <td class="td-bg">Overdue Amount: </td>
                            <td style="border-left: 0 !important;text-align: right;padding-left: 5.6rem;"><center>{{number_format($overDue)}}</center></td>
                        </tr>                       
                    </tbody>
                </table>               
            </div>
        </div>


            <div class="table-responsive" style="clear: both;">
                <table class="table table-bordered usm_table">
                    <thead class="td-bg" style="color:black;">
                        <tr style="text-align: center">
                            <th style=" font-size: 13px;">Payment Head</th>
                            <th style=" font-size: 13px; width: 9.3%;">Due Date</th>
                            <th style=" font-size: 13px;">Due Amt.</th>
                            <th style=" font-size: 13px;">Received Amt.</th>
                            <th class="no-print" style=" font-size: 13px;">Balance</th>
                            <th style=" font-size: 13px;">Payment Mode</th>
                            <!-- <th class="no-print">Detail</th> -->
                            <th style=" font-size: 13px;">Receipt #</th>
                            <!-- <th>Ref#</th> -->
                            <th style=" font-size: 13px;">Receipt Date</th>

                            <th style=" font-size: 13px;">Surcharge Amt</th>
                            <th style=" font-size: 13px;">Balance Amt.</th>
                            <!-- <th>Net Amt</th> -->
                        </tr>
                    </thead>
                    <tbody>
                        <?php $due = 0;
                            $received = 0;
                            $balance = 0;
                            $surcharge = 0;
                            $net_payable = 0;
                            $count = 1;
                            $total = $property->net_pay - $property->development_fee;
                           
                             $otherArray = [];
                            ?>

                        @foreach($periorities as $periority)

                            @foreach($property->statement->where('payment_head','!=',\App\CustomerStatement::development) as $statement)

                            @if($statement->due > 0 && ($statement->payment_head == $periority->payment_head ) || ($statement->payment_head == \App\CustomerStatement::other && !in_array($statement->payment_head , $otherArray)))

                                    @php

                                        if($statement->payment_head == \App\CustomerStatement::other)
                                        {
                                        $otherArray[] = $statement->payment_head;
                                        }

                                    @endphp

                                     @if($statement->balance > 0 && $statement->due_date < Carbon\Carbon::today())
                                        <tr style="background-color: #e8e3c1;">
                                        @else
                                        <tr>
                                    @endif


                                     @if($statement->balance > 0 && $statement->due_date < Carbon\Carbon::today())
                                <tr style="background-color: #e8e3c1;">
                            @else
                                <tr>
                            @endif

                            
                            @if($statement->payment_head == \App\CustomerStatement::down_payment)
                            <td class="printFV">
                                
                                @if( $property->booking_type == \App\CustomerProperty::full_payment)
                                 {{'Full Payment'}}
                                 @else
                                 {{'Down Payment'}}
                                @endif
                            </td>
                            @elseif($statement->payment_head == \App\CustomerStatement::possession)
                            <td class="printFV">Possession Fee</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::installment)
                            <td class="printFV">
                                @if (!str_contains($statement->inst_no , '-b')) 
                                    Installment - {{str_replace('-a' , '' ,  $statement->inst_no)}}
                                    @else
                                   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Installment
                                @endif
                            </td>
                            @elseif($statement->payment_head == \App\CustomerStatement::other)
                            <td class="printFV">Other</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::allotment)
                            <td class="printFV">Allotment</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::confirmation)
                            <td class="printFV">Confirmation</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::booking)
                            <td class="printFV">Booking</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::development)
                            <td class="printFV">Development</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::file_processing)
                            <td class="printFV">File Processing</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::registration)
                            <td class="printFV">Registration</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::ballon)
                            <td class="printFV">Ballon Payment</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::balloting)
                            <td class="printFV">Balloting </td>
                            @else
                            <td class="printFV"></td>
                            @endif

                                    <!-- <td class="printFV">{{ $statement->inst_no }}</td> -->
                                    <td class="printFV">
                                        {{ date('d-m-Y', strtotime($statement->due_date)) }}

                                        <!-- @if($statement->payment_head == \App\CustomerStatement::possession) 
                                    <a href="JavaScript:void(0)" onclick="return changePossessionDate('{{ $statement->id }}' , '{{ date('Y-m-d', strtotime($statement->due_date)) }}');"><i class="fa fa-pencil" aria-hidden="true"></i></a>
@endif-->
                                     </td>
                                <td class="printFV text-right">{{ number_format($statement->due) }}</td><?php $due += $statement->due; ?>
                                <td class="printFV text-right">
                                @if($statement->is_deleted == false){{ number_format($statement->received) }}<?php $received += $statement->received; ?>
                                @else
                                                                0
                                @endif
                            </td>
                             <td class="printFV no-print text-right">
                            @if($statement->is_deleted == false)
                                {{ number_format($statement->balance) }}
                            @else
                                {{ number_format($statement->due) }}
                            @endif
                            </td>

                            @if($statement->is_deleted == false)

                            @if($statement->receipt)

                            @if($statement->receipt->payment_method == \App\Receipt::cash)
                                                            <td>Cash</td>
                            @elseif($statement->receipt->payment_method == \App\Receipt::bank)
                                                            <td>Bank</td>
                            @elseif($statement->receipt->payment_method == \App\Receipt::adjustment)
                                                            <td>Adjustment</td>
                            @elseif($statement->receipt->payment_method == \App\Receipt::cheque)
                                                            <td>Cheque</td>
                            @elseif($statement->receipt->payment_method == \App\Receipt::merging)
                                                            <td>Merging</td>
                            @else
                                                            <td></td>
                            @endif
                                                                
                            @else
                                                            <td></td>
                            @endif
                            @else
                                                            <td></td>
                            @endif


                            
                                <td class="printFV">@if($statement->is_deleted == false) {{ $statement->rcpt_no }} @endif</td>
                                <!-- <td class="printFV"> {{ $statement->ref_no }} </td> -->
                                    <td class="printFV text-right">@if($statement->is_deleted == false)
                                        {{ $statement->rcpt_date ? date('d-m-Y', strtotime($statement->rcpt_date)) : '' }}
                                        @endif</td>


                                    <td class="printFV text-right">{{ number_format($statement->surcharge) }}
                                        <?php $surcharge += $statement->surcharge; 
                                ?></td>

                                    @if($statement->is_deleted == false)
                                        @if($statement->received)
                                            <?php $total -=$statement->received;?>
                                            <td class="printFV text-right"> {{ number_format($total) }}</td>
                                        @else
                                            <td class="printFV"></td>
                                        @endif
                                    @else
                                        <td class="printFV"></td>
                                    @endif
                                    <!-- <?php $balance += $statement->balance; ?>-->





                                    </tr>
                                @endif
                            @endforeach

                        @endforeach
                        <tr>
                            <td colspan="2" class="printFV text-center"><b>Total</b></td>
                            <td class="printFV text-right"><b>{{ number_format($received) }}</b></td>
                            <!-- <td colspan="3"></td> -->
                            <td colspan="5" class="printFV text-right"> Total WaveOff ({{ $waiveOff }})
                                <b>{{ number_format($surcharge - $waiveOff) }}</b></td>
                            <td class="printFV text-right"><b>{{ number_format($total) }}</b></td>


                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <br>

    </div>
    @if($projectType->id == \App\ProjectType::society)
        {{-- Development Charges --}}

        <div class="col-lg-12">
            <div class="white-box1">
                <div class="table-responsive" style="clear: both;">
                    <table class="table table-bordered usm_table">
                        <thead class="td-bg" style="color:black;">
                            <tr style="text-align: center">
                                <th style=" font-size: 13px;">Payment Head</th>
                                <th style=" font-size: 13px;">Due Date</th>
                                <th style=" font-size: 13px;">Due Amt.</th>
                                <th style=" font-size: 13px;">Received Amt.</th>
                                <th class="no-print" style=" font-size: 13px;">Balance</th>
                                <th style=" font-size: 13px;">Payment Mode</th>
                                <!-- <th class="no-print">Detail</th> -->
                                <th style=" font-size: 13px;">Receipt #</th>
                                <!-- <th>Ref#</th> -->
                                <th style=" font-size: 13px;">Receipt Date</th>

                                <th style=" font-size: 13px;">Surcharge Amt</th>
                                <th style=" font-size: 13px;">Balance Amt.</th>
                                <!-- <th>Net Amt</th> -->
                            </tr>
                        </thead>
                        <tbody>
                            <?php $development_due = 0;
                            $development_received = 0;
                            $development_balance = 0;
                            $development_surcharge = 0;
                            $development_net_payable = 0;
                            $count = 1;
                            $development_total = $property->development_fee;
                           
                             $otherArray = [];
                            ?>

                            @foreach($periorities as $periority)

                            @foreach($property->statement->where('payment_head',\App\CustomerStatement::development) as $statement)

                            @if($statement->due > 0 && ($statement->payment_head == $periority->payment_head ) || ($statement->payment_head == \App\CustomerStatement::other && !in_array($statement->payment_head , $otherArray)))

                                @php
                            
                            if($statement->payment_head == \App\CustomerStatement::other)
                            {
                              $otherArray[] = $statement->payment_head;
                            }
                          
                            @endphp
                            
                            @if($statement->balance > 0 && $statement->due_date < Carbon\Carbon::today())
                                <tr style="background-color: #e8e3c1;">
                            @else
                                <tr>
                            @endif

                            
                            
                           
                             @if($statement->payment_head == \App\CustomerStatement::development)
                            <td class="printFV">Development</td>

                                        @else
                                            <td class="printFV"></td>
                                        @endif

                                        <!-- <td class="printFV">{{ $statement->inst_no }}</td> -->
                                        <td class="printFV">
                                            {{ date('d-m-Y', strtotime($statement->due_date)) }}

                                            <!-- @if($statement->payment_head == \App\CustomerStatement::possession) 
                                    <a href="JavaScript:void(0)" onclick="return changePossessionDate('{{ $statement->id }}' , '{{ date('Y-m-d', strtotime($statement->due_date)) }}');"><i class="fa fa-pencil" aria-hidden="true"></i></a>
@endif-->
                                     </td>
                                <td class="printFV text-right">{{ number_format($statement->due) }}</td><?php $development_due += $statement->due; ?>
                                <td class="printFV text-right">
@if($statement->is_deleted == false){{ number_format($statement->received) }}<?php $development_received += $statement->received; ?>
@else
                                0
@endif
                            </td>
                             <td class="printFV no-print text-right">
@if($statement->is_deleted == false){{ number_format($statement->balance) }}
@else
                                    {{ number_format($statement->due) }}
@endif
                            </td>

@if($statement->is_deleted == false)

@if($statement->receipt)

@if($statement->receipt->payment_method == \App\Receipt::cash)
                                <td>Cash</td>
@elseif($statement->receipt->payment_method == \App\Receipt::bank)
                                <td>Bank</td>
@elseif($statement->receipt->payment_method == \App\Receipt::adjustment)
                                <td>Adjustment</td>
@elseif($statement->receipt->payment_method == \App\Receipt::cheque)
                                <td>Cheque</td>
@elseif($statement->receipt->payment_method == \App\Receipt::merging)
                                <td>Merging</td>
@else
                                <td></td>
@endif
                                    
@else
                                <td></td>
@endif
@else
                                <td></td>
@endif


                            
                                <td class="printFV">@if($statement->is_deleted == false) {{ $statement->rcpt_no }} @endif</td>
                                <!-- <td class="printFV"> {{ $statement->ref_no }} </td> -->
                                        <td class="printFV text-right">@if($statement->is_deleted == false)
                                            {{ $statement->rcpt_date ? date('d-m-Y', strtotime($statement->rcpt_date)) : '' }}
                                            @endif</td>


                                        <td class="printFV text-right">{{ number_format($statement->surcharge) }}
                                            <?php $surcharge += $statement->surcharge; 
                                ?></td>

                                        @if($statement->is_deleted == false)
                                            @if($statement->received)
                                                <?php $development_total -=$statement->received;?>
                                                <td class="printFV text-right"> {{ number_format($development_total) }}
                                                </td>
                                            @else
                                                <td class="printFV"></td>
                                            @endif
                                        @else
                                            <td class="printFV"></td>
                                        @endif
                                        <!-- <?php $development_balance += $statement->balance; ?>-->





                                        </tr>
                                    @endif
                                @endforeach

                            @endforeach
                            <tr>
                                <td colspan="2" class="printFV text-center"><b>Total</b></td>
                                <td class="printFV text-right"><b>{{ number_format($development_due) }}</b></td>
                                <td class="printFV text-right"><b>{{ number_format($development_received) }}</b></td>
                                <!-- <td colspan="3"></td> -->
                                <td colspan="5" class="printFV text-right"> Total WaveOff ({{ $waiveOff }})
                                    <b>{{ number_format($development_surcharge - $waiveOff) }}</b></td>
                                <td class="printFV text-right"><b>{{ number_format($development_total) }}</b></td>


                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <br>

        </div>
    @endif
    {{-- End Development Charges --}}

    @if($property->booking_type == \App\CustomerProperty::full_payment )

        @if($property->fullPayment)
            <div class="col-lg-12">
                <div class="white-box1">
                    <h4 class="box-title">Discount Payment Terms</h4>
                    <hr>
                    <div class="table-responsive pull-left">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Total Amount :</td>
                                    <td> {{ number_format($property->fullPayment->total_amount) }} </td>
                                </tr>
                                <tr>
                                    <td>
                                        Discount Percentage :</td>
                                    <td> {{ $property->fullPayment->discount_percentage }} %</td>
                                </tr>
                                <tr>
                                    <td>Discount Amount</td>
                                    <td> {{ number_format($property->fullPayment->discount_amount) }} </td>
                                </tr>
                                <tr>
                                    <td>Net Amount</td>
                                    <td> {{ number_format($property->fullPayment->discount_amount - $property->fullPayment->deduction_amount) }}
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    <div class="table-responsive pull-right">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Total Tenure : </td>
                                    <td>{{ $property->fullPayment->total_tenure }} months</td>
                                </tr>
                                <tr>
                                    <td>Return Tenure :</td>
                                        @if($property->fullPayment->return_tenure == \App\CustomerProperty::monthly)
                                        <td> Monthly </td>
                                        @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::quarterly)
                                        <td> Quarterly </td>
                                        @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::semi_annually)
                                        <td> Semi Annually </td>
                                        @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::annually)
                                        <td> Annually </td>
                                        @else
                                        <td></td>
                                        @endif
                                    </tr>
                                    <tr>
                                    <td>Deduction Amount : </td>
                                    <td> {{ number_format($property->fullPayment->deduction_amount) }} </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clear"></div>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="white-box">
                    <div class="table-responsive" style="clear: both;">
                        <table class="table table-bordered printFW1">
                            <thead class="printFH11">
                                <tr>
                                    <th style="color: #fff;font-size: 13px;">inst #</th>
                                    <th style="color: #fff;font-size: 13px;">Due Date</th>
                                    <th style="color: #fff;font-size: 13px;">Due Amount</th>

                                    <th style="color: #fff;font-size: 13px;">Paid Amount</th>
                                    <th style="color: #fff;font-size: 13px;">Receipt #</th>
                                    <th style="color: #fff;font-size: 13px;">Receipt Date</th>
                                    <th style="color: #fff;font-size: 13px;">Balance Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $due = 0;
                            $received = 0;
                            $balance = 0;
                            $count = 1; ?>
                                @foreach($property->fullPaymentStatement as $statement)
                                    <tr>
                                        <td class="printFV">{{ $count++ }}</td>
                                        <td class="printFV">
                                            {{ date('d-m-Y', strtotime($statement->due_date)) }}
                                        </td>
                                        <td class="printFV text-right">{{ number_format($statement->due) }}</td>
                                        <?php $due += $statement->due; ?>
                                        <td class="printFV text-right">{{ number_format($statement->received) }}</td>
                                        <?php $received += $statement->received; ?>
                                        <td class="printFV"> {{ $statement->receipt_no }} </td>
                                        <td class="printFV">
                                            {{ $statement->receipt_date ? date('d-m-Y', strtotime($statement->receipt_date)) : '' }}
                                        </td>
                                        <td class="printFV text-right">
                                            {{ number_format($statement->due - $statement->received) }}</td>
                                        <?php $balance += ($statement->due - $statement->received); ?>
                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="2"><b>Total</b></td>
                                    <td class="text-right"><b>{{ number_format($due) }}</b></td>
                                    <td class="text-right"><b>{{ number_format($received) }}</b></td>
                                    <td></td>
                                    <td></td>
                                    <td class="text-right"><b>{{ number_format($balance) }}</b></td>
                                </tr>

                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        @endif

    @endif



    @if($property->propertyTax)

        <div class="col-lg-10 no-print">
            <div class="white-box">
                <h4 class="box-title">Property Tax Record</h4>
                <div class="table-responsive" style="clear: both;">
                    <table class="table table-bordered printFW1">
                        <thead class="printFH11">
                            <tr>
                                <th style="color: #fff;font-size: 13px;">Sr #</th>
                                <th style="color: #fff;font-size: 13px;">inst #</th>
                                <th style="color: #fff;font-size: 13px;">Tax</th>

                                <th style="color: #fff;font-size: 13px;">Pay By</th>
                                <th style="color: #fff;font-size: 13px;">Payment Received</th>

                                <th style="color: #fff;font-size: 13px;">Status</th>
                                <th style="color: #fff;font-size: 16px;">CPR</th>
                                <th style="color: #fff;font-size: 13px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $sr =1;$sum =0;?>
                            @foreach($property->PropertyTax as $tax)

                                <tr>
                                        <td class="printFV">{{$sr++}}</td>
                                        @if($tax->statement->payment_head == \App\CustomerStatement::down_payment)
                                        <td class="printFV">Down Payment</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::possession)
                                        <td class="printFV">Possession Fee</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::installment)
                                        <td class="printFV">Installment - {{$tax->statement->inst_no}}</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::other)
                                        <td class="printFV">Other</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::allotment)
                                        <td class="printFV">Allotment</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::confirmation)
                                        <td class="printFV">Confirmation</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::booking)
                                        <td class="printFV">Booking</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::development)
                                        <td class="printFV">Development</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::file_processing)
                                        <td class="printFV">File Processing</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::registration)
                                        <td class="printFV">Registration</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::ballon)
                                        <td class="printFV">Ballon Payment</td>
                                        @elseif($tax->statement->payment_head == \App\CustomerStatement::balloting)
                                        <td class="printFV">Balloting </td>
                                        @else
                                        <td class="printFV"></td>
                                        @endif
                                        <td class="printFV text-right">
                                            {{ number_format($tax->tax) }}
                                        </td>
                                        <?php $sum += $tax->tax; ?>

                                        <td class="printFV text-right">@if($tax->tax_pay_by == \App\Receipt::customer)
                                            Customer
                                        @else
                                            Company
                                        @endif
                                        </td>

                            <td class="printFV text-right">
                                {{ $tax->tax_payment_received == \App\CustomerPropertyTax::paid ? 'YES' : 'NO' }}
                            </td>

                            <td class="printFV text-right">
                                {{ $tax->status == \App\CustomerPropertyTax::paid ? 'Paid' : 'UnPaid' }}
                                @if($tax->status)
                                    <br>
                                    <b>Reference # </b>
                                    {{ $tax->reference }}
                                @endif
                            </td>

                            <td>
                                @if($tax->cpr)
                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px"
                                        href="{{ asset('uploads/'.$tax->cpr) }}" download=""> <i
                                            class="fa fa-download" style="text-transform: none;">&nbsp;</i>Download</a>
                                @endif
                            </td>

                            <td>
                                <button
                                    {{ $tax->status ? 'disabled' : '' }}
                                    class="btn btn-info" onclick="openTaxModal({{ $tax->id }})">
                                    Add CPR
                                </button>

                                @if($tax->tax_pay_by == \App\Receipt::customer)
                                    <button
                                        {{ ($tax->tax_payment_received == \App\CustomerPropertyTax::paid) ? 'disabled' : '' }}
                                        data-instal-no='{{ $tax->statement->inst_no }}' class="btn btn-info"
                                        onclick="openTaxReceiptModal(this, {{ $tax->id }} , {{ $tax->tax }} , {{ $tax->statement->rcpt_no }} , {{ $tax->statement->payment_head }} )">
                                        Make tax receipt
                                    </button>
                                @endif
                            </td>

                            </tr>
    @endforeach
    <tr>
        <td colspan="2"><b>Total</b></td>
        <td class="text-right"><b>{{ number_format($sum) }}</b></td>

    </tr>

    </tbody>
    </table>

    </div>
    </div>
    </div>
@endif

<div class="modal fade" id="taxReceiptModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">

    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header" style="text-align: center;">
                <h5 class="modal-title" id="exampleModalLabel">Tax Receipt</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body" style="height: 250px;">

                <div class="alert alert-danger" role="alert" style="display:none;" id="fields_error">
                    All fields with * is required.
                </div>

                <form method="post" action="{{ route('customer.tax.amount.paid') }}"
                    onsubmit="return checkValue()">
                    {{ csrf_field() }}
                    <input type="hidden" name="tax_receipt_id" id="tax_receipt_id">
                    <input type="hidden" name="inst_no" id="inst_no">
                    <input type="hidden" name="payment_head" id="payment_head">


                    <div class="col-xs-6">
                        <label>Receipt No</label>
                        <input type="text" name="receipt_no" id="receipt_no" readonly class="form-control">
                    </div>


                    <div class="col-xs-6">
                        <label>Tax Amount</label>
                        <input type="text" name="tax_amount" id="tax_amount" class="form-control">
                    </div>


                    <div class="col-xs-6" style="margin-top: 2rem;">
                        <label>Date</label>
                        <input type="date" name="tax_receipt_date" value="{{ date('Y-m-d') }}"
                            id="tax_receipt_date" class="form-control">
                    </div>


                    <div class="col-xs-6" style="margin-top: 2rem;">
                        <label>Payment Mode</label>
                        <select class="form-control chosen-select" id="payment_method" name='payment_method'
                            onchange="changeFunc(this.value)">
                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                            <!--   <option value="{{ \App\Receipt::adjustment }}">Adjustment</option> -->
                        </select>
                    </div>



                    <div class="col-md-6" id='bank' style="display: none;margin-top: 2rem;">

                        <label class="control-label ">
                            Depositor Bank Name
                            <span style="color:red;">*</span>
                        </label>

                        <select name="bank_name" class="form-control chosen-select" id="bank_name">
                            <option value="" selected="">None</option>

                            @foreach($banks as $bank)

                                @if(old('bank_name') == $bank->id)
                                    <option selected="" value="{{ $bank->id }}">{{ $bank->name }}</option>
                                @else
                                    <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                @endif

                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6" id='company-bank' style="display: none;margin-top: 2rem;">

                        <label class="control-label">Company Account <span style="color:red;">*</span></label>

                        <select name="company_account" class="form-control chosen-select" id="company_account">
                            <option value="" selected="">None</option>

                            @foreach($cBanks as $bank)

                                @if(old('company_account') == $bank->id)
                                    <option selected="" value="{{ $bank->id }}">{{ $bank->name }} -
                                        {{ $bank->account_number }}</option>
                                @else
                                    <option value="{{ $bank->id }}">{{ $bank->name }} -
                                        {{ $bank->account_number }}</option>
                                @endif
                            @endforeach

                        </select>
                    </div>


                    <div class="col-md-6" id="cheque-dd-po-drawn-date" style="display: none;margin-top: 2rem;">
                        <label class="control-label">
                            Drawn Date
                            <span style="color:red;">*</span>
                        </label>

                        <input type="date" class="form-control" id="drawnDate" name='drawn_date'>
                    </div>

                    <div class="col-md-6" id="cheque-dd-po-instrument-no" style="display: none;margin-top: 2rem;">
                        <label class="control-label ">
                            Instrument No
                            <span style="color:red;">*</span>
                        </label>

                        <input type="text" name='cheque_number' id="checkNumber" class="form-control">
                    </div>


                    <div class="col-md-12" id="note" style="margin-top: 2rem;">
                        <label class="control-label ">
                            Note
                        </label>

                        <textarea placeholder="type here...." rows="4" name="description"
                            class="form-control"></textarea>
                    </div>



            </div>

            <div class="modal-footer" style="border-top: none;">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"
                    style="margin-top: 3rem;">Close</button>
                <button type="submit" class="btn btn-primary" style="margin-top: 3rem;">Save</button>
                </form>
            </div>

        </div>
    </div>

</div>




<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">

    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="text-align: center;">
                <h5 class="modal-title" id="exampleModalLabel">Tax CPR</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="{{ route('customer.tax.paid') }}"
                enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="modal-body" style="height: 250px;">

                    <input type="hidden" name="statement_id" value="{{ $statement->id }}">
                    <input type="hidden" name="tax_id" id="tax_id">

                    <div class="form-group form-group-sm">
                        <div class="col-xs-4">
                            <label>Reference</label>
                        </div>
                        <div class="col-xs-8">
                            <input type="text" name="reference" placeholder="Enter Reference" class="form-control">
                        </div>
                    </div>
                    <div class="form-group form-group-sm">
                        <div class="col-xs-4">
                            <label>File</label>
                        </div>
                        <div class="col-xs-8">
                            <input type="file" name="file" class="form-control">
                        </div>
                    </div>
                    <br>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Upload</button>
                </div>
            </form>
        </div>
    </div>

</div>




</div>
<div style="display: inline-block;    margin-bottom: 70px;">


    <!-- @permission('edit-membership')
    <div class="text-left no-print" style="display: inline-block;"><a target="_blank" href="{{ route('membership.edit',['id'=>$property->id]) }}">
        <button  class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-edit"></i> Edit</span> </button></a>
    </div>
@endpermission-->

     <div class="text-right" style="display: inline-block;">
       <button  class="btn btn-default btn-outline no-print" onclick="return print_whole_statement()" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
    </div>
    
     <div class="text-right" style="display: inline-block;">
       <button  class="btn btn-default btn-outline no-print" onclick="return  print_summery()" type="button"> <span><i class="fa fa-print"></i> Print Summary</span> </button>
    </div>
    
</div>
</div>
<!-- /.container-fluid -->

    <!-- Modal -->
    <div class="modal fade" id="possession_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="myModalLabel">Update Possession Date</h4>
                </div>
                <form method="post" onsubmit="return UpdatePossessionDate(this)">
                    <div class="modal-body">
                        <span style="color:red;display: none; padding-bottom: 1rem;" id="error_message">Date Not be
                            Empty.</span>
                        <span style="color:green;display: none; padding-bottom: 1rem;" id="success_message">Update
                            Successfully!</span>
                        <input type="hidden" id="payment_head_id">
                        <input type="date" min="{{ date('Y-m-d') }}" id="new_possession_date"
                            class="form-control" name="">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" id="possession_modal_btn" class="btn btn-primary">Save changes</button>
                </form>
            </div>
        </div>
    </div>
</div>


@stop

    @section('js')
    <script src="{{ asset('js/jspdf.min.js') }}" type="text/JavaScript"></script>
    <script src="{{ asset('js/jquery.PrintArea.js') }}" type="text/JavaScript"></script>


    <script>
        window.setInterval(function () {
            $('#text_detail').html('Member Information')
            $('#main_unit_details').show();
            $('#summary_customer_info').hide();
            $('#main_customer_info').show();
        }, 1000);

        function print_summery() {
            $('#text_detail').html("Unit's Details")
            $('#payment_div').addClass("no-print");
            $('#summary_customer_info').show();
            $('#main_customer_info').hide();
            $('#main_unit_details').hide();
            $('.block_id').hide();
            $('.Category').hide();
            $('.net_amount').hide();
            $('.area').hide();
            $('.discount').hide();
            $('.category_cost').hide();
            window.print();
            return false;
        }

        function print_whole_statement() {
            $('#text_detail').html('Member Information')
            $('#payment_div').addClass("no-print");
            $('#summary_customer_info').hide();
            $('#main_customer_info').show();
            $('#main_unit_details').show();
            window.print();
            return false;
        }


        function checkValue(self) {
            if ($('#payment_method').val() != '{{ \App\Receipt::cash }}' && ($('#bank_name').val() == '' || $(
                    '#company_account').val() == '' || $('#drawnDate').val() == '' || $('#checkNumber').val() == '')) {
                $('#fields_error').show('slow')
                return false;
            } else {
                return true;
            }
        }

          function changeFunc(a){
    if(a == {{\App\Receipt::cash}})
    {
      $('#bank').css('display', 'none');
      $('#company-bank').css('display', 'none');
      $('#cheque').css('display', 'none');
      $('#adjustment').css('display', 'none');
      $('#cheque-dd-po-drawn-date').css('display', 'none');
      $('#cheque-dd-po-instrument-no').css('display', 'none');
      $('#drawnDate').val('')
      $('#checkNumber').val('')
    }
    else if(a == {{\App\Receipt::bank}})
    {
      $('#bank').css('display', 'block');
        $('#company-bank').css('display', 'block');
        $('#cheque').css('display', 'none');
        $('#adjustment').css('display', 'none');
        $('#cheque-dd-po-drawn-date').css('display', 'block');
        $('#cheque-dd-po-instrument-no').css('display', 'block');
    }
    else if(a == {{\App\Receipt::cheque}})
    {
        $('#bank').css('display', 'block');
        $('#company-bank').css('display', 'block');
        $('#cheque').css('display', 'none');
        $('#adjustment').css('display', 'none');
        $('#cheque-dd-po-drawn-date').css('display', 'block');
        $('#cheque-dd-po-instrument-no').css('display', 'block');
      
    }
   
  }



        function showDealerDiv() {
            $("#data_div").toggle('slow');
        }

        function openTaxReceiptModal(self, tax_id, tax_amount, receipt_no, payment_head) {

            $('#tax_receipt_id').val(tax_id);

            $('#tax_amount').val(tax_amount);

            $('#receipt_no').val(receipt_no);

            $('#payment_head').val(payment_head);

            $('#inst_no').val($(self).data("instal-no"));

            $('#taxReceiptModal').modal();
        }

        function openTaxModal(tax_id) {

            $('#tax_id').val(tax_id);

            $('#exampleModal').modal();

        }

        function UpdatePossessionDate(self) {

            $('#possession_modal_btn').html('Processing...');
            $('#possession_modal_btn').prop('disabled', true);

            var payment_head_id = $('#payment_head_id').val();
            var possession_date = $('#new_possession_date').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('payment.head.update') }}",
                method: 'POST',
                data: {
                    payment_head_id: payment_head_id,
                    possession_date: possession_date
                },
                success: function (data) {
                    if (data == '1') {
                        $('#success_message').show();
                        location.reload(true)
                    } else if (data == 'empty') {
                        $('#possession_modal_btn').html('Save changes');
                        $('#possession_modal_btn').prop('disabled', false);
                        $('#error_message').show();
                    } else {
                        alert('Something Went wrong!')
                        location.reload(true)
                    }
                }
            })


            return false;
        }

        function changePossessionDate(id, date) {
            $('#payment_head_id').val(id)
            $('#new_possession_date').val(date);
            $('#possession_modal').modal('show')
        }
        $(function () {
            $("#print").on("click", function () {
                var mode = 'iframe'; //popup
                var close = mode == "popup";
                var options = {
                    mode: mode,
                    popClose: close
                };
                $("div.printableArea").printArea(options);
            });
        });
    </script>
    <script>
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    </script>
    <script>
        var doc = new jsPDF();
        var specialElementHandlers = {
            '#editor': function (element, renderer) {
                return true;
            }
        };

        //margins.left, // x coord   margins.top, { // y coord
        $('#generatePDF').click(function () {
            doc.fromHTML($('#htmlContent').html(), 15, 15, {
                'width': 700,
                'elementHandlers': specialElementHandlers
            });
            doc.save('sample_file.pdf');
        });
    </script>
    @stop