@extends('layouts.app')


@section('title')
    Detail of Customer Statement
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-membership')
            <li><a href="{{ route('statement.all') }}">Statements</a></li>
        @endpermission
        <li class="active">Statement Detail</li>
    </ol>
@stop

@section('css')
    <style type="text/css">
    .input_field{
        
 
  font-size: inherit;
  font-family: inherit;
  text-align: inherit;
  outline: none;

    }
        .swal-wide {
            /* width:850px !important;
            height: 850px !important; */
            font-size: 1.6rem !important;
            max-width:
        }

        .bg-color {
            background-color: #1c3752;
        }

        .anchor-link {
            display: none;
        }

        body {
            font-weight: bold;
        }
    </style>
    <style type="text/css" media="print">
        @media print {
            .page-wrapper {
                font-size: 12px !important;
                font-family: "time-new-roman", Arial, sans-serif !important;
                color: black !important;

            }

            .hide-icon {
                display: none;
            }
            .remainig_amount_val{
                display: none;
            }
            
            .action_portion
            {
                display: none;
            }
            h3 {
                line-height: 1px;
            }

            h3 strong {
                text-transform: uppercase;
                color: black !important
            }

            h4 strong {
                text-transform: uppercase;
                color: black !important
            }

            body {
                font-weight: bold;
            }

            .printFH11 {
                font-size: 13px;
                font-weight: 800;
                background-color: #000000;
            }

            .white-box .box-title {
                margin: 0px 0px 4px 0px;
                font-weight: 700;
                font-size: 14px;
                color: #1c3752;
                background-color: #000000 !important;
            }

            .white-box {
                padding: 0px 0px 2px 0px;
                margin-bottom: 0px;
                margin-bottom: 0;
                border-radius: inherit;
            }

            .table {
                width: 100% !important;
                margin-bottom: 5px;
                margin-top: -2px;
            }

            .table>tbody>tr>td,
            .table>tbody>tr>th,
            .table>tfoot>tr>td,
            .table>tfoot>tr>th {
                vertical-align: top;
            }

            .page-wrapper {
                padding-top: 0px;
            }
        }
    </style>

@stop

@section('content')

    @php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphp

    @php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    @endphp

    <div class="container-fluid">
        <div class="row printableArea" id="htmlContent">

            <div class="col-lg-12 text-center">

                <!-- <div class="pull-left hidden-lg">-->



            </div>
            <div class="row">
                <div class="col-sm-6 col-xs-6">
                    @if ($property->inventory)
                        @if ($property->inventory->multiProject)
                            <img id="blah" class='circle'
                                src="{{ asset('images/'.$property->inventory->multiProject->image) }}"
                                style="margin-left: 42px;width:91px;margin-bottom: -49px;" alt="your image" />
                        @endif
                    @endif
                </div>

            </div>
            <div class="clear"></div>
            <div class="text-center">
                <h3><strong>
                        @if ($property->inventory)
                            @if ($property->inventory->multiProject)
                                {{ $property->inventory->multiProject->name }}
                            @endif
                        @endif
                    </strong></h3>
                <h4><strong>Account Statement</strong></h4>
            </div>
            <div class="col-lg-12">
                <div class="white-box1 ">
                    <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px"
                        id="text_detail">&nbsp;&nbsp;Member Information</h4>
                    @php
                        
                        $ownerArray[] = $property->customer->name;
                        
                        if (!empty($property->customer->first_owner)) {
                            $ownerArray[] = $property->customer->first_owner;
                        }
                        
                        if (!empty($property->customer->second_owner)) {
                            $ownerArray[] = $property->customer->second_owner;
                        }
                        
                    @endphp
                    <div class="pull-left" style="width:100%">
                        <div class="table-responsive">
                            <table class="table bottom-table" id="main_customer_info">
                                <tbody class="printFW">

                                    <tr>
                                        <td style="font-weight: 600; width: 150px">Ref No:</td>
                                        <td>{{ $property->membership_no }}</td>
                                        <td style="font-weight: 600; width: 140px">
                                            <?= $property->customer->type == 1 ? 'Incorporation no' : 'CNIC No.' ?></td>
                                        <td style="width:240px">


                                            @if (count($ownerArray) > 1)
                                                {{ str_replace('_', '', $property->customer->cnic) }},
                                                {{ $property->customer->first_owner_cnic }},
                                                {{ $property->customer->second_owner_cnic }}
                                            @else
                                                <?php $c = str_split($property->customer->cnic, 1); ?>
                                                <?php 
                                    for($i =0;$i<count($c) ; $i++) 
                                    {
                                    ?>
                                                @if (($i == 5 || $i == 12) && $property->customer->type == 0)
                                                    -
                                                @endif
                                                <?= $property->customer->type == 1 ? str_replace('_', '', $c[$i]) : $c[$i] ?>
                                                <?php 
                                    }
                                    ?>
                                            @endif




                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">
                                            <?= $property->customer->type == 1 ? 'Company Name:' : 'Member Name:' ?></td>
                                        <td>
                                            @if (count($ownerArray) > 1)
                                                {{ $property->customer->name }}, {{ $property->customer->first_owner }},
                                                {{ $property->customer->second_owner }}
                                            @else
                                                {{ $property->customer->name }}
                                            @endif

                                        </td>

                                        <td
                                            style="font-weight: 600; width: 140px; display: <?= $property->customer->type == 1 ? 'none' : '' ?>">
                                            @if ($property->customer->father_type == 1)
                                                {{ 'S/O:' }}
                                            @elseif($property->customer->father_type == 2)
                                                {{ 'D/O:' }}
                                            @elseif($property->customer->father_type == 3)
                                                {{ 'W/O:' }}
                                            @else
                                                {{ 'Company Name' }}
                                            @endif
                                        </td>
                                        <td
                                            style="width:240px;display: <?= $property->customer->type == 1 ? 'none' : '' ?>">

                                            @if (count($ownerArray) > 1)
                                                {{ $property->customer->father_name }},
                                                {{ $property->customer->first_owner_father }},
                                                {{ $property->customer->second_owner_father }}
                                            @else
                                                {{ $property->customer->father_name }}
                                            @endif

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Contact #:</td>
                                        <td> {{ $property->customer ? $property->customer->mobile_number : '' }} </td>
                                        <td style="font-weight: 600;">Address:</td>
                                        <td> {{ $property->customer->mailing_address }} </td>
                                    </tr>

                                </tbody>
                            </table>



                            <table class="table bottom-table" style="display:none;" id="summary_customer_info">
                                <tbody class="printFW">

                                    <tr>
                                        <td style="font-weight: 600;">
                                            <?= $property->customer->type == 1 ? 'Company Name:' : 'Member Name:' ?></td>
                                        <td> {{ $property->customer->name }} </td>


                                    </tr>

                                    <tr>

                                        <td style="font-weight: 600;">Unit No.:</td>
                                        <td>{{ $property->inventory ? $property->inventory->unit_number : '' }}</td>

                                    </tr>

                                    <tr>
                                        <td class="block_id" style="font-weight: 600;">Block:</td>
                                        @if ($property->inventory->floor)
                                            <td class="block_id">
                                                {{ $property->inventory->floor->unitBlock ? $property->inventory->floor->unitBlock->name : '' }}
                                            </td>
                                        @endif
                                        <td style="font-weight: 600;">Unit Type:</td>
                                        <td>{{ $property->inventory->type->name }}</td>

                                    </tr>

                                    <tr>
                                        <td style="font-weight: 600;" class="Category">Category:</td>
                                        <td class="Category">
                                            @foreach ($property->inventory->categories as $c)
                                                @if ($c->category)
                                                    @if ($loop->last)
                                                        {{ $c->category->name }} ({{ $c->category->percent }} )
                                                    @else
                                                        {{ $c->category->name }} ({{ $c->category->percent }} ),
                                                    @endif
                                                @endif
                                            @endforeach
                                        </td>
                                        <td style="font-weight: 600;" class="area">Area:</td>
                                        <td class="area">{{ $property->inventory->area }}</td>

                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Size:</td>
                                        <td>
                                            {{ $property->inventory->size ? $property->inventory->size->name : '' }}
                                            {{ $size }}
                                        </td>

                                        <td style="font-weight: 600;" class="discount">Discount:</td>
                                        <td class="discount"> {{ number_format($property->discount) }} </td>

                                    </tr>
                                    <tr>

                                        <td style="font-weight: 600;" class="category_cost">Category Cost:</td>
                                        <td class="category_cost"> {{ number_format($property->inventory->extra_amount) }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;" class="net_amount">Net Amt.:</td>
                                        <td class="net_amount"> {{ number_format($property->net_pay) }} </td>

                                        <td style="font-weight: 600;">Booking Date:</td>

                                        <td> {{ date('d-m-Y', strtotime($property->original_boooking_date)) }}</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: 600;">Over Due Amt.</td>
                                        <td> {{ number_format($overDue) }}</td>

                                    </tr>


                                </tbody>
                            </table>


                        </div>
                        <div class="clear"></div>
                    </div>

                </div>
            </div>
            <div class="col-lg-12" id="main_unit_details">
                <div class="white-box1">
                    <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px">
                        &nbsp;&nbsp;Unit's Details</h4>
                    <div class="col-md-4 col-xs-6">
                        <div class="table-responsive">
                            <table class="table bottom-table">

                                <tbody>
                                    <tr>
                                        <td style="font-weight: 600;">Project:</td>
                                        <td>
                                            @if ($property->inventory)
                                                @if ($property->inventory->multiProject)
                                                    {{ $property->inventory->multiProject->name }}
                                                @endif
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">{{ $map }}:</td>
                                        <td>
                                            @if ($property->inventory->floor)
                                                {{ $property->inventory->floor->name }}
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: 600;">Block:</td>
                                        @if ($property->inventory->floor)
                                            <td> {{ $property->inventory->floor->unitBlock ? $property->inventory->floor->unitBlock->name : '' }}
                                            </td>
                                        @endif
                                    </tr>

                                    <tr>
                                        <td style="font-weight: 600;">Category:</td>
                                        <td>
                                            @foreach ($property->inventory->categories as $c)
                                                @if ($c->category)
                                                    @if ($loop->last)
                                                        {{ $c->category->name }} ({{ $c->category->percent }} )
                                                    @else
                                                        {{ $c->category->name }} ({{ $c->category->percent }} ),
                                                    @endif
                                                @endif
                                            @endforeach
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Size:</td>
                                        <td>
                                            {{ $property->inventory->size ? $property->inventory->size->name : '' }}
                                            {{ $size }}
                                        </td>

                                    </tr>

                                    @if ($projectType->id == \App\ProjectType::society)
                                        <tr>
                                            <td style="font-weight: 600;">Cost Of Land:</td>
                                            {{-- <td>PKR {{ number_format($property->inventory->total_price) }}</td> --}}
                                            <td>PKR {{ number_format($property->cost) }}</td>
                                        </tr>
                                        <tr>
                                            <td style="font-weight: 600;">Development Charges:</td>
                                            <td>PKR {{ number_format($developmentcharges) }}</td>
                                        </tr>
                                    @endif

                                    @if ($projectType->id == \App\ProjectType::high_rise)
                                        <tr>
                                            <td style="font-weight: 600;">Total Price:</td>
                                            {{-- <td>PKR {{ number_format($property->inventory->total_price) }} </td> --}}
                                            <td>PKR {{ number_format($property->cost) }} </td>
                                        </tr>
                                    @endif
                                    <tr>

                                        <td style="font-weight: 600;">Net Amt:</td>
                                        <td>PKR {{ number_format($property->net_pay) }} </td>
                                    </tr>

                                    @if ($property->down_payment_note)
                                        <tr class="no-print">
                                            <td style="font-weight: 600;">Notes:</td>
                                            <td>{{ $property->down_payment_note }}</td>
                                        </tr>
                                    @endif
                                    <!--  <tr class="no-print">
                                        <td style="font-weight: 600;">Automatic Sms Alerts</td>
                                        @if ($property->sms_alert == true)
                                                <td>On</td>
                                                @else
                                                <td>Off</td>
                                                      @endif
                                               </tr>
                                              <tr class="no-print">
                                                 <td style="font-weight: 600;">Automatic Email Alerts</td>
                                                  @if ($property->email_alert == true)
                                                   <td>On</td>
                                                  @else
                                                   <td>Off</td>
                                                     @endif
                                    </tr> -->


                                    <tr class="no-print">
                                        @permission('print-membership')
                                            <td><a style="font-size: 10px;" target="_blank"
                                                    href="{{ route('statement.booking', ['id' => $property->id]) }}"
                                                    class="btn btn-primary" data-toggle="tooltip"
                                                    data-original-title="Print - {{ $property->print_count_m }}"><i
                                                        class="fa fa-print "></i> Application Form</a></td>
                                        @endpermission
                                        <!--                              @permission('print-membership')
                                                        -->
                                            <!--                              <td><a  style="font-size: 10px;pointer-events: none;-->
                                           <!--cursor: default;" href="#" class="btn btn-primary" data-toggle="tooltip" data-original-title="Print - {{ $property->print_count_c }}" ><i class="fa fa-print "></i> Allotment Letter </a></td>-->
                                            <!--
                                                  @endpermission-->
                                    </tr>
                                    <tr class="no-print">
                                        @permission('print-membership')
                                            <td><a style="font-size: 10px;" target="_blank"
                                                    href="{{ route('statement.sale-agreement', ['id' => $property->id]) }}"
                                                    class="btn btn-primary"><i class="fa fa-print "></i> Allotment Letter </a>
                                            </td>
                                        @endpermission

                                    </tr>

                                    <tr class="no-print">
                                        @permission('print-membership')
                                            <td><a style="font-size: 10px;" target="_blank"
                                                    href="{{ route('statement.provisional', ['id' => $property->id]) }}"
                                                    class="btn btn-primary"><i class="fa fa-print "></i> Provisional Letter </a>
                                            </td>
                                        @endpermission

                                    </tr>



                                    <!-- <tr>
                                        <td>Discount:</td>
                                        <td> {{ $property->discount }} </td>
                                    </tr> -->

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--
                        <div class="col-md-4">&nbsp;</div> -->
                    <div class="col-md-4 col-xs-6">
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td style="font-weight: 600;">Unit No.:</td>
                                        <td>{{ $property->inventory ? $property->inventory->unit_number : '' }}</td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Unit Type:</td>
                                        <td>{{ $property->inventory->type->name }}</td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Area:</td>
                                        <td>{{ $property->inventory->area }}</td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Discount:</td>
                                        <td> {{ number_format($property->discount) }} </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Category Cost:</td>
                                        <td> {{ number_format($property->inventory->extra_amount) }} </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Booking Type : </td>
                                        @if ($property->booking_type == \App\CustomerProperty::normal)
                                            <td>Installment</td>
                                        @elseif($property->booking_type == \App\CustomerProperty::full_payment)
                                            <td>Full Payment</td>
                                        @endif
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Booking Date:</td>

                                        <td> {{ date('d-m-Y', strtotime($property->original_boooking_date)) }}</td>


                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Schedule Start Date:</td>
                                        <td>
                                            @if ($property->schedule_start_date)
                                                {{ date('d-m-Y', strtotime($property->schedule_start_date)) }}
                                            @endif
                                        </td>
                                    </tr>

                                    <!-- <tr class="no-print">
                                        <td  style="font-weight: 600;">Sale By : </td>
                                        <td>{{ $property->saleBy ? $property->saleBy->name : '' }}</td>
                                    </tr> -->

                                </tbody>
                            </table>
                        </div>
                    </div>


                    <div class="clear"></div>
                </div>
            </div>

            <div class="col-lg-12 no-print">
                <div class="white-box1 ">
                    <h6 class="box-title " style=" color: white; background-color:#1c3752; line-height: 30px">
                        &nbsp;&nbsp;Rebate's Info <span
                            style="float: right;margin-right: 2rem;font-size: 3rem;font-weight: bolder;cursor: pointer;"
                            onclick="showDealerDiv()">+</span></h6>

                    <div class="col-xs-4 col-sm-4" style="display:none;" id="data_div">
                        <div class="table-responsive">
                            <table class="table bottom-table">
                                <tbody class="printFW">

                                    @foreach ($dealers as $d)
                                        <tr>
                                            <td style="font-weight: 600;">Name :</td>
                                            <td> {{ $d->dealer->name }} </td>

                                            <td style="font-weight: 600;">Rebate : </td>
                                            <td> {{ number_format($d->amount) }} </td>


                                        </tr>
                                    @endforeach



                                </tbody>
                            </table>
                        </div>
                        <div class="clear"></div>
                    </div>

                </div>
            </div>




            <div class="col-lg-12" id="payment_div">
                <div class="white-box1 ">
                    <h4 class="box-title " style=" color: white; background-color:#1c3752; line-height: 30px">
                        &nbsp;&nbsp;Payment Detail</h4>

                    <div class="col-md-12 col-xs-12">
                        <div class="table-responsive">
                            <table class="table bottom-table">
                                <tbody class="printFW">

                                    <tr>
                                        <td style="font-weight: 600;">Net Price: </td>
                                        <td>PKR {{ number_format($property->net_pay) }} </td>


                                        <td style="font-weight: 600;">Received Amount: </td>
                                        <td>PKR {{ number_format($amount) }} &nbsp;
                                            &nbsp;({{ number_format($receivedAmtPer, 2) }} % ) </td>


                                        <td style="font-weight: 600;">Outstanding Amt: </td>
                                        <td>PKR {{ number_format($outstandingAmt) }} &nbsp;
                                            &nbsp;({{ number_format($outstandingAmtPer, 2) }} % )</td>

                                    </tr>


                                    <tr>

                                        <td style="font-weight: 600;">Over Due Amt.</td>
                                        <td>PKR {{ number_format($overDue) }} &nbsp; &nbsp;
                                            ({{ number_format($overDuePer, 2) }} % )</td>


                                        <td style="font-weight: 600;">PDC.</td>
                                        <td>PKR {{ number_format($pdc_receipt) }} &nbsp;
                                            &nbsp;({{ number_format($pdcReceiptPer, 2) }} % )</td>

                                        <td style="font-weight: 600;">Paid Surcharge</td>
                                        <td>PKR {{ number_format($paidSurcharge) }} </td>

                                    </tr>


                                </tbody>
                            </table>
                        </div>
                        <div class="clear"></div>
                    </div>

                </div>
            </div>
@php
$count=0;
@endphp
            <div class="col-lg-12">
                <div class="white-box1">
                    <div class="table-responsive" style="clear: both;">
                        <form method="POST" action="{{route('statement.single.update')}}"  enctype="multipart/form-data" onsubmit="return validateForm()">
                               @csrf

                            <table class="table table-bordered">
                            <thead class="bg-color">
                                <tr style="text-align: center">
                                    <th style="color: #fff;font-size: 13px;">Payment Head</th>
                                    <th style="color: #fff;font-size: 13px;">Due Date</th>
                                    <th style="color: #fff;font-size: 13px;">Due Amt.</th>
                                    <th style="color: #fff;font-size: 13px;">Received Amt.</th>
                                    <th class="no-print" style="color: #fff;font-size: 13px;">Balance</th>
                                    <th style="color: #fff;font-size: 13px;">Payment Mode</th>
                                    <!-- <th class="no-print">Detail</th> -->
                                    <th style="color: #fff;font-size: 13px;">Receipt #</th>
                                    <!-- <th>Ref#</th> -->
                                    <th style="color: #fff;font-size: 13px;">Receipt Date</th>

                                    <th style="color: #fff;font-size: 13px;">Surcharge Amt</th>
                                    <th style="color: #fff;font-size: 13px;">Balance Amt.</th>
                                    <th style="color: #fff;font-size: 13px;" class='action_portion'>Action</th>
                                    <!-- <th>Net Amt</th> -->
                                </tr>
                            </thead>
                            <tbody>
                                <?php $due = 0;
                                $received = 0;
                                $balance = 0;
                                $surcharge = 0;
                                $net_payable = 0;
                                $count = 1;
                                $total = $property->net_pay - $property->development_fee;
                                
                                $otherArray = [];
                                ?>
                             
                                @foreach ($periorities as $periority)

                                    @foreach ($property->statement->where('payment_head', '!=', \App\CustomerStatement::development) as $statement)
                                      @php
                                      $count = $count +1;
                                      @endphp
                                      @if (
                                            ($statement->due > 0 && $statement->payment_head == $periority->payment_head) ||
                                                ($statement->payment_head == \App\CustomerStatement::other && !in_array($statement->payment_head, $otherArray)))
                                            @php
                                                
                                                if ($statement->payment_head == \App\CustomerStatement::other) {
                                                    $otherArray[] = $statement->payment_head;
                                                }
                                                
                                            @endphp

                                            @if ($statement->balance > 0 && $statement->due_date < Carbon\Carbon::today())
                                                <tr style="background-color: #e8e3c1;">
                                                @else
                                                <tr>
                                            @endif


                                            @if ($statement->payment_head == \App\CustomerStatement::down_payment)
                                                <td class="printFV">

                                                    @if ($property->booking_type == \App\CustomerProperty::full_payment)
                                                        {{ 'Full Payment' }}
                                                    @else
                                                        {{ 'Down Payment' }}
                                                    @endif
                                                </td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::possession)
                                                <td class="printFV">Possession Fee</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::installment)
                                                <td class="printFV">
                                                    @if (!str_contains($statement->inst_no, '-b'))
                                                        Installment - {{ str_replace('-a', '', $statement->inst_no) }}
                                                    @else
                                                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Installment
                                                    @endif
                                                </td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::other)
                                                <td class="printFV">Other</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::allotment)
                                                <td class="printFV">Allotment</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::confirmation)
                                                <td class="printFV">Confirmation</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::booking)
                                                <td class="printFV">Booking</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::development)
                                                <td class="printFV">Development</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::file_processing)
                                                <td class="printFV">File Processing</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::registration)
                                                <td class="printFV">Registration</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::ballon)
                                                <td class="printFV">Ballon Payment</td>
                                            @elseif($statement->payment_head == \App\CustomerStatement::balloting)
                                                <td class="printFV">Balloting </td>
                                            @else
                                                <td class="printFV"></td>
                                            @endif

                                            
                                            

                                            <!-- <td class="printFV">{{ $statement->inst_no }}</td> -->
                                            <td class="printFV">
                                                {{ date('d-m-Y', strtotime($statement->due_date)) }}
                                                @permission('edit-membership')
                                                    @if ($statement->received == 0)
                                                        <i class="fa fa-pencil-square hide-icon" aria-hidden="true"
                                                            onclick="callSweetAlert('{{ $statement->id }}')"></i>
                                                    @endif
                                                @endpermission

                                            </td>
                                            @permission('edit-membership')
                                            @if ($statement->received == 0)
                                                <input type='hidden' value='{{$statement->due}}' id='due_amount_value_input_{{$count}}'>
                                            @endif
                                        @endpermission
                                            <td class="printFV text-right"
                                            id='due_amount_{{$count}}'>
                                            {{ number_format($statement->due) }}
                                          
                                           
                                        
                                        </td>
                                            <?php $due += $statement->due; ?>
                                            <td class="printFV text-right">
                                                @if ($statement->is_deleted == false)
                                                    {{ number_format($statement->received) }}<?php $received += $statement->received; ?>
                                                @else
                                                    0
                                                @endif
                                            </td>
                                            <td class="printFV no-print text-right">
                                                @if ($statement->is_deleted == false)
                                                    {{ number_format($statement->balance) }}
                                                @else
                                                    {{ number_format($statement->due) }}
                                                @endif
                                            </td>

                                            @if ($statement->is_deleted == false)
                                                @if ($statement->receipt)
                                                    @if ($statement->receipt->payment_method == \App\Receipt::cash)
                                                        <td>Cash</td>
                                                    @elseif($statement->receipt->payment_method == \App\Receipt::bank)
                                                        <td>Bank</td>
                                                    @elseif($statement->receipt->payment_method == \App\Receipt::adjustment)
                                                        <td>Adjustment</td>
                                                    @elseif($statement->receipt->payment_method == \App\Receipt::cheque)
                                                        <td>Cheque</td>
                                                    @elseif($statement->receipt->payment_method == \App\Receipt::merging)
                                                        <td>Merging</td>
                                                    @else
                                                        <td></td>
                                                    @endif
                                                @else
                                                    <td></td>
                                                @endif
                                            @else
                                                <td></td>
                                            @endif



                                            <td class="printFV">
                                                @if ($statement->is_deleted == false)
                                                    {{ $statement->rcpt_no }}
                                                @endif
                                            </td>
                                            <!-- <td class="printFV"> {{ $statement->ref_no }} </td> -->
                                            <td class="printFV text-right">
                                                @if ($statement->is_deleted == false)
                                                    {{ $statement->rcpt_date ? date('d-m-Y', strtotime($statement->rcpt_date)) : '' }}
                                                @endif
                                            </td>


                                            <td class="printFV text-right">{{ number_format($statement->surcharge) }}
                                                <?php $surcharge += $statement->surcharge;
                                                ?></td>

                                            @if ($statement->is_deleted == false)
                                                @if ($statement->received)
                                                    <?php $total -= $statement->received; ?>
                                                    <td class="printFV text-right"> {{ number_format($total) }}</td>
                                                @else
                                                    <td class="printFV"></td>
                                                @endif
                                            @else
                                                <td class="printFV"></td>
                                            @endif
                                            <!-- <?php $balance += $statement->balance; ?>-->

                                            <td class='action_portion'>
                                                @permission('edit-membership')
                                                @if ($statement->received == 0)
                                                    <i id='edit_due_amount{{$count}}' class="fa fa-pencil text-inverse  hide-icon edit_due_amount_icon" aria-hidden="true"
                                                        onclick="callSweetAlertForEdit('{{ $count }}', '{{ $statement->id }}')" data-toggle="tooltip" data-original-title="Edit"></i>
                                              
                                                        <i  id='eraser_to_remove{{$count}}' class="fa fa-eraser text-inverse  hide-icon" aria-hidden="true"
                                                        onclick="removeEditDueInput('{{  $count  }}')" data-toggle="tooltip" data-original-title="Remove" style="display:none
                                                        "></i>
                                              
                                              <i  id='adjust_value_inside_{{$count}}' class="fa fa-adjust text-inverse  hide-icon adjust_value_inside_icon" aria-hidden="true"
                                              onclick="adjustValueIntoInput('{{  $count  }}', '{{ $statement->id }}')" data-toggle="tooltip" data-original-title="Adjust Remaining" style="display:none
                                              "></i>
                                                       
                                                      
                                             
                                                        @endif
                                            @endpermission
                                            @permission('delete-membership')

                                                @if ($statement->received == 0)
                                                    <i class="fa fa-close text-danger hide-icon" aria-hidden="true"
                                                        onclick="callSweetAlertForDelete('{{ $statement->id}}')" data-toggle="tooltip" data-original-title="Delete"></i>
                                                @endif
                                            @endpermission
                                            </td>



                                            </tr>
                                        @endif
                                    @endforeach

                                @endforeach
                                <tr>
                                    <td colspan="2" class="printFV text-center"><b>Total</b></td>
                                    <td class="printFV text-right"><b>{{ number_format($due) }}</b></td>
                                    <td class="printFV text-right"><b>{{ number_format($received) }}</b></td>
                                    <!-- <td colspan="3"></td> -->
                                    <td colspan="5" class="printFV text-right"> Total WaveOff ({{ $waiveOff }})
                                        <b>{{ number_format($surcharge - $waiveOff) }}</b>
                                    </td>
                                    <td class="printFV text-right"><b>{{ number_format($total) }}</b></td>


                                </tr>
                                <tr id='remainig_amount_val' style='display:none;'>
                                    <td colspan="2" class="printFV text-center"><b>Remaining Amount</b></td>
                                    <td class="printFV text-right" ><b id='remaining_text' class="label label-danger">0</b></td>
                                     
                                    <input type='hidden' id='remaining_due_amount' value="{{$due}}">
                                    <input type='hidden' id='remaining_due_after_edit' value="0">
                                </tr>
                               
                           
                            </tbody>
                        </table>
                        <div class="form-actions"  id='submitbutton' style="margin-top: 26px;float: right; display:none" >
                            <button type="submit" class="btn btn-success search-customer"> <i class="fa fa-check"></i> Search</button>
        
                            </div>
                        </form>
                    </div>
                </div>
                <br>

            </div>
            @if ($projectType->id == \App\ProjectType::society)
                {{-- Development Charges --}}

                <div class="col-lg-12">
                    <div class="white-box1">
                        <div class="table-responsive" style="clear: both;">
                            <table class="table table-bordered">
                                <thead class="bg-color">
                                    <tr style="text-align: center">
                                        <th style="color: #fff;font-size: 13px;">Payment Head</th>
                                        <th style="color: #fff;font-size: 13px;">Due Date</th>
                                        <th style="color: #fff;font-size: 13px;">Due Amt.</th>
                                        <th style="color: #fff;font-size: 13px;">Received Amt.</th>
                                        <th class="no-print" style="color: #fff;font-size: 13px;">Balance</th>
                                        <th style="color: #fff;font-size: 13px;">Payment Mode</th>
                                        <!-- <th class="no-print">Detail</th> -->
                                        <th style="color: #fff;font-size: 13px;">Receipt #</th>
                                        <!-- <th>Ref#</th> -->
                                        <th style="color: #fff;font-size: 13px;">Receipt Date</th>

                                        <th style="color: #fff;font-size: 13px;">Surcharge Amt</th>
                                        <th style="color: #fff;font-size: 13px;">Balance Amt.</th>
                                        <!-- <th>Net Amt</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $development_due = 0;
                                    $development_received = 0;
                                    $development_balance = 0;
                                    $development_surcharge = 0;
                                    $development_net_payable = 0;
                                    $count = 1;
                                    $development_total = $property->development_fee;
                                    
                                    $otherArray = [];
                                    ?>

                                    @foreach ($periorities as $periority)
                                        @foreach ($property->statement->where('payment_head', \App\CustomerStatement::development) as $development_statement)
                                            @if (
                                                ($development_statement->due > 0 && $development_statement->payment_head == $periority->payment_head) ||
                                                    ($development_statement->payment_head == \App\CustomerStatement::other &&
                                                        !in_array($development_statement->payment_head, $otherArray)))
                                                @php
                                                    
                                                    if ($development_statement->payment_head == \App\CustomerStatement::other) {
                                                        $otherArray[] = $development_statement->payment_head;
                                                    }
                                                    
                                                @endphp

                                                @if ($development_statement->balance > 0 && $development_statement->due_date < Carbon\Carbon::today())
                                                    <tr style="background-color: #e8e3c1;">
                                                    @else
                                                    <tr>
                                                @endif




                                                @if ($development_statement->payment_head == \App\CustomerStatement::development)
                                                    <td class="printFV">Development</td>
                                                @else
                                                    <td class="printFV"></td>
                                                @endif


                                                <td class="printFV">
                                                    {{ date('d-m-Y', strtotime($development_statement->due_date)) }}

                                                    @permission('edit-membership')
                                                        @if ($development_statement->received == 0)
                                                            <i class="fa fa-pencil-square hide-icon" aria-hidden="true"
                                                                onclick="callSweetAlert('{{ $development_statement->id }}')"></i>
                                                        @endif
                                                    @endpermission

                                                </td>
                                                <td class="printFV text-right">
                                                    {{ number_format($development_statement->due) }}</td>
                                                <?php $development_due += $development_statement->due; ?>
                                                <td class="printFV text-right">
                                                    @if ($development_statement->is_deleted == false)
                                                        {{ number_format($development_statement->received) }}<?php $development_received += $development_statement->received; ?>
                                                    @else
                                                        0
                                                    @endif
                                                </td>
                                                <td class="printFV no-print text-right">
                                                    @if ($development_statement->is_deleted == false)
                                                        {{ number_format($development_statement->balance) }}
                                                    @else
                                                        {{ number_format($development_statement->due) }}
                                                    @endif
                                                </td>

                                                @if ($development_statement->is_deleted == false)
                                                    @if ($development_statement->receipt)
                                                        @if ($development_statement->receipt->payment_method == \App\Receipt::cash)
                                                            <td>Cash</td>
                                                        @elseif($development_statement->receipt->payment_method == \App\Receipt::bank)
                                                            <td>Bank</td>
                                                        @elseif($development_statement->receipt->payment_method == \App\Receipt::adjustment)
                                                            <td>Adjustment</td>
                                                        @elseif($development_statement->receipt->payment_method == \App\Receipt::cheque)
                                                            <td>Cheque</td>
                                                        @elseif($development_statement->receipt->payment_method == \App\Receipt::merging)
                                                            <td>Merging</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                    @else
                                                        <td></td>
                                                    @endif
                                                @else
                                                    <td></td>
                                                @endif



                                                <td class="printFV">
                                                    @if ($development_statement->is_deleted == false)
                                                        {{ $development_statement->rcpt_no }}
                                                    @endif
                                                </td>
                                                <!-- <td class="printFV"> {{ $development_statement->ref_no }} </td> -->
                                                <td class="printFV text-right">
                                                    @if ($development_statement->is_deleted == false)
                                                        {{ $development_statement->rcpt_date ? date('d-m-Y', strtotime($development_statement->rcpt_date)) : '' }}
                                                    @endif
                                                </td>


                                                <td class="printFV text-right">
                                                    {{ number_format($development_statement->surcharge) }}
                                                    <?php $surcharge += $development_statement->surcharge;
                                                    ?></td>

                                                @if ($development_statement->is_deleted == false)
                                                    @if ($development_statement->received)
                                                        <?php $development_total -= $development_statement->received; ?>
                                                        <td class="printFV text-right">
                                                            {{ number_format($development_total) }}</td>
                                                    @else
                                                        <td class="printFV"></td>
                                                    @endif
                                                @else
                                                    <td class="printFV"></td>
                                                @endif
                                                <!-- <?php $development_balance += $development_statement->balance; ?>-->





                                                </tr>
                                            @endif
                                        @endforeach
                                    @endforeach
                                    <tr>
                                        <td colspan="2" class="printFV text-center"><b>Total</b></td>
                                        <td class="printFV text-right"><b>{{ number_format($development_due) }}</b></td>
                                        <td class="printFV text-right"><b>{{ number_format($development_received) }}</b>
                                        </td>
                                        <!-- <td colspan="3"></td> -->
                                        <td colspan="5" class="printFV text-right"> Total WaveOff
                                            ({{ $waiveOff }})
                                            <b>{{ number_format($development_surcharge - $waiveOff) }}</b>
                                        </td>
                                        <td class="printFV text-right"><b>{{ number_format($development_total) }}</b>
                                        </td>


                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <br>

                </div>
            @endif
            {{-- End Development Charges --}}

            @if ($property->booking_type == \App\CustomerProperty::full_payment)

                @if ($property->fullPayment)
                    <div class="col-lg-12">
                        <div class="white-box">
                            <h4 class="box-title">Discount Payment Terms</h4>
                            <hr>
                            <div class="table-responsive pull-left">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <td>Total Amount :</td>
                                            <td> {{ number_format($property->fullPayment->total_amount) }} </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Discount Percentage :</td>
                                            <td> {{ $property->fullPayment->discount_percentage }} %</td>
                                        </tr>
                                        <tr>
                                            <td>Discount Amount</td>
                                            <td> {{ number_format($property->fullPayment->discount_amount) }} </td>
                                        </tr>
                                        <tr>
                                            <td>Net Amount</td>
                                            <td> {{ number_format($property->fullPayment->discount_amount - $property->fullPayment->deduction_amount) }}
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                            <div class="table-responsive pull-right">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <td>Total Tenure : </td>
                                            <td>{{ $property->fullPayment->total_tenure }} months</td>
                                        </tr>
                                        <tr>
                                            <td>Return Tenure :</td>
                                            @if ($property->fullPayment->return_tenure == \App\CustomerProperty::monthly)
                                                <td> Monthly </td>
                                            @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::quarterly)
                                                <td> Quarterly </td>
                                            @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::semi_annually)
                                                <td> Semi Annually </td>
                                            @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::annually)
                                                <td> Annually </td>
                                            @else
                                                <td></td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td>Deduction Amount : </td>
                                            <td> {{ number_format($property->fullPayment->deduction_amount) }} </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="clear"></div>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="white-box">
                            <div class="table-responsive" style="clear: both;">
                                <table class="table table-bordered printFW1">
                                    <thead class="printFH11">
                                        <tr>
                                            <th style="color: #fff;font-size: 13px;">inst #</th>
                                            <th style="color: #fff;font-size: 13px;">Due Date</th>
                                            <th style="color: #fff;font-size: 13px;">Due Amount</th>

                                            <th style="color: #fff;font-size: 13px;">Paid Amount</th>
                                            <th style="color: #fff;font-size: 13px;">Receipt #</th>
                                            <th style="color: #fff;font-size: 13px;">Receipt Date</th>
                                            <th style="color: #fff;font-size: 13px;">Balance Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $due = 0;
                                        $received = 0;
                                        $balance = 0;
                                        $count = 1; ?>
                                        @foreach ($property->fullPaymentStatement as $statement)
                                            <tr>
                                                <td class="printFV">{{ $count++ }}</td>
                                                <td class="printFV">{{ date('d-m-Y', strtotime($statement->due_date)) }}
                                                </td>
                                                <td class="printFV text-right">{{ number_format($statement->due) }}</td>
                                                <?php $due += $statement->due; ?>
                                                <td class="printFV text-right">{{ number_format($statement->received) }}
                                                </td><?php $received += $statement->received; ?>
                                                <td class="printFV"> {{ $statement->receipt_no }} </td>
                                                <td class="printFV">
                                                    {{ $statement->receipt_date ? date('d-m-Y', strtotime($statement->receipt_date)) : '' }}
                                                </td>
                                                <td class="printFV text-right">
                                                    {{ number_format($statement->due - $statement->received) }}</td>
                                                <?php $balance += $statement->due - $statement->received; ?>
                                            </tr>
                                        @endforeach
                                        <tr>
                                            <td colspan="2"><b>Total</b></td>
                                            <td class="text-right"><b>{{ number_format($due) }}</b></td>
                                            <td class="text-right"><b>{{ number_format($received) }}</b></td>
                                            <td></td>
                                            <td></td>
                                            <td class="text-right"><b>{{ number_format($balance) }}</b></td>
                                        </tr>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                @endif

            @endif



            @if ($property->propertyTax)

                <div class="col-lg-12 no-print">
                    <div class="white-box">
                        <h4 class="box-title">Property Tax Record</h4>
                        <div class="table-responsive" style="clear: both;">
                            <table class="table table-bordered printFW1">
                                <thead class="printFH11">
                                    <tr>
                                        <th style="color: #fff;font-size: 13px;">Sr #</th>
                                        <th style="color: #fff;font-size: 13px;">inst #</th>
                                        <th style="color: #fff;font-size: 13px;">Tax</th>

                                        <th style="color: #fff;font-size: 13px;">Pay By</th>
                                        <th style="color: #fff;font-size: 13px;">Payment Received</th>

                                        <th style="color: #fff;font-size: 13px;">Status</th>
                                        <th style="color: #fff;font-size: 16px;">CPR</th>
                                        <th style="color: #fff;font-size: 13px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $sr = 1;
                                    $sum = 0; ?>
                                    @foreach ($property->PropertyTax as $tax)
                                        <tr>
                                            <td class="printFV">{{ $sr++ }}</td>
                                            @if ($tax->statement->payment_head == \App\CustomerStatement::down_payment)
                                                <td class="printFV">Down Payment</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::possession)
                                                <td class="printFV">Possession Fee</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::installment)
                                                <td class="printFV">Installment - {{ $tax->statement->inst_no }}</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::other)
                                                <td class="printFV">Other</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::allotment)
                                                <td class="printFV">Allotment</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::confirmation)
                                                <td class="printFV">Confirmation</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::booking)
                                                <td class="printFV">Booking</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::development)
                                                <td class="printFV">Development</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::file_processing)
                                                <td class="printFV">File Processing</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::registration)
                                                <td class="printFV">Registration</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::ballon)
                                                <td class="printFV">Ballon Payment</td>
                                            @elseif($tax->statement->payment_head == \App\CustomerStatement::balloting)
                                                <td class="printFV">Balloting </td>
                                            @else
                                                <td class="printFV"></td>
                                            @endif
                                            <td class="printFV text-right">
                                                {{ number_format($tax->tax) }}
                                            </td>
                                            <?php $sum += $tax->tax; ?>

                                            <td class="printFV text-right">
                                                @if ($tax->tax_pay_by == \App\Receipt::customer)
                                                    Customer
                                                @else
                                                    Company
                                                @endif
                                            </td>

                                            <td class="printFV text-right">
                                                {{ $tax->tax_payment_received == \App\CustomerPropertyTax::paid ? 'YES' : 'NO' }}
                                            </td>

                                            <td class="printFV text-right">
                                                {{ $tax->status == \App\CustomerPropertyTax::paid ? 'Paid' : 'UnPaid' }}
                                                @if ($tax->status)
                                                    <br>
                                                    <b>Reference # </b>
                                                    {{ $tax->reference }}
                                                @endif
                                            </td>

                                            <td>
                                                @if ($tax->cpr)
                                                    <a target="_blank"
                                                        style="color:blue;text-decoration: underline;font-size: 11px"
                                                        href="{{ asset('uploads/' . $tax->cpr) }}" download=""> <i
                                                            class="fa fa-download"
                                                            style="text-transform: none;">&nbsp;</i>Download</a>
                                                @endif
                                            </td>

                                            <td>
                                                <button {{ $tax->status ? 'disabled' : '' }} class="btn btn-info"
                                                    onclick="openTaxModal({{ $tax->id }})">
                                                    Add CPR
                                                </button>

                                                @if ($tax->tax_pay_by == \App\Receipt::customer)
                                                    <button
                                                        {{ $tax->tax_payment_received == \App\CustomerPropertyTax::paid ? 'disabled' : '' }}
                                                        data-instal-no='{{ $tax->statement->inst_no }}'
                                                        class="btn btn-info"
                                                        onclick="openTaxReceiptModal(this, {{ $tax->id }} , {{ $tax->tax }} , {{ $tax->statement->rcpt_no }} , {{ $tax->statement->payment_head }} )">
                                                        Make tax receipt
                                                    </button>
                                                @endif
                                            </td>

                                        </tr>
                                    @endforeach
                                    <tr>
                                        <td colspan="2"><b>Total</b></td>
                                        <td class="text-right"><b>{{ number_format($sum) }}</b></td>

                                    </tr>

                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            @endif

            <div class="modal fade" id="taxReceiptModal" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">

                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header" style="text-align: center;">
                            <h5 class="modal-title" id="exampleModalLabel">Tax Receipt</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body" style="height: 250px;">

                            <div class="alert alert-danger" role="alert" style="display:none;" id="fields_error">
                                All fields with * is required.
                            </div>

                            <form method="post" action="{{ route('customer.tax.amount.paid') }}"
                                onsubmit="return checkValue()">
                                {{ csrf_field() }}
                                <input type="hidden" name="tax_receipt_id" id="tax_receipt_id">
                                <input type="hidden" name="inst_no" id="inst_no">
                                <input type="hidden" name="payment_head" id="payment_head">


                                <div class="col-xs-6">
                                    <label>Receipt No</label>
                                    <input type="text" name="receipt_no" id="receipt_no" readonly
                                        class="form-control">
                                </div>


                                <div class="col-xs-6">
                                    <label>Tax Amount</label>
                                    <input type="text" name="tax_amount" id="tax_amount" class="form-control">
                                </div>


                                <div class="col-xs-6" style="margin-top: 2rem;">
                                    <label>Date</label>
                                    <input type="date" name="tax_receipt_date" value="{{ date('Y-m-d') }}"
                                        id="tax_receipt_date" class="form-control">
                                </div>


                                <div class="col-xs-6" style="margin-top: 2rem;">
                                    <label>Payment Mode</label>
                                    <select class="form-control chosen-select" id="payment_method" name='payment_method'
                                        onchange="changeFunc(this.value)">
                                        <option value="{{ \App\Receipt::cash }}">Cash</option>
                                        <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                        <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                        <!--   <option value="{{ \App\Receipt::adjustment }}">Adjustment</option> -->
                                    </select>
                                </div>



                                <div class="col-md-6" id='bank' style="display: none;margin-top: 2rem;">

                                    <label class="control-label ">
                                        Depositor Bank Name
                                        <span style="color:red;">*</span>
                                    </label>

                                    <select name="bank_name" class="form-control chosen-select" id="bank_name">
                                        <option value="" selected="">None</option>

                                        @foreach ($banks as $bank)
                                            @if (old('bank_name') == $bank->id)
                                                <option selected="" value="{{ $bank->id }}">{{ $bank->name }}
                                                </option>
                                            @else
                                                <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6" id='company-bank' style="display: none;margin-top: 2rem;">

                                    <label class="control-label">Company Account <span style="color:red;">*</span></label>

                                    <select name="company_account" class="form-control chosen-select"
                                        id="company_account">
                                        <option value="" selected="">None</option>

                                        @foreach ($cBanks as $bank)
                                            @if (old('company_account') == $bank->id)
                                                <option selected="" value="{{ $bank->id }}">{{ $bank->name }}
                                                    - {{ $bank->account_number }}</option>
                                            @else
                                                <option value="{{ $bank->id }}">{{ $bank->name }} -
                                                    {{ $bank->account_number }}</option>
                                            @endif
                                        @endforeach

                                    </select>
                                </div>


                                <div class="col-md-6" id="cheque-dd-po-drawn-date"
                                    style="display: none;margin-top: 2rem;">
                                    <label class="control-label">
                                        Drawn Date
                                        <span style="color:red;">*</span>
                                    </label>

                                    <input type="date" class="form-control" id="drawnDate" name='drawn_date'>
                                </div>

                                <div class="col-md-6" id="cheque-dd-po-instrument-no"
                                    style="display: none;margin-top: 2rem;">
                                    <label class="control-label ">
                                        Instrument No
                                        <span style="color:red;">*</span>
                                    </label>

                                    <input type="text" name='cheque_number' id="checkNumber" class="form-control">
                                </div>


                                <div class="col-md-12" id="note" style="margin-top: 2rem;">
                                    <label class="control-label ">
                                        Note
                                    </label>

                                    <textarea placeholder="type here...." rows="4" name="description" class="form-control"></textarea>
                                </div>



                        </div>

                        <div class="modal-footer" style="border-top: none;">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"
                                style="margin-top: 3rem;">Close</button>
                            <button type="submit" class="btn btn-primary" style="margin-top: 3rem;">Save</button>
                            </form>
                        </div>

                    </div>
                </div>

            </div>




            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">

                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header" style="text-align: center;">
                            <h5 class="modal-title" id="exampleModalLabel">Tax CPR</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form method="post" action="{{ route('customer.tax.paid') }}" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="modal-body" style="height: 250px;">

                                <input type="hidden" name="statement_id" value="{{ $statement->id }}">
                                <input type="hidden" name="tax_id" id="tax_id">

                                <div class="form-group form-group-sm">
                                    <div class="col-xs-4">
                                        <label>Reference</label>
                                    </div>
                                    <div class="col-xs-8">
                                        <input type="text" name="reference" placeholder="Enter Reference"
                                            class="form-control">
                                    </div>
                                </div>
                                <div class="form-group form-group-sm">
                                    <div class="col-xs-4">
                                        <label>File</label>
                                    </div>
                                    <div class="col-xs-8">
                                        <input type="file" name="file" class="form-control">
                                    </div>
                                </div>
                                <br>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Upload</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>




        </div>
        <div style="display: inline-block;    margin-bottom: 70px;">


            <!-- @permission('edit-membership')
        <div class="text-left no-print" style="display: inline-block;"><a target="_blank" href="{{ route('membership.edit', ['id' => $property->id]) }}">
                        <button  class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-edit"></i> Edit</span> </button></a>
                    </div>
    @endpermission -->

            <div class="text-right" style="display: inline-block;">
                <button class="btn btn-default btn-outline no-print" onclick="return print_whole_statement()"
                    type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
            </div>

            <div class="text-right" style="display: inline-block;">
                <button class="btn btn-default btn-outline no-print" onclick="return  print_summery()" type="button">
                    <span><i class="fa fa-print"></i> Print Summary</span> </button>
            </div>

        </div>
    </div>
    <!-- /.container-fluid -->

    <!-- Modal -->
    <div class="modal fade" id="possession_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="myModalLabel">Update Possession Date</h4>
                </div>
                <form method="post" onsubmit="return UpdatePossessionDate(this)">
                    <div class="modal-body">
                        <span style="color:red;display: none; padding-bottom: 1rem;" id="error_message">Date Not be
                            Empty.</span>
                        <span style="color:green;display: none; padding-bottom: 1rem;" id="success_message">Update
                            Successfully!</span>
                        <input type="hidden" id="payment_head_id">
                        <input type="date" min="{{ date('Y-m-d') }}" id="new_possession_date" class="form-control"
                            name="">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" id="possession_modal_btn" class="btn btn-primary">Save changes</button>
                </form>
            </div>
        </div>
    </div>
    </div>


@stop

@section('js')
    <script src="{{ asset('js/jspdf.min.js') }}" type="text/JavaScript"></script>
    <script src="{{ asset('js/jquery.PrintArea.js') }}" type="text/JavaScript"></script>


    <script>
        window.setInterval(function() {
            $('#text_detail').html('Member Information')
            $('#main_unit_details').show();
            $('#summary_customer_info').hide();
            $('#main_customer_info').show();
        }, 1000);

        function print_summery() {
            $('#text_detail').html("Unit's Details")
            $('#payment_div').addClass("no-print");
            $('#summary_customer_info').show();
            $('#main_customer_info').hide();
            $('#main_unit_details').hide();
            $('.block_id').hide();
            $('.Category').hide();
            $('.net_amount').hide();
            $('.area').hide();
            $('.discount').hide();
            $('.category_cost').hide();
            window.print();
            return false;
        }

        function print_whole_statement() {
            $('#text_detail').html('Member Information')
            $('#payment_div').removeClass("no-print");
            $('#summary_customer_info').hide();
            $('#main_customer_info').show();
            $('#main_unit_details').show();
            window.print();
            return false;
        }


        function checkValue(self) {
            if ($('#payment_method').val() != '{{ \App\Receipt::cash }}' && ($('#bank_name').val() == '' || $(
                    '#company_account').val() == '' || $('#drawnDate').val() == '' || $('#checkNumber').val() == '')) {
                $('#fields_error').show('slow')
                return false;
            } else {
                return true;
            }
        }

        function changeFunc(a) {
            if (a == {{ \App\Receipt::cash }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#drawnDate').val('')
                $('#checkNumber').val('')
            } else if (a == {{ \App\Receipt::bank }}) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
            } else if (a == {{ \App\Receipt::cheque }}) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');

            }

        }



        function showDealerDiv() {
            $("#data_div").toggle('slow');
        }

        function openTaxReceiptModal(self, tax_id, tax_amount, receipt_no, payment_head) {

            $('#tax_receipt_id').val(tax_id);

            $('#tax_amount').val(tax_amount);

            $('#receipt_no').val(receipt_no);

            $('#payment_head').val(payment_head);

            $('#inst_no').val($(self).data("instal-no"));

            $('#taxReceiptModal').modal();
        }

        function openTaxModal(tax_id) {

            $('#tax_id').val(tax_id);

            $('#exampleModal').modal();

        }

        function UpdatePossessionDate(self) {

            $('#possession_modal_btn').html('Processing...');
            $('#possession_modal_btn').prop('disabled', true);

            var payment_head_id = $('#payment_head_id').val();
            var possession_date = $('#new_possession_date').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('payment.head.update') }}",
                method: 'POST',
                data: {
                    payment_head_id: payment_head_id,
                    possession_date: possession_date
                },
                success: function(data) {
                    if (data == '1') {
                        $('#success_message').show();
                        location.reload(true)
                    } else if (data == 'empty') {
                        $('#possession_modal_btn').html('Save changes');
                        $('#possession_modal_btn').prop('disabled', false);
                        $('#error_message').show();
                    } else {
                        alert('Something Went wrong!')
                        location.reload(true)
                    }
                }
            })


            return false;
        }

        function changePossessionDate(id, date) {
            $('#payment_head_id').val(id)
            $('#new_possession_date').val(date);
            $('#possession_modal').modal('show')
        }
        $(function() {
            $("#print").on("click", function() {
                var mode = 'iframe'; //popup
                var close = mode == "popup";
                var options = {
                    mode: mode,
                    popClose: close
                };
                $("div.printableArea").printArea(options);
            });
        });
    </script>
    <script>
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    </script>
    <script>
        var doc = new jsPDF();
        var specialElementHandlers = {
            '#editor': function(element, renderer) {
                return true;
            }
        };

        //margins.left, // x coord   margins.top, { // y coord
        $('#generatePDF').click(function() {
            doc.fromHTML($('#htmlContent').html(), 15, 15, {
                'width': 700,
                'elementHandlers': specialElementHandlers
            });
            doc.save('sample_file.pdf');
        });
        @permission('edit-membership')
            function callSweetAlert(id) {


                const template = `
            <div>
                <input class='swal2-input' type="date" id="statement_datepicker">
            </div>
        `;
                Swal.fire({

                    title: "Enter a date",
                    customClass: 'swal-wide',
                    html: template,
                    showCancelButton: true,
                    confirmButtonText: "Submit",
                    cancelButtonText: "Cancel",

                    preConfirm: () => {

                        date = document.getElementById('statement_datepicker').value;
                        id = id;




                        if (!date) {
                            Swal.showValidationMessage(
                                'You need to add date!'
                            )
                        }


                        return [

                            date,
                            id,


                        ]
                    }

                }).then(function(result) {
                    if (result.value) {
                        // get the selected date from the custom element
                        var date = $("#statement_datepicker").val();

                        // send an AJAX request to update the date
                        $.ajax({
                            url: "{{ route('statement.date.update') }}",
                            type: "POST",
                            data: {
                                date: date,
                                id: id,
                                _token: "{{ csrf_token() }}",
                            },
                            success: function(response) {
                                // update the date in the blade template
                                if (response.errors) {
                                    // display validation errors
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Oops...',
                                        text: response.errors,
                                    })

                                } else {
                                    // display success message
                                    Swal.fire({

                                            icon: 'success',
                                            title: 'Data Updated Successfully!',
                                            confirmButtonColor: '#3085d6',

                                            confirmButtonText: 'ok!',
                                            showCancelButton: false,
                                            allowOutsideClick: false
                                        })
                                        .then((result) => {
                                            if (result.isConfirmed) { // reload the current page
                                                location.reload();

                                            }
                                        });


                                }

                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: 'Something went wrong!',

                                })
                            },
                        });
                    }
                });



            }

            function callSweetAlertForEdit(id,val){

              
                var td = $('#due_amount_'+id);
                
                var original_val= $('#due_amount_value_input_'+id).val();
                       var text = td.text();
                       var value = parseInt(original_val); 
                      
                 td.html(`
                  <input type='hidden' name='statement_id[]' value="`+val+`">
                 <input class="input_field" style="width: 30%;" name='new_due_statement[]' type="number" data-original-value="`+value+`" value="` + value + `" id="new_due_input_amount`+id+`" onkeyup='handleKeyUp()' oninput="handleKeyUp()">
                 `);
                 $('#eraser_to_remove'+id).show();
                 
                 $('#edit_due_amount'+id).hide();
                
                 $('.adjust_value_inside_icon').show();
                 $('#adjust_value_inside_'+id).hide();
                 
                $('#submitbutton').show();
                $('#remainig_amount_val').show();
                

            }
            function removeEditDueInput(id){
                 $('#eraser_to_remove'+id).hide();
                 
                 $('#edit_due_amount'+id).show();
                 $('#due_amount_'+id).empty();
                     value=  $('#due_amount_value_input_'+id).val();
                  $('#due_amount_'+id).text(value);
                  $('.edit_due_amount_icon').show();
                  if ($('input.input_field').length > 0) {
                    
                    $('#submitbutton').show();
                    $('#remainig_amount_val').show();
                } else {
                        $('.adjust_value_inside_icon').hide();
                        $('#submitbutton').hide();
                        $('#remaining_text').empty();
           $('#remaining_text').text(0);
                        $('#remainig_amount_val').hide();

                            }
            }
          
 function adjustValueIntoInput(id,val){


    var td = $('#due_amount_'+id);
             
                      
             var text = td.text();
             var value = parseInt(text); 
         var remaing_val=    parseInt($('#remaining_text').text());

      new_val=   remaing_val + value; 
            
       td.html(`
        <input type='hidden' name='statement_id[]' value="`+val+`">
       <input class="input_field" style="width: 30%;" name='new_due_statement[]' type="number" data-original-value="`+value+`" value="` + new_val + `" id="new_due_input_amount`+id+`" onkeyup='handleKeyUp(this)' oninput="handleKeyUp(this)">
       `);
       $('#eraser_to_remove'+id).show();
       
       $('#edit_due_amount'+id).hide();
      
       $('.adjust_value_inside_icon').show();
       $('#adjust_value_inside_'+id).hide();
       
      $('#submitbutton').show();
      $('#remainig_amount_val').show();
      handleKeyUp();
 }
 

            function handleKeyUp(){
                
                var total_due = $('#remaining_due_amount').val();
        var remaining_due = total_due;
        $('.input_field').each(function() {
            var original_value = parseFloat($(this).data('original-value'));
            var new_value = parseFloat($(this).val());
            if (!isNaN(new_value)) {
                remaining_due -= (new_value - original_value);
            }
        });
        res = remaining_due - total_due;
        $('#remaining_text').empty();
        $('#remaining_text').text(res);
            
            }

            function validateForm(){

                var remaining = $("#remaining_text").text();
            val=    parseInt(remaining);


 
    
             if (parseInt(val) > 0 || parseInt(val) < 0) {
                Swal.fire('Remaining Amount Exists');

                return false;
            }
            }

        @endpermission
        @permission('delete-membership')
                   function callSweetAlertForDelete(id) {

                                        Swal.fire({
                                            icon: 'question',
                                            customClass: 'swal-wide',
                                            title: 'Are you sure',
                                            text: 'You want to delete it?',
                                            confirmButtonColor: '#3085d6',
                                            confirmButtonText: 'Yes',
                                            showCancelButton: true,
                                            allowOutsideClick: false
                                        })
                                        .then((result) => {
                                            if (result.isConfirmed) { // reload the current page
                                                $.ajax({
                            url: "{{ route('statement.single.delete') }}",
                            type: "POST",
                            data: {
                                
                                id: id,
                                _token: "{{ csrf_token() }}",
                            },
                            success: function(response) {
                                // update the date in the blade template
                                if (response.errors) {
                                    // display validation errors
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Oops...',
                                        text: response.errors,
                                    })

                                } else {
                                    // display success message
                                    Swal.fire({

                                            icon: 'success',
                                            title: 'Data Deleted Successfully!',
                                            confirmButtonColor: '#3085d6',

                                            confirmButtonText: 'ok!',
                                            showCancelButton: false,
                                            allowOutsideClick: false
                                        })
                                        .then((result) => {
                                            if (result.isConfirmed) { // reload the current page
                                                location.reload();

                                            }
                                        });


                                }

                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: 'Something went wrong!',

                                })
                            },
                        });
                                            }
                                        });
                    }
        @endpermission
    </script>
@stop
