@extends('layouts.app')

@section('title')
    Add Development Charges
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        
        <li class="active">Add Development Charges </li>
    </ol>
@stop
@section('css')
    <style>
        .help-block {
            font-weight: bold;
        }

        span {
            display: inline-block;
        }
    </style>

@stop

@section('content')

@php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphps

    <div class="container-fluid">
        <div class="row">

            <form class="form-horizontal" method='post' action="{{ route('statement.insert-developmentcharges') }}" enctype="multipart/form-data"
                onsubmit="return validateData(this)">
                {{ csrf_field() }}
                <div class="col-md-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="white-box">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Add Development Charges</h3>
                        <p class="text-muted  font-13"> Note: All * fields are mandatory </p>

                        <hr>

                    </div>
                </div>

            



                
                  



                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box1">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa fa-map"></i> Select Unit Type</h3>


                        
                        <hr>
                        <input type="hidden" name='inventory_id' id='inventory-id' >









                         
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Unit # <span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div id='addUnitDetail'>
                                            <select class="form-control chosen-select" id="unit_number"
                                                name="unit_number" data-id='0'>
                                                <option value="" selected="">None</option>
                                                @foreach ($allStatements as $statement)
                                                    <option value="{{ $statement->inventory->id }}">{{ $statement->customer->name }} ---- {{$statement->inventory->unit_number }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>


                                        @if ($errors->has('unit_number'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('unit_number') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>


                        


<input type='hidden' name='customer_property_id' id='customer_property_id'>






                        <div class="col-md-6" id="inventory_type">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Type</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="type"
                                        value="{{ old('type') }}" id="type">
                                    @if ($errors->has('type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <div class="clearfix"></div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Size ({{$size}})</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="size"
                                        value="{{ old('size') }}" id="size">
                                    @if ($errors->has('size'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('size') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Price</label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='total-amount' class="form-control"
                                        name="total_price" value="{{ old('total_price') }}">
                                    @if ($errors->has('total_price'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('total_price') }}</strong>
                                        </span>
                                    @endif
                                    <div style="color:black;" class="help-block" id='total-amount-label'></div>
                                </div>
                            </div>
                            
                        </div>


                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Category</label>
                                <div class="col-md-8">

                                    <input readonly="" type="category" class="form-control" name="category"
                                        value="{{ old('category') }}" id="category">
                                    @if ($errors->has('category'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('category') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>




                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Extra Charges </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='extra_charges' class="form-control"
                                        name="extra_charges" value="{{ old('extra_charges') }}">

                                    <div style="color:black;" class="help-block" id='extra-charges-label'></div>
                                </div>
                            </div>
                        </div>


                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Unit Description </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='description' class="form-control"
                                        name="description" value="{{ old('description') }}">


                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Net Amount</label>
                                <div class="col-md-8">
                                    <input type="hidden" id="dummy_net_amount">
                                    <input readonly="" type="text" id='net_amount' class="form-control"
                                        name="net_amount" value="{{ old('net_amount') }}">
                                    @if ($errors->has('net_amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('net_amount') }}</strong>
                                        </span>
                                    @endif
                                    <div style="color:black;" class="help-block" id='net_amount-label'></div>

                                </div>
                            </div>
                        </div>


                        <div class="clearfix"></div>


                      
                        
                        <div class="clearfix"></div>

                       



                     

                        




                        
                        <div class="clearfix"></div>
                        



                    </div>
                </div>
                




              


                <div class="col-lg-12 col-sm-12 col-xs-12" id="normal">
                    <div class="white-box">
                        <h3 class="box-title">Payment Scheduler</h3>
                        <hr>

                       
                        <div class="col-md-12">

                            <div class="form-group">
                                

                                <div class="col-md-10">


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='{{ \App\CustomerProperty::full_payment }}' checked> Full Payment
                                    </div>


                                  


                                    


                                    

 

                                 

                                     
                                   
                                   



                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableCustom(this.value)" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_custom }}'> Custom
                                    </div>


                                    @if ($errors->has('schedule_type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('schedule_type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>















 

                       

                        {{-- 3rd row --}}
                        <div  id='singlepayment'>

                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Development <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 43%;" type="date"
                                            id='development_date' class="form-control" name="development_date"
                                            placeholder="Date">

                                        <input style="display: inline-block;width: 49%;" type="integer"
                                            class="form-control" name="development_charges" 
                                            placeholder="Amount">
                                    </div>
                                </div>
                            </div>


                            
                            <div class="clearfix"></div>
                           &nbsp;&nbsp;&nbsp;
                           
                            <div class="clearfix"></div>
                        </div>
                    

 






















                        <div class="col-md-1"></div>


                        <div class="clearfix"></div>

                        <div id="auto" style="margin-top: 2%;">

                           


                           

                           
                           
                             



                            
                            <div class="clearfix"></div>
                            
                            <div class="clearfix"></div>


                        </div>

                        <!---Custom-->
                        <div id="custom" style="display: none;">

                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Installment <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 43%;" type="date"
                                            id='installment' class="form-control" name="custom_date[]"
                                            placeholder="Date">

                                        <input style="display: inline-block;width: 49%;" type="integer"
                                            class="form-control" name="custom_amount[]" onkeyup="customPayment()"
                                            placeholder="Amount">
                                    </div>
                                </div>
                            </div>


                            <div class="clearfix"></div>
                            <div class="input_fields_wrap2 col-md-10">

                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                            <button type="button" class="btn btn-primary add_field_button2">Add
                                Installment</button>&nbsp;&nbsp;&nbsp;
                           
                            <div class="clearfix"></div>
                        </div>

                        <!-- Custom End -->

                    </div>
                </div>
                <!--receipt module -->




                <div class="col-md-12" style="height: 70px;">
                    <div class="alert alert-danger" style="display:none;" role="alert" id="required_field_error">
                        All Fields With * is Required.
                    </div>

                    <button style="float: right;" type="submit"
                        class="btn btn-info  waves-effect waves-light btn-lg">Save</button>
                </div>


        </div>
    </div>


    </form>
    </div>
    </div>
    <input type='hidden' id="possession_per">
    <input type='hidden' id="down_payment_per">
    <input type='hidden' id="total_month_per">
    <input type='hidden' id="annual_installment_per">
    <input type='hidden' id="monthly_installment_per">
    <input type="hidden" id="down_payment_dis">
    <input type="hidden" name="percentage" id="percentage">
    <input type="hidden" name="rebate_in_percent" id="rebate_in_percent">

    <input type="hidden" name="semi_installment_hid_per" id="semi_installment_hid_per">
    <input type="hidden" name="semi_installment_hid_amount" id="semi_installment_hid_amount">


@stop


@section('js')
<script>
function percentage(num, per)
{
  return (num/100)*per;
}
function validateData(self) 
{
    
    var customer =  $(self).find('#customer_id').val();
    var unit_number =  $(self).find('#unit_number').val();
     
    var development =  $(self).find('#development').val();
   
     
    if (development == "")
    {
        $('#required_field_error').show();
        setTimeout(function() { 
        $('#required_field_error').hide();        
        }, 3000);
return false;
    }



   


    if (unit_number == "")
    {
        $('#required_field_error').show();
        setTimeout(function() { 
        $('#required_field_error').hide();        
        }, 3000);
return false;
    }

 


    
}

  
    $(document).ready(function() {
    var max_fields      = 2; //maximum input boxes allowed
    var wrapper         = $(".input_fields_wrap3"); //Fields wrapper
    
    var add_button      = $(".add_field_button3"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function(e){ //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
            $(wrapper).append('<div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Nominee Name <span style="color: red">*</span></label><div class="col-md-9"><input type="text" class="form-control" name="nominee_name_n" value="" id="exampleInputuname" placeholder="Enter Name"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">S/O, D/O, W/O.<span style="color: red">*</span></label><div class="col-md-9"><input  type="text" class="form-control" name="nominee_so_do_wo_n" value="" id="exampleInputuname" placeholder="Enter Father Name"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">CNIC</label><div class="col-md-9"><input type="text"  class="form-control" value="" name="nominee_cnic_n" id="nominee_cnic"  placeholder="XXXXXXXXXXXXX"  onfocusout="return validateCnic(this)"><input type="radio" name="nominee_cnic_flag_n" value="1"> Locally<input type="radio" name="nominee_cnic_flag_n" value="2"> Internationally</div><div style="color: red;display: none;" class="col-md-12"  id="cnic_error1">This Customer cnic is found in list of DNFBP. You cant add this Customer record. </div></div></div> <div class="col-md-6"><div class="form-group" id="nominee_address"><label for="address" class="col-sm-3 control-label" id="nominee_address">Nominee Address <span style="color: red">*</span></label><div class="col-sm-9"><div class="input-group"><div class="input-group-addon"><i class="icon-location-pin"></i></div><textarea class="form-control" id="nominee_address" name="nominee_address" ></textarea></div></div> </div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Passport No.</label><div class="col-md-9"><input type="text"  class="form-control" value="" name="nominee_passport_no_n" id="nominee_passport_no"  placeholder="XXXXXXXXX" ></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Relation With Applicant <span style="color: red">*</span></label><div class="col-md-9"><input type="text" class="form-control" name="nominee_relation_n" value=""  placeholder="Enter Relation"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Email</label><div class="col-md-9"><input type="text" class="form-control" name="nominee_email_n" value=""  placeholder="Enter Email"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Mobile Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_mobile_number_n" value=""  placeholder="Enter Mobile Number"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Res. Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_res_number_n" value=""  placeholder="Enter Res Number"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Phone Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_phone_number_n" value=""  placeholder="Enter Phone Number"></div></div></div><a href="#"class="remove_field">Remove</a>'); //add input box

        }
    });

    $(wrapper).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
    
});


    //multiple dealers
     

    


    
 

    
 
$(document).ready(function() {
    var max_fields = 50; //maximum input boxes allowed
    var wrapper = $(".input_fields_wrap1"); //Fields wrapper
    var wrapper1 = $(".input_fields_wrap"); //Fields wrapper
    var add_button = $(".add_field_button"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function(e) { //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
            $(wrapper).append('<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Add Extra Payment<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 49%;" onkeyup="addPayment()" type="integer" class="form-control" name="add_amount[]" placeholder="Amount"><input style="display: inline-block;width: 49%;" type="date" class="form-control"  name="add_date[]"  placeholder=""></div> </div><a href="#" class="remove_field">Remove</a>'); //add input box
            $(".bdpk").datepicker(
            {
                dateFormat: "dd-mm-yy"
            });
        }
    });

    $(wrapper).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
    $(wrapper1).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
});

//custom
$(document).ready(function() {
    var max_fields      = 100; //maximum input boxes allowed
    var wrapper         = $(".input_fields_wrap2"); //Fields wrapper
    var wrapper1         = $(".input_fields_wrap2"); //Fields wrapper
    var add_button      = $(".add_field_button2"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function(e){ //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
            $(wrapper).append('<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Installment-'+ x +'<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 43%;margin-right: 4px;" type="date" class="form-control" name="custom_date[]" placeholder="Date"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount"></div> </div><a href="#" class="remove_field">Remove</a>'); //add input box
            $(".bdpk").datepicker(
            {
                dateFormat: "dd-mm-yy"
            });
        }
    });

    $(wrapper).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
    $(wrapper1).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
});

//end custom

function customPayment() {

    // net_amount = parseInt($('#net_amount').val());
    // down_payment = parseInt($('#down-payment').val());
    // possession = parseInt($('#possession').val());
    
    var cus_amount = 0;

    $("input[name='custom_amount[]']").each(function() {
        if(!this.value){
            cus_amount += 0;
        }
        else {
            cus_amount += parseInt($(this).val());
        }
        
    });

    net_amount = parseInt($('#net_amount').val());
    down_payment = parseInt($('#down-payment').val());
    possession = parseInt($('#possession').val());
    allotment = parseInt($('#allotment').val());
    confirmation = parseInt($('#confirmation').val());
    booking = parseInt($('#booking').val());
    development = parseInt($('#development').val());
    file_processing = parseInt($('#file_processing').val());
    registration = parseInt($('#registration').val());
    remaining_amount = net_amount - down_payment - possession  - allotment - confirmation - booking - development - file_processing - registration- cus_amount;

    // remaining_amount = net_amount - down_payment - possession - cus_amount;

    $('#custome_rem').val(Math.round(remaining_amount));

}

function addPayment() {

    net_amount = parseInt($('#net_amount').val());
    if($('#down-payment').val())
        down_payment = parseInt($('#down-payment').val());
    else
        down_payment = 0;
    possession = parseInt($('#possession').val());
    monthly_installment = parseInt($('#total_installment').val());
    annual_installment = 0;

    val = parseInt($('input[name="schedule_type"]:checked').val());
    if(val =={{\App\CustomerProperty::inst_mon_w_semi}}) {
        annual_installment = $('#total_semi_installment').val();
    }
    else if(val =={{\App\CustomerProperty::inst_mon_w_ann}}) {
        annual_installment = $('#total_annual_installment').val();
    }
    else if(val =={{\App\CustomerProperty::inst_mon_w_quar}}) {
        annual_installment = $('#total_quarterly_installment').val();
    }


    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });


    remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment - add_amount;

    $('#remaining_amount').val(remaining_amount);

    var radioValue = $("input[name='schedule_type']:checked").val();

    if (radioValue == '{{\App\CustomerProperty::inst_custom}}') 
    {
        remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
    }
    $('#custome_rem').val(Math.round(remaining_amount));
}


 
</script>

 


   <script>

    var a = ['','one ','two ','three ','four ', 'five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
    var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];

//update the cost label
  



//update the registration

    
//update the booking

    
 




//update the possession

    


 

 

 

//update the installment label
    
    
 @php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp
 
 

 

$('#addUnitDetail').on('change', '#unit_number', function () {
    
    $('.preloader').fadeIn();

    let data_id = $('#unit_number').data('id');
        var data = { 'unit_number': $(this).val() };



        $.get('/getInformationByInventory', data, function (data) {
            if(data) {
            $('#total-amount').val(data.info.total_price - data.info.extra_amount);
            $('#net_amount').val(data.info.total_price);

            $("#type").val(data.info.type.name);
            $('#description').val(data.info.description);


           $('#dummy_net_amount').val(data.info.total_price)

            $('#extra_charges').val(data.info.extra_amount);
            
            $('#size').val((data.info.size) ? data.info.size.name : ''  + ' {{$size}}');
            $('#inventory-id').val(data.info.id);
            $('#description').val(data.info.description);

            $('#customer_property_id').val(data.info.property.id);
           
             name = '';
             for( i = 0 ; i<data.info.categories.length ; i++)
             {
                name += data.info.categories[i].category.name + ', ';
             }

            $('#category').val(name);
            //$('#category').val(data.info.category.name);
            
            //  $('#per_development').val(data.schedule.development);


        
             
                            

          
            
            

               //Full Payment
               
               num=$("#net_amount").val();
               $("#net_amount-label").text(number2TextConversion(num));
              
               $('#sqrt').html((data.info.size)?data.info.size.name:'');
               vl=(data.info.size)?data.info.size.name:'';
               $('#per_sqrt_value').val(net_amount/vl);


              
               
               let data_id = $('#unit_number').data('id');

               if(data_id ==1){
               $('#total_rebate1').val(data.dealer_rebate);

             
               $('#dealer_id').val(data.dealer_id);
               $("#total_rebate1").attr('readonly','readonly');
                //   $('#total_rebate1').attr("disabled","disabled") 
                // $('#dealer_id').attr("disabled","disabled") 
                $('#dealer_id option:not(:selected)').prop('disabled', true);
               }
            }
        });
       
        // $('#amount_schedule').click()
         $('.preloader').fadeOut();
});




 
 

function disableAnn(val) {
    $('#singlepayment').show();
  
    document.getElementById('custom').style.display = 'none';
    document.getElementById('auto').style.display = 'block';

    $('#remaining_amount').val(0);
    document.getElementById('semi_div').style.display = 'none';
    document.getElementById('ann_div').style.display = 'none';
    document.getElementById('quar_div').style.display = 'none';
    document.getElementById('bi_mon_div').style.display = 'none';
    price = $('#net_amount').val();

    ballon=  parseFloat($('#ballon').val());
    bullating=   parseFloat($('#bulleting').val());

    net_amount = parseInt($('#net_amount').val());
    down_payment = parseInt($('#down-payment').val());
    possession = parseInt($('#possession').val());
    allotment = parseFloat($('#allotment').val());
    confirmation = parseFloat($('#confirmation').val());
    booking = parseFloat($('#booking').val());
    development = parseFloat($('#development').val());
    file_processing = parseFloat($('#file_processing').val());
    registration = parseFloat($('#registration').val());

    remaining_amount = net_amount - down_payment - possession  - allotment - confirmation - booking - development - file_processing - registration - ballon - bullating;


 
    if(val == {{\App\CustomerProperty::inst_mon}}) {

        $('#total_installment').val(Math.round(remaining_amount));

        $('#installment').val(Math.round((remaining_amount)/parseInt($('#total_month_per').val())));

        $('#total-months').val( Math.round(parseInt($('#total_month_per').val())));
    }
    else if(val == {{\App\CustomerProperty::inst_bi_mon}}) {

        $('#total_installment').val(Math.round(remaining_amount));

        $('#installment').val(Math.round((remaining_amount)/(parseInt($('#total_month_per').val())/2)));
        
        $('#total-months').val( Math.round(parseInt($('#total_month_per').val()/2)));

    }
    else if(val == {{\App\CustomerProperty::inst_quar}}) {

       
        $('#total_installment').val(Math.round(remaining_amount));

        $('#installment').val(Math.round((remaining_amount)/(parseInt($('#total_month_per').val())/3)));
       
        $('#total-months').val( Math.round(parseInt($('#total_month_per').val()/3)));

    }
    else if(val == {{\App\CustomerProperty::inst_semi}}) {



        $('#total_installment').val(Math.round(remaining_amount));

        $('#installment').val(Math.round((remaining_amount)/(parseInt($('#total_month_per').val())/6)));

        $('#total-months').val( Math.round(parseInt($('#total_month_per').val()/6)));

    }
    else if(val == {{\App\CustomerProperty::inst_ann}}) {


        $('#total_installment').val(Math.round(remaining_amount));

        $('#installment').val(Math.round((remaining_amount)/
            (parseInt($('#total_month_per').val()/12))));
     
        $('#total-months').val( Math.round(parseInt($('#total_month_per').val()/12)));

    }



}


function enableCustom(val) {
    $('#singlepayment').hide();
   
    document.getElementById('custom').style.display = 'block';
    document.getElementById('auto').style.display = 'none';


 

    
}

 



 

function number2TextConversion(num) {

    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';

    return str;
}


 

function activeNormal() {

        document.getElementById('normal').style.display = 'block';
       
        document.getElementById('full_payment').style.display = 'none';
         }

    
    function activeFullPayment() {
        document.getElementById('normal').style.display = 'none';
     
        document.getElementById('full_payment').style.display = 'block';
    }

$('#return_tenure_full_payment').change(function() {
        tenure = $('#return_tenure_full_payment').val();
            total_month = $('#total_tenure_full_payment').val();

            if(tenure == 2) {
                total_month = total_month / 3;
            }
            else if(tenure == 3) {
                total_month = total_month / 6;
            }
            else if(tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_full_payment').val(Math.round($('#net_amount_full_payment').val() / total_month));

            //update the total_installment
        num=$("#per_full_payment").val();
        var str = '';
        if ((num = num.toString()).length < 9){
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (n){
                str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
            }
            $("#per-full-payment-label").text(str);
        }
    });

$('#total_tenure_full_payment').keyup(function() {
        tenure = $('#return_tenure_full_payment').val();
            total_month = $('#total_tenure_full_payment').val();

            if(tenure == 2) {
                total_month = total_month / 3;
            }
            else if(tenure == 3) {
                total_month = total_month / 6;
            }
            else if(tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_full_payment').val(Math.round($('#net_amount_full_payment').val() / total_month));

            //update the total_installment
        num=$("#per_full_payment").val();
        var str = '';
        if ((num = num.toString()).length < 9){
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (n){
                str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
            }
            $("#per-full-payment-label").text(str);
        }
    });

    $('#discount_percentage_full_payment').keyup(function(){

        if($('#discount_percentage_full_payment').val()) {

            price = Math.round(parseFloat($('#discount_percentage_full_payment').val())  / 100 * $('#total_amount_full_payment').val());

            $('#discount_amount_full_payment').val(price);
            $('#net_amount_full_payment').val(price);

            //update per tenure full payment

            tenure = $('#return_tenure_full_payment').val();
            total_month = $('#total_tenure_full_payment').val();

            if(tenure == 2) {
                total_month = total_month / 3;
            }
            else if(tenure == 3) {
                total_month = total_month / 6;
            }
            else if(tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_full_payment').val(Math.round(price / total_month));



//update the total_installment
        num=$("#discount_amount_full_payment").val();
        var str = '';
        if ((num = num.toString()).length < 9){
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (n){
                str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
            }
            $("#discount-amount-full-payment-label").text(str);
        }

        //update the total_installment
        num=$("#net_amount_full_payment").val();
        var str = '';
        if ((num = num.toString()).length < 9){
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (n){
                str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
            }
            $("#net-amount-full-payment-label").text(str);
        }

        //update the total_installment
        num=$("#per_full_payment").val();
        var str = '';
        if ((num = num.toString()).length < 9){
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (n){
                str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
            }
            $("#per-full-payment-label").text(str);
        }
    }
    else {
            $('#discount_amount_full_payment').val('');
        }

     });

$('#deduction_amount_full_payment').keyup(function(){

    if($('#deduction_amount_full_payment').val()) {

            price = Math.round(parseInt($('#discount_amount_full_payment').val()) -  parseInt($('#deduction_amount_full_payment').val()));

            $('#net_amount_full_payment').val(price);

    }
    else {
            $('#net_amount_full_payment').val($('rebate_amount_full_payment').val());
        }

        //update per tenure full payment

            tenure = $('#return_tenure_buy_back').val();
            total_month = $('#total_tenure_buy_back').val();

            if(tenure == 2) {
                total_month = total_month / 3;
            }
            else if(tenure == 3) {
                total_month = total_month / 6;
            }
            else if(tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_buy_back').val(Math.round($('#net_amount_full_payment').val() / total_month));



        //update the total_installment
        num=$("#net_amount_full_payment").val();
        var str = '';
        if ((num = num.toString()).length < 9){
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (n){
                str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
            }
            $("#net-amount-full-payment-label").text(str);
        }

        //update the total_installment
        num=$("#per_full_payment").val();
        var str = '';
        if ((num = num.toString()).length < 9){
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (n){
                str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
            }
            $("#per-full-payment-label").text(str);
        }

     });
    

     
      

    </script>
@stop