@extends('layouts.app')

@section('title')
    Edit Development Charges
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ route('development-charges.list') }}"> List Development Charges</a></li>

        <li class="active">Edit </li>
    </ol>
@stop
@section('css')
    <style>
        .help-block {
            font-weight: bold;
        }

        span {
            display: inline-block;
        }
    </style>

@stop

@section('content')

    @php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphps

    <div class="container-fluid">
        <div class="row">

            <form class="form-horizontal" method='post' action="{{ route('development-charges.update-charges') }}"
                enctype="multipart/form-data" onsubmit="return validateData(this)">
                {{ csrf_field() }}
                <div class="col-md-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="white-box">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Edit Development Charges</h3>
                        <p class="text-muted  font-13"> Note: All * fields are mandatory </p>

                        <hr>

                    </div>
                </div>










                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box1">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa fa-map"></i> Update Unit Type</h3>



                        <hr>
                        <input type="hidden" name='inventory_id' id='inventory-id'>










                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Unit # <span
                                        style="color:red">*</span></label>
                                <div class="col-md-8">
                                    <div id='addUnitDetail'>
                                        <select class="form-control chosen-select" id="unit_number" name="unit_number"
                                            data-id='0'>
                                            <option value="{{ $customer_property->inventory->id }}">
                                                {{ $customer_property->customer->name }} ----
                                                {{ $customer_property->inventory->unit_number }}
                                            </option>
                                        </select>
                                    </div>


                                    @if ($errors->has('unit_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>





                        <input type='hidden' name='customer_property_id' id='customer_property_id'
                            value="{{ $customer_property->id }}">






                        <div class="col-md-6" id="inventory_type">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Type</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="type"
                                        value="{{ $customer_property->inventory->type->name }}" id="type">
                                    @if ($errors->has('type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="clearfix"></div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Size
                                    ({{ $size }})</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="size"
                                        value="{{ $customer_property->inventory->size ? $customer_property->inventory->size->name : '' }}{{ $size }}"
                                        id="size">
                                    @if ($errors->has('size'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('size') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Price</label>
                                <div class="col-md-8">

                                    @php
                                        $total = $customer_property->inventory->total_price - $customer_property->inventory->extra_amount;
                                    @endphp
                                    <input readonly="" type="text" id='total-amount' class="form-control"
                                        name="total_price" value="{{ $total }}">
                                    @if ($errors->has('total_price'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('total_price') }}</strong>
                                        </span>
                                    @endif
                                    <div style="color:black;" class="help-block" id='total-amount-label'></div>
                                </div>
                            </div>

                        </div>


                        <div class="clearfix"></div>


                        @php
                            $name = '';
                            for ($i = 0; $i < sizeof($customer_property->inventory->categories); $i++) {
                                $name += $customer_property->inventory->categories[$i]->category->name + ', ';
                            }
                            
                        @endphp

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Category</label>
                                <div class="col-md-8">

                                    <input readonly="" type="category" class="form-control" name="category"
                                        value="{{ $name }}" id="category">
                                    @if ($errors->has('category'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('category') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>




                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Extra Charges </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='extra_charges' class="form-control"
                                        name="extra_charges" value="{{ $customer_property->inventory->extra_amount }}">

                                    <div style="color:black;" class="help-block" id='extra-charges-label'></div>
                                </div>
                            </div>
                        </div>


                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Unit Description </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='description' class="form-control"
                                        name="description" value="{{ $customer_property->inventory->description }}">


                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Net Amount</label>
                                <div class="col-md-8">
                                    <input type="hidden" id="dummy_net_amount">
                                    <input readonly="" type="text" id='net_amount' class="form-control"
                                        name="net_amount" value="{{ $customer_property->inventory->total_price }}">
                                    @if ($errors->has('net_amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('net_amount') }}</strong>
                                        </span>
                                    @endif
                                    <div style="color:black;" class="help-block" id='net_amount-label'></div>

                                </div>
                            </div>
                        </div>


                        <div class="clearfix"></div>




                        <div class="clearfix"></div>













                        <div class="clearfix"></div>




                    </div>
                </div>








                <div class="col-lg-12 col-sm-12 col-xs-12" id="normal">
                    <div class="white-box">
                        <h3 class="box-title">Payment Scheduler</h3>
                        <hr>


                        <div class="col-md-12">

                            <div class="form-group">


                                <div class="col-md-10">
                                    @php
                                    $total_count = sizeof($customer_statement);
                                    @endphp
                                   

                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::full_payment }}'  {{($total_count==1)?'checked':''}}> Full Payment
                                    </div>




















                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableCustom()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_custom }}'   {{($total_count>1)?'checked':''}}> Custom
                                    </div>


                                    @if ($errors->has('schedule_type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('schedule_type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



















                        {{-- 3rd row --}}

                        <div id='singlepayment'>
                            @if($total_count == 1)
                            @foreach($customer_statement as $cs)
                            @if($cs->due == $cs->received)
                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Development <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 43%;"  
                                            id='development_date' class="form-control"  
                                            placeholder="Date" readonly>

                                        <input style="display: inline-block;width: 49%;"  
                                            class="form-control"   placeholder="Amount" readonly>
                                    </div>
                                </div>
                            </div>
                            @else
                            <div class="form-group">
                                <label class="control-label col-md-3">Development <span
                                        style="color: red">*</span></label>
                                <div class="col-md-9">

                                    <input style="display: inline-block;width: 43%;" type="date"
                                        id='development_date' class="form-control" name="development_date"
                                        placeholder="Date">

                                    <input style="display: inline-block;width: 49%;" type="integer"
                                        class="form-control" name="development_charges" placeholder="Amount">
                                </div>
                            </div>
                        </div>
                            @endif
                            @endforeach
                            @else
                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Development <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 43%;" type="date"
                                            id='development_date' class="form-control" name="development_date"
                                            placeholder="Date">

                                        <input style="display: inline-block;width: 49%;" type="integer"
                                            class="form-control" name="development_charges" placeholder="Amount">
                                    </div>
                                </div>
                            </div>
                            @endif




                            <div class="clearfix"></div>
                            &nbsp;&nbsp;&nbsp;

                            <div class="clearfix"></div>
                        </div>

                        <div class="col-md-1"></div>


                        <div class="clearfix"></div>

                        <div id="auto" style="margin-top: 2%;">

                            <div class="clearfix"></div>

                            <div class="clearfix"></div>


                        </div>

                        <!---Custom-->
                        <div id="custom" style="display: none;">

                            @if($total_count > 1)
                            @foreach($customer_statement as $cs)
                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Installment <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        @if($cs->due == $cs->received)

                                        <input style="display: inline-block;width: 43%;" type="date" id='installment'
                                            class="form-control"   placeholder="Date" value="{{$cs->due_date}}" readonly>

                                        <input style="display: inline-block;width: 49%;" type="integer"
                                            class="form-control"   
                                            placeholder="Amount" value='{{$cs->due}}' readonly>
                                          @else
                                          <input style="display: inline-block;width: 43%;" type="date" id='installment'
                                          class="form-control" name="custom_date[]" placeholder="Date" value="{{$cs->due_date}}">

                                      <input style="display: inline-block;width: 49%;" type="integer"
                                          class="form-control" name="custom_amount[]"  
                                          placeholder="Amount" value='{{$cs->due}}'>
                                          @endif

                                    </div>
                                </div>
                            </div>
                            @endforeach
                            @else

                              <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Installment <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 43%;" type="date" id='installment'
                                            class="form-control" name="custom_date[]" placeholder="Date">

                                        <input style="display: inline-block;width: 49%;" type="integer"
                                            class="form-control" name="custom_amount[]" onkeyup="customPayment()"
                                            placeholder="Amount">
                                    </div>
                                </div>
                            </div>
@endif

                            <div class="clearfix"></div>
                            <div class="input_fields_wrap2 col-md-10">

                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                            <button type="button" class="btn btn-primary add_field_button2">Add
                                Installment</button>&nbsp;&nbsp;&nbsp;

                            <div class="clearfix"></div>
                        </div>

                        <!-- Custom End -->

                    </div>
                </div>
                <!--receipt module -->




                <div class="col-md-12" style="height: 70px;">
                    <div class="alert alert-danger" style="display:none;" role="alert" id="required_field_error">
                        All Fields With * is Required.
                    </div>

                    <button style="float: right;" type="submit"
                        class="btn btn-info  waves-effect waves-light btn-lg">Save</button>
                </div>


        </div>
    </div>


    </form>
    </div>
    </div>



@stop


@section('js')
    <script>
        @if(sizeof($customer_statement) > 1)
       
        $('#singlepayment').hide();
   
   document.getElementById('custom').style.display = 'block';
   document.getElementById('auto').style.display = 'none';
        @endif

        



        function percentage(num, per) {
            return (num / 100) * per;
        }

        function validateData(self) {

            var customer = $(self).find('#customer_id').val();
         

            var development = $(self).find('#development').val();


            if (development == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }






            





        }


        $(document).ready(function() {
            var max_fields = 2; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap3"); //Fields wrapper

            var add_button = $(".add_field_button3"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Nominee Name <span style="color: red">*</span></label><div class="col-md-9"><input type="text" class="form-control" name="nominee_name_n" value="" id="exampleInputuname" placeholder="Enter Name"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">S/O, D/O, W/O.<span style="color: red">*</span></label><div class="col-md-9"><input  type="text" class="form-control" name="nominee_so_do_wo_n" value="" id="exampleInputuname" placeholder="Enter Father Name"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">CNIC</label><div class="col-md-9"><input type="text"  class="form-control" value="" name="nominee_cnic_n" id="nominee_cnic"  placeholder="XXXXXXXXXXXXX"  onfocusout="return validateCnic(this)"><input type="radio" name="nominee_cnic_flag_n" value="1"> Locally<input type="radio" name="nominee_cnic_flag_n" value="2"> Internationally</div><div style="color: red;display: none;" class="col-md-12"  id="cnic_error1">This Customer cnic is found in list of DNFBP. You cant add this Customer record. </div></div></div> <div class="col-md-6"><div class="form-group" id="nominee_address"><label for="address" class="col-sm-3 control-label" id="nominee_address">Nominee Address <span style="color: red">*</span></label><div class="col-sm-9"><div class="input-group"><div class="input-group-addon"><i class="icon-location-pin"></i></div><textarea class="form-control" id="nominee_address" name="nominee_address" ></textarea></div></div> </div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Passport No.</label><div class="col-md-9"><input type="text"  class="form-control" value="" name="nominee_passport_no_n" id="nominee_passport_no"  placeholder="XXXXXXXXX" ></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Relation With Applicant <span style="color: red">*</span></label><div class="col-md-9"><input type="text" class="form-control" name="nominee_relation_n" value=""  placeholder="Enter Relation"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Email</label><div class="col-md-9"><input type="text" class="form-control" name="nominee_email_n" value=""  placeholder="Enter Email"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Mobile Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_mobile_number_n" value=""  placeholder="Enter Mobile Number"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Res. Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_res_number_n" value=""  placeholder="Enter Res Number"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Phone Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_phone_number_n" value=""  placeholder="Enter Phone Number"></div></div></div><a href="#"class="remove_field">Remove</a>'
                        ); //add input box

                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })

        });


        //multiple dealers












        //custom
        $(document).ready(function() {
            var max_fields = 100; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap2"); //Fields wrapper
            var wrapper1 = $(".input_fields_wrap2"); //Fields wrapper
            var add_button = $(".add_field_button2"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div  ><div class="form-group"><label class="control-label col-md-3">Installment-' +
                        x +
                        ' <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 43%;margin-right: 4px;" type="date" class="form-control" name="custom_date[]" placeholder="Date"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount"></div> </div><a href="#" class="remove_field">Remove</a>'
                        ); //add input box
                    $(".bdpk").datepicker({
                        dateFormat: "dd-mm-yy"
                    });
                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
            $(wrapper1).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
        });

        //end custom
    </script>




    <script>
        var a = ['', 'one ', 'two ', 'three ', 'four ', 'five ', 'six ', 'seven ', 'eight ', 'nine ', 'ten ', 'eleven ',
            'twelve ', 'thirteen ', 'fourteen ', 'fifteen ', 'sixteen ', 'seventeen ', 'eighteen ', 'nineteen '
        ];
        var b = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];

        //update the cost label



      



        //update the registration


        //update the booking







        //update the possession










        //update the installment label


        @php
            $size = '';
            
            if ($projectType->id == \App\ProjectType::society) {
                $size = \App\ProjectType::society_size;
            } else {
                $size = \App\ProjectType::high_rise_size;
            }
            
        @endphp























        function number2TextConversion(num) {

            if ((num = num.toString()).length > 9) return 'overflow';
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return;
            var str = '';
            str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
            str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
            str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
            str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
            str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) +
                'only ' : '';

            return str;
        }




        function activeNormal() {

            document.getElementById('normal').style.display = 'block';

            document.getElementById('full_payment').style.display = 'none';
        }


        function activeFullPayment() {
            document.getElementById('normal').style.display = 'none';

            document.getElementById('full_payment').style.display = 'block';
        }

        $('#return_tenure_full_payment').change(function() {
            tenure = $('#return_tenure_full_payment').val();
            total_month = $('#total_tenure_full_payment').val();

            if (tenure == 2) {
                total_month = total_month / 3;
            } else if (tenure == 3) {
                total_month = total_month / 6;
            } else if (tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_full_payment').val(Math.round($('#net_amount_full_payment').val() / total_month));

            //update the total_installment
            num = $("#per_full_payment").val();
            var str = '';
            if ((num = num.toString()).length < 9) {
                n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                if (n) {
                    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5]
                        [1]]) + 'only ' : '';
                }
                $("#per-full-payment-label").text(str);
            }
        });

        $('#total_tenure_full_payment').keyup(function() {
            tenure = $('#return_tenure_full_payment').val();
            total_month = $('#total_tenure_full_payment').val();

            if (tenure == 2) {
                total_month = total_month / 3;
            } else if (tenure == 3) {
                total_month = total_month / 6;
            } else if (tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_full_payment').val(Math.round($('#net_amount_full_payment').val() / total_month));

            //update the total_installment
            num = $("#per_full_payment").val();
            var str = '';
            if ((num = num.toString()).length < 9) {
                n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                if (n) {
                    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5]
                        [1]]) + 'only ' : '';
                }
                $("#per-full-payment-label").text(str);
            }
        });

        function disableAnn() {
    $('#singlepayment').show();
  
    document.getElementById('custom').style.display = 'none';
    document.getElementById('auto').style.display = 'block';

    

 
     



}


function enableCustom() {
    $('#singlepayment').hide();
   
    document.getElementById('custom').style.display = 'block';
    document.getElementById('auto').style.display = 'none';


 

}    





      
    </script>
@stop
