 <!--.row-->
 @php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp

@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp
'<div class="col-sm-12">
    <div class="white-box">

        <h3 class="box-title">All Development Statement </h3>

        <div class="table-responsive">
            <table id="myTable" class="table table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Project</th>

                        <th>Unit #</th>
                        <th>Size</th>
                        <th>Member Name</th>
                        <th>Development Charges</th>

                        <th>Received Development Charges</th>

                        <th>Booking Date</th>
                        <th>Status</th>
                        <th style="width: 185px!important;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $count = 1; ?>
                    @permission('view-membership')
                        <?php $view_membership = true; ?>
                    @else
                        <?php $view_membership = false; ?>
                    @endpermission

                    @permission('create-schedule')
                        <?php $create_schedule = true; ?>
                    @else
                        <?php $create_schedule = false; ?>
                    @endpermission

                    @permission('edit-membership')
                        <?php $edit_membership = true; ?>
                    @else
                        <?php $edit_membership = false; ?>
                    @endpermission

                    @permission('delete-membership')
                        <?php $delete_membership = true; ?>
                    @else
                        <?php $delete_membership = false; ?>
                    @endpermission

                    @permission('download-membership')
                        <?php $download_membership = true; ?>
                    @else
                        <?php $download_membership = false; ?>
                    @endpermission

                    @permission('reminder-membership')
                        <?php $reminder_membership = true; ?>
                    @else
                        <?php $reminder_membership = false; ?>
                    @endpermission

                    @permission('sms-membership')
                        <?php $sms_membership = true; ?>
                    @else
                        <?php $sms_membership = false; ?>
                    @endpermission

                    @foreach ($allStatements as $statement)
                        <tr>
                            <td>{{ $count++ }}</td>
                            <td>
                                @if ($statement->inventory)
                                    @if ($statement->inventory->multiProject)
                                        {{ $statement->inventory->multiProject->name }}
                                    @else
                                        None
                                    @endif
                                @endif
                            </td>

                            <td>{{ $statement->inventory ? $statement->inventory->unit_number : '' }}</td>
                            <td>
                                @if ($statement->inventory)
                                    @if ($statement->inventory->size)
                                        {{ $statement->inventory->size->name }}

                                        {{ $size }}
                                    @endif
                                @endif
                            </td>
                            <td>{{ $statement->customer ? $statement->customer->name : '' }}<br><b>Dealer:
                                </b>{{ $statement->dealer ? $statement->dealer->name : '' }}</td>

                            <td><b>{{ number_format($statement->development_fee) }}</b></td>




                            <td><b>{{ number_format($receivedAmt[$statement->id]) }}</b></td>





                            <td>{{ date('d-m-Y', strtotime($statement->booking_date)) }}</td>



                            @if ($statement->status == \App\CustomerProperty::pending)
                                <td><span class="label label-primary"
                                        style="background-color:#cd703d;">Pending</span></td>
                            @elseif($statement->status == \App\CustomerProperty::approved)
                                <td><span class="label label-success">Approved</span></td>
                            @elseif($statement->status == \App\CustomerProperty::cancel)
                                <td><span class="label label-danger">Canceled</span></td>
                            @elseif($statement->status == \App\CustomerProperty::block)
                                <td><span class="label label-danger"
                                        style="background-color:#f80c0c;">Block</span></td>
                            @else
                                <td></td>
                            @endif



                            <td class="text-nowrap">
                                @if ($view_membership)
                                    <a href="{{ route('statement.detail', ['id' => $statement->id]) }}"
                                        data-toggle="tooltip" data-original-title="View"> <i
                                            class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                @endif



                                @if ($edit_membership)
                                    <a href="{{ route('development-charges.edit-charges', ['id' => $statement->id]) }}"
                                        data-toggle="tooltip" data-original-title="Edit"> <i
                                            class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                @endif

                               
                              

                              
                             


                            </td>

                        </tr>

                    @endforeach

                </tbody>
            </table>
          
        </div>
    </div>
</div>