@extends( 'layouts.app')

@section('title')
Update Statement 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-membership')
        <li ><a href="{{route('statement.all')}}">Statements</a></li>
        @endpermission
        <li class="active">Edit Statement</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
    <div class="row">

        <div class="col-md-12">
            <div class="white-box">
                            <h3 class="box-title m-b-0">Update Reference No</h3><hr>

            <form method='post' action="{{route('statement.updatePending')}}" enctype="multipart/form-data">
                {{csrf_field()}}
                <input type="hidden" value="{{$property->id}}" name="id">

                  <div class="col-lg-12 col-sm-12 col-xs-12">

                              <div class="col-md-8">
                                                    <div class="form-group">
                                                        <label style="padding-top: 8px;" class="control-label col-md-4">Reference No <span style="color: red">*</span></label>
                                                        <div class="col-md-8">

                                                            <input type="text" class="form-control" name="membership_no" value="AAA_BC_00{{$property->id}}" id="exampleInputEmail1" placeholder="Enter Reference">
                                        @if ($errors->has('membership_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('membership_no') }}</strong>
                                    </span>
                                @endif</div>
                                                    </div>
                            </div>



<div class="col-md-8">
                            <div class="form-group" >
                                    <label for="inputPassword3" class="col-sm-4 control-label">Status<span style="color: red">*</span></label>
                                    <div class="col-sm-8">
                                        <div class="input-group">
                                            <select class="form-control chosen-select" style="width:300px" name="status">
                                                @if($property->status == \App\CustomerProperty::pending)
                                                <option value='{{\App\CustomerProperty::pending}}' selected="">Pending</option>
                                                <option value="{{\App\CustomerProperty::approved}}">Approved</option>
                                                <option value="{{\App\CustomerProperty::cancel}}">Cancel</option>

                                                @elseif($property->status == \App\CustomerProperty::approved)
                                                <option value='{{\App\CustomerProperty::pending}}'>Pending</option>
                                                <option value="{{\App\CustomerProperty::approved}}" selected="">Approved</option>
                                                <option value="{{\App\CustomerProperty::cancel}}" >Cancel</option>

                                                @elseif($property->status == \App\CustomerProperty::cancel)
                                                <option value='{{\App\CustomerProperty::pending}}'>Pending</option>
                                                <option value="{{\App\CustomerProperty::approved}}">Approved</option>
                                                <option value="{{\App\CustomerProperty::cancel}}" selected="">Cancel</option>

                                                @endif

                                            </select>

                                        @if ($errors->has('status'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('status') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
</div>


                        </div>
                        <input type="checkbox" name="notify_sms" value="1"> Sms Notification<br>
                    <input type="checkbox" name="notify_email" value="1"> Email Notification
                    </div>




                                <div class="form-group m-b-0 pull-right">
                    <div class="col-sm-offset-3 col-sm-9">
                        <button type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                    </div>
              </div>
                        </div>
                    </div>
</form>
    </div>
</div>


@stop
