@extends('layouts.app')

@section('title')
    All Statements
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Statements</li>
    </ol>
@stop
@section('css')

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

@stop

@section('content')

    @php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphp

    @php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    @endphp


    <div class="container-fluid">
        <!-- /row -->
        @can('isSuperAdmin')
            @include('partial.multiproject_select')
        @endcan
        <!--.row-->
        <div id='updatecontent'>
        <div class="row" style="margin-top: 25px;">
            <div class="col-md-12">
                <div class="panel panel-info">
                    <div class="panel-heading">Search Statements</div>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body">
                            <form>
                                <div class="form-body">
                                    <div class="row">
                                        <!--/span-->

                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit No.</label>

                                                <select id="unit" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    @foreach ($unitNumbers as $p)
                                                        <option value="{{ $p->id }}">{{ $p->unit_number }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->
                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Customer</label>

                                                <select id="customer" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    @foreach ($customers as $c)
                                                        <option value="{{ $c->id }}">{{ $c->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Dealer</label>

                                                <select id="dealer" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    @foreach ($dealers as $d)
                                                        <option value="{{ $d->id }}">
                                                            {{ $d->name }}-{{ $d->code }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By status</label>
                                                <select id="status" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    <option value="{{ \App\CustomerProperty::approved }}">Approved</option>
                                                    <option value="{{ \App\CustomerProperty::pending }}">Pending</option>
                                                    <option value="{{ \App\CustomerProperty::cancel }}">Cancelled</option>

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit Size</label>
                                                <select id="unit_size" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    @foreach ($unitSize as $s)
                                                        <option value="{{ $s->id }}">{{ $s->name }}
                                                            {{ $size }}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit Type</label>
                                                <select id="unit_type" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    @foreach ($unitType as $s)
                                                        <option value="{{ $s->id }}">{{ $s->name }}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->


                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit Block</label>
                                                <select id="unit_block" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    @foreach ($unitBlock as $s)
                                                        <option value="{{ $s->id }}">{{ $s->name }}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->



                                        <div class="col-md-3">
                                            <div class="form-actions" style="margin-top: 26px">
                                                <button type="button" class="btn btn-success search-customer"> <i
                                                        class="fa fa-check"></i> Search</button>

                                            </div>
                                        </div>


                                    </div>

                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--./row-->

        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Statement ({{ number_format($statementCount) }})</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Project</th>

                                    <th>Unit #</th>
                                    <th>Size</th>
                                    <th>Member Name</th>
                                    <th>Net Amount</th>

                                    <th>Received Amount</th>

                                    <th>Booking Date</th>
                                    <th>Status</th>
                                    <th style="width: 185px!important;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                @permission('view-membership')
                                    <?php $view_membership = true; ?>
                                @else
                                    <?php $view_membership = false; ?>
                                @endpermission

                                @permission('create-schedule')
                                    <?php $create_schedule = true; ?>
                                @else
                                    <?php $create_schedule = false; ?>
                                @endpermission

                                @permission('edit-membership')
                                    <?php $edit_membership = true; ?>
                                @else
                                    <?php $edit_membership = false; ?>
                                @endpermission

                                @permission('delete-membership')
                                    <?php $delete_membership = true; ?>
                                @else
                                    <?php $delete_membership = false; ?>
                                @endpermission

                                @permission('download-membership')
                                    <?php $download_membership = true; ?>
                                @else
                                    <?php $download_membership = false; ?>
                                @endpermission

                                @permission('reminder-membership')
                                    <?php $reminder_membership = true; ?>
                                @else
                                    <?php $reminder_membership = false; ?>
                                @endpermission

                                @permission('sms-membership')
                                    <?php $sms_membership = true; ?>
                                @else
                                    <?php $sms_membership = false; ?>
                                @endpermission

                                @foreach ($allStatements as $statement)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>
                                            @if ($statement->inventory)
                                                @if ($statement->inventory->multiProject)
                                                    {{ $statement->inventory->multiProject->name }}
                                                @else
                                                    None
                                                @endif
                                            @endif
                                        </td>

                                        <td>{{ $statement->inventory ? $statement->inventory->unit_number : '' }}</td>
                                        <td>
                                            @if ($statement->inventory)
                                                @if ($statement->inventory->size)
                                                    {{ $statement->inventory->size->name }}

                                                    {{ $size }}
                                                @endif
                                            @endif
                                        </td>
                                        <td>{{ $statement->customer ? $statement->customer->name : '' }}<br><b>Dealer:
                                            </b>{{ $statement->dealer ? $statement->dealer->name : '' }}</td>

                                        <td><b>{{ number_format($statement->net_pay) }}</b></td>




                                        <td><b>{{ number_format($receivedAmt[$statement->id]) }}</b></td>





                                        <td>{{ date('d-m-Y', strtotime($statement->booking_date)) }}</td>



                                        @if ($statement->status == \App\CustomerProperty::pending)
                                            <td><span class="label label-primary"
                                                    style="background-color:#cd703d;">Pending</span></td>
                                        @elseif($statement->status == \App\CustomerProperty::approved)
                                            <td><span class="label label-success">Approved</span></td>
                                        @elseif($statement->status == \App\CustomerProperty::cancel)
                                            <td><span class="label label-danger">Canceled</span></td>
                                        @elseif($statement->status == \App\CustomerProperty::block)
                                            <td><span class="label label-danger"
                                                    style="background-color:#f80c0c;">Block</span></td>
                                        @else
                                            <td></td>
                                        @endif



                                        <td class="text-nowrap">
                                            @if ($view_membership)
                                                <a href="{{ route('statement.detail', ['id' => $statement->id]) }}"
                                                    data-toggle="tooltip" data-original-title="View"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            @endif



                                            @if ($edit_membership)
                                                <a href="{{ route('statement.editViewCustomer', ['id' => $statement->id]) }}"
                                                    data-toggle="tooltip" data-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            @endif

                                            @if ($statement->status != \App\CustomerProperty::approved)
                                                @if ($delete_membership)
                                                    <a href="{{ route('statement.delete', ['id' => $statement->id]) }}"
                                                        data-toggle="confirmation" data-title="Are you sure to delete?">
                                                        <i
                                                            class="fa fa-close text-danger"></i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a>
                                                @endif
                                            @endif
                                            @if ($download_membership)
                                                <a target="_blank"
                                                    href="{{ route('membership.download', ['id' => $statement->id]) }}"
                                                    data-toggle="tooltip" data-original-title="Download"> <i
                                                        class="fa fa-download text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            @endif

                                            @if ($reminder_membership)

                                                @if ($statement->reminder_text)
                                                    @if ($statement->reminder_date)
                                                        @if ($statement->reminder_date < \Carbon\Carbon::now())
                                                            <a href="#"
                                                                onclick="openReminderModal({{ $statement->id }})"
                                                                data-toggle="tooltip"
                                                                data-original-title="Overdue Reminder"
                                                                style="color: red;"> <i
                                                                    class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        @else
                                                            <a href="#"
                                                                onclick="openReminderModal({{ $statement->id }})"
                                                                data-toggle="tooltip"
                                                                data-original-title="Coming Reminder"
                                                                style="color: green;"> <i
                                                                    class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        @endif
                                                    @else
                                                        <a href="#"
                                                            onclick="openReminderModal({{ $statement->id }})"
                                                            data-toggle="tooltip"
                                                            data-original-title="See Coming Reminder"
                                                            style="color: green;"> <i
                                                                class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                    @endif
                                                @else
                                                    <a href="#" onclick="openReminderModal({{ $statement->id }})"
                                                        data-toggle="tooltip" data-original-title="Reminder"> <i
                                                            class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                @endif

                                            @endif

                                            @if ($sms_membership)
                                                <a href="#" onclick="openSmsModal({{ $statement->id }})"><i
                                                        class="fa fa-comment"></i>&nbsp;&nbsp;&nbsp;&nbsp;</a>
                                            @endif

                                            @if (!empty($statement->inventory->dealerPackageOpenFileUnit))
                                                @if ($statement->status == \App\CustomerProperty::approved)
                                                    <a href="{{ route('statement.letter', [$statement->id]) }}"
                                                        data-toggle="tooltip" data-original-title="Registration-Letter"><i
                                                            class="fa fa-envelope" aria-hidden="true"></i>&nbsp;&nbsp;</a>
                                                @endif
                                            @endif



                                        </td>

                                    </tr>

                                @endforeach

                            </tbody>
                        </table>
                        <div style="float: right;">{{ $allStatements->links() }}</div>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

    </div>


    <div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

    </div>

@stop

@section('js')

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'ordering': false,
                'sorting': false,
                'info': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });

        function callItBack(){
        $('.search-customer').on('click', function() {
            $('.preloader').fadeIn();
            unit = $('#unit').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            status = $('#status').val();
            unit_size = $('#unit_size').val();
            unit_type = $('#unit_type').val();
            unit_block = $('#unit_block').val();
            var multipro_id = "";
            if ($("#multipro").length > 0) {
                if ($("#multipro").val() !== 'search') {
                    multipro_id = $("#multipro").val();
                }
                // Do something with the value
            }



            if (unit == 0 && customer == 0 && status == 0 && dealer == 0 && unit_size == 0 && unit_type == 0 &&
                unit_block == 0 && multipro_id == 0) {
                toastr.warning("please select any option.");
                $('.preloader').fadeOut();
                return false;
            }

            var data = {
                'multipro_id': multipro_id,
                'unit': unit,
                'customer': customer,
                'dealer': dealer,
                'status': status,
                'unit_size': unit_size,
                'unit_type': unit_type,
                'unit_block': unit_block
            };
            $.get('/statement/updateTable', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });
        });




        function openSmsModal(property_id) {

            var data = {
                'property_id': property_id
            };
            $.get('/update_sms_modal', data, function(data) {
                document.getElementById('exampleModal').innerHTML = data;
                $('#exampleModal').modal();
            });
        }

        function openReminderModal(property_id) {

            var data = {
                'property_id': property_id
            };
            $.get('/update_reminder_modal', data, function(data) {
                document.getElementById('exampleModal1').innerHTML = data;
                $('#exampleModal1').modal();
            });
        }
    }
    callItBack();


        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('{{ route('statement.all') }}', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();

                $('.chosen-select').chosen('destroy');

                document.getElementById('updatecontent').innerHTML = data;
                $('.chosen-select').trigger('chosen:updated');
                callItBack();
                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }


    </script>
@stop
