@extends('layouts.app')

@section('title')
    Update Statement
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-membership')
            <li><a href="{{ route('statement.all') }}">Statements</a></li>
        @endpermission
        <li class="active">Cancel Statement</li>
    </ol>
@stop
@section('content')

    <div class="container-fluid">
        <div class="row">

            <div class="col-md-12">
                <div class="white-box">
                    <h3 class="box-title m-b-0">Cancel Property </h3>
                    <hr>

                    <form method='post' action="{{ route('statement.cancel.new') }}" enctype="multipart/form-data">
                        {{ csrf_field() }}


                        <div class="col-lg-12 col-sm-12 col-xs-12">

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Property No <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-8">

                                        <select name="property_no" class="form-control select2">
                                            @foreach ($allStatements as $s)
                                                <option value="{{ $s->id }}">{{ $s->customer->name }} -
                                                    {{ $s->inventory->unit_number }} - {{ $s->membership_no }}</option>
                                            @endforeach
                                        </select>
                                        @if ($errors->has('property_no'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('property_no') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="inputPassword3" class="col-sm-4 control-label">Status<span
                                            style="color: red">*</span></label>
                                    <div class="col-sm-8">
                                        <div class="input-group">
                                            <select class="form-control chosen-select" style="width:300px" name="status">

                                                <option value="{{ \App\CustomerProperty::cancel }}">Cancel</option>

                                            </select>

                                            @if ($errors->has('status'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('status') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>

                </div>




                <div class="form-group m-b-0 pull-right">
                    <div class="col-sm-offset-3 col-sm-9">
                        <button type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                    </div>
                </div>
            </div>
        </div>
        </form>
    </div>
    </div>


@stop
