@extends('layouts.app')

@section('title')
    Edit Cancellation Request
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-cancellation')
            <li><a href="{{ route('property.refund') }}">All Refund Units</a></li>
        @endpermission
        <li class="active">Edit Refund Unit Request </li>
    </ol>
@stop
@section('content')
    <style>

    </style>
    <div class="container-fluid">


        <div class="container-fluid" style='background: white;
        border: 1px solid #e5ebec;'>
            <h2>Refund Request Information</h2>



            <form method='post' action="{{ route('property.refund.update') }}" enctype="multipart/form-data">
                {{ csrf_field() }}



                {{-- Adjust or Refund Property  --}}
                <div class="form-group" id='adjust_refund'>

             <input type='hidden' name='id' value={{$allStatements->cancelProperty->id}}>

                    {{-- Refund Div --}}
                    <div class="form-horizontal" id='refunded_portion'>

                        <div class="form-group">
                            <label class="control-label col-sm-2" for="email">Total Received Amount:</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control" id="total_paid_amount" 
                                    value={{ $received_amount }} style='width:59%' readonly>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-2" for="pwd">Add Deduction Charges:</label>
                            <div class="col-sm-10" style='display: flex'>
                                <input type="number" class="form-control" id="refund_amount_deducted"
                                    placeholder="Enter..." name='refund_amount_deducted' style='width:50%' value={{($allStatements->unitRefundHistory)?$allStatements->unitRefundHistory->total_deduct:0}} oninput="getPerIf(this)">
                                <select id='refund_deduction_type' name="refund_deduction_type"
                                    onchange="refundValueType(this)" class="custom-select mb-3">
                             
                                    @if($allStatements->unitRefundHistory)
                                    <option value="{{App\UnitRefundHistory::REFUND_DEDUCTUION_IN_PKR}}" selected>Rs</option>
                                    <option value="{{App\UnitRefundHistory::REFUND_DEDUCTUION_IN_PERCENTAGE}}">%</option>
                                 
                                 @else
                                 <option value="{{App\UnitRefundHistory::REFUND_DEDUCTUION_IN_PKR}}" selected>Rs</option>
                                 <option value="{{App\UnitRefundHistory::REFUND_DEDUCTUION_IN_PERCENTAGE}}">%</option>
                              
                                 @endif
                                </select>
                                @if ($errors->has('refund_amount_deducted'))
                                <span class="help-block">
                                    {{ $errors->first('refund_amount_deducted') }}
                                </span>
                            @endif
                            </div>
                            

                           
                        </div>
                        <div class="form-group">
                        <div style='display:none' id='per_for_refund_deduction'>
                            <label class="control-label col-sm-2" for="pwd">Your Percentage Amount:</label>
                            <div class="col-sm-10">
                                <input type="number" class="form-control" id="refund_amount_deducted_per"
                                    style='width:30%' readonly>
                            </div>
                        </div>
                        </div>


                        <div class="form-group">
                            <label class="control-label col-sm-2" for="pwd" style='    margin-top: 10px;'>Status<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group" style='margin-top: 10px;'>
        
                                    <select class="custom-select mb-3 chosen-select" style="width:300px; " name="status"  >
                            
                                            <option value="{{App\UnitRefundHistory::REFUND_DECISION_PENDING}}" selected >Pending</option>
                                            <option value="{{App\UnitRefundHistory::REFUND_DECISION_APPROVED}}">Approve</option>
                                            <option value="{{App\UnitRefundHistory::REFUND_DECISION_DECLINE}}">Decline</option>
                                           
                                    
        
                                    </select>
                                    @if ($errors->has('status'))
                                        <span class="help-block">
                                            {{ $errors->first('status') }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                    {{-- End Refund Div --}}







                </div>
                {{-- End Adjust or Refund Property --}}
                <div class="form-group">
                    <div class="col-sm-offset-2 col-sm-10">
                        <button type="submit" class="btn btn-info  waves-effect waves-light "
                            style='    margin-top: 10px;'>Save</button>
                    </div>
                </div>













            </form>
        </div>


        <div class="container-fluid" style='background: white;
                     border: 1px solid #e5ebec;     margin-top: 3%; '>
            <h2>Request Information</h2>

            <div class="col-lg-12" id="payment_div">
                <div class="white-box1 ">
                    <h4 class="box-title " style=" color: white; background-color:#1c3752; line-height: 30px">
                        &nbsp;&nbsp;Detail</h4>

                    <div class="col-md-12 col-xs-12">
                        <div class="table-responsive">
                            <table class="table bottom-table">
                                <tbody class="printFW">

                                    <tr>
                                        <td style="font-weight: 600;">Property No: </td>
                                        <td> {{ $allStatements->customer->name }} -
                                            {{ $allStatements->inventory->unit_number }} -
                                            {{ $allStatements->membership_no }}</td>


                                        <td style="font-weight: 600;">Request: </td>
                                        <td>Cancel </td>




                                    </tr>


                                    <tr>

                                        <td style="font-weight: 600;">Unit Status:</td>

                                        @if ($allStatements->status == \App\CustomerProperty::pending)
                                        <td><span class="label label-primary"
                                                style="background-color:#cd703d;">Pending</span></td>
                                    @elseif($allStatements->status == \App\CustomerProperty::approved)
                                        <td><span class="label label-success">Approved</span></td>
                                    @elseif($allStatements->status == \App\CustomerProperty::cancel)
                                        <td><span class="label label-danger">Canceled</span></td>
                                    @else
                                        <td></td>
                                    @endif
                                        <td style="font-weight: 600;">Fee/Charges: </td>
                                        <td>{{ $allStatements->cancelProperty->fee }}</td>
                                        



                                    </tr>

                                    <tr>

                                        <td style="font-weight: 600;">After Cancellation Decision Request:</td>

                                       
                                       

                                        @if ($allStatements->cancelProperty->after_cancellation_status == 'pending')
                                        <td><span class="label label-primary"
                                            style="background-color:#cd703d;">Pending</span></td>
                                        @elseif($allStatements->cancelProperty->after_cancellation_status == 'adjust-pending')
                                        <td><span class="label label-success">Adjust/Pending</span></td>
                                        @elseif($allStatements->cancelProperty->after_cancellation_status == 'refund-pending')
                                        <td><span class="label label-success">Refund/Pending</span></td>

                                        @elseif($allStatements->cancelProperty->after_cancellation_status == 'adjusted')
                                        <td><span class="label label-success">Adjusted</span></td>
                                        @elseif($allStatements->cancelProperty->after_cancellation_status == 'refunded')
                                        <td><span class="label label-success">Refunded</span></td>
                                        @elseif($allStatements->cancelProperty->after_cancellation_status == 'decline')
                                        <td><span class="label label-success"  style="background-color:#e80d0d;">Decline</span></td>
                                        @endif
                                        
                                       

                                    </tr>


                                </tbody>
                            </table>
                        </div>
                        <div class="clear"></div>
                    </div>

                </div>
            </div>


            {{-- <form method='post' action="{{ route('statement.cancel.update') }}" enctype="multipart/form-data">
                {{ csrf_field() }}
                <input type='hidden' value={{ $allStatements->id }} name='property_no'>
                <div class="form-group">
                    <label class="control-label col-sm-2" for="property_no">Property No <span
                            style="color: red">*</span>:</label>
                    <div class="col-sm-10">
                        <div class="input-group">
                            <select class="form-control js-example-basic-multiple" multiple="multiple">

                                <option value="{{ $allStatements->id }}" selected>{{ $allStatements->customer->name }} -
                                    {{ $allStatements->inventory->unit_number }} - {{ $allStatements->membership_no }}
                                </option>

                            </select>
                            @if ($errors->has('property_no'))
                                <span class="help-block">
                                    {{ $errors->first('property_no') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='    margin-top: 15px;'>Request<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px;'>
                            <select class="form-control chosen-select" style="width:300px; " name="status">

                                <option value="{{ \App\CustomerProperty::cancel }}" selected>Cancel</option>

                            </select>

                            @if ($errors->has('status'))
                                <span class="help-block">
                                    {{ $errors->first('status') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>



                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='    margin-top: 10px;'>Fee/Charges<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px;'>

                            <input type="number" class="form-control" placeholder="Add fee" name='fee'
                                value='{{ $allStatements->cancelProperty->fee }}'>
                            @if ($errors->has('fee'))
                                <span class="help-block">
                                    {{ $errors->first('fee') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='    margin-top: 10px;'>Status<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px;'>

                            <select class="form-control chosen-select" style="width:300px; " name="property_status"
                                onchange="getval(this)">
                                @if ($allStatements->cancelProperty->status == 0)
                                    <option value="0" selected style=" background: red;">Pending</option>

                                    <option value="1" style=" background: green;">Approve</option>
                                @elseif($allStatements->cancelProperty->status == 1)
                                    <option value="0" style=" background: red;">Pending</option>

                                    <option value="1" selected style=" background: green;">Approve</option>
                                @endif

                            </select>
                            @if ($errors->has('status'))
                                <span class="help-block">
                                    {{ $errors->first('status') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div> --}}





            {{-- Adjust or Refund Property  --}}

            {{-- End Adjust or Refund Property --}}




















            {{-- <div class="form-group">
                    <div class="col-sm-offset-2 col-sm-10">
                        <button type="submit" class="btn btn-info  waves-effect waves-light "
                            style='    margin-top: 10px;'>Save</button>
                    </div>
                </div>
            </form> --}}
        </div>




    </div>



@stop
@section('js')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-multiple').select2({
                disabled: true
            });
        });

        function findPercentage(value, totalpaidamount) {

            return (value / 100) * totalpaidamount;
        }

        function getval(sel) {

            if (sel.value == 1) {

                $("#adjust_refund").show();

            } else if (sel.value == 0) {
                $("#adjust_refund").hide();
            }
        }

        function adjusOrRefund(sel) {

            if (sel.value == 1) {
                $("#refunded_portion").hide();
                //    $("#adjust_refund").show();

            } else if (sel.value == 0) {
                //    $("#refunded_portion").hide();
                $("#refunded_portion").show();
            }
        }

        function refundValueType(sel) {

            if (sel.value == 0) {
                $("#per_for_refund_deduction").hide();
                //    $("#adjust_refund").show();
                $("#refund_amount_deducted_per").val(0);

            } else if (sel.value == 1) {
                //    $("#refunded_portion").hide();
                $("#per_for_refund_deduction").show();



                var totalpaidamount = $("#total_paid_amount").val(); //total paid value
                var value = $("#refund_amount_deducted").val();

                result = findPercentage(value, totalpaidamount);
                //    (sel.value /100) * totalpaidamount;
                $("#refund_amount_deducted_per").val(result);
            }
        }

        function getPerIf(sel) {
            //refund_deduction_type
            var deductiontype = $('#refund_deduction_type').find(":selected").val();

            if (deductiontype == 1) {
                // '#refund_amount_deducted_per';
                var totalpaidamount = $("#total_paid_amount").val(); //total paid value
                result = findPercentage(sel.value, totalpaidamount);
                //    (sel.value /100) * totalpaidamount;
                $("#refund_amount_deducted_per").val(result);

            }


        }
    </script>
@stop
