@extends('layouts.app')


@section('title')
Detail of Customer Refund Property Statement 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    @permission('view-cancellation')
    <li><a href="{{ route('property.refund') }}">All Refund Units</a></li>
@endpermission
    <li class="active">Refund Statement Detail</li>
</ol>
@stop

@section('css')
<style type="text/css">
    .bg-color{
        background-color: #1c3752;
    }
    .anchor-link
    {
        display: none;
    }
</style>
<style type="text/css" media="print">
    
    @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        color: black !important;
        }
        h3{
            line-height: 1px;
        }

          h3 strong{
        text-transform: uppercase;
        color: black !important
    }
    h4 strong{
        text-transform: uppercase;
        color: black !important
    }
    .printFH11 {
    font-size: 13px;
    font-weight: 800;
    background-color: #000000;
    }
    .white-box .box-title {
    margin: 0px 0px 4px 0px;
    font-weight: 700;
    font-size: 14px;
    color: #1c3752;
    background-color: #000000 !important;
    }
    .white-box {
    padding: 0px 0px 2px 0px;
    margin-bottom: 0px;
    margin-bottom: 0;
    border-radius: inherit;
    }
    .table {
    width: 100% !important;
    margin-bottom: 5px;
    margin-top: -2px;
    }
    .table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th {
    vertical-align: top;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    }
</style>

@stop

@section('content')

<div class="container-fluid">
    <div class="row printableArea"  id="htmlContent">

        <div class="col-lg-12 text-center">
   
            <!-- <div class="pull-left hidden-lg">-->



        </div><div class="clear"></div>
            <div class="text-center">
                <h3><strong>{{env('APP_NAME')}}</strong></h3>
                <h4>Account Statement Before Refund</h4>
            </div>
        <div class="col-lg-12">
            <div class="white-box1 ">
                <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px" id="text_detail">&nbsp;&nbsp;Member Information</h4>
                    @php
                      $ownerArray[] =$unit_refund->customer->name;

if(!empty($unit_refund->customer->first_owner))
{
     $ownerArray[] = $unit_refund->customer->first_owner;
}

if(!empty($unit_refund->customer->second_owner))
{
     $ownerArray[] = $unit_refund->customer->second_owner;
}

                   

                    @endphp
                <div class="pull-left" style="width:100%">
                    <div class="table-responsive">
                        <table class="table bottom-table" id="main_customer_info">
                            <tbody class="printFW">
                                
                               
                                <tr>
                                    <td style="font-weight: 600;"> <?= ( $unit_refund->customer->type  == 1) ? 'Company Name:' : 'Member Name:' ?></td>
                                    <td> 
                                        @if(count($ownerArray) > 1)
                                            {{$unit_refund->customer->name}}, {{$unit_refund->customer->first_owner}}, {{$unit_refund->customer->second_owner}} 
                                        @else
                                            {{$unit_refund->customer->name}} 
                                        @endif

                                    </td>

                                    <td style="font-weight: 600; width: 140px; display: <?= ( $unit_refund->customer->type  == 1) ? 'none' : '' ?>">S/O:</td>
                                    <td style="width:240px;display: <?= ( $unit_refund->customer->type  == 1) ? 'none' : '' ?>"> 

                                        @if(count($ownerArray) > 1)
                                        {{$unit_refund->customer->father_name}},  {{$unit_refund->customer->first_owner_father}}, 
                                        {{$unit_refund->customer->second_owner_father}} 
                                        @else
                                        {{$unit_refund->customer->father_name}} 
                                        @endif

                                         </td>
                                </tr>
                                <tr>
                                    <td style="font-weight: 600;">Contact #:</td>
                                    <td> {{$unit_refund->customer ? $unit_refund->customer->mobile_number : ''}} </td>
                                    <td style="font-weight: 600;">Address:</td>
                                    <td> {{$unit_refund->customer->mailing_address}} </td>
                                </tr>
                                <tr>
                                     
                                    <td style="font-weight: 600; width: 140px"><?= ( $unit_refund->customer->type  == 1) ? 'Incorporation no' : 'CNIC No.' ?></td>
                                    <td style="width:240px"> 


                                    @if(count($ownerArray) > 1)
                                    {{str_replace('_' , ''  , $unit_refund->customer->cnic)}},  {{$unit_refund->customer->first_owner_cnic}}, 
                                    {{$unit_refund->customer->second_owner_cnic}} 
                                    @else
                                    <?php $c = str_split($unit_refund->customer->cnic, 1);?>
                                    <?php 
                                    for($i =0;$i<count($c) ; $i++) 
                                    {
                                    ?>
                                    @if(($i == 5 || $i == 12) &&  $unit_refund->customer->type  == 0)
                                    -
                                    @endif
                                    <?= ( $unit_refund->customer->type  == 1) ? str_replace('_' , '' , $c[$i] ) : $c[$i] ?> 
                                    <?php 
                                    }
                                    ?> 
                                    @endif


                                                         
                                       
                                    </td>
                                </tr>
                            </tbody>
                        </table>



                      


                    </div>
                    <div class="clear"></div>
                </div>
              
            </div>
        </div>

            {{-- Unit Detail --}}
           
        <div class="col-lg-12"  id="main_unit_details">
            <div class="white-box1">
                <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px">&nbsp;&nbsp;Unit's Details</h4>
                <div class="col-md-4 col-xs-6">
                    <div class="table-responsive" >
                    <table class="table bottom-table" >

                        <tbody>
                            <tr>
                                <td style="font-weight: 600;">Floor / Street:</td>
                                <td>{{$data['floor_street']}} </td>
                            </tr>

                            <tr>
                                <td style="font-weight: 600;">Block:</td>
                                 <td>{{$data['block']}} </td>
                            </tr>

                            <tr>
                                <td style="font-weight: 600;">Category:</td>
                                <td>{{$data['category']}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Size:</td>
                                <td>
                                                    {{$data['size']}}
                                                    </td>

                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Total Price:</td>
                                <td>{{$data['total_price']}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Net Amt.:</td>
                                <td> {{$data['net_amt']}} </td>
                            </tr>

                           
                         
                           
                            <tr>
                                <td style="font-weight: 600;">Schedule Start Date:</td>
                                <td> {{$data['schedule_start_date'] }} </td>
                            </tr>

                            
                           


                           

                        </tbody>
                    </table>
                </div>
                </div><!-- 
                <div class="col-md-4">&nbsp;</div> -->
                <div class="col-md-4 col-xs-6">
                    <div class="table-responsive" >
                    <table class="table">
                        <tbody>
                            <tr>
                                <td style="font-weight: 600;" >Unit/Plot No.:</td>
                                <td>{{$data['unit_plot_no']}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Unit Type:</td>
                                <td>{{$data['unit_type']}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Area:</td>
                                <td>{{$data['area']}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Discount:</td>
                                <td> {{$data['discount']}} </td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Category Cost:</td>
                                <td> {{$data['category_cost'] }} </td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Booking Type:</td>
                                <td> {{$data['booking_type'] }} </td>
                            </tr>
                            
                            <tr>
                                <td style="font-weight: 600;">Booking Date:</td>
                                <td> {{$data['booking_date'] }} </td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                </div>
                
                
                <div class="clear"></div>
            </div>
        </div>
         {{-- End Unit Detail --}}


        {{-- Rebate's Info --}}
        {{-- <div class="col-lg-12 no-print" >
            <div class="white-box1 ">
                <h6 class="box-title " style=" color: white; background-color:#1c3752; line-height: 30px">&nbsp;&nbsp;Rebate's Info <span style="float: right;margin-right: 2rem;font-size: 3rem;font-weight: bolder;cursor: pointer;" onclick="showDealerDiv()">+</span></h6>

                <div class="col-xs-4 col-sm-4" style="display:none;" id="data_div">
                    <div class="table-responsive">
                        <table class="table bottom-table">
                            <tbody class="printFW">

                                @foreach($dealers as $d)
                                
                                <tr>
                                    <td style="font-weight: 600;">Name :</td>
                                    <td> {{$d->dealer->name}} </td>

                                    <td style="font-weight: 600;">Rebate : </td>
                                    <td> {{number_format($d->amount)}} </td>

                                    
                                </tr>

                                @endforeach
                               
                                

                            </tbody>
                        </table>
                    </div>
                    <div class="clear"></div>
                </div>
                
            </div>
        </div> --}}
        {{-- End Rebate's Info --}}
        
        {{-- Payment Detail --}}

         <div class="col-lg-12" id="payment_div">
            <div class="white-box1 ">
                <h4 class="box-title " style=" color: white; background-color:#1c3752; line-height: 30px">&nbsp;&nbsp;Payment Detail</h4>
                 
                <div class="col-md-12 col-xs-12">
                    <div class="table-responsive">
                        <table class="table bottom-table">
                            <tbody class="printFW">
                                
                                <tr>
                                    <td style="font-weight: 600;">Net Price: </td>
                                    <td> {{$data['net_amt']}} </td>


                                    <td style="font-weight: 600;">Received Amount: </td>
                                    <td> {{number_format($amount)}} &nbsp; &nbsp;({{number_format($receivedAmtPer , 2)}} % ) </td>

                                    
                                      <td style="font-weight: 600;">Outstanding Amt: </td>
                                      <td> {{number_format($outstandingAmt)}}  &nbsp; &nbsp;({{number_format($outstandingAmtPer , 2)}} % )</td>

                                </tr>
                              

                                <tr>

                                  

                                    <td style="font-weight: 600;">PDC.</td>
                                    <td> {{number_format($pdc_receipt)}} &nbsp; &nbsp;({{number_format($pdcReceiptPer , 2)}} % )</td>

                                    <td style="font-weight: 600;">Paid Surcharge</td>
                                    <td> {{number_format($paidSurcharge)}} </td>

                                </tr>
                                

                            </tbody>
                        </table>
                    </div>
                    <div class="clear"></div>
                </div>
                
            </div>
        </div>

        {{-- End Payment Detail --}}






        <div class="col-lg-12">
            <div class="white-box1">
                <div class="table-responsive" style="clear: both;">
                    <table  class="table table-bordered">
                        <thead class="bg-color">
                            <tr style="text-align: center">
                                <th style="color: #fff;font-size: 13px;">Payment Head</th>
                                <th style="color: #fff;font-size: 13px;">Due Date</th>
                                <th style="color: #fff;font-size: 13px;">Due Amt.</th>
                                <th style="color: #fff;font-size: 13px;">Received Amt.</th>
                                <th class="no-print" style="color: #fff;font-size: 13px;">Balance</th>
                                <th style="color: #fff;font-size: 13px;">Payment Mode</th>
                                <!-- <th class="no-print">Detail</th> -->
                                <th style="color: #fff;font-size: 13px;">Receipt #</th>
                                <!-- <th>Ref#</th> -->
                                <th style="color: #fff;font-size: 13px;">Receipt Date</th>

                                <th style="color: #fff;font-size: 13px;">Surcharge Amt</th>
                                <th style="color: #fff;font-size: 13px;">Balance Amt.</th>
                                <!-- <th>Net Amt</th> -->
                            </tr>
                        </thead>
                        <tbody>
                            <?php $due = 0;
                            $received = 0;
                            $balance = 0;
                            $surcharge = 0;
                            $net_payable = 0;
                            $count = 1;
                            $total = $property->net_pay;
                             $otherArray = [];
                            ?>

                            @foreach($periorities as $periority)

                            @foreach($unit_refund->refundhistory as $statement)

                            @if($statement->due > 0 && ($statement->payment_head == $periority->payment_head ) || ($statement->payment_head == \App\CustomerStatement::other && !in_array($statement->payment_head , $otherArray)))

                                @php
                            
                            if($statement->payment_head == \App\CustomerStatement::other)
                            {
                              $otherArray[] = $statement->payment_head;
                            }
                          
                            @endphp
                            
                            @if($statement->balance > 0 && $statement->due_date < Carbon\Carbon::today())
                                <tr style="background-color: #e8e3c1;">
                            @else
                                <tr>
                            @endif

                            
                            @if($statement->payment_head == \App\CustomerStatement::down_payment)
                            <td class="printFV">
                                
                                @if( $property->booking_type == \App\CustomerProperty::full_payment)
                                 {{'Full Payment'}}
                                 @else
                                 {{'Down Payment'}}
                                @endif
                            </td>
                            @elseif($statement->payment_head == \App\CustomerStatement::possession)
                            <td class="printFV">Possession Fee</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::installment)
                            <td class="printFV">
                                @if (!str_contains($statement->inst_no , '-b')) 
                                    Installment - {{str_replace('-a' , '' ,  $statement->inst_no)}}
                                    @else
                                   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Installment
                                @endif
                            </td>
                            @elseif($statement->payment_head == \App\CustomerStatement::other)
                            <td class="printFV">Other</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::allotment)
                            <td class="printFV">Allotment</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::confirmation)
                            <td class="printFV">Confirmation</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::booking)
                            <td class="printFV">Booking</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::development)
                            <td class="printFV">Development</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::file_processing)
                            <td class="printFV">File Processing</td>
                            @elseif($statement->payment_head == \App\CustomerStatement::registration)
                            <td class="printFV">Registration</td>
                            @else
                            <td class="printFV"></td>
                            @endif

                                <!-- <td class="printFV">{{$statement->inst_no}}</td> -->
                                <td class="printFV">
                                    {{date('d-m-Y', strtotime($statement->due_date)) }}

                                    <!-- @if($statement->payment_head == \App\CustomerStatement::possession) 
                                    <a href="JavaScript:void(0)" onclick="return changePossessionDate('{{$statement->id}}' , '{{date('Y-m-d', strtotime($statement->due_date)) }}');"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                     @endif -->
                                     </td>
                                <td class="printFV text-right">{{number_format($statement->due)}}</td><?php $due += $statement->due; ?>
                                <td class="printFV text-right">
                                    @if($statement->is_deleted == false){{number_format($statement->received)}}<?php $received += $statement->received; ?>
                                @else 
                                0
                                @endif
                            </td>
                             <td class="printFV no-print text-right">
                                    @if($statement->is_deleted == false){{number_format($statement->balance)}}
                                    @else
                                    {{number_format($statement->due)}}
                                @endif
                            </td>

                                @if($statement->is_deleted == false)

                                @if($statement->receipt)

                                @if($statement->receipt->payment_method == \App\Receipt::cash)
                                <td>Cash</td>
                                @elseif($statement->receipt->payment_method == \App\Receipt::bank)
                                <td>Bank</td>
                                @elseif($statement->receipt->payment_method == \App\Receipt::adjustment)
                                <td>Adjustment</td>
                                @elseif($statement->receipt->payment_method == \App\Receipt::cheque)
                                <td>Cheque</td>
                                @elseif($statement->receipt->payment_method == \App\Receipt::merging)
                                <td>Merging</td>
                                @else
                                <td></td>
                                @endif
                                    
                                @else
                                <td></td>
                                @endif
                                @else
                                <td></td>
                                @endif


                            
                                <td class="printFV">@if($statement->is_deleted == false) {{$statement->rcpt_no}} @endif</td>
                                <!-- <td class="printFV"> {{$statement->ref_no}} </td> -->
                                <td class="printFV text-right">@if($statement->is_deleted == false)  {{ $statement->rcpt_date ? date('d-m-Y', strtotime($statement->rcpt_date)) : '' }} @endif</td>


                                <td class="printFV text-right">{{number_format($statement->surcharge)}}
                                    <?php $surcharge += $statement->surcharge; 
                                ?></td>

                                @if($statement->is_deleted == false)
                                @if($statement->received)
                                <?php $total -=$statement->received;?>
                                <td class="printFV text-right"> {{number_format($total)}}</td>
                                @else
                                <td class="printFV"></td>
                                @endif
                                @else
                                <td class="printFV"></td>
                                @endif
                                <!-- <?php $balance += $statement->balance; ?>-->


                                

                                
                            </tr>
                            @endif
                            @endforeach

                            @endforeach
                            <tr>
                                <td colspan="2" class="printFV text-center"><b>Total</b></td>
                                <td class="printFV text-right"><b>{{number_format($due)}}</b></td>
                                <td  class="printFV text-right"><b>{{number_format($received)}}</b></td>
                                <!-- <td colspan="3"></td> -->
                                <td colspan="5" class="printFV text-right">  Total WaveOff ({{$waiveOff}}) <b>{{number_format($surcharge - $waiveOff)}}</b></td>
                                <td  class="printFV text-right"><b>{{number_format($total)}}</b></td>

                                
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <br>
        
        </div>


        @if($property->booking_type == \App\CustomerProperty::full_payment )
        
@if($property->fullPayment)
        <div class="col-lg-12">
            <div class="white-box">
                <h4 class="box-title">Discount Payment Terms</h4>
                <hr>
                <div class="table-responsive pull-left">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td >Total Amount :</td>
                                <td> {{number_format($property->fullPayment->total_amount)}} </td>
                            </tr>
                            <tr>
                                <td >
                                Discount Percentage :</td>
                                <td> {{$property->fullPayment->discount_percentage}} %</td>
                            </tr>
                            <tr>
                                <td>Discount Amount</td>
                                <td> {{number_format($property->fullPayment->discount_amount)}} </td>
                            </tr>
                            <tr>
                                <td>Net Amount</td>
                                <td> {{number_format($property->fullPayment->discount_amount - $property->fullPayment->deduction_amount)}} </td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                <div class="table-responsive pull-right">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td >Total Tenure : </td>
                                <td>{{$property->fullPayment->total_tenure}} months</td>
                            </tr>
                            <tr>
                                <td>Return Tenure :</td>
                                @if($property->fullPayment->return_tenure == \App\CustomerProperty::monthly)
                                <td> Monthly </td>
                                @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::quarterly)
                                <td> Quarterly </td>
                                @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::semi_annually)
                                <td> Semi Annually </td>
                                @elseif($property->fullPayment->return_tenure == \App\CustomerProperty::annually)
                                <td> Annually </td>
                                @else
                                <td></td>
                                @endif
                            </tr>
                            <tr>
                                <td>Deduction Amount : </td>
                                <td> {{number_format($property->fullPayment->deduction_amount)}} </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="clear"></div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="white-box">
                <div class="table-responsive" style="clear: both;">
                    <table  class="table table-bordered printFW1">
                        <thead class="printFH11">
                            <tr>
                                <th style="color: #fff;font-size: 13px;">inst #</th>
                                <th style="color: #fff;font-size: 13px;">Due Date</th>
                                <th style="color: #fff;font-size: 13px;">Due Amount</th>

                                <th style="color: #fff;font-size: 13px;">Paid Amount</th>
                                <th style="color: #fff;font-size: 13px;">Receipt #</th>
                                <th style="color: #fff;font-size: 13px;">Receipt Date</th>
                                <th style="color: #fff;font-size: 13px;">Balance Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $due = 0;
                            $received = 0;
                            $balance = 0;
                            $count = 1; ?>
                            @foreach($property->fullPaymentStatement as $statement)
                            <tr>
                                <td class="printFV">{{$count++}}</td>
                                <td class="printFV">{{date('d-m-Y', strtotime($statement->due_date)) }}</td>
                                <td class="printFV text-right">{{number_format($statement->due)}}</td><?php $due += $statement->due; ?>
                                <td class="printFV text-right">{{number_format($statement->received)}}</td><?php $received += $statement->received; ?>
                                <td class="printFV"> {{$statement->receipt_no}} </td>
                                <td class="printFV"> {{ $statement->receipt_date ? date('d-m-Y', strtotime($statement->receipt_date)) : '' }} </td>
                                <td class="printFV text-right">{{number_format($statement->due - $statement->received)}}</td>
                                <?php $balance += ($statement->due - $statement->received); ?>
                            </tr>
                            @endforeach
                            <tr>
                                <td colspan="2"><b>Total</b></td>
                                <td class="text-right"><b>{{number_format($due)}}</b></td>
                                <td class="text-right"><b>{{number_format($received)}}</b></td>
                                <td></td>
                                <td></td>
                                <td class="text-right"><b>{{number_format($balance)}}</b></td>
                            </tr>

                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
        @endif

        @endif



        @if($taxs)

        <div class="col-lg-12 no-print">
            <div class="white-box">
                <h4 class="box-title">Property Tax Record</h4>
                <div class="table-responsive" style="clear: both;">
                    <table  class="table table-bordered printFW1">
                        <thead class="printFH11">
                            <tr>
                                <th style="color: #fff;font-size: 13px;">Sr #</th>
                                <th style="color: #fff;font-size: 13px;">inst #</th>
                                <th style="color: #fff;font-size: 13px;">Tax</th>
                             
                                <th style="color: #fff;font-size: 13px;">Pay By</th>
                                <th style="color: #fff;font-size: 13px;">Payment Received</th>
                            
                                <th style="color: #fff;font-size: 13px;">Status</th>
                                <th style="color: #fff;font-size: 16px;">CPR</th>
                              
                            </tr>
                        </thead>
                        <tbody>
                            <?php $sr =1;$sum =0;?>
                            @foreach($taxs as $tax)
                             
                            <tr>
                            <td class="printFV">{{$sr++}}</td>
                            @if($tax->statement->payment_head == \App\CustomerStatement::down_payment)
                            <td class="printFV">Down Payment</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::possession)
                            <td class="printFV">Possession Fee</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::installment)
                            <td class="printFV">Installment - {{$tax->statement->inst_no}}</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::other)
                            <td class="printFV">Other</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::allotment)
                            <td class="printFV">Allotment</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::confirmation)
                            <td class="printFV">Confirmation</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::booking)
                            <td class="printFV">Booking</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::development)
                            <td class="printFV">Development</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::file_processing)
                            <td class="printFV">File Processing</td>
                            @elseif($tax->statement->payment_head == \App\CustomerStatement::registration)
                            <td class="printFV">Registration</td>
                            @else
                            <td class="printFV"></td>
                            @endif
                            <td class="printFV text-right">
                                {{number_format($tax->tax)}}
                            </td>
                                <?php $sum += $tax->tax; ?>

                                <td class="printFV text-right">@if($tax->tax_pay_by == \App\Receipt::customer)
                                Customer
                                @else
                                Company
                                @endif
                                </td>

                                <td class="printFV text-right">
                                    {{$tax->tax_payment_received == \App\CustomerPropertyTax::paid ? 'YES' : 'NO'}}
                                </td>

                                <td class="printFV text-right">
                                    {{$tax->status == \App\CustomerPropertyTax::paid ? 'Paid' : 'UnPaid'}}
                                    @if($tax->status)
                                <br>
                                <b>Reference # </b> 
                                {{$tax->reference}}
                                @endif
                                </td>

                            <td>
                            @if($tax->cpr)
                            <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('uploads/'.$tax->cpr)}}" download=""> <i class="fa fa-download" style="text-transform: none;">&nbsp;</i>Download</a>
                            @endif
                            </td>

                           
                            </tr>
                            @endforeach
                            <tr>
                                <td colspan="2"><b>Total</b></td>
                                <td class="text-right"><b>{{number_format($sum)}}</b></td>
                                
                            </tr>

                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    @endif

<div class="modal fade" id="taxReceiptModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

<div class="modal-dialog modal-lg" role="document">
<div class="modal-content">
<div class="modal-header" style="text-align: center;">
<h5 class="modal-title" id="exampleModalLabel" >Tax Receipt</h5>
<button type="button" class="close" data-dismiss="modal" aria-label="Close">
<span aria-hidden="true">&times;</span>
</button>
</div>

<div class="modal-body" style="height: 250px;">

    <div class="alert alert-danger" role="alert" style="display:none;" id="fields_error">
  All fields with * is required.
</div>


</div>

</div>
</div>

</div>




<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

<div class="modal-dialog" role="document">
<div class="modal-content">
<div class="modal-header" style="text-align: center;">
<h5 class="modal-title" id="exampleModalLabel" >Tax CPR</h5>
<button type="button" class="close" data-dismiss="modal" aria-label="Close">
<span aria-hidden="true">&times;</span>
</button>
</div>
 
</div>
</div>

</div>

        
        

    </div>
    <div style="display: inline-block;    margin-bottom: 70px;">
       

  

     <div class="text-right" style="display: inline-block;">
       <button  class="btn btn-default btn-outline no-print" onclick="return print_whole_statement()" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
    </div>
    
     <div class="text-right" style="display: inline-block;">
       <button  class="btn btn-default btn-outline no-print" onclick="return  print_summery()" type="button"> <span><i class="fa fa-print"></i> Print Summary</span> </button>
    </div>
    
</div>
</div>
<!-- /.container-fluid -->

<!-- Modal -->
<div class="modal fade" id="possession_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Update Possession Date</h4>
      </div>
      
      </div>
    </div>
  </div>
</div>


@stop

@section('js')
<script src="{{asset('js/jspdf.min.js')}}" type="text/JavaScript"></script>
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>


<script>


    window.setInterval(function(){
  $('#text_detail').html('Member Information')
        $('#main_unit_details').show();
        $('#summary_customer_info').hide();
        $('#main_customer_info').show();
}, 1000);
    
function print_summery()
{
    $('#text_detail').html("Unit's Details")
    $('#payment_div').addClass("no-print");
    $('#summary_customer_info').show();
    $('#main_customer_info').hide();
    $('#main_unit_details').hide();
    $('.block_id').hide();
    $('.Category').hide();
    $('.net_amount').hide();
    $('.area').hide();
    $('.discount').hide();
    $('.category_cost').hide();
    window.print();
    return false;
}

function print_whole_statement()
{
    $('#text_detail').html('Member Information')
    $('#payment_div').removeClass("no-print");
    $('#summary_customer_info').hide();
    $('#main_customer_info').show();
    $('#main_unit_details').show();
    window.print();
    return false;
}


function checkValue(self) 
{
    if ($('#payment_method').val() != '{{\App\Receipt::cash}}' && ($('#bank_name').val() == '' || $('#company_account').val() == '' || $('#drawnDate').val() == '' || $('#checkNumber').val() == '')) 
    {
            $('#fields_error').show('slow')
            return false;
    }
    else
    {
         return true;
    }
}

      function changeFunc(a){
    if(a == {{\App\Receipt::cash}})
    {
      $('#bank').css('display', 'none');
      $('#company-bank').css('display', 'none');
      $('#cheque').css('display', 'none');
      $('#adjustment').css('display', 'none');
      $('#cheque-dd-po-drawn-date').css('display', 'none');
      $('#cheque-dd-po-instrument-no').css('display', 'none');
      $('#drawnDate').val('')
      $('#checkNumber').val('')
    }
    else if(a == {{\App\Receipt::bank}})
    {
      $('#bank').css('display', 'block');
        $('#company-bank').css('display', 'block');
        $('#cheque').css('display', 'none');
        $('#adjustment').css('display', 'none');
        $('#cheque-dd-po-drawn-date').css('display', 'block');
        $('#cheque-dd-po-instrument-no').css('display', 'block');
    }
    else if(a == {{\App\Receipt::cheque}})
    {
        $('#bank').css('display', 'block');
        $('#company-bank').css('display', 'block');
        $('#cheque').css('display', 'none');
        $('#adjustment').css('display', 'none');
        $('#cheque-dd-po-drawn-date').css('display', 'block');
        $('#cheque-dd-po-instrument-no').css('display', 'block');
      
    }
   
  }



    function showDealerDiv() 
    {
        $("#data_div").toggle('slow');
    }

    function openTaxReceiptModal(self,tax_id , tax_amount , receipt_no , payment_head ) 
    {
       
        $('#tax_receipt_id').val(tax_id);

        $('#tax_amount').val(tax_amount);

        $('#receipt_no').val(receipt_no);

        $('#payment_head').val(payment_head);

        $('#inst_no').val($(self).data("instal-no"));

        $('#taxReceiptModal').modal();
    }

    function openTaxModal(tax_id) {

        $('#tax_id').val(tax_id);
        
        $('#exampleModal').modal();
        
    }

    function UpdatePossessionDate(self) {
        
        $('#possession_modal_btn').html('Processing...');
         $('#possession_modal_btn').prop('disabled' , true);

        var payment_head_id = $('#payment_head_id').val();
        var possession_date = $('#new_possession_date').val();
  $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   $.ajax({
        url:"{{ route('payment.head.update') }}",
        method:'POST',
        data: {payment_head_id:payment_head_id , possession_date:possession_date },
        success:function(data)
        {
           if(data == '1')
           {
               $('#success_message').show();
               location.reload(true)
           }
           else if (data == 'empty')
            {
                $('#possession_modal_btn').html('Save changes');
                $('#possession_modal_btn').prop('disabled' , false);
                $('#error_message').show();
            }
           else
           {
            alert('Something Went wrong!')
            location.reload(true)
           }
        }
        })


        return false;
    }

    function changePossessionDate(id , date) {
        $('#payment_head_id').val(id)
        $('#new_possession_date').val(date);
        $('#possession_modal').modal('show')
    }
$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>
<script>
var doc = new jsPDF();
var specialElementHandlers = {
    '#editor': function (element, renderer) {
        return true;
    }
};

//margins.left, // x coord   margins.top, { // y coord
$('#generatePDF').click(function () {
    doc.fromHTML($('#htmlContent').html(), 15, 15, {
        'width': 700,
        'elementHandlers': specialElementHandlers
    });
    doc.save('sample_file.pdf');
});
</script>
@stop