@extends('layouts.app')
@section('title')
Agreement 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-left no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    @permission('list-membership')
    <li ><a href="{{route('statement.all')}}">Statements</a></li>
    @endpermission
    <li class="active">Statement Detail</li>
</ol>
<div class="container-fluid" style="padding: 6px 30px 0 0;">
    <div class="pull-right">
        <div class="text-right" style="display: inline-block;">
        <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>
</div>

@stop
@section('content')




<div class="container-fluid">
    <div class="row printableArea"  id="content">
        <div class="col-lg-12">
            <div class="white-box border-none mt-95">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="row text-center">
                            <u><b>AGREEMENT</b></u>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="row" >
                            <div class="col-xs-12 col-sm-12">
                                <br><b>THIS AGREEMENT TO SELL ("Agreement"), </b> executed at Islamabad on the <u>{{date('d-m-Y')}}</u> by and between: <b><br><br>The Signature Complex, </b> having its registered office at <b>Plot No. 3, Main Sri Nagar Highway, Top City-1, Near New Islamabad Airport, Islamabad, Pakistan </b> (hereinafter called <b>“SIGNATURE”</b> which term and expression shall, wherever the context so permits, include its successors in interest and assignees).
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-10 col-xs-10 mt-18">
                        <div class="row text-center">
                            <div>AND</div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row">
                            <div class="col-xs-12 col-sm-12">
                                <p>
                                    Mr./MRs./Ms. <u>{{$statement->customer->name}}</u> Son/Wife/Daughter of Mr <u>{{$statement->customer->father_name}}</u> holding Computerised National Identity Card (CNIC) Number/Passport No. <u>{{$statement->customer->cnic}}</u>, being resident of <u>{{$statement->customer->permanent_address}}</u> (hereinafter called the <b>“Purchasers”</b> which term and expression shall, wherever the context so permits, include its successors in interest and permitted assignees) and any person who acquires the interest of the Purchaser.
                                </p>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">1.   Agreement to Sell and Purchase</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <p>WHEREAS <b>SIGNATURE</b> has acquired a piece of land measuring <b>10.55 Kanal (6377 Sq. Yards)</b> located at <b>Plot No. 3, Main Sri Nagar Highway, Top City-1, Near New Islamabad Airport, Islamabad, Pakistan</b> for the purpose of construction of a multi-purpose building, (the <b>“SIGNATURE”</b>) comprising of Dedicated Hotel and Commercial Building. </p>
                        <ol style="list-style-type: none;">
                          <li>1.1.  WHEREAS <b>SIGNATURE</b> wishes to sell units in the <b>SIGNATURE</b> to the purchasers.    
                          </li>
                          <li>1.2.  WHEREAS the purchaser wishes to purchase the following Unit in the SIGNATURE, payable in accordance with the payment schedule as set out in the instalment plan.</li>
                        <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th class="font-13">Unit. No</th>
                                            <th class="font-13">Floor</th>
                                            <th class="font-13">Amount</th>
                                            <th class="font-13">Area/Sq.Ft</th>
                                            <th class="font-13">Rate/Sq.Ft (PKR)</th>
                                            <th class="font-13">Total Amount of Unit (PKR)</th>
                                            <th class="font-13">Down Payment Percentage</th>
                                            <th class="font-13">Amount Down Payment (PKR)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{$statement->inventory->unit_number}}</td>
                                            <td>{{$statement->inventory->floor->name}}</td>
                                            <td>{{number_format($statement->inventory->total_price)}}</td>
                                            <td>{{$statement->inventory->size->name}} sqft</td>
                                            <td> {{number_format(($statement->inventory->total_price - $statement->inventory->extra_amount) / $statement->inventory->size->name)}}</td>
                                            <td>{{number_format($statement->net_pay)}}</td>
                                            <td>{{round(($statement->down_payment / $statement->net_pay) * 100)}} %</td>
                                            <td>{{number_format($statement->down_payment)}}</td>

                                        </tr>
                                        <tr>
                                            <td colspan="3" class="font-13"><b>Amount of Down Payment in words</b></td>
                                            <td colspan="5">&nbsp; {{$down_payment_words}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <li>1.3.    The sale price includes charges of Furnishing the Hotel Suites.</li>
                        </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">2.   Down Payment</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>2.1.  The purchaser has paid the down payment <u><b>Rs.{{number_format($statement->down_payment)}}/-</b></u> (In Words) <b>Pak Rupees <u>{{$down_payment_words}}</u></b>    
                          </li>
                          <li>2.2.  The purchaser shall make payment of the balance of the sale price in accordance with the payment schedule set out in instalment plan.</li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">3.   Management Services</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>3.1.  The management company shall provide services detailed in any management agreement entered or to be entered into between the management company and the purchaser.</li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">4.   Possession and Risk</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>4.1.  The completion date represents the date upon which it is expected at the time of entering into this Agreement that construction of the <b>SIGNATURE</b> will be completed, and the Unit will be ready for occupation. However, <b>SIGNATURE</b> reserves the right to extend the completion date by a maximum period of six (6) months under intimation to the Purchaser prior to ---------- 2025.</li>
                          <li>4.2.  Subject to the terms of this agreement, in the event <b>SIGNATURE</b> is unable to complete the <b>SIGNATURE</b> and handover possession of the unit to the Purchaser by the completion date (or as extended per Article 4.1 here in above), <b>SIGNATURE</b> shall pay to the purchaser who paid all his/her/their instalments timely (as the purchaser’s exclusive remedy for delay in completion) 0.5% of the received amount to date, per month to the purchaser until the completion of the <b>SIGNATURE.</b></li>
                          <li>
                              4.3.  On or before the Completion Date, SIGNATURE shall issue a notice of possession to the purchaser, requiring the purchaser:<br>
                              <ol style="list-style-type: none;">
<li>a)  To pay any outstanding portion of the Sale Price and other charges, if any</li> 
<li>b)  Execute a management agreement, in form and content approved by with the management company and pay the management fee to the management company.  </li>
<li>c)  To take possession of the unit on or before the date specified in the notice of possession.</li>
In the event the purchaser does not take possession of the unit on or before such date, the purchaser shall be liable to pay penalties as specified in the notice of possession to without affecting any other right or remedy of under this agreement.</ol>

                          </li>
                          <li>4.4.  <b>SIGNATURE</b> shall be entitled to decline the transfer of title and retain or resume possession of the unit from the purchaser in the event the purchaser fails to pay the sale price as specified here in above or fails to comply with any other provisions of this agreement.</li>
                          <li>4.5.  That the project is to be constructed on the <b>Plot No. 3, Main Sri Nagar Highway, Top City-1, Near New Islamabad Airport, Islamabad, Pakistan </b>which is allotted to the sponsors with the nature of Mixed-Use Development. However, due to any reason whatsoever, in future, if the intended usage is not allowed or changed by the regulatory authority, then the purchaser shall have the right to cancel this sale agreement and return the amount to the purchaser without any penalty or additional charges and no objection of the purchaser in this regard shall be acceptable.</li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">5.   Payment Taxes</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>5.1.  The purchaser will be responsible for payment of all taxes, rates, charges, impositions, duties (howsoever designated), costs of assessment and including but not limited to penalties in respect of the Unit. </li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">6.   Re-Sale and Assignment</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>6.1.  Client can sale his/her inventory through <b>SIGNATURE</b> sales team or by any other source at any stage at each resale transfer fee of RS. 80 /Sq. Ft for purchased unit will be charged by <b>SIGNATURE</b> management. <b>SIGNATURE</b> may impose additional terms and conditions at its sole discretion.</li>
                          <li>6.2.  Not with standing anything to the contrary in this agreement, the purchaser shall not create or permit to exist any mortgage, lien (excepting the lien in favour of <b>SIGNATURE</b> under this agreement) or charge or encumbrance (of whatever nature and howsoever described) over or in respect of the unit or the purchaser’s interest therein without the prior written approval of <b>SIGNATURE.</b></li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">7.   Modifications/Variation</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>7.1.  The purchaser acknowledges and understands that the gross area of the unit includes net area of the unit and proportionate common area of the unit, <b>SIGNATURE</b>  at its sole discretion or as required by RDA or any public authority, change, vary or modify the plans (as set out in the Drawing), features list, floor plan, lay out, design, features, colours, materials, finishes, equipment, accessories, fixtures, fittings and specifications and amenities of the unit or the <b>SIGNATURE</b> shown at the time of execution of this agreement or as the same may be illustrated in any sales brochures, model or otherwise, without notice to or consent from the purchaser, provided that the substituted items are of comparable quality. The Purchaser hereby consents to any such changes, modifications and/or substitutions.</li>
                          <li>7.2.  The purchaser agrees that the purchased unit will be used exclusively for permitted use as recommended by <b>SIGNATURE</b> management.</li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">8.   Refund Policy</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>8.1.  In case the purchaser wishes to terminate this agreement prior to making full and final payment or transferring title in the Unit, and a refund is claimed, the <b>SIGNATURE</b> management shall have the right to deduct 50% of the total down payment amount of the sold unit value, balance will be paid to purchaser within three months after issuance of notice in writing to the purchaser.</li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">9.   Default by the Purchaser  </b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>9.1.  In case of termination of this agreement because of the default of payment of the sale price or other breach by the purchaser, <b>SIGNATURE</b> shall reserve the right to sell the unit to any third party and refund to the purchaser the proceeds of such sale or the amount received from the purchaser to date, whichever is less, after deducting 50% of the total down payment amount, after six months of such sale. In case the total amount received by <b>SIGNATURE</b> is less than 25% of the total sales price, the whole paid amount to date will be confiscated without affecting any other right or remedy available to <b>SIGNATURE</b> under this agreement or in law.</li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">10.  Force Majeure</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>10.1. God forbid, should an event of force majeure occur that will delay the completion date, <b>SIGNATURE</b> shall promptly notify the purchaser of such event and give the purchaser a new completion date or an estimate of the duration of the delay caused by the force majeure, followed by an amended completion date, at such time as the same can be reasonably ascertained.</li>
                          <li>10.2. The purchaser shall not stop paying instalments of the sale price under any circumstances.</li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">11.  Entire Agreement</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>11.1. This agreement along with its schedules constitutes the entire agreement between the parties and there are no other representations, warrants, conditions or collateral agreements, express or implied, written or oral, whether made by any agent, employee or representative of <b>SIGNATURE</b> or any other person including, without limitation, those arising out of any marketing material including sales brochures, models, representative view sets, show room displays, photographs, videos, illustrations, renderings revenue projections or pro-forma statements provided to the Purchaser or made available for viewing, and this agreement shall form a binding agreement subject only to the terms and conditions contained herein. Any and all previous agreements, written or oral, express or implied between the parties or on their behalf relating to the sale of the Unit by <b>SIGNATURE</b> are terminated and cancelled and each of the parties releases and forever discharges the other of and from all manner of actions, causes of action, claims or demands whatsoever under or in respect of any such agreement. This agreement may be amended or changed only by a writing signed by the parties hereto.</li>
                      </ol>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;">12.  Governing Law and Dispute Resolution</b>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="col-xs-12 col-sm-12">
                            <ol style="list-style-type: none;">
                          <li>12.1. This agreement will be governed by and construed in accordance with the prevailing laws of the Islamic Republic of Pakistan. </li>
                          <li>12.2. All disputes between the parties in relation to or arising from the agreement shall be referred to arbitration in Islamabad to be conducted in accordance with Arbitration Act, 1940. An award given by the arbitrator shall be final and binding on the parties.</li>
                      </ol>
                        </div>
                    </div>
                </div>
            </div>

            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>For & on Behalf of SIGNATURE:</b>
                    </div><br><br><br><br>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                           <div class="row">
                               <div class="col-sm-6 col-xs-6">
                                   <span>1.<b>_____________________________</b></span><br>
                                   <span><b>Maqbool Hussain / Yaseen Masud</b></span><br>
                                   <p style="font-weight: 400">(Chairman / CEO)</p><br>
                               </div>
                               <div class="col-sm-6 col-xs-6">
                                   <span>2.<b>____________________________</b></span><br>
                                   <span><b>{{$statement->customer->name}}</b></span><br>
                                   <span style="font-weight: 400">(Purchaser)</span><br>
                                   <span>&nbsp;&nbsp;&nbsp; <b>CNIC#:</b>{{$statement->customer->cnic}}</span><br>
                               </div>
                               <div style="height: 150px"></div>
                               <div class="col-sm-6 col-xs-6">
                                   <span>3.<b>_____________________</b></span><br>
                                   <span><b>&nbsp;&nbsp;&nbsp;Witness-1</b></span><br>
                               </div>
                               <div class="col-sm-6 col-xs-6">
                                   <span>4.<b>_____________________</b></span><br>
                                   <span><b>&nbsp;&nbsp;&nbsp;Witness-2</b></span><br>
                               </div>                               
                           </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        

        

    </div>
    <!-- <div style="display: inline-block;    margin-bottom: 70px;">
        <div class="text-right" style="display: inline-block;">
        <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div> -->
</div>
<!-- /.container-fluid -->





@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>
$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>
@stop