@extends('layouts.app')

@section('title')
    Add Sale
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-membership')
            <li><a href="{{ route('statement.all') }}">Statements</a></li>
        @endpermission
        <li class="active">Add Sale</li>
    </ol>
@stop
@section('css')
    <style>
        .help-block {
            font-weight: bold;
        }

        span {
            display: inline-block;
        }
    </style>

@stop

@section('content')

    <div class="container-fluid">
        <div class="row">

            <form class="form-horizontal" method='post' action="{{ route('statement.insert') }}" enctype="multipart/form-data"
                onsubmit="return validateData(this)">
                {{ csrf_field() }}
                <div class="col-md-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="white-box">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Add New Sale</h3>
                        <p class="text-muted  font-13"> Note: All * fields are mandatory </p>

                        <hr>

                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box">

                        <h3 class="box-title m-b-0"><i class="icon-layers fa fa-user"></i> Customer Information</h3>

                        <hr>
                        <div class="clearfix"></div>
                        <!-- Nav tabs -->
                        <ul class="nav customtab nav-tabs" role="tablist">
                            <li role="presentation" class="active">
                                <a href="#profile1" aria-controls="profile" role="tab" data-toggle="tab"
                                    aria-expanded="false" style="font-weight: 700;"><span class="visible-xs"><i
                                            class="ti-user"></i></span> <span class="hidden-xs">Existing Customer</span></a>
                            </li>
                            <!-- <li role="presentation" ><a href="#home1" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true" style="font-weight: 700;"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs"> New Customer</span></a></li>                                 -->
                        </ul>
                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div role="tabpanel" class="tab-pane fade active in" id="profile1">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Name of Applicant</label>
                                        <div class="col-md-8">
                                            <select autocomplete="off" class="form-control chosen-select" id="customer_id"
                                                name="customer_id" style="width: 100%!important;">
                                                <option value="" selected="">None</option>
                                                @foreach ($customers as $c)
                                                    @if (isset($customer))
                                                        @if ($customer->id == $c->id)
                                                            <option value="{{ $c->id }}" selected="">
                                                                {{ $c->name }} -

                                                                <b>{{ $c->cnic }}</b>

                                                            </option>
                                                        @endif
                                                    @else
                                                        @if (old('customer_id') == $c->id)
                                                            <option value="{{ $c->id }}" selected="">
                                                                {{ $c->name }} -
                                                                <b>{{ $c->cnic }}</b>
                                                            </option>
                                                        @else
                                                            <option value="{{ $c->id }}">{{ $c->name }} -
                                                                <b>{{ $c->cnic }}</b>
                                                            </option>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                <button type="button" style="float: left!important;"
                                    class="btn btn-primary add_field_button3">Add Nominee</button>
                                <div class="input_fields_wrap3">
                                    <div class="clearfix"></div>
                                    <div>
                                    </div>


                                </div>
                            </div>




                            <div role="tabpanel" class="tab-pane fade " id="home1">

                                <div class="form-body">
                                    <div class="row">

                                        <div class="col-md-12" style="margin-bottom: 2rem;">
                                            <div class="form-group">
                                                <label for="exampleInputuname" class="col-sm-3 control-label">Type<span
                                                        style="color: red">*</span></label>
                                                <div class="col-sm-9">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <input type="hidden" value="0" name="user_type"
                                                                id="type">
                                                            <label style="font-weight: bold;"> Individual </label>
                                                            <input type="radio" <?= old('type') == 0 ? 'checked' : '' ?>
                                                                onchange="return hideFields('individual')" name="radio_type"
                                                                style="margin-left: 1rem;">

                                                        </div>

                                                        <div class="col-sm-6">

                                                            <label style="font-weight: bold;"> Company </label>
                                                            <input type="radio" <?= old('type') == 1 ? 'checked' : '' ?>
                                                                onchange="return hideFields('company')" name="radio_type"
                                                                style="margin-left: 1rem;">

                                                        </div>

                                                    </div>


                                                    @if ($errors->has('type'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('type') }}</strong>
                                                        </span>
                                                    @endif

                                                </div>

                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Name of Applicant <span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="name"
                                                        value="{{ old('name') }}" placeholder="Enter Name">
                                                    @if ($errors->has('name'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('name') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" style="display: <?= old('type') == 1 ? 'none' : '' ?>"
                                            id="father_name_parent">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">S/O D/O W/O <span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" id="father_name"
                                                        name="father_name" value="{{ old('father_name') }}"
                                                        placeholder="">
                                                    <input type="radio" name="father_type" value="1">S/O
                                                    <input type="radio" name="father_type" value="2">D/O
                                                    <input type="radio" name="father_type" value="3"> W/O
                                                    @if ($errors->has('father_name'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('father_name') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="clearfix"></div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3"
                                                    id="cnic_no"><?= old('type') == 1 ? 'Incorporation no' : 'CNIC' ?>
                                                    <span style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        onfocusout="return validateCnic(this)"
                                                        value="{{ old('cnic') }}" name="cnic" id="cnic"
                                                        data-inputmask="'mask': '9999999999999'"
                                                        placeholder="XXXXXXXXXXXXX">
                                                    <input type="radio" name="cnic_flag" value="1"> Locally
                                                    <input type="radio" name="cnic_flag" value="2">
                                                    Internationally
                                                    @if ($errors->has('cnic'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('cnic') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>

                                                <div style="color: red;display: none;" id="cnic_error1">This Customer cnic
                                                    is found in list of DNFBP. You can't add this Customer record. </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6" id="passport_no"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Passport No.</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        value="{{ old('passport_no') }}" name="passport_no"
                                                        id="passport_no" placeholder="XXXXXXXXX">
                                                    @if ($errors->has('passport_no'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('passport_no') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3" id="date_of_birth">
                                                    <?= old('type') == 1 ? 'Date of Incorporation' : 'Date of Birth' ?>
                                                    <span style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="date" class="form-control"
                                                        value="{{ old('dob') }}" name="dob"
                                                        max="{{ date('Y-m-d') }}" id="dob"
                                                        placeholder="XX-XX-XXXX">
                                                    @if ($errors->has('dob'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('dob') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3"
                                                    id="occupations"><?= old('type') == 1 ? 'Type Of Company' : 'Occupation' ?>
                                                </label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        value="{{ old('occupation') }}" name="occupation"
                                                        id="occupation">
                                                    @if ($errors->has('occupation'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('occupation') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>



                                        <div class="clearfix"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3" id="mailing_label">
                                                    <?= old('type') == 1 ? 'Company Registered Address' : 'Mailing Address' ?>
                                                    <span style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <textarea class="form-control" name="mailing_address" id="mailing_address">{{ old('mailing_address') }}</textarea>
                                                    @if ($errors->has('mailing_address'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('mailing_address') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" id="permanent_add"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Permanent Address <span
                                                        style="color: red">*</span></label> &nbsp; &nbsp;&nbsp;same as
                                                above <input type="checkbox" id="same_address" name="same_address">
                                                <div class="col-md-9">
                                                    <textarea class="form-control" name="permanent_address" id="permanent_address">{{ old('permanent_address') }}</textarea>
                                                    @if ($errors->has('permanent_address'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('permanent_address') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="clearfix"></div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Email</label>
                                                <div class="col-md-9">
                                                    <input type="email" class="form-control" name="email"
                                                        value="{{ old('email') }}" id="exampleInputEmail1"
                                                        placeholder="Enter email">

                                                    @if ($errors->has('address'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('address') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Password</label>
                                                <div class="col-md-9">
                                                    <input type="text" autocomplete="off" class="form-control"
                                                        name="password" value="{{ old('password') }}"
                                                        id="exampleInputEmail1" placeholder="Enter Password">

                                                    @if ($errors->has('password'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('password') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3"
                                                    id="mobile_number"><?= old('type') == 1 ? 'Mobile Number' : 'Phone Number' ?>
                                                    <span style="color: red">*</span></label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control" type='number'
                                                        name="mobile_number" value="{{ old('mobile_number') }}"
                                                        placeholder="Enter Mobile Number">
                                                    @if ($errors->has('mobile_number'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('mobile_number') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" id="res_number"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Residential Number</label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control" name="res_number"
                                                        value="{{ old('res_number') }}" placeholder="Enter Res. Number">
                                                    @if ($errors->has('res_number'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('res_number') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" id="phone_number"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Phone Number</label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control" type='number'
                                                        name="phone_number" value="{{ old('phone_number') }}"
                                                        placeholder="Enter Phone Number">
                                                    @if ($errors->has('phone_number'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('phone_number') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="clearfix"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1" class="col-sm-3 control-label"
                                                    id="imgs_label"><?= old('type') == 1 ? 'Certificate' : 'Passport size photo' ?><span
                                                        style="color: red">*</span></label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="icon-picture"></i></div>
                                                        <label for="cropzee-input" class="image-previewer"
                                                            data-cropzee="cropzee-input"></label>
                                                        <input name="file" id="cropzee-input" class="form-control"
                                                            type="file" accept="image/*">

                                                        @if ($errors->has('file'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('file') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" id="photo_s"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1" class="col-sm-3 control-label">Documents
                                                    (CNIC, Passport etc) <span style="color: red">*</span></label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="icon-picture"></i></div>
                                                        <input multiple="" type="file" class="form-control"
                                                            name="photos[]">
                                                        @if ($errors->has('document'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('document') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">

                                            <div class="form-group">
                                                <label for="exampleInputEmail1" class="col-sm-3 control-label">Is Filer
                                                </label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="icon-phone"></i></div>
                                                        <select class="form-control select2" name="is_filer">
                                                            <option value="1">YES</option>
                                                            <option value="0">NO</option>
                                                        </select>


                                                        @if ($errors->has('is_filer'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('is_filer') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="exampleInputuname" class="col-sm-3 control-label">NTN
                                                    Number</label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="ti-user"></i></div>
                                                        <input type="text" class="form-control" name="ntn_number"
                                                            value="{{ old('ntn_number') }}" placeholder="Enter NTN">
                                                        @if ($errors->has('ntn_number'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('ntn_number') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>



                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="exampleInputuname" class="col-sm-3 control-label">Payment
                                                    Method</label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="ti-user"></i></div>
                                                        <select class="form-control chosen-select" name="payment_method">
                                                            <option
                                                                <?= old('payment_method') == \App\Customer::CASH ? 'selected' : '' ?>
                                                                value="0">Cash</option>
                                                            <option
                                                                <?= old('payment_method') == \App\Customer::BANK ? 'selected' : '' ?>
                                                                value="1">Bank</option>
                                                            <option
                                                                <?= old('payment_method') == \App\Customer::CHEAQUE ? 'selected' : '' ?>
                                                                value="2">Cheaque</option>
                                                            <option
                                                                <?= old('payment_method') == \App\Customer::OPEN_CHEAQUE ? 'selected' : '' ?>
                                                                value="3">Open Cheaque</option>
                                                        </select>

                                                        @if ($errors->has('payment_method'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('payment_method') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>





                                        <div class="clearfix"></div>

                                        <hr>


                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-3 control-label">Account
                                                Title</label>
                                            <div class="col-sm-9">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="account_title"
                                                        value="{{ old('account_title') }}"
                                                        placeholder="Enter Account Title">

                                                </div>
                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Bank Name
                                            </label>
                                            <div class="col-sm-9">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                                    <select class="form-control chosen-select" name="depositer_bank">
                                                        <option value="">None</option>
                                                        @foreach ($banks as $list)
                                                            <option value="{{ $list->id }}">{{ $list->name }}
                                                            </option>
                                                        @endforeach

                                                    </select>

                                                </div>
                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-3 control-label">IBAN
                                                Number</label>
                                            <div class="col-sm-9">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="iban_number"
                                                        value="{{ old('iban_number') }}"
                                                        placeholder="Enter Account IBAN Number">

                                                </div>
                                            </div>
                                        </div>


                                        <div class="clearfix"></div>
                                        <hr>

                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-3 control-label">Name 2</label>

                                            <div class="col-sm-3">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="first_owner"
                                                        value="{{ old('first_owner') }}" placeholder="Enter First Owner">

                                                </div>
                                            </div>

                                            <label for="exampleInputuname" class="col-sm-2 control-label">Name 3</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="second_owner"
                                                        value="{{ old('second_owner') }}"
                                                        placeholder="Enter Second Owner">

                                                </div>
                                            </div>

                                        </div>



                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-3 control-label">First Owner
                                                Father</label>

                                            <div class="col-sm-3">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="first_owner_father"
                                                        value="{{ old('first_owner_father') }}"
                                                        placeholder="Enter First Owner">

                                                </div>
                                            </div>

                                            <label for="exampleInputuname" class="col-sm-2 control-label">Second Owner
                                                Father</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="second_owner_father"
                                                        value="{{ old('second_owner_father') }}"
                                                        placeholder="Enter Second Owner Father">

                                                </div>
                                            </div>

                                        </div>



                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-3 control-label">First Owner
                                                Cnic</label>

                                            <div class="col-sm-3">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="first_owner_cnic"
                                                        value="{{ old('first_owner_cnic') }}"
                                                        placeholder="Enter First Owner Cnic">

                                                </div>
                                            </div>

                                            <label for="exampleInputuname" class="col-sm-2 control-label">Second Owner
                                                Cnic</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="second_owner_cnic"
                                                        value="{{ old('second_owner_cnic') }}"
                                                        placeholder="Enter Second Owner Cnic">

                                                </div>
                                            </div>

                                        </div>


                                        <div class="clearfix"></div>
                                        <hr>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Nominee Name <span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="nominee_name"
                                                        value="{{ old('nominee_name') }}" id="exampleInputuname"
                                                        placeholder="Enter Name">
                                                    @if ($errors->has('nominee_name'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_name') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">S/O, D/O, W/O.<span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="nominee_so_do_wo"
                                                        value="{{ old('nominee_so_do_wo') }}" id="exampleInputuname"
                                                        placeholder="Enter Father Name">
                                                    <input type="radio" name="nominee_father_type" value="1">S/O
                                                    <input type="radio" name="nominee_father_type" value="2">D/O
                                                    <input type="radio" name="nominee_father_type" value="3"> W/O
                                                    @if ($errors->has('nominee_so_do_wo'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_so_do_wo') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">CNIC</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        value="{{ old('nominee_cnic') }}"
                                                        onfocusout="return validateCnic(this)" name="nominee_cnic"
                                                        id="nominee_cnic" data-inputmask="'mask': '9999999999999'"
                                                        placeholder="XXXXXXXXXXXXX">
                                                    <input type="radio" name="nominee_cnic_flag" value="1">
                                                    Locally
                                                    <input type="radio" name="nominee_cnic_flag" value="2">
                                                    Internationally


                                                    @if ($errors->has('nominee_cnic'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_cnic') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>

                                                <div style="color: red;display: none;" id="cnic_error1">This Customer cnic
                                                    is found in list of DNFBP. You can't add this Customer record. </div>

                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group" id="nominee_address">
                                                <label for="address" class="col-sm-3 control-label"
                                                    id="nominee_address">Nominee Address <span
                                                        style="color: red">*</span></label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="icon-location-pin"></i>
                                                        </div>
                                                        <textarea class="form-control" id="nominee_address" name="nominee_address">{{ old('nominee_address') }}</textarea>
                                                        @if ($errors->has('nominee_address'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('nominee_address') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Passport No.</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        value="{{ old('nominee_passport_no') }}"
                                                        name="nominee_passport_no" id="nominee_passport_no"
                                                        placeholder="XXXXXXXXX">
                                                    @if ($errors->has('nominee_passport_no'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_passport_no') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Relation With Applicant <span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="nominee_relation"
                                                        value="{{ old('nominee_relation') }}"
                                                        placeholder="Enter Relation">
                                                    @if ($errors->has('nominee_relation'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_relation') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Email</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="nominee_email"
                                                        value="{{ old('nominee_email') }}" placeholder="Enter Email">
                                                    @if ($errors->has('nominee_email'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_email') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Mobile Number </label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control"
                                                        name="nominee_mobile_number"
                                                        value="{{ old('nominee_mobile_number') }}"
                                                        placeholder="Enter Mobile Number">
                                                    @if ($errors->has('nominee_mobile_number'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_mobile_number') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Res. Number </label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control" name="nominee_res_number"
                                                        value="{{ old('nominee_res_number') }}"
                                                        placeholder="Enter Res Number">
                                                    @if ($errors->has('nominee_res_number'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_res_number') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Phone Number </label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control"
                                                        name="nominee_phone_number"
                                                        value="{{ old('nominee_phone_number') }}"
                                                        placeholder="Enter Phone Number">
                                                    @if ($errors->has('nominee_phone_number'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('nominee_phone_number') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="clearfix"></div>
                                        <button type="button" style="float: left!important;"
                                            class="btn btn-primary add_field_button4">Add Nominee</button>
                                        <div class="input_fields_wrap4">
                                            <div class="clearfix"></div>
                                            <div>
                                            </div>


                                        </div>

                                    </div>

                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>



                @if ($projecttype->id == \App\ProjectType::society)
                    {{-- Inventory Type --}}
                    <div class="col-lg-12 col-sm-12 col-xs-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-layers fa fa-map"></i> Select Unit Type</h3>


                            <hr />
                            <div class="clearfix"></div>
                            <!-- Nav tabs -->
                            <ul class="nav customtab nav-tabs" role="tablist">
                                <li role="presentation" class="active">
                                    <a onclick='addBasicUnit();' aria-controls="profile" role="tab"
                                        data-toggle="tab" aria-expanded="false" style="font-weight: 700;">
                                        <span class="visible-xs"><i class="ti-user"></i></span> <span
                                            class="hidden-xs">Direct End User</span>
                                    </a>
                                </li>
                                <li role="presentation">
                                    <a onclick='addDealerUnit();' aria-controls="home" role="tab" data-toggle="tab"
                                        aria-expanded="true" style="font-weight: 700;">
                                        <span class="visible-xs"><i class="ti-home"></i></span><span
                                            class="hidden-xs">Open File End User</span>
                                    </a>
                                </li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane fade active in">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">Unit #</label>
                                            <div class="col-md-8">

                                                <div id='addUnitDetail'>
                                                    <select class="form-control chosen-select" id="unit_number"
                                                        name="unit_number" data-id='0'>
                                                        <option value="" selected="">None</option>
                                                        @foreach ($unitNumbers as $unit)
                                                            <option value="{{ $unit->id }}">{{ $unit->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>


                                                @if ($errors->has('unit_number'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('unit_number') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>

                                    <div class="input_fields_wrap3">
                                        <div class="clearfix"></div>
                                        <div></div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                    {{-- End Inventory Type --}}
                @endif



                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box1">
                        <h3 class="box-title">Unit Information</h3>
                        <hr>
                        <input type="hidden" name='inventory_id' id='inventory-id' value='{{ old('inventory_id') }}'>









                        @if ($projecttype->id == \App\ProjectType::high_rise)

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Unit # <span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" id="unit_number" name="unit_number"
                                            data-id='0'>
                                            <option value="" selected="">None</option>
                                            @foreach ($unitNumbers as $unit)
                                                <option value="{{ $unit->id }}">{{ $unit->name }}</option>
                                            @endforeach
                                        </select>

                                        @if ($errors->has('unit_number'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('unit_number') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>


                        @endif









                        <div class="col-md-6" id="inventory_type">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Type</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="type"
                                        value="{{ old('type') }}" id="type">
                                    @if ($errors->has('type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Size</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="size"
                                        value="{{ old('size') }}" id="size">
                                    @if ($errors->has('size'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('size') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Price</label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='total-amount' class="form-control"
                                        name="total_price" value="{{ old('total_price') }}">
                                    @if ($errors->has('total_price'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('total_price') }}</strong>
                                        </span>
                                    @endif
                                    <div style="color:black;" class="help-block" id='total-amount-label'></div>
                                </div>
                            </div>
                        </div>


                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Category</label>
                                <div class="col-md-8">

                                    <input readonly="" type="category" class="form-control" name="category"
                                        value="{{ old('category') }}" id="category">
                                    @if ($errors->has('category'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('category') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <!--    <div class="col-md-6" >
                                <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Access Amount </label>
                                <div class="col-md-8">

                                <input  type="text"  id='access_amount' class="form-control" name="access_amount" value="{{ old('access_amount') }}">

                                </div>
                                </div>
                                </div> -->



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Extra Charges </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='extra_charges' class="form-control"
                                        name="extra_charges" value="{{ old('extra_charges') }}">

                                    <div style="color:black;" class="help-block" id='extra-charges-label'></div>
                                </div>
                            </div>
                        </div>


                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Unit Description </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='description' class="form-control"
                                        name="description" value="{{ old('description') }}">


                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Discount<br> (use percent <input type="checkbox"
                                        onclick="percentCheckbox()" name="discount_percent"
                                        id="discount_percent">)</label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 12px;"
                                            id="dis_input">PKR</span>
                                        <input id='discount_s' type="numeric" class="form-control" name="discount"
                                            value="{{ old('discount') }}" placeholder="Enter Discount ">
                                    </div>

                                    @if ($errors->has('discount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('discount') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>






                        <div class="clearfix"></div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Net Amount</label>
                                <div class="col-md-8">
                                    <input type="hidden" id="dummy_net_amount">
                                    <input readonly="" type="text" id='net_amount' class="form-control"
                                        name="net_amount" value="{{ old('net_amount') }}">
                                    @if ($errors->has('net_amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('net_amount') }}</strong>
                                        </span>
                                    @endif
                                    <div style="color:black;" class="help-block" id='net_amount-label'></div>

                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>

                        <!-- <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-4">Membership Number </label>
                                                            <div class="col-md-8">

                                                                <input type="text" class="form-control" name="membership_number" value="{{ old('membership_number') }}" id="exampleInputEmail1" placeholder="Enter Membership Number">
                                            @if ($errors->has('membership_number'))
    <span class="help-block">
                                            <strong>{{ $errors->first('membership_number') }}</strong>
                                        </span>
    @endif
    </div>
    </div>
                                </div> -->



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Booking Date <span
                                        style="color:red">*</span></label>
                                <div class="col-md-8">

                                    <input type="date" class="form-control" name="original_boooking_date"
                                        value="{{ old('original_boooking_date') }}" id="original_boooking_date"
                                        placeholder="Enter Booking Date">
                                    @if ($errors->has('original_boooking_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('original_boooking_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4"> Rate <br> (Per {{ env('SIZE') }})</label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <span style="display:none;" id="sqrt"></span>
                                        <input readonly="" style="width: 37.5rem;" type="text" id='per_sqrt_value'
                                            class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>




                        <!--    <div class="col-md-6" >
                                    <div class="form-group">
                                         <label class="control-label col-md-4">Downpayment Date <span style="color:red">*</span></label>
                                        <div class="col-md-8">

                                        <input type="date" class="form-control" name="booking_date" value="{{ old('booking_date') }}" id="exampleInputEmail1" placeholder="Enter Booking Date">
                                        @if ($errors->has('booking_date'))
    <span class="help-block">
                                        <strong>{{ $errors->first('booking_date') }}</strong>
                                        </span>
    @endif
                                        </div>
                                </div>
                                </div> -->
                        <div class="clearfix"></div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-5">Booking Type <span
                                        style="color: red">*</span></label>
                                <div class="col-md-7">

                                    <input type='radio' onchange="activeNormal()" name="booking_type"
                                        value='{{ \App\CustomerProperty::normal }}' checked=""> Installment<br>

                                    <input type='radio' onchange="activeFullPayment()" name="booking_type"
                                        value='{{ \App\CustomerProperty::full_payment }}'> Full Payment
                                    @if ($errors->has('booking_type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('booking_type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>




                    </div>
                </div>
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box">
                        <h3 class="box-title" style="display: inline-block;">Dealer Rebate Information</h3>
                        <span style="margin-left:17%">%
                            <input type="float" name="rebate_in_percentage" style="width: 5%;display: inherit;"
                                class="form-control" id="rebate_in_percentage">
                            <input type="float" class="form-control" style="width: 10%;display: inherit;"
                                name="rebate_in_amount" id="rebate_in_amount"> PKR</span>
                        <a class="btn btn-outline btn-default waves-effect waves-light pull-right add_field_button5"
                            style="margin-top: 9px"> <span>Add More</span></a>
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Authorized Dealer </label>
                                <div class="col-md-8">
                                    <select class="form-control  " name="dealer_id[]" id="dealer_id">
                                        <option value="">None</option>
                                        @foreach ($dealers as $dealer)
                                            @foreach ($dealer as $d)
                                                @if ($loop->first)
                                                    <optgroup label="{{ $dealerTypes[$d->dealer_type_id] }}">
                                                @endif
                                                @if (old('dealer_id'))
                                                    @if (old('dealer_id') == $d->id)
                                                        <option value="{{ $d->id }}" selected="">
                                                            {{ $d->name }} ( {{ $d->percentage }} %)</option>
                                                    @else
                                                        <option value="{{ $d->id }}">{{ $d->name }} (
                                                            {{ $d->percentage }} %)</option>
                                                    @endif
                                                @else
                                                    <option value="{{ $d->id }}">{{ $d->name }} (
                                                        {{ $d->percentage }} %)</option>
                                                @endif
                                            @endforeach
                                            <!-- </optgroup> -->
                                        @endforeach
                                    </select>
                                    @if ($errors->has('dealer_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('dealer_id') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="clearfix"></div>


                        <div class="col-md-8">
                            <div class="form-group">
                                <label class="control-label col-md-6"> Rebate </label>
                                <div class="col-md-6">
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 10px;">PKR</span>
                                        <input id="total_rebate1" type="text" class="form-control total_rebate"
                                            name="total_rebate[]" value="">


                                        @if ($errors->has('total_rebate'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('total_rebate') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>








                        <div class="input_fields_wrap5">
                            <div class="clearfix"></div>
                            <div>
                            </div>


                        </div>

                        <input style="    width: 20%;" readonly="" type="integer" id='remaining_amount_in_rebate'
                            class="form-control" placeholder="Remaining amount">



                    </div>
                </div>




                <div class="col-lg-12 col-sm-12 col-xs-12" id="" style="display:none">
                    <div class="white-box">
                        <h3 class="box-title">Discount Payment Terms</h3>
                        isDiscounted? <input type="checkbox" name="full_discount" value="1"
                            id="discount_full_payment" onclick="fullPaymentBox()">
                        <div id="discount_div" style="display: none">
                            <hr>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Total Amount <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input id="total_amount_full_payment" readonly="" class="form-control"
                                            type='number' name="total_amount_full_payment">
                                        @if ($errors->has('total_amount_full_payment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('total_amount_full_payment') }}</strong>
                                            </span>
                                        @endif
                                        <div style="color:black;" class="help-block"
                                            id='total-amount-full-payment-label'></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Total Tenure (months)<span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input class="form-control" id="total_tenure_full_payment" type='number'
                                            name="total_tenure_full_payment">
                                        @if ($errors->has('total_tenure_full_payment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('total_tenure_full_payment') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Discount Percentage <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input id="discount_percentage_full_payment" class="form-control" type='numeric'
                                            name="discount_percentage_full_payment">
                                        @if ($errors->has('discount_percentage_full_payment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('discount_percentage_full_payment') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Return Tenure <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">
                                        <select class="form-control chosen-select" name="return_tenure_full_payment"
                                            id="return_tenure_full_payment">
                                            @if (old('return_tenure_full_payment'))
                                                @if (old('reutrn_tenure_full_payment') == \App\CustomerProperty::monthly)
                                                    <option selected="" value="{{ \App\CustomerProperty::monthly }}">
                                                        Monthly</option>
                                                    <option value="{{ \App\CustomerProperty::quarterly }}">Quarterly
                                                    </option>
                                                    <option value="{{ \App\CustomerProperty::semi_annually }}">Semi
                                                        Annually</option>
                                                    <option value="{{ \App\CustomerProperty::annually }}">Annually
                                                    </option>
                                                @elseif(old('reutrn_tenure_full_payment') == \App\CustomerProperty::quarterly)
                                                    <option value="{{ \App\CustomerProperty::monthly }}">Monthly</option>
                                                    <option selected=""
                                                        value="{{ \App\CustomerProperty::quarterly }}">Quarterly</option>
                                                    <option value="{{ \App\CustomerProperty::semi_annually }}">Semi
                                                        Annually</option>
                                                    <option value="{{ \App\CustomerProperty::annually }}">Annually
                                                    </option>
                                                @elseif(old('reutrn_tenure_full_payment') == \App\CustomerProperty::semi_annually)
                                                    <option value="{{ \App\CustomerProperty::monthly }}">Monthly</option>
                                                    <option value="{{ \App\CustomerProperty::quarterly }}">Quarterly
                                                    </option>
                                                    <option selected=""
                                                        value="{{ \App\CustomerProperty::semi_annually }}">Semi Annually
                                                    </option>
                                                    <option value="{{ \App\CustomerProperty::annually }}">Annually
                                                    </option>
                                                @elseif(old('reutrn_tenure_full_payment') == \App\CustomerProperty::annually)
                                                    <option value="{{ \App\CustomerProperty::monthly }}">Monthly</option>
                                                    <option value="{{ \App\CustomerProperty::quarterly }}">Quarterly
                                                    </option>
                                                    <option value="{{ \App\CustomerProperty::semi_annually }}">Semi
                                                        Annually</option>
                                                    <option selected=""
                                                        value="{{ \App\CustomerProperty::annually }}">Annually</option>
                                                @else
                                                    <option selected="" value="{{ \App\CustomerProperty::monthly }}">
                                                        Monthly</option>
                                                    <option value="{{ \App\CustomerProperty::quarterly }}">Quarterly
                                                    </option>
                                                    <option value="{{ \App\CustomerProperty::semi_annually }}">Semi
                                                        Annually</option>
                                                    <option value="{{ \App\CustomerProperty::annually }}">Annually
                                                    </option>
                                                @endif
                                            @else
                                                <option selected="" value="{{ \App\CustomerProperty::monthly }}">
                                                    Monthly</option>
                                                <option value="{{ \App\CustomerProperty::quarterly }}">Quarterly
                                                </option>
                                                <option value="{{ \App\CustomerProperty::semi_annually }}">Semi Annually
                                                </option>
                                                <option value="{{ \App\CustomerProperty::annually }}">Annually</option>
                                            @endif

                                        </select>
                                        @if ($errors->has('return_tenure_full_payment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('return_tenure_full_payment') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Discount Amount<span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input readonly="" class="form-control" id="discount_amount_full_payment"
                                            type='number' name="discount_amount_full_payment">
                                        @if ($errors->has('discount_amount_full_payment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('discount_amount_full_payment') }}</strong>
                                            </span>
                                        @endif
                                        <div style="color:black;" class="help-block"
                                            id='rebate-amount-full-payment-label'></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Deduction Amount </label>
                                    <div class="col-md-7">

                                        <input id="deduction_amount_full_payment" class="form-control" type='number'
                                            name="deduction_amount_full_payment">
                                        @if ($errors->has('deduction_amount_full_payment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('deduction_amount_full_payment') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Net Amount after Deduction<span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input readonly="" id="net_amount_full_payment" class="form-control"
                                            type='number' name="net_amount_full_payment">
                                        @if ($errors->has('net_amount_full_payment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('net_amount_full_payment') }}</strong>
                                            </span>
                                        @endif
                                        <div style="color:black;" class="help-block"
                                            id='net-amount-full-payment-label'></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Per tenure Amount</label>
                                    <div class="col-md-7">

                                        <input readonly="" id="per_full_payment" class="form-control"
                                            type='number' name="per_full_payment">
                                        @if ($errors->has('per_full_payment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('per_full_payment') }}</strong>
                                            </span>
                                        @endif
                                        <div style="color:black;" class="help-block" id='per-full-payment-label'>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>


                <div class="col-lg-12 col-sm-12 col-xs-12" id="normal">
                    <div class="white-box">
                        <h3 class="box-title">Payment Scheduler</h3>
                        <hr>

                        <!--    <div class="col-md-6">
                                    <div class="form-group">
                                    <label class="control-label col-md-5">Amount Schedule in <span style="color: red">*</span></label>
                                    <div class="col-md-7">

                                    <input type='radio' onchange="manToPer()" name="amount_schedule" value='1' > Percentage<br>
                                    <input type='radio' onchange="perToMan()"  name="amount_schedule" value='2' checked="" > Manual
                                    @if ($errors->has('amount_schedule'))
    <span class="help-block">
                                    <strong>{{ $errors->first('amount_schedule') }}</strong>
                                    </span>
    @endif
    </div>
    </div>
                                    </div>

                                    <div class="col-md-6">
                                    <div class="form-group">
                                    <label class="control-label col-md-5">Schedule Start Date <span style="color:red">*</span></label>
                                    <div class="col-md-7">

                                    <input type="date" class="form-control" name="schedule_start_date" value="{{ old('schedule_start_date') }}" id="exampleInputEmail1" placeholder="Enter Schedule Start Date">
                                    @if ($errors->has('schedule_start_date'))
    <span class="help-block">
                                    <strong>{{ $errors->first('schedule_start_date') }}</strong>
                                    </span>
    @endif
    </div>
                                    </div>
                                    </div>

                                <div class="clearfix"></div>
                                <hr> -->
                        <div class="col-md-12">

                            <div class="form-group">
                                <label class="control-label col-md-2">Schedular Type<span
                                        style="color: red">*</span></label>


                                <div class="col-md-10">


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_mon }}'> Monthly
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableQuar()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_mon_w_quar }}' checked="">
                                        Monthly with Quarterly
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableSemi()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_mon_w_semi }}' checked="">
                                        Monthly with Semi Annually
                                    </div>


                                    <div class="clearfix"></div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableAnn()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_mon_w_ann }}' checked="">
                                        Monthly with Annually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_bi_mon }}'> Bi Monthly
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_quar }}'> Quarterly
                                    </div>


                                    <div class="clearfix"></div>

                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableSemi()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_quar_w_semi }}'> Quarterly with
                                        SemiAnnually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_semi }}'> SemiAnnually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_ann }}'> Annually
                                    </div>

                                    <div class="clearfix"></div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableAnn()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_mon_exclude_ann }}'> Monthly exclude
                                        Annually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableQuar()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_mon_exclude_quar }}'> Monthly exclude
                                        Quarterly
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableSemi()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_mon_exclude_semi }}'> Monthly exclude
                                        Semi Annually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableSemi()" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_quar_exclude_semi }}'> Quarterly
                                        exclude SemiAnnually
                                    </div>



                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableCustom(this.value)" name="schedule_type"
                                            value='{{ \App\CustomerProperty::inst_custom }}'> Custom
                                    </div>


                                    @if ($errors->has('schedule_type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('schedule_type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
















                        <div class="clearfix"></div>
                        <hr>

                        {{-- 1st row --}}
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">Possession Date </label>
                                <input type="date" id='possession_date' class="form-control"
                                    name="possession_date" value="{{ $possession_date }}">

                                @if ($errors->has('possession_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('possession_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Possession <span style="color: red">*</span></label>
                                <input type="integer" id='possession' class="form-control" name="possession"
                                    value="{{ old('possession') }}" placeholder="Enter Possession">
                                <div style="color:black;" class="help-block" id='possession-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                {{-- <input type="text" class="form-control" placeholder="Column 3"> --}}
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_possession" placeholder="%">
                                </div>
                                @if ($errors->has('possession'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('possession') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Down Payment Date <span style="color:red">*</span></label>

                                <input type="date" class="form-control" name="booking_date"
                                    value="{{ date('Y-m-d') }}" id="booking_date">
                                @if ($errors->has('booking_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('booking_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Down Payment <span style="color: red">*</span></label>
                                <input type="integer" id='down-payment' class="form-control" name="down_payment"
                                    value="{{ old('down_payment') }}" placeholder="Down Payment">
                                <div style="color:black;" class="help-block" id='down-payment-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_down_payment"
                                        placeholder="%">
                                </div>
                                @if ($errors->has('down_payment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('down_payment') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        {{-- 2nd row --}}
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">Allotment Date </label>
                                <input type="date" id='allotment_date' class="form-control"
                                    value="{{ date('Y-m-d') }}" name="allotment_date">

                                @if ($errors->has('allotment_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('allotment_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Allotment <span style="color: red">*</span></label>
                                <input type="integer" id='allotment' class="form-control" name="allotment"
                                    value="{{ old('allotment') }}" placeholder="Enter Allotment">
                                <div style="color:black;" class="help-block" id='allotment-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_allotment" placeholder="%">
                                </div>
                                @if ($errors->has('allotment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('allotment') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label ">Confirmation Date </label>
                                <input type="date" id='confirmation_date' value="{{ date('Y-m-d') }}"
                                    class="form-control" name="confirmation_date">

                                @if ($errors->has('confirmation_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('confirmation_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Confirmation <span style="color: red">*</span></label>
                                <input type="integer" id='confirmation' class="form-control" name="confirmation"
                                    value="{{ old('confirmation') }}" placeholder="Confirmation">
                                <div style="color:black;" class="help-block" id='confirmation-label'></div>

                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_confirmation"
                                        placeholder="%">

                                </div>


                                @if ($errors->has('confirmation'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('confirmation') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        {{-- 3rd row --}}
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">Schedule Start Date <span
                                        style="color:red">*</span></label>

                                <input type="date" class="form-control" name="schedule_start_date"
                                    value="{{ date('Y-m-d') }}" id="schedule_start_date"
                                    placeholder="Enter Schedule Start Date">
                                @if ($errors->has('schedule_start_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('schedule_start_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Booking <span style="color: red">*</span></label>
                                <input type="integer" id='booking' class="form-control" name="booking"
                                    value="{{ old('booking') }}" placeholder="Enter Booking">
                                <div style="color:black;" class="help-block" id='booking-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_booking" placeholder="%">
                                </div>


                                @if ($errors->has('booking'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('booking') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label ">Development Date </label>
                                <input type="date" id='development_date' value="{{ date('Y-m-d') }}"
                                    class="form-control" name="development_date">

                                @if ($errors->has('development_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('development_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Development <span style="color: red">*</span></label>
                                <input type="integer" id='development' class="form-control" name="development"
                                    value="{{ old('development') }}" placeholder="Development">
                                <div style="color:black;" class="help-block" id='development-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_development" placeholder="%">

                                </div>


                                @if ($errors->has('development'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('development') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        {{-- 4th row --}}
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">File Processing Date </label>
                                <input type="date" id='file_processing_date' value="{{ date('Y-m-d') }}"
                                    class="form-control" name="file_processing_date">

                                @if ($errors->has('file_processing_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('file_processing_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">File Processing <span style="color: red">*</span></label>
                                <input type="integer" id='file_processing' class="form-control"
                                    name="file_processing" value="{{ old('file_processing') }}"
                                    placeholder="Enter File Processing">
                                <div style="color:black;" class="help-block" id='file_processing-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_file_processing"
                                        placeholder="%">

                                </div>


                                @if ($errors->has('file_processing'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('file_processing') }}</strong>
                                    </span>
                                @endif

                            </div>
                            <div class="col-md-2">
                                <label class="control-label ">Registration Date </label>
                                <input type="date" id='registration_date' value="{{ date('Y-m-d') }}"
                                    class="form-control" name="registration_date">

                                @if ($errors->has('registration_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('registration_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Registration <span style="color: red">*</span></label>
                                <input type="integer" id='registration' class="form-control" name="registration"
                                    value="{{ old('registration') }}" placeholder="Registration">
                                <div style="color:black;" class="help-block" id='registration-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_registration"
                                        placeholder="%">

                                </div>


                                @if ($errors->has('registration'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('registration') }}</strong>
                                    </span>
                                @endif

                            </div>
                        </div>

                        {{-- 5th row --}}
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">Ballon Payment Date </label>
                                <input type="date" id='ballonpayment_date' value="{{ date('Y-m-d') }}"
                                    class="form-control" name="ballonpayment_date">

                                @if ($errors->has('ballonpayment_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ballonpayment_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Ballon Payment<span style="color: red">*</span></label>
                                <input type="integer" id='ballon' class="form-control" name="ballon"
                                    value="{{ old('ballon') }}" placeholder="Enter Ballon">
                                <div style="color:black;" class="help-block" id='ballon-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_file_ballon" placeholder="%">

                                </div>


                                @if ($errors->has('ballon'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ballon') }}</strong>
                                    </span>
                                @endif

                            </div>
                            <div class="col-md-2">
                                <label class="control-label ">Bulleting Date </label>
                                <input type="date" id='bulleting_date' value="{{ date('Y-m-d') }}"
                                    class="form-control" name="bulleting_date">

                                @if ($errors->has('bulleting_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bulleting_date') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Bulleting <span style="color: red">*</span></label>
                                <input type="integer" id='bulleting' class="form-control" name="bulleting"
                                    value="{{ old('bulleting') }}" placeholder="Bulleting">
                                <div style="color:black;" class="help-block" id='bullating-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_bulleting" placeholder="%">

                                </div>


                                @if ($errors->has('bulleting'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bulleting') }}</strong>
                                    </span>
                                @endif

                            </div>
                        </div>






















                        <div class="col-md-1"></div>


                        <div class="clearfix"></div>

                        <div id="auto" style="margin-top: 2%;">

                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Per Installment <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 23%;" type="integer"
                                            id='installment' class="form-control" name="installment"
                                            value="{{ old('installment') }}" placeholder="Per installment">
                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_installment"
                                            placeholder="%" style="width: 15%;display: inline-block;">




                                        <input style="display: inline-block;width: 28%;" type="integer"
                                            id='total_installment' class="form-control" name="total_installment"
                                            value="{{ old('total_installment') }}" placeholder="Total amount">

                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_total_installment"
                                            placeholder="%" style="width: 10%;display: inline-block;">


                                        <!-- <label class="control-label col-md-5">Total Installments (Months) <span style="color: red">*</span></label> -->
                                        <input type="integer" style="width: 10.5%;display: inline-block;"
                                            id='total-months' class="form-control" name="installment_plan"
                                            value="{{ old('installment_plan') }}" placeholder="Count">

                                        <div style="display: inline-block;width: 49%;color:black;" class="help-block"
                                            id='installment-label'></div>
                                        <div style="display: inline-block;width: 49%;color:black;" class="help-block"
                                            id='total-installment-label'></div>
                                        @if ($errors->has('installment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('installment') }}</strong>
                                            </span>
                                        @endif

                                        @if ($errors->has('installment_plan'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('installment_plan') }}</strong>
                                            </span>
                                        @endif
                                        <div style="color:black;" class="help-block" id='total-months-label'></div>
                                    </div>


                                </div>
                            </div>


                            <div class="col-md-10" id="ann_div">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Annual Installments <br> <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">
                                        <input style="display: inline-block;width: 43%;" type="integer"
                                            id='annual-installment' class="form-control" name="annual_installment"
                                            value="{{ old('annual_installment') }}" id="exampleInputEmail1"
                                            placeholder=" Annual">

                                        <input style="display: inline-block;width: 40%;" type="integer"
                                            id='total_annual_installment' class="form-control"
                                            name="total_annual_installment"
                                            value="{{ old('total_annual_installment') }}" id="exampleInputEmail1"
                                            placeholder="Total Annual">
                                        <input style="display: inline-block;width: 15%;" type="integer"
                                            id='total_annual_installment_count' class="form-control"
                                            name="total_annual_installment_count"
                                            value="{{ old('total_annual_installment_count') }}"
                                            id="exampleInputEmail1" placeholder="Count">
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='annual-installment-label'></div>
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='total-annual-installment-label'></div>
                                        @if ($errors->has('annual_installment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('annual_installment') }}</strong>
                                            </span>
                                        @endif

                                    </div>
                                </div>
                            </div>

                            <div class="col-md-10" id="semi_div" style="display: none">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Semi Installments <br> <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">
                                        {{-- <input style="display: inline-block;width: 43%;" type="integer" id='semi-installment' class="form-control" name="semi_installment" value="{{old('semi_installment')}}" id="exampleInputEmail1" placeholder=" Semi">
                        
                        <input style="display: inline-block;width: 40%;" type="integer" id='total_semi_installment' class="form-control" name="total_semi_installment" value="{{old('total_semi_installment')}}" id="exampleInputEmail1" placeholder="Total Semi Annually">
                        <input style="display: inline-block;width: 15%;" type="integer" id='total_semi_installment_count' class="form-control" name="total_semi_installment_count" value="{{old('total_semi_installment_count')}}" id="exampleInputEmail1" placeholder="Count">
                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"  id='semi-installment-label'></div>
                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"  id='total-semi-installment-label'></div>
                        @if ($errors->has('semi_installment'))
                        <span class="help-block">
                        <strong>{{ $errors->first('semi_installment') }}</strong>
                        </span>
                        @endif --}}
                                        <input style="display: inline-block;width: 23%;" type="integer"
                                            id='semi-installment' class="form-control" name="semi_installment"
                                            value="{{ old('semi_installment') }}" id="exampleInputEmail1"
                                            placeholder=" Semi">


                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_semi_installment"
                                            placeholder="%" style="width: 15%;display: inline-block;">


                                        <input style="display: inline-block;width: 28%;" type="integer"
                                            id='total_semi_installment' class="form-control"
                                            name="total_semi_installment" value="{{ old('total_semi_installment') }}"
                                            id="exampleInputEmail1" placeholder="Total Semi Annually">


                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_total_semi_installment"
                                            placeholder="%" style="width: 10%;display: inline-block;">



                                        <input style="width: 10.5%;display: inline-block;" type="integer"
                                            id='total_semi_installment_count' class="form-control"
                                            name="total_semi_installment_count"
                                            value="{{ old('total_semi_installment_count') }}" id="exampleInputEmail1"
                                            placeholder="Count">

                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='semi-installment-label'></div>
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='total-semi-installment-label'></div>
                                        @if ($errors->has('semi_installment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('semi_installment') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-10" id="bi_mon_div" style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Bi Monthly Installments <br> <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">
                                        <input style="display: inline-block;width: 40%;" type="integer"
                                            id='bi-mon-installment' class="form-control" name="bi_mon_installment"
                                            value="{{ old('bi_mon_installment') }}" id="exampleInputEmail1"
                                            placeholder=" Bi Monthly">

                                        <input style="display: inline-block;width: 40%;" type="integer" readonly=""
                                            id='total_bi_mon_installment' class="form-control"
                                            name="total_bi_mon_installment"
                                            value="{{ old('total_bi_mon_installment') }}" id="exampleInputEmail1"
                                            placeholder="Total Bi Monthly">
                                        <input style="display: inline-block;width: 15%;" type="integer" readonly=""
                                            id='total_bi_mon_installment_count' class="form-control"
                                            name="total_bi_mon_installment_count"
                                            value="{{ old('total_bi_mon_installment_count') }}"
                                            id="exampleInputEmail1" placeholder="Count">
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='bi-mon-installment-label'></div>
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='total-bi-mon-installment-label'></div>
                                        @if ($errors->has('bi_mon_installment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('bi_mon_installment') }}</strong>
                                            </span>
                                        @endif

                                    </div>
                                </div>
                            </div>

                            <div class="col-md-10" id="quar_div" style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Quarterly Installments <br> <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">
                                        <input style="display: inline-block;width: 43%;" type="integer"
                                            id='quarterly-installment' class="form-control"
                                            name="quarterly_installment" value="{{ old('quarterly_installment') }}"
                                            id="exampleInputEmail1" placeholder=" Quarterly">

                                        <input style="display: inline-block;width: 40%;" type="integer"
                                            id='total_quarterly_installment' class="form-control"
                                            name="total_quarterly_installment"
                                            value="{{ old('total_quarterly_installment') }}" id="exampleInputEmail1"
                                            placeholder="Total Quarterly">
                                        <input style="display: inline-block;width: 15%;" type="integer" readonly=""
                                            id='total_quarterly_installment_count' class="form-control"
                                            name="total_quarterly_installment_count"
                                            value="{{ old('total_quarterly_installment_count') }}"
                                            id="exampleInputEmail1" placeholder="Count">
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='quarterly-installment-label'></div>
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='total-quarterly-installment-label'></div>
                                        @if ($errors->has('quarterly_installment'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('quarterly_installment') }}</strong>
                                            </span>
                                        @endif

                                    </div>
                                </div>
                            </div>




                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Remaining Amount</label>
                                    <div class="col-md-7">

                                        <input readonly="" type="integer" id='remaining_amount'
                                            class="form-control" value="{{ old('remaining_amount') }}"
                                            placeholder="Remaining amount">
                                        <br>


                                        Adjust to <br>

                                        <ul type="none">

                                            <li>
                                                <input type="radio" id="adjust" name="adjust"
                                                    onclick="adjustAmount(1)"> Installment
                                            </li>

                                            <!-- <li><input type="radio" name="adjust" id="adjust" onclick="adjustAmount(2)"> Semi-Installment</li> -->

                                            <li>
                                                <input type="radio" name="adjust" id="adjust"
                                                    onclick="adjustAmount(3)"> Down Payment
                                            </li>


                                            <li>
                                                <input type="radio" name="adjust" id="adjust"
                                                    onclick="adjustAmount(4)"> Possession
                                            </li>


                                            <li>
                                                <input type="radio" name="adjust" id="adjust"
                                                    onclick="adjustAmount(5)"> Allotment
                                            </li>


                                            <li>
                                                <input type="radio" name="adjust" id="adjust"
                                                    onclick="adjustAmount(6)"> Confirmation
                                            </li>

                                            <li>
                                                <input type="radio" name="adjust" id="adjust"
                                                    onclick="adjustAmount(7)"> Booking
                                            </li>

                                            <li>
                                                <input type="radio" name="adjust" id="adjust"
                                                    onclick="adjustAmount(8)"> Development
                                            </li>

                                            <li>
                                                <input type="radio" name="adjust" id="adjust"
                                                    onclick="adjustAmount(9)"> File Processing
                                            </li>

                                            <li>
                                                <input type="radio" name="adjust" id="adjust"
                                                    onclick="adjustAmount(10)"> Registration
                                            </li>


                                        </ul>


                                        <div style="color:black;" class="help-block" id='remaining-amount-label'>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <div class="input_fields_wrap1">
                                <button type="button" style="float: left!important;"
                                    class="btn btn-primary add_field_button">Add Payment</button>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>


                        </div>

                        <!---Custom-->
                        <div id="custom" style="display: none;">

                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Installment <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 43%;" type="date"
                                            id='installment' class="form-control" name="custom_date[]"
                                            placeholder="Date">

                                        <input style="display: inline-block;width: 49%;" type="integer"
                                            class="form-control" name="custom_amount[]" onkeyup="customPayment()"
                                            placeholder="Amount">
                                    </div>
                                </div>
                            </div>


                            <div class="clearfix"></div>
                            <div class="input_fields_wrap2 col-md-10">

                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                            <button type="button" class="btn btn-primary add_field_button2">Add
                                Installment</button>&nbsp;&nbsp;&nbsp;
                            <input style="display: inline-block;width: 30%;" type="integer" readonly=""
                                id='custome_rem' class="form-control" placeholder="Remaining amount">
                            <div class="clearfix"></div>
                        </div>

                        <!-- Custom End -->

                    </div>
                </div>
                <!--receipt module -->




                <div class="col-md-12" style="height: 70px;">
                    <div class="alert alert-danger" style="display:none;" role="alert" id="required_field_error">
                        All Fields With * is Required.
                    </div>

                    <button style="float: right;" type="submit"
                        class="btn btn-info  waves-effect waves-light btn-lg">Save</button>
                </div>


        </div>
    </div>


    </form>
    </div>
    </div>
    <input type='hidden' id="possession_per">
    <input type='hidden' id="down_payment_per">
    <input type='hidden' id="total_month_per">
    <input type='hidden' id="annual_installment_per">
    <input type='hidden' id="monthly_installment_per">
    <input type="hidden" id="down_payment_dis">
    <input type="hidden" name="percentage" id="percentage">
    <input type="hidden" name="rebate_in_percent" id="rebate_in_percent">

    <input type="hidden" name="semi_installment_hid_per" id="semi_installment_hid_per">
    <input type="hidden" name="semi_installment_hid_amount" id="semi_installment_hid_amount">


@stop
