@extends( 'layouts.app')


@section('title')
Transfer Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li ><a href="{{route('transfer.all')}}">Transfers</a></li>
        <li class="active">Transfer Detail</li>
      </ol>
@stop

@section('content')
            <div class="container-fluid">
                <div class="row colorbox-group-widget">
                     <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="profile-widget">
                                <div class="profile-img">
                                   <img src="{{asset('plugins/images/big/logo.png')}}" height="70px" width="auto" alt="user-img" class="img-circle">
                                     <p class="m-t-10 m-b-5"><a href="javascript:void(0);" class="profile-text font-22 font-semibold">@if($transfer->property->inventory)
                                                @if($transfer->property->inventory->registration)
                                                {{$transfer->property->inventory->registration ->registrationNo->number}}
                                                @endif
                                                @endif</a></p>
                                    <p class="info-ot font-20"> @if($transfer->property->inventory)
                                        {{$transfer->property->inventory->unit_number}}
                                        @endif
                                        </p>
                                        
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">

                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-info">
                                <div class="media-body">
                                    <h3 class="info-count">{{ number_format($transfer->property->net_pay)}} <span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                    <p class="info-text font-12">PKR</p>
                                    <p class="info-ot font-20">Cost Amount</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-success">
                                <div class="media-body">
                                    <h3 class="info-count">{{number_format($transfer->amount_paid)}}<span class="pull-right"><i class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                    <p class="info-text font-12">PKR </p>
                                    <p class="info-ot font-20"> Paid Amount</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Other Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Previous Owner Name</td>
                                                    <td> {{$transfer->owner->name}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Transfer to</td>
                                                    <td> {{$transfer->transfer->name}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Old Client ID</td>
                                                    <td> {{$transfer->old_client_id}} </td>
                                                </tr>
                                                <tr>
                                                    <td>New Client ID</td>
                                                    <td> {{$transfer->new_client_id}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Transfer Note</td>
                                                    <td> {{$transfer->transfer_note}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Transfer Date</td>
                                                    <td> {{date('d-m-Y',strtotime($transfer->transfer_date))}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Transfer Charges</td>
                                                    <td> {{$transfer->transfer_charges}} </td>
                                                </tr>
<!--
                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$transfer->updated_at}}</td>
                                                </tr>-->
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{date('d-m-Y h i',strtotime($transfer->created_at))}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->
                 <!-- /.row -->


                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">unit History</h3>
                            <hr>
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Unit #</th>
                                        <th>Owner Name</th>
                                        <th>Duration</th>
                                        <th>Paid Amount</th>
                                        <th>Transfer Date</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $count =1;?>
                                    @foreach($allTransfers as $t)

                                    @if($count == 1)

                                    <tr>
                                            <td>{{$count++}}</td>

                                            <td><b>{{$t->property->inventory->unit_number}}</b></td>

                                            <td>{{$t->owner ? $t->owner->name: ''}}</td>


                                            
                                                <td>{{date('d-m-Y',strtotime($t->property->booking_date)) . '  :  ' . date('d-m-Y',strtotime($t->transfer_date))}}</td>
                                            




                                            <td>{{number_format($t->amount_paid)}} PKR</td>




                                            <td>{{date('d-m-Y', strtotime($t->transfer_date)) }}</td>


                                        </tr>

                                        <tr>
                                            <td>{{$count++}}</td>

                                            <td><b>{{$t->property->inventory->unit_number}}</b></td>

                                            <td>{{$t->transfer ? $t->transfer->name: ''}}</td>


                                            @if($loop->last)

                                                <td><b>Current Owner</b>
                                            @else
                                                <td>{{$duration[$t->id]}}</td>
                                            @endif




                                            <td>{{number_format($t->amount_paid)}} PKR</td>




                                            <td>{{date('d-m-Y', strtotime($t->transfer_date)) }}</td>


                                        </tr>

                                    @else
                                        <tr>
                                            <td>{{$count++}}</td>

                                            <td><b>{{$t->property->inventory->unit_number}}</b></td>

                                            <td>{{$t->transfer ? $t->transfer->name: ''}}</td>


                                            @if($loop->last)

                                                <td><b>Current Owner</b>
                                            @else
                                                <td>{{$duration[$t->id]}}</td>
                                            @endif




                                            <td>{{number_format($t->amount_paid)}} PKR</td>




                                            <td>{{date('d-m-Y', strtotime($t->transfer_date)) }}</td>


                                        </tr>

                                        @endif
                                    @endforeach

                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>



              </div>
            <!-- /.container-fluid -->

@stop