

@php
$size=  '';

if($projectType->id == \App\ProjectType::society){
                                           
          $size=        \App\ProjectType::society_size;
}

else
{
    $size=   \App\ProjectType::high_rise_size;
}
                                        
@endphp

@php
$map= ' ';

if($projectType->id == \App\ProjectType::society){

    $map= \App\ProjectType::society_map;
}

else
{ 
    $map= \App\ProjectType::high_rise_map;
}

@endphp
<div class="col-sm-12">
    <div class="white-box">

        <h3 class="box-title">Pending Statements ({{count($allStatements)}})</h3>

        <div class="table-responsive">
            <table id="myTable" class="table table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Project</th>
                        <th>Unit #</th>
                        <th>Size</th>
                        <th>Member Name</th>
                        <th>Net Amount</th>

                        <th>Received Amount</th>
                        <th>Sold By</th>
                        <th>Booking Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $count =1;?>
                    @foreach($allStatements as $statement)
                    <tr >
                        <td>{{$count++}}</td>
                        <td>
                            @if($statement->inventory)
                             @if($statement->inventory->multiProject)
                             {{$statement->inventory->multiProject->name}}
                             @else
                             None
                            @endif
                           
                          @endif
                        </td>
                         <td>{{$statement->inventory ? $statement->inventory->unit_number : '' }}</td>
                          <td>@if($statement->inventory)
                            @if($statement->inventory->size)
                            
                            {{$statement->inventory->size->name}} {{$size}}
                            @endif
                            @endif
                        </td>
                        <td>{{$statement->customer ? $statement->customer->name: ''}}</td>

                        <td>{{number_format($statement->net_pay)}} PKR</td>


                        <td>{{number_format($receivedAmt[$statement->id])}} PKR</td>

                        <td>
                            @if($statement->dealer)
                            {{$statement->dealer->name}} <b>({{$statement->dealer->dealerType->name}})</b>
                            @else
                            Company
                            @endif
                        </td>

                        <td>{{date('d-m-Y', strtotime($statement->booking_date)) }}</td>



                        @if($statement->status == \App\CustomerProperty::pending)
                        <td><span class="label label-primary" style="background-color:#cd703d;">Pending</span></td>

                        @elseif($statement->status == \App\CustomerProperty::approved)
                        <td><span class="label label-success">Approved</span></td>
                        @elseif($statement->status == \App\CustomerProperty::cancel)
                        <td><span class="label label-danger">Canceled</span></td>
                        @else
                        <td></td>
                        @endif



                        <td class="text-nowrap">
                            <a href="{{route('statement.detail',['id'=>$statement->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>

                            <a href="{{route('statement.editPendingView',['id'=>$statement->id])}}" data-toggle="tooltip" data-original-title="Update Reference No."> <i class="fa fa-sun-o text-inverse m-r-10"></i> </a>


                            <a href="{{route('statement.delete',['id'=>$statement->id])}}" data-toggle="confirmation" data-placement="left" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                        </td>

                    </tr>

                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>