@extends('layouts.app')

@section('title')
    Edit Statement
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-membership')
            <li><a href="{{ route('statement.all') }}">Statements</a></li>
        @endpermission
        <li class="active">Add Statement</li>
    </ol>
@stop


@section('content')
    <style>
        .remaining_amount {
            background: khaki;
        }
    </style>

    <div class="container-fluid">
        <div class="row">

            <form class="form-horizontal" method='post' action="{{ route('statement.schedule.update') }}"
                enctype="multipart/form-data" onsubmit="return validateForm()">
                {{ csrf_field() }}
                <input type="hidden" name="property_id" value="{{ $property->id }}">
                <div class="col-md-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="white-box">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Add New Statement</h3>
                        <p class="text-muted  font-13"> Note: All * fields are mandatory </p>

                        <hr>

                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box">
                        <h3 class="box-title">Customer Information </h3>
                        <hr>
                        <div class="clearfix"></div>
                        <!-- Nav tabs -->
                        <ul class="nav customtab nav-tabs" role="tablist">
                            <li role="presentation" class="active">
                                <a href="#profile1" aria-controls="profile" role="tab" data-toggle="tab"
                                    aria-expanded="false" style="font-weight: 700;"><span class="visible-xs"><i
                                            class="ti-user"></i></span> <span class="hidden-xs">Property Customer</span></a>
                            </li>
                        </ul>
                        <!-- Tab panes -->
                        <div class="tab-content">




                            <div role="tabpanel" class="tab-pane fade active in" id="profile1">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Name of Applicant</label>
                                        <div class="col-md-8">
                                            <select autocomplete="off" readonly class="form-control" id="customer_id"
                                                name="customer_id" style="width: 100%!important;">

                                                <option value="{{ $customer->id }}" selected="">{{ $customer->name }} -
                                                    <b>{{ $customer->cnic }}</b>
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>

                            </div>

                        </div>

                        <div class="clearfix"></div>
                    </div>
                </div>




                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box1">
                        <h3 class="box-title">Unit Information</h3>
                        <hr>
                        <input type="hidden" name='inventory_id' id='customer_property-id' value='{{ $property->id }}'>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Unit # <span
                                        style="color:red">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control " id="unit_number" name="unit_number">
                                        <option value="{{ $unitNumber->id }}" selected>{{ $unitNumber->unit_number }}
                                        </option>

                                    </select>

                                    @if ($errors->has('unit_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6" id="inventory_type">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Type</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="type"
                                        value="{{ $unitNumber->type->name }}" id="type">
                                    @if ($errors->has('type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Size</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="size"
                                        value="{{ $unitNumber->size ? $unitNumber->size->name : '' }}" id="size">
                                    @if ($errors->has('size'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('size') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Price</label>
                                <div class="col-md-8">
                                    @php
                                        $total_price = (int) $unitNumber->total_price - (int) $unitNumber->extra_amount;
                                    @endphp
                                    <input readonly="" type="text" id='total-amount' class="form-control"
                                        name="total_price" value="{{ $total_price }}">
                                    @if ($errors->has('total_price'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('total_price') }}</strong>
                                        </span>
                                    @endif
                                    {{-- <div style="color:black;" class="help-block" id='total-amount-label'></div> --}}
                                </div>
                            </div>
                        </div>


                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Category</label>
                                <div class="col-md-8">
                                    @php
                                        $categories_name = '';
                                    @endphp
                                    @foreach ($unitNumber->categories as $category)
                                        @php
                                            $categories_name = $category->category->name . ',' . $categories_name;
                                        @endphp
                                    @endforeach
                                    <input readonly="" type="category" class="form-control" name="category"
                                        value="{{ $categories_name }}" id="category">
                                    @if ($errors->has('category'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('category') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Extra Charges </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='extra_charges' class="form-control"
                                        name="extra_charges" value="{{ $unitNumber->extra_amount }}">

                                    <div style="color:black;" class="help-block" id='extra-charges-label'></div>
                                </div>
                            </div>
                        </div>




                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Booking Date</label>
                                <div class="col-md-8">

                                    <input type="text" readonly class="form-control" name="original_boooking_date"
                                        value=" {{ date('d-m-Y', strtotime($property->original_boooking_date)) }}"
                                        id="original_boooking_date" placeholder="Enter Booking Date">
                                    @if ($errors->has('original_boooking_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('original_boooking_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Discount Amount</label>
                                <div class="col-md-8">

                                    <input type="text" readonly class="form-control" name="discount"
                                        value="{{ $property->discount }}" id="discount">
                                    @if ($errors->has('discount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('discount') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>


                        </div>




                        {{-- <div class="clearfix"></div>

                            <div class="col-md-6">
                            <div class="form-group">
                            <label class="control-label col-md-4">Unit Description </label>
                            <div class="col-md-8">

                            <input readonly="" type="text"  id='description' class="form-control" name="description" value="{{old('description')}}">


                            </div>
                            </div>
                            </div> --}}


                        <div class="clearfix"></div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Net Amount</label>
                                <div class="col-md-8">
                                    {{-- <input type="hidden" id="dummy_net_amount"> --}}
                                    <input readonly="" type="text" id='net_amount' class="form-control"
                                        name="net_amount" value="{{ $property->net_pay }}">
                                    @if ($errors->has('net_amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('net_amount') }}</strong>
                                        </span>
                                    @endif
                                    <div style="color:black;" class="help-block" id='net_amount-label'></div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{-- <label class="control-label col-md-4">Add Discount </label> --}}
                                <label class="control-label col-md-4">Add New Discount <br> (use percent <input
                                        type="checkbox" onclick="percentCheckbox()" name="discount_percent"
                                        id="discount_percent">)</label>

                                <div class="col-md-8">
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 12px;"
                                            id="dis_input">PKR</span>
                                        <input type="number" class="form-control" name="newdiscount"
                                            id="add_new_discount" max={{ $remaining_amount }}
                                            placeholder="Enter Discount">
                                    </div>
                                    @if ($errors->has('newdiscount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('newdiscount') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>


                        </div>
                        <div class="clearfix"></div>





                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Remaining Payable</label>
                                <div class="col-md-8">

                                    <input type="integer" id='remianing_payable' class="form-control"
                                        name="remianing_payable" value="{{ $remaining_amount }}">
                                    @if ($errors->has('remianing_payable'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('remianing_payable') }}</strong>
                                        </span>
                                    @endif
                                    <div style="color:black;" class="help-block" id='remainig-amount-label'></div>

                                </div>
                            </div>
                        </div>

                        <div class="clearfix"></div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4"> Rate <br> (Per {{ env('SIZE') }})</label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <span style="display:none;" id="sqrt"></span>
                                        <input readonly="" style="width: 37.5rem;" type="text" id='per_sqrt_value'
                                            class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-5">Booking Type </label>
                                <div class="col-md-7">
                                    @if ($property->booking_type == \App\CustomerProperty::normal)
                                        <input type='radio' onchange="activeNormal()" name="booking_type"
                                            value='{{ \App\CustomerProperty::normal }}' checked> Installment<br>

                                        <input type='radio' onchange="activeFullPayment()" name="booking_type"
                                            value='{{ \App\CustomerProperty::full_payment }}' disabled> Full Payment
                                    @elseif($property->booking_type == \App\CustomerProperty::full_payment)
                                        <input type='radio' onchange="activeNormal()" name="booking_type"
                                            value='{{ \App\CustomerProperty::normal }}' disabled> Installment<br>

                                        <input type='radio' onchange="activeFullPayment()" name="booking_type"
                                            value='{{ \App\CustomerProperty::full_payment }}' checked> Full
                                        Payment
                                    @endif

                                    @if ($errors->has('booking_type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('booking_type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>




                    </div>
                </div>
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box">
                        <h3 class="box-title" style="display: inline-block;">Dealer Rebate Information</h3>
                        {{-- <span style="margin-left:17%">% 
                                <input type="float" name="rebate_in_percentage" style="width: 5%;display: inherit;" class="form-control"  id="rebate_in_percentage"><input type="float" class="form-control" style="width: 10%;display: inherit;" name="rebate_in_amount" id="rebate_in_amount"> PKR</span> --}}
                        {{-- <a class="btn btn-outline btn-default waves-effect waves-light pull-right add_field_button5" style="margin-top: 9px">  <span>Add More</span></a> --}}
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{-- <label class="control-label col-md-4">Authorized Dealer <span style="color: red">*</span></label> --}}
                                <div class="col-md-8">
                                    @foreach ($dealers_involved_in_property as $d)
                                        <tr>
                                            <td><b>Name :</b></td>
                                            <td> {{ $d->dealer->name }} </td>

                                            <td><b>Rebate : </b></td>
                                            <td> {{ number_format($d->amount) }} </td>


                                        </tr>
                                    @endforeach

                                    @if ($errors->has('dealer_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('dealer_id') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="clearfix"></div>


                        {{-- <div class="col-md-8">
                            <div class="form-group">
                            <label class="control-label col-md-6"> Rebate <span style="color: red">*</span></label>
                            <div class="col-md-6" >
                            <div class="input-group">
                            <span class="input-group-addon" style="font-size: 10px;">PKR</span>
                            <input id="total_rebate1" type="text" class="form-control total_rebate" name="total_rebate[]" value="" >


                            @if ($errors->has('total_rebate'))
                            <span class="help-block">
                            <strong>{{ $errors->first('total_rebate') }}</strong>
                            </span>
                            @endif
                            </div>
                            </div>
                            </div>
                            </div> --}}








                        <div class="input_fields_wrap5">
                            <div class="clearfix"></div>
                            <div>
                            </div>


                        </div>

                        {{-- <input style="    width: 20%;" readonly="" type="integer" id='remaining_amount_in_rebate' class="form-control"   placeholder="Remaining amount"> --}}



                    </div>
                </div>










                @if ($property->booking_type == \App\CustomerProperty::normal)
                    <div class="col-lg-12 col-sm-12 col-xs-12" id="normal">
                        <div class="white-box">
                            <h3 class="box-title">Payment Scheduler</h3>
                            <hr>


                            <div class="col-md-12">

                                <div class="form-group">
                                    <label class="control-label col-md-2">Schedular Type<span
                                            style="color: red">*</span></label>

                                    @if (sizeof($check_remaining_installments) > 1)
                                        <div class="col-md-10">


                                            <div class="col-md-4">
                                                <input type='radio' onchange="disableAnn(this.value)"
                                                    name="schedule_type" value='{{ \App\CustomerProperty::inst_mon }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon ? 'checked' : ''; ?>> Monthly
                                            </div>



                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableQuar()" name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_w_quar }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_w_quar ? 'checked' : ''; ?>>
                                                Monthly
                                                with Quarterly
                                            </div>



                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableSemi()" name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_w_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_w_semi ? 'checked' : ''; ?>>
                                                Monthly
                                                with Semi Annually
                                            </div>


                                            <div class="clearfix"></div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableAnn()" name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_w_ann }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_w_ann ? 'checked' : ''; ?>>
                                                Monthly
                                                with Annually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="disableAnn(this.value)"
                                                    name="schedule_type" value='{{ \App\CustomerProperty::inst_bi_mon }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_bi_mon ? 'checked' : ''; ?>> Bi
                                                Monthly
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="disableAnn(this.value)"
                                                    name="schedule_type" value='{{ \App\CustomerProperty::inst_quar }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_quar ? 'checked' : ''; ?>>
                                                Quarterly
                                            </div>


                                            <div class="clearfix"></div>

                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableSemi()" name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_quar_w_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_quar_w_semi ? 'checked' : ''; ?>>
                                                Quarterly with
                                                SemiAnnually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="disableAnn(this.value)"
                                                    name="schedule_type" value='{{ \App\CustomerProperty::inst_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_semi ? 'checked' : ''; ?>>
                                                SemiAnnually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="disableAnn(this.value)"
                                                    name="schedule_type" value='{{ \App\CustomerProperty::inst_ann }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_ann ? 'checked' : ''; ?>>
                                                Annually
                                            </div>

                                            <div class="clearfix"></div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableAnn()" name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_exclude_ann }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_exclude_ann ? 'checked' : ''; ?>> Monthly exclude
                                                Annually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableQuar()" name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_exclude_quar }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_exclude_quar ? 'checked' : ''; ?>> Monthly exclude
                                                Quarterly
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableSemi()" name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_exclude_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_exclude_semi ? 'checked' : ''; ?>> Monthly exclude
                                                Semi Annually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableSemi()" name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_quar_exclude_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_quar_exclude_semi ? 'checked' : ''; ?>> Quarterly exclude
                                                SemiAnnually
                                            </div>



                                            <div class="col-md-4">
                                                <input type='radio' onchange="enableCustom(this.value)"
                                                    name="schedule_type" value='{{ \App\CustomerProperty::inst_custom }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_custom ? 'checked' : ''; ?>> Custom
                                            </div>


                                            @if ($errors->has('schedule_type'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('schedule_type') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    @else
                                        <div class="col-md-10">


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon }}' <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon ? 'checked' : 'disabled'; ?>>
                                                Monthly
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_w_quar }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_w_quar ? 'checked' : 'disabled'; ?>>
                                                Monthly
                                                with Quarterly
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_w_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_w_semi ? 'checked' : 'disabled'; ?>>
                                                Monthly
                                                with Semi Annually
                                            </div>


                                            <div class="clearfix"></div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_w_ann }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_w_ann ? 'checked' : 'disabled'; ?>>
                                                Monthly
                                                with Annually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_bi_mon }}' <?php echo $property->schedular_type == \App\CustomerProperty::inst_bi_mon ? 'checked' : 'disabled'; ?>>
                                                Bi
                                                Monthly
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_quar }}' <?php echo $property->schedular_type == \App\CustomerProperty::inst_quar ? 'checked' : 'disabled'; ?>>
                                                Quarterly
                                            </div>


                                            <div class="clearfix"></div>

                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_quar_w_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_quar_w_semi ? 'checked' : 'disabled'; ?>> Quarterly with
                                                SemiAnnually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_semi }}' <?php echo $property->schedular_type == \App\CustomerProperty::inst_semi ? 'checked' : 'disabled'; ?>>
                                                SemiAnnually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_ann }}' <?php echo $property->schedular_type == \App\CustomerProperty::inst_ann ? 'checked' : 'disabled'; ?>>
                                                Annually
                                            </div>

                                            <div class="clearfix"></div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_exclude_ann }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_exclude_ann ? 'checked' : 'disabled'; ?>> Monthly exclude
                                                Annually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_exclude_quar }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_exclude_quar ? 'checked' : 'disabled'; ?>> Monthly exclude
                                                Quarterly
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_mon_exclude_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_mon_exclude_semi ? 'checked' : 'disabled'; ?>> Monthly exclude
                                                Semi Annually
                                            </div>


                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_quar_exclude_semi }}'
                                                    <?php echo $property->schedular_type == \App\CustomerProperty::inst_quar_exclude_semi ? 'checked' : 'disabled'; ?>> Quarterly exclude
                                                SemiAnnually
                                            </div>



                                            <div class="col-md-4">
                                                <input type='radio' name="schedule_type"
                                                    value='{{ \App\CustomerProperty::inst_custom }}' <?php echo $property->schedular_type == \App\CustomerProperty::inst_custom ? 'checked' : 'disabled'; ?>>
                                                Custom
                                            </div>


                                            @if ($errors->has('schedule_type'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('schedule_type') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </div>











                            @php
                                $down_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::down_payment);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                
                               
                                $possession_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::possession);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                
                                $allotment_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::allotment);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                $confirmation_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::confirmation);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                $development_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::development);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                
                                $file_processing_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::file_processing);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                $registration_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::registration);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                $ballon_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::ballon);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                $balloting_payment_date = $customer_statement->where('payment_head', \App\CustomerStatement::balloting);
                                // ->where('due', '>', 0)
                                // ->where('received', 0)
                                
                                $d_p = 1;
                                $p_d = 1;
                                $a_d = 1;
                                $c_d = 1;
                                $d_d = 1;
                                $f_d = 1;
                                $r_d = 1;
                                $b_d = 1;
                                $balloting_d = 1;
                            @endphp




                            <div class="clearfix"></div>
                            <hr>
                            {{-- 1st row --}}
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="control-label ">Schedule Start Date <span
                                            style="color:red">*</span></label>

                                    <input type="date" class="form-control" name="schedule_start_date"
                                        value="{{ date('Y-m-d', strtotime($property->schedule_start_date)) }}"
                                        id="schedule_start_date" placeholder="Enter Schedule Start Date">
                                    @if ($errors->has('schedule_start_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('schedule_start_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Booking <span style="color: red">*</span></label>
                                    <input type="integer" id='booking' class="form-control" name="booking"
                                        value="{{ old('booking') }}" placeholder="Enter Booking">
                                    <div style="color:black;" class="help-block" id='booking-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_booking" placeholder="%">
                                    </div>


                                    @if ($errors->has('booking'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('booking') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Down Payment Date <span
                                            style="color:red">*</span></label>

                                    @if (sizeof($down_payment_date) > 1)
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Select the date
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                @foreach ($down_payment_date as $key => $down_date)
                                                    <label class="control-label col-md-6" style='text-align: left;'>
                                                        <b>Payment {{ $d_p }}</b>
                                                        <input type="date" class="dropdown-item form-control"
                                                            name="down_date[]"
                                                            value="{{ date('Y-m-d', strtotime($down_date->due_date)) }}"
                                                            id="down_date">
                                                    </label>
                                                    @php
                                                        $d_p = $d_p + 1;
                                                    @endphp
                                                @endforeach

                                            </div>
                                        </div>
                                    @elseif(!empty($down_payment_date))
                                        <input type="date" class="form-control" name="down_date"
                                            value="{{ date('Y-m-d', strtotime($down_payment_date->pluck('due_date')->first())) }}"
                                            id="down_date">
                                    @endif

                                    {{--  --}}
                                    @if ($errors->has('down_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('down_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Down Payment <span style="color: red">*</span></label>
                                    <input type="integer" id='down-payment' class="form-control" name="down_payment"
                                        value="{{ old('down_payment') }}" placeholder="Down Payment">
                                    <div style="color:black;" class="help-block" id='down-payment-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_down_payment"
                                            placeholder="%">
                                    </div>
                                    @if ($errors->has('down_payment'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('down_payment') }}</strong>
                                        </span>
                                    @endif
                                </div>


                            </div>

                            {{-- 1st row remaining --}}
                            <div class="row">

                                <div class="col-md-4">
                                    <label class="control-label remaining_amount">Remainig Booking <span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_booking' class="form-control"
                                        name="remaining_booking" placeholder="Remaining Booking Amount" value="0">
                                    <div style="color:black;" class="help-block" id='remaining_booking-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_booking"
                                            placeholder="%">
                                    </div>


                                    @if ($errors->has('booking'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('booking') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label remaining_amount">Remaining Down Payment <span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_down-payment' class="form-control"
                                        name="remaining_down_payment" placeholder="Remaining Down Payment"
                                        value="0">
                                    <div style="color:black;" class="help-block" id='remaining_down-payment-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_down_payment"
                                            placeholder="%">
                                    </div>
                                    @if ($errors->has('down_payment'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('down_payment') }}</strong>
                                        </span>
                                    @endif
                                </div>


                            </div>

                            {{-- 2nd row --}}
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="control-label ">Possession Date </label>
                                    @if (sizeof($possession_payment_date) > 1)
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Select the date
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                @foreach ($possession_payment_date as $key => $possession_date)
                                                    <label class="control-label col-md-6"
                                                        style='text-align: left;'><b>Payment {{ $p_d }}</b>
                                                        <input type="date" class="dropdown-item form-control"
                                                            name="possession_date[]"
                                                            value="{{ date('Y-m-d', strtotime($possession_date->due_date)) }}"
                                                            id="possession_date">
                                                    </label>
                                                    @php
                                                        $p_d = $p_d + 1;
                                                    @endphp
                                                @endforeach

                                            </div>
                                        </div>
                                    @elseif(!empty($possession_payment_date))
                                        <input type="date" id='possession_date' class="form-control"
                                            name="possession_date"
                                            value="{{ date('Y-m-d', strtotime($possession_payment_date->pluck('due_date')->first())) }}">
                                    @endif


                                    @if ($errors->has('possession_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('possession_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Possession <span style="color: red">*</span></label>
                                    <input type="integer" id='possession' class="form-control" name="possession"
                                        value="{{ old('possession') }}" placeholder="Enter Possession">
                                    <div style="color:black;" class="help-block" id='possession-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                    {{-- <input type="text" class="form-control" placeholder="Column 3"> --}}
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_possession" placeholder="%">
                                    </div>
                                    @if ($errors->has('possession'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('possession') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label ">Confirmation Date </label>
                                    @if (sizeof($confirmation_payment_date) > 1)
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Select the date
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                @foreach ($confirmation_payment_date as $key => $confirmation_date)
                                                    <label class="control-label col-md-6"
                                                        style='text-align: left;'><b>Payment {{ $c_d }}</b>
                                                        <input type="date" class="dropdown-item form-control"
                                                            name="confirmation_date[]"
                                                            value="{{ date('Y-m-d', strtotime($confirmation_date->due_date)) }}"
                                                            id="confirmation_date">
                                                    </label>
                                                    @php
                                                        $c_d = $c_d + 1;
                                                    @endphp
                                                @endforeach

                                            </div>
                                        </div>
                                    @elseif(!empty($confirmation_payment_date))
                                        <input type="date"
                                            id='confirmation_date'value="{{ date('Y-m-d', strtotime($confirmation_payment_date->pluck('due_date')->first())) }}"
                                            class="form-control" name="confirmation_date">
                                    @endif


                                    @if ($errors->has('confirmation_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('confirmation_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Confirmation <span style="color: red">*</span></label>
                                    <input type="integer" id='confirmation' class="form-control" name="confirmation"
                                        value="{{ old('confirmation') }}" placeholder="Confirmation">
                                    <div style="color:black;" class="help-block" id='confirmation-label'></div>

                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_confirmation"
                                            placeholder="%">

                                    </div>


                                    @if ($errors->has('confirmation'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('confirmation') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            {{-- 2nd row remaining --}}
                            <div class="row">

                                <div class="col-md-4">
                                    <label class="control-label remaining_amount">Remaining Possession <span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_possession' class="form-control"
                                        name="remaining_possession" value="0" placeholder="Remaining Possession">
                                    <div style="color:black;" class="help-block" id='remaining_possession-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_possession"
                                            placeholder="%">
                                    </div>
                                    @if ($errors->has('possession'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('possession') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label  remaining_amount">Remaining Confirmation <span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_confirmation' class="form-control"
                                        name="remaining_confirmation" value="0"
                                        placeholder="Remaining Confirmation">
                                    <div style="color:black;" class="help-block" id='remaining_confirmation-label'></div>

                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_confirmation"
                                            placeholder="%">

                                    </div>


                                    @if ($errors->has('confirmation'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('confirmation') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>


                            {{-- 3rd row --}}
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="control-label ">Allotment Date </label>
                                    @if (sizeof($allotment_payment_date) > 1)
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Select the date
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                @foreach ($allotment_payment_date as $key => $allotment_date)
                                                    <label class="control-label col-md-6"
                                                        style='text-align: left;'><b>Payment {{ $a_d }}</b>
                                                        <input type="date" class="dropdown-item form-control"
                                                            name="allotment_date[]"
                                                            value="{{ date('Y-m-d', strtotime($allotment_date->due_date)) }}"
                                                            id="allotment_date">
                                                    </label>
                                                    @php
                                                        $a_d = $a_d + 1;
                                                    @endphp
                                                @endforeach

                                            </div>
                                        </div>
                                    @elseif(!empty($allotment_payment_date))
                                        <input type="date" id='allotment_date' class="form-control"
                                            value="{{ date('Y-m-d', strtotime($allotment_payment_date->pluck('due_date')->first())) }}"
                                            name="allotment_date">

                                    @endif


                                    @if ($errors->has('allotment_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('allotment_date') }}</strong>
                                        </span>
                                    @endif

                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Allotment <span style="color: red">*</span></label>
                                    <input type="integer" id='allotment' class="form-control" name="allotment"
                                        value="{{ old('allotment') }}" placeholder="Enter Allotment">
                                    <div style="color:black;" class="help-block" id='allotment-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_allotment" placeholder="%">
                                    </div>
                                    @if ($errors->has('allotment'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('allotment') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label ">Registration Date </label>
                                    @if (sizeof($registration_payment_date) > 1)
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Select the date
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                @foreach ($registration_payment_date as $key => $registration_date)
                                                    <label class="control-label col-md-6"
                                                        style='text-align: left;'><b>Payment{{ $r_d }}</b>
                                                        <input type="date" class="dropdown-item form-control"
                                                            name="registration_date[]"
                                                            value="{{ date('Y-m-d', strtotime($registration_date->due_date)) }}"
                                                            id="registration_date">
                                                    </label>
                                                    @php
                                                        $r_d = $r_d + 1;
                                                    @endphp
                                                @endforeach

                                            </div>
                                        </div>
                                    @elseif(!empty($registration_payment_date))
                                        <input type="date" id='registration_date'
                                            value="{{ date('Y-m-d', strtotime($registration_payment_date->pluck('due_date')->first())) }}"
                                            class="form-control" name="registration_date">
                                    @endif

                                    @if ($errors->has('registration_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('registration_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Registration <span style="color: red">*</span></label>
                                    <input type="integer" id='registration' class="form-control" name="registration"
                                        value="{{ old('registration') }}" placeholder="Registration">
                                    <div style="color:black;" class="help-block" id='registration-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_registration"
                                            placeholder="%">

                                    </div>


                                    @if ($errors->has('registration'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('registration') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                            {{-- 3rd row remaining --}}
                            <div class="row">

                                <div class="col-md-4">
                                    <label class="control-label remaining_amount">Remaining Allotment <span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_allotment' class="form-control"
                                        name="remaining_allotment" value="0" placeholder="Remaining Allotment">
                                    <div style="color:black;" class="help-block" id='remaining_allotment-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_allotment"
                                            placeholder="%">
                                    </div>
                                    @if ($errors->has('allotment'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('allotment') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label remaining_amount">Remaining Registration <span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_registration' class="form-control"
                                        name="remaining_registration" value="0">
                                    <div style="color:black;" class="help-block" id='remaining_registration-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_registration"
                                            placeholder="%">

                                    </div>


                                    @if ($errors->has('registration'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('registration') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>


                            {{-- 4th row --}}
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="control-label ">File Processing Date </label>
                                    @if (sizeof($file_processing_payment_date) > 1)
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Select the date
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                @foreach ($file_processing_payment_date as $key => $file_processing_date)
                                                    <label class="control-label col-md-6"
                                                        style='text-align: left;'><b>Payment {{ $f_d }}</b>
                                                        <input type="date" class="dropdown-item form-control"
                                                            name="file_processing_date[]"
                                                            value="{{ date('Y-m-d', strtotime($file_processing_date->due_date)) }}"
                                                            id="file_processing_date">
                                                    </label>
                                                    @php
                                                        $f_d = $f_d + 1;
                                                    @endphp
                                                @endforeach

                                            </div>
                                        </div>
                                    @elseif(!empty($file_processing_payment_date))
                                        <input type="date" id='file_processing_date'
                                            value="{{ date('Y-m-d', strtotime($file_processing_payment_date->pluck('due_date')->first())) }}"
                                            class="form-control" name="file_processing_date">
                                    @endif

                                    @if ($errors->has('file_processing_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('file_processing_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">File Processing <span style="color: red">*</span></label>
                                    <input type="integer" id='file_processing' class="form-control"
                                        name="file_processing" value="{{ old('file_processing') }}"
                                        placeholder="Enter File Processing">
                                    <div style="color:black;" class="help-block" id='file_processing-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_file_processing"
                                            placeholder="%">

                                    </div>


                                    @if ($errors->has('file_processing'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('file_processing') }}</strong>
                                        </span>
                                    @endif

                                </div>
                                <div class="col-md-2">
                                    <label class="control-label ">Balloting Date </label>
                                    @if (sizeof($balloting_payment_date) > 1)
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Select the date
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                @foreach ($balloting_payment_date as $key => $balloting_date)
                                                    <label class="control-label col-md-6"
                                                        style='text-align: left;'><b>Payment {{ $balloting_d }}</b>
                                                        <input type="date" class="dropdown-item form-control"
                                                            name="balloting_date[]"
                                                            value="{{ date('Y-m-d', strtotime($balloting_date->due_date)) }}"
                                                            id="balloting_date">
                                                    </label>
                                                    @php
                                                        $balloting_d = $balloting_d + 1;
                                                    @endphp
                                                @endforeach

                                            </div>
                                        </div>
                                    @elseif(!empty($balloting_payment_date))
                                        <input type="date" id='balloting_date'
                                            value="{{ date('Y-m-d', strtotime($balloting_payment_date->pluck('due_date')->first())) }}"
                                            class="form-control" name="balloting_date">
                                    @endif

                                    @if ($errors->has('balloting_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('balloting_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Balloting <span style="color: red">*</span></label>
                                    <input type="integer" id='balloting' class="form-control" name="balloting"
                                        placeholder="Balloting">
                                    <div style="color:black;" class="help-block" id='balloting-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_balloting" placeholder="%">

                                    </div>


                                    @if ($errors->has('balloting'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('balloting') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>

                            {{-- 4th row remaining --}}
                            <div class="row">

                                <div class="col-md-4">
                                    <label class="control-label remaining_amount">Remaining Processing<span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_file_processing' class="form-control"
                                        name="remaining_file_processing" value="0">
                                    <div style="color:black;" class="help-block" id='remaining_file_processing-label'>
                                    </div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_file_processing"
                                            placeholder="%">

                                    </div>


                                    @if ($errors->has('file_processing'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('file_processing') }}</strong>
                                        </span>
                                    @endif

                                </div>

                                <div class="col-md-4">
                                    <label class="control-label remaining_amount">Remaining Balloting <span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_balloting' class="form-control"
                                        name="remaining_balloting" value="0">
                                    <div style="color:black;" class="help-block" id='remaining_balloting-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_balloting"
                                            placeholder="%">

                                    </div>


                                    @if ($errors->has('balloting'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('balloting') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>

                            {{-- 5th row --}}
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="control-label ">Ballon Payment Date </label>
                                    {{-- <input type="date" id='ballonpayment_date' value="{{ date('Y-m-d') }}"
                                    class="form-control" name="ballonpayment_date"> --}}

                                    @if (sizeof($ballon_payment_date) > 1)
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Select the date
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                @foreach ($ballon_payment_date as $key => $ballon_date)
                                                    <label class="control-label col-md-6"
                                                        style='text-align: left;'><b>Payment {{ $b_d }}</b>
                                                        <input type="date" class="dropdown-item form-control"
                                                            name="ballonpayment_date[]"
                                                            value="{{ date('Y-m-d', strtotime($ballon_date->due_date)) }}"
                                                            id="ballonpayment_date">
                                                    </label>
                                                    @php
                                                        $b_d = $b_d + 1;
                                                    @endphp
                                                @endforeach

                                            </div>
                                        </div>
                                    @elseif(!empty($ballon_payment_date))
                                        <input type="date" id='ballonpayment_date'
                                            value="{{ date('Y-m-d', strtotime($ballon_payment_date->pluck('due_date')->first())) }}"
                                            class="form-control" name="ballonpayment_date">
                                    @endif
                                    @if ($errors->has('ballonpayment_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('ballonpayment_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">Ballon Payment<span style="color: red">*</span></label>
                                    <input type="integer" id='ballon' class="form-control" name="ballon"
                                        value="{{ old('ballon') }}" placeholder="Enter Ballon">
                                    <div style="color:black;" class="help-block" id='ballon-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="per_file_ballon" placeholder="%">

                                    </div>


                                    @if ($errors->has('ballon'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('ballon') }}</strong>
                                        </span>
                                    @endif

                                </div>
                                @if ($projectType->id == \App\ProjectType::high_rise)
                                    <div class="col-md-2">
                                        <label class="control-label ">Development Date </label>
                                        <input type="date" id='development_date' value="{{ date('Y-m-d') }}"
                                            class="form-control" name="development_date">

                                        @if ($errors->has('development_date'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('development_date') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">Development <span style="color: red">*</span></label>
                                        <input type="integer" id='development' class="form-control" name="development"
                                            value="{{ old('development') }}" placeholder="Development">
                                        <div style="color:black;" class="help-block" id='development-label'></div>
                                    </div>
                                    <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                        <div class="input-group">
                                            <span class="input-group-addon"
                                                style="font-size: 16px;background: none;">%</span>
                                            <input type="float" class="form-control" id="per_development"
                                                placeholder="%">

                                        </div>


                                        @if ($errors->has('development'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('development') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                @endif
                            </div>

                            {{-- 5th row remaining --}}
                            <div class="row">

                                <div class="col-md-4">
                                    <label class="control-label remaining_amount">Remaining Ballon Payment<span
                                            style="color: red">*</span></label>
                                    <input type="integer" id='remaining_ballon' class="form-control"
                                        name="remaining_ballon" value="0">
                                    <div style="color:black;" class="help-block" id='remaining_ballon-label'></div>
                                </div>
                                <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                    <div class="input-group">
                                        <span class="input-group-addon"
                                            style="font-size: 16px;background: none;">%</span>
                                        <input type="float" class="form-control" id="remaining_per_file_ballon"
                                            placeholder="%">

                                    </div>


                                    @if ($errors->has('ballon'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('ballon') }}</strong>
                                        </span>
                                    @endif

                                </div>
                                @if ($projectType->id == \App\ProjectType::high_rise)

                                    <div class="col-md-4">
                                        <label class="control-label remaining_amount">Remaining Development <span
                                                style="color: red">*</span></label>
                                        <input type="integer" id='remaining_development' class="form-control"
                                            name="remaining_development" value="0">
                                        <div style="color:black;" class="help-block" id='remaining_development-label'>
                                        </div>
                                    </div>
                                    <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                        <div class="input-group">
                                            <span class="input-group-addon"
                                                style="font-size: 16px;background: none;">%</span>
                                            <input type="float" class="form-control" id="remaining_per_development"
                                                placeholder="%">

                                        </div>


                                        @if ($errors->has('development'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('development') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                @endif
                            </div>





















                            <div class="col-md-1"></div>


                            <div class="clearfix"></div>

                            <div id="auto" style="margin-top: 2%;">

                                <div class="col-md-10">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">Per Installment <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-9">

                                            <input style="display: inline-block;width: 23%;" type="integer"
                                                id='installment' class="form-control" name="installment"
                                                value="{{ old('installment') }}" placeholder="Per installment"
                                                readonly>
                                            <span>%</span>
                                            <input type="float" class="form-control" id="per_installment"
                                                placeholder="%" style="width: 15%;display: inline-block;" readonly>




                                            <input style="display: inline-block;width: 28%;" type="integer"
                                                id='total_installment' class="form-control" name="total_installment"
                                                value="{{ old('total_installment') }}" placeholder="Total amount"
                                                readonly>

                                            <span>%</span>
                                            <input type="float" class="form-control" id="per_total_installment"
                                                placeholder="%" style="width: 10%;display: inline-block;" readonly>


                                            <!-- <label class="control-label col-md-5">Total Installments (Months) <span style="color: red">*</span></label> -->
                                            <input type="integer" style="width: 10.5%;display: inline-block;"
                                                id='total-months' class="form-control" name="installment_plan"
                                                value="{{ old('installment_plan') }}" placeholder="Count" readonly>

                                            <div style="display: inline-block;width: 49%;color:black;"
                                                class="help-block" id='installment-label'></div>
                                            <div style="display: inline-block;width: 49%;color:black;"
                                                class="help-block" id='total-installment-label'></div>
                                            @if ($errors->has('installment'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('installment') }}</strong>
                                                </span>
                                            @endif

                                            @if ($errors->has('installment_plan'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('installment_plan') }}</strong>
                                                </span>
                                            @endif
                                            <div style="color:black;" class="help-block" id='total-months-label'>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                                {{-- Start Remaining  --}}

                                <div class="col-md-10">
                                    <div class="form-group">
                                        <label class="control-label col-md-3 remaining_amount">Remaning Per Installment
                                            <span style="color: red">*</span></label>
                                        <div class="col-md-9">

                                            <input style="display: inline-block;width: 23%;" type="integer"
                                                id='remaining_single_installment' class="form-control"
                                                name="remaining_single_installment" value="0"
                                                placeholder="total installment">
                                            <span>%</span>
                                            <input type="float" class="form-control" id="remaining_per_installment"
                                                placeholder="%" style="width: 15%;display: inline-block;">

                                            <input style="display: inline-block;width: 28%;     margin-left: 3%;"
                                                type="integer" id='remaining_total_installment' class="form-control"
                                                name="remaining_total_installment" value="0"
                                                placeholder="Total amount">

                                            <span style='margin-left: 2%;'>%</span>
                                            <input type="float" class="form-control"
                                                id="remaining_per_total_installment" placeholder="%"
                                                style="width: 10%;display: inline-block;     margin-left: 1%;">




                                            <input type="integer" style="width: 10.5%;display: inline-block;"
                                                id='remaining-total-months' class="form-control"
                                                name="remainig_installment_plan" value="0" placeholder="Count">


                                            @if ($errors->has('installment'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('installment') }}</strong>
                                                </span>
                                            @endif

                                            @if ($errors->has('installment_plan'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('installment_plan') }}</strong>
                                                </span>
                                            @endif
                                            <div style="color:black;" class="help-block" id='total-months-label'>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                                {{-- End Remainig --}}

                                <div class="col-md-10" id="ann_div">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">Annual Installments <br> <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-9">



                                            <input style="display: inline-block;width: 23%;" type="integer"
                                                id='annual-installment' class="form-control" name="annual_installment"
                                                value="{{ old('annual_installment') }}" id="exampleInputEmail1"
                                                placeholder=" Annual">


                                            <span>%</span>
                                            <input type="float" class="form-control" id="per_annual-installment"
                                                placeholder="%" style="width: 15%;display: inline-block;">
                                            <input style="display: inline-block;width: 28%;" type="integer"
                                                id='total_annual_installment' class="form-control"
                                                name="total_annual_installment"
                                                value="{{ old('total_annual_installment') }}" id="exampleInputEmail1"
                                                placeholder="Total Annual">

                                            <span>%</span>
                                            <input type="float" class="form-control"
                                                id="per_total_annual_installment" placeholder="%"
                                                style="width: 10%;display: inline-block;">

                                            <input style="display: inline-block;width: 10.5%;" type="integer"
                                                id='total_annual_installment_count' class="form-control"
                                                name="total_annual_installment_count"
                                                value="{{ old('total_annual_installment_count') }}"
                                                id="exampleInputEmail1" placeholder="Count">


                                            <div style="display: inline-block;width: 40%;color:black;"
                                                class="help-block" id='annual-installment-label'></div>
                                            <div style="display: inline-block;width: 40%;color:black;"
                                                class="help-block" id='total-annual-installment-label'></div>





                                            @if ($errors->has('annual_installment'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('annual_installment') }}</strong>
                                                </span>
                                            @endif

                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-10" id="semi_div" style="display: none">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">Remaining Semi Installments <br> <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-9">

                                            <input style="display: inline-block;width: 23%;" type="integer"
                                                id='semi-installment' class="form-control" name="semi_installment"
                                                value="{{ old('semi_installment') }}" id="exampleInputEmail1"
                                                placeholder=" Semi">


                                            <span>%</span>
                                            <input type="float" class="form-control" id="per_semi_installment"
                                                placeholder="%" style="width: 15%;display: inline-block;">


                                            <input style="display: inline-block;width: 28%;" type="integer"
                                                id='total_semi_installment' class="form-control"
                                                name="total_semi_installment"
                                                value="{{ old('total_semi_installment') }}" id="exampleInputEmail1"
                                                placeholder="Total Semi Annually">


                                            <span>%</span>
                                            <input type="float" class="form-control" id="per_total_semi_installment"
                                                placeholder="%" style="width: 10%;display: inline-block;">



                                            <input style="width: 10.5%;display: inline-block;" type="integer"
                                                id='total_semi_installment_count' class="form-control"
                                                name="total_semi_installment_count"
                                                value="{{ old('total_semi_installment_count') }}"
                                                id="exampleInputEmail1" placeholder="Count">

                                            <div style="display: inline-block;width: 40%;color:black;"
                                                class="help-block" id='semi-installment-label'></div>
                                            <div style="display: inline-block;width: 40%;color:black;"
                                                class="help-block" id='total-semi-installment-label'></div>
                                            @if ($errors->has('semi_installment'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('semi_installment') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-10" id="bi_mon_div" style="display: none;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">Bi Monthly Installments <br> <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-9">
                                            <input style="display: inline-block;width: 40%;" type="integer"
                                                id='bi-mon-installment' class="form-control" name="bi_mon_installment"
                                                value="{{ old('bi_mon_installment') }}" id="exampleInputEmail1"
                                                placeholder=" Bi Monthly">

                                            <input style="display: inline-block;width: 40%;" type="integer"
                                                readonly="" id='total_bi_mon_installment' class="form-control"
                                                name="total_bi_mon_installment"
                                                value="{{ old('total_bi_mon_installment') }}" id="exampleInputEmail1"
                                                placeholder="Total Bi Monthly">
                                            <input style="display: inline-block;width: 15%;" type="integer"
                                                readonly="" id='total_bi_mon_installment_count'
                                                class="form-control" name="total_bi_mon_installment_count"
                                                value="{{ old('total_bi_mon_installment_count') }}"
                                                id="exampleInputEmail1" placeholder="Count">
                                            <div style="display: inline-block;width: 40%;color:black;"
                                                class="help-block" id='bi-mon-installment-label'></div>
                                            <div style="display: inline-block;width: 40%;color:black;"
                                                class="help-block" id='total-bi-mon-installment-label'></div>
                                            @if ($errors->has('bi_mon_installment'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('bi_mon_installment') }}</strong>
                                                </span>
                                            @endif

                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-10" id="quar_div" style="display: none;">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">Quarterly Installments <br> <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-9">
                                            <input style="display: inline-block;width: 43%;" type="integer"
                                                id='quarterly-installment' class="form-control"
                                                name="quarterly_installment"
                                                value="{{ old('quarterly_installment') }}" id="exampleInputEmail1"
                                                placeholder=" Quarterly">

                                            <input style="display: inline-block;width: 40%;" type="integer"
                                                id='total_quarterly_installment' class="form-control"
                                                name="total_quarterly_installment"
                                                value="{{ old('total_quarterly_installment') }}"
                                                id="exampleInputEmail1" placeholder="Total Quarterly">
                                            <input style="display: inline-block;width: 15%;" type="integer"
                                                readonly="" id='total_quarterly_installment_count'
                                                class="form-control" name="total_quarterly_installment_count"
                                                value="{{ old('total_quarterly_installment_count') }}"
                                                id="exampleInputEmail1" placeholder="Count">
                                            <div style="display: inline-block;width: 40%;color:black;"
                                                class="help-block" id='quarterly-installment-label'></div>
                                            <div style="display: inline-block;width: 40%;color:black;"
                                                class="help-block" id='total-quarterly-installment-label'></div>
                                            @if ($errors->has('quarterly_installment'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('quarterly_installment') }}</strong>
                                                </span>
                                            @endif

                                        </div>
                                    </div>
                                </div>




                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-5">Remaining Amount</label>
                                        <div class="col-md-7">

                                            <input readonly="" type="integer" id='remaining_amount'
                                                class="form-control" value="{{ old('remaining_amount') }}"
                                                placeholder="Remaining amount">
                                            <br>




                                            Adjust to <br>
                                            <ul type="none">
                                                <li><input type="radio" id="adjust_installment" name="adjust"
                                                        onclick="adjustAmount(1)"> Installment</li>
                                                <!-- <li><input type="radio" name="adjust" id="adjust" onclick="adjustAmount(2)"> Semi-Installment</li> -->
                                                <li><input type="radio" name="adjust" id="adjust_down_payment"
                                                        onclick="adjustAmount(3)"> Down Payment</li>
                                                <li><input type="radio" name="adjust" id="adjust_possession"
                                                        onclick="adjustAmount(4)"> Possession</li>

                                                <li><input type="radio" name="adjust" id="adjust_allotment"
                                                        onclick="adjustAmount(5)"> Allotment</li>
                                                <li><input type="radio" name="adjust" id="adjust_confirmation"
                                                        onclick="adjustAmount(6)"> Confirmation</li>

                                                <li><input type="radio" name="adjust" id="adjust_booking"
                                                        onclick="adjustAmount(7)"> Booking</li>
                                                <li><input type="radio" name="adjust" id="adjust_development"
                                                        onclick="adjustAmount(8)"> Development</li>

                                                <li><input type="radio" name="adjust" id="adjust_file_processing"
                                                        onclick="adjustAmount(9)"> File Processing</li>
                                                <li><input type="radio" name="adjust" id="adjust_registration"
                                                        onclick="adjustAmount(10)"> Registration</li>

                                            </ul>


                                            <div style="color:black;" class="help-block" id='remaining-amount-label'>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                                <div class="input_fields_wrap1">
                                    <button type="button" style="float: left!important;"
                                        class="btn btn-primary add_field_button">Add Payment</button>
                                    <div class="clearfix"></div>
                                </div>
                                <div class="clearfix"></div>


                            </div>

                            <!---Custom-->
                            <div id="custom" style="display: none;">

                                <div class="col-md-10">
                                    <div class="form-group">
                                        <label class="control-label col-md-3">Installment <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-9">

                                            <input style="display: inline-block;width: 43%;" type="date"
                                                id='installment' class="form-control" name="custom_date[]"
                                                placeholder="Date">

                                            <input style="display: inline-block;width: 49%;" type="integer"
                                                class="form-control" name="custom_amount[]" onkeyup="customPayment()"
                                                placeholder="Amount">
                                        </div>
                                    </div>
                                </div>


                                <div class="clearfix"></div>
                                <div class="input_fields_wrap2 col-md-10">

                                    <div class="clearfix"></div>
                                </div>
                                <div class="clearfix"></div>
                                <button type="button" class="btn btn-primary add_field_button2">Add
                                    Installment</button>&nbsp;&nbsp;&nbsp;
                                <input style="display: inline-block;width: 30%;" type="integer" readonly=""
                                    id='custome_rem' class="form-control" placeholder="Remaining amount">
                                <div class="clearfix"></div>
                            </div>

                            <!-- Custom End -->

                        </div>
                    </div>
                    <!--receipt module -->
                @endif;



                <div class="col-md-12" style="height: 70px;">
                    <button style="float: right;" type="submit" class="btn btn-info  waves-effect waves-light btn-lg"
                        id='submit_button'>Save</button>
                </div>


        </div>
    </div>


    </form>
    </div>
    </div>
    <input type='hidden' id="possession_per">
    <input type='hidden' id="down_payment_per">
    <input type='hidden' id="total_month_per">
    <input type='hidden' id="annual_installment_per">
    <input type='hidden' id="monthly_installment_per">
    <input type="hidden" id="down_payment_dis">
    <input type="hidden" name="percentage" id="percentage">
    <input type="hidden" name="rebate_in_percent" id="rebate_in_percent">

    <input type='hidden' id="remainig-possession-amount">
    <input type='hidden' id="remainig-down_payment-amount">
    <input type='hidden' id="remaining-total_month_per">
    @php
        $value = $per_insta * $remaining_installment_count;
    @endphp
    <input type='hidden' id="remaining-total_extra_install" value={{ $value }}>
    <input type='hidden' id="remaining-per_installment">
    <input type='hidden' id="remaining-per-total_install">



@stop

@section('js')

    <script>
        var a = ['', 'one ', 'two ', 'three ', 'four ', 'five ', 'six ', 'seven ', 'eight ', 'nine ', 'ten ',
            'eleven ',
            'twelve ', 'thirteen ', 'fourteen ', 'fifteen ', 'sixteen ', 'seventeen ', 'eighteen ',
            'nineteen '
        ];
        var b = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];
        var data = {
            'customer_property_id': $('#customer_property-id').val()
        };

        // get information
        $.get('/getInformationByUnitEdit', data, function(data) {
            if (data) {

                $('#total-amount').val(data.info.total_price);
                data.info.total_price = parseInt(data.info.total_price) + parseInt(data.info
                    .extra_amount) - parseInt(data.receivedAmt);

                if (data.info.customer_property.schedule_start_date != '') {
                    $('#schedule_start_date').val(data.info.customer_property.schedule_start_date)
                }
                $('#total_month_per').val(36);

                //set schedules amount
                $('#down-payment').val(Math.round((parseInt(data.down_payment_amount))));
                $('#possession').val(Math.round((parseInt(data.possession_payment_amount))));
                $('#allotment').val(Math.round((parseInt(data.allotment_payment_amount))));
                $('#confirmation').val(Math.round((parseInt(data.confirmation_payment_amount))));
                $('#booking').val(Math.round((parseInt(data.booking_payment_amount))));
                $('#development').val(Math.round((parseInt(data.development_payment_amount))));
                $('#file_processing').val(Math.round((parseInt(data.file_processing_payment_amount))));
                $('#registration').val(Math.round((parseInt(data.registration_payment_amount))));
                $('#ballon').val(Math.round((parseInt(data.ballon_payment_amount))));
                $('#balloting').val(Math.round((parseInt(data.balloting_payment_amount))));
                $('#installment').val(Math.round((parseInt(data.per_installment_amount))));
                $('#total_installment').val(Math.round((parseInt(data.total_installment_amount))));

                $('#sqrt').html(data.info.size.name);
                net_amount = parseInt($('#net_amount').val());
                $('#per_sqrt_value').val((net_amount / data.info.size.name).toFixed(2));
                //set schedules percentage
                $('#per_possession').val(Math.round(data.possession_payment_percentage).toFixed(2));
                $('#per_down_payment').val(Math.round(data.down_payment_percentage).toFixed(2));
                $('#per_allotment').val(Math.round(data.allotment_payment_percentage).toFixed(2));
                $('#per_confirmation').val(Math.round(data.confirmation_payment_percentage).toFixed(2));
                $('#per_booking').val(Math.round(data.booking_payment_percentage).toFixed(2));
                $('#per_development').val(Math.round(data.development_payment_percentage).toFixed(2));
                $('#per_file_processing').val(Math.round(data.file_processing_payment_percentage).toFixed(2));
                $('#per_registration').val(Math.round(data.registration_payment_percentage).toFixed(2));
                $('#per_installment').val(Math.round(data.per_installment_percentage).toFixed(2));
                $('#per_total_installment').val(Math.round(data.total_installment_percentage).toFixed(2));
                $('#down_payment_per').val(Math.round(data.schedule.down_payment).toFixed(2));
                $('#possession_per').val(Math.round(data.schedule.possession).toFixed(2));
                $('#per_balloting').val(Math.round(data.schedule.bulleting).toFixed(2));
                $('#per_file_ballon').val(Math.round(data.schedule.ballon).toFixed(2));

                // adjust_installment             
                //set remaining for schedules
                makeDisable('balloting', 'per_balloting', data.check_balloting_payment,
                    'remaining_balloting', 'remaining_per_balloting', data.total_amount,
                    'adjust_balloting');
                makeDisable('ballon', 'per_file_ballon', data.check_ballon_payment,
                    'remaining_ballon', 'remaining_per_file_ballon', data.total_amount,
                    'adjust_ballot');

                makeDisable('possession', 'per_possession', data.check_possession_payment,
                    'remaining_possession', 'remaining_per_possession', data.total_amount,
                    'adjust_possession');
                makeDisable('down-payment', 'per_down_payment', data.check_down_payment,
                    'remaining_down-payment', 'remaining_per_down_payment', data.total_amount,
                    'adjust_down_payment');
                makeDisable('allotment', 'per_allotment', data.check_allotment_payment,
                    'remaining_allotment', 'remaining_per_allotment', data.total_amount,
                    'adjust_allotment');
                makeDisable('confirmation', 'per_confirmation', data.check_confirmation_payment,
                    'remaining_confirmation', 'remaining_per_confirmation', data.total_amount,
                    'adjust_confirmation');
                makeDisable('booking', 'per_booking', data.check_booking_payment, 'remaining_booking',
                    'remaining_per_booking', data.total_amount, 'adjust_booking');
                makeDisable('development', 'per_development', data.check_development_payment,
                    'remaining_development', 'remaining_per_development', data.total_amount,
                    'adjust_development');
                makeDisable('file_processing', 'per_file_processing', data
                    .check_file_processing_payment, 'remaining_file_processing',
                    'remaining_per_file_processing', data.total_amount, 'adjust_file_processing');
                makeDisable('registration', 'per_registration', data.check_registration_payment,
                    'remaining_registration', 'remaining_per_registration', data.total_amount,
                    'adjust_registration');
                makeDisableIntstallment('remaining_single_installment', 'remaining_per_installment',
                    data.check_per_installment, 'remaining_total_installment',
                    'remaining_per_total_installment', data.total_amount, data
                    .per_installment_amount, 'adjust_installment');


                $('#total-months').val(Math.round(data.number_of_installments));
                $('#remaining-total-months').val(Math.round(data.number_of_installments_remianing));
                $('#remaining-total_month_per').val(Math.round(data.number_of_installments_remianing));
                $('#remainig-possession-amount').val(Math.round(data.check_possession_payment));
                $('#remainig-down_payment-amount').val(Math.round(data.check_down_payment));

                updateCurrency()
            }


            remaining_net_amount = parseInt($('#remianing_payable').val());
            net_amount = parseInt($('#net_amount').val());
            if ($('#remaining_down-payment').val())
                down_payment = parseInt($('#remaining_down-payment').val());
            else
                down_payment = 0;
            registration = parseInt($('#remaining_registration').val());
            possession = parseFloat($('#remaining_possession').val());

            if (isNaN(registration)) {
                registration = 0;

            }
            monthly_installment = parseInt($('#remaining_total_installment').val());
            annual_installment = 0;
            num = $("#remaining_registration").val();
            $("#remaining_registration-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == {{ \App\CustomerProperty::inst_mon_w_semi }} || val ==
                {{ \App\CustomerProperty::inst_quar_exclude_semi }}) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == {{ \App\CustomerProperty::inst_mon_w_ann }}) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == {{ \App\CustomerProperty::inst_mon_w_quar }} || val ==
                {{ \App\CustomerProperty::inst_mon_exclude_quar }}) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == {{ \App\CustomerProperty::inst_quar_w_semi }} || val ==
                {{ \App\CustomerProperty::inst_mon_exclude_semi }}) {
                annual_installment = $('#total_semi_installment').val();
            }
            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });

            allotment = parseFloat($('#remaining_allotment').val());
            confirmation = parseFloat($('#remaining_confirmation').val());
            booking = parseFloat($('#remaining_booking').val());

            file_processing = parseFloat($('#remaining_file_processing').val());
            registration = parseFloat($('#remaining_registration').val());
            balloting = parseFloat($('#remaining_balloting').val());
            ballon = parseFloat($('#remaining_ballon').val());


            remaining_amount = remaining_net_amount - down_payment - possession - monthly_installment -
                annual_installment - add_amount - allotment - confirmation - booking -
                file_processing - registration - ballon - balloting;


            $('#remaining_amount').val(remaining_amount);
        });


        function adjustRemainingPayable() {
            if ($('#add_new_discount').val()) {
                discount = 0;
                if ($('#discount_percent').prop("checked") == false) {

                    price = Math.round(parseInt({{ $remaining_amount }}) -
                        parseFloat($('#add_new_discount').val()));

                    discount = parseFloat($('#add_new_discount').val());


                } else {


                    price = Math.round(parseInt({{ $remaining_amount }}) -
                        parseFloat($('#add_new_discount').val()) /
                        100 * (parseInt($('#remianing_payable').val())));

                    discount = parseFloat($('#add_new_discount').val()) / 100 * (parseInt($(
                        '#remianing_payable').val()));

                }

                $('#remianing_payable').val(price).trigger("input");


                updateCurrency();
            } else {

                $('#remianing_payable').val({{ $remaining_amount }}).trigger("input");
                $re_p = $('#remainig-possession-amount').val();
                $re_d = $('#remainig-down_payment-amount').val();
                $('#remaining_down-payment').val(Math.round($re_p));
                $('#remaining_possession').val(Math.round($re_d));

                updateCurrency();

            }

        }
        $('#add_new_discount').keyup(function() {

            //  $('#remianing_payable').val({{ $remaining_amount }});
            adjustRemainingPayable();
        });


        function percentCheckbox() {

            if ($('#discount_percent').prop("checked") == false) {
                document.getElementById('dis_input').innerHTML = 'PKR';
            } else {
                document.getElementById('dis_input').innerHTML = '%';
            }
            adjustRemainingPayable();
        }




        function number2TextConversion(num) {


            if ((num = num.toString()).length > 9) return 'overflow';
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return;
            var str = '';
            str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
            str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
            str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
            str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
            str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][
                    1
                ]]) +
                'only ' : '';

            return str;
        }

        function updateCurrency() {


            //update the cost label

            num = $("#total-amount").val();

            $("#total-amount-label").text(number2TextConversion(num));

            //update the net amount
            num = $("#net_amount").val();

            $("#net_amount-label").text(number2TextConversion(num));


            //update the down payemnt label
            num = $("#down-payment").val();

            $("#down-payment-label").text(number2TextConversion(num));
            num = $("#remaining_down-payment").val();

            $("#remaining_down-payment-label").text(number2TextConversion(num));



            //update the annual installment text
            num = $("#annual-installment").val();


            $("#annual-installment-label").text(number2TextConversion(num));


            //update the total annual installment text
            num = $("#total_annual_installment").val();

            $("#total-annual-installment-label").text(number2TextConversion(num));

            //update the semi installment text
            num = $("#semi-installment").val();

            $("#semi-installment-label").text(number2TextConversion(num));


            // //update the total semi installment
            num = $("#total_semi_installment").val();

            $("#total-semi-installment-label").text(number2TextConversion(num));

            // //upte the quarterly installment text
            num = $("#bi-mon-installment").val();

            $("#bi-mon-installment-label").text(number2TextConversion(num));

            // //upte the quarterly installment text
            num = $("#quarterly-installment").val();

            $("#quarterly-installment-label").text(number2TextConversion(num));

            // //update the total quarterly installment
            num = $("#total_bi_mon_installment").val();

            $("#total-bi-mon-installment-label").text(number2TextConversion(num));


            // //update the total quarterly installment
            num = $("#total_quarterly_installment").val();

            $("#total-quarterly-installment-label").text(number2TextConversion(num));

            // //update the installment label

            num = $("#installment").val();

            $("#installment-label").text(number2TextConversion(num));

            // //update the total_installment
            num = $("#total_installment").val();

            $("#total-installment-label").text(number2TextConversion(num));


            // //update the possession
            num = $("#possession").val();

            $("#possession-label").text(number2TextConversion(num));
            num = $("#remaining_possession").val();

            $("#remaining_possession-label").text(number2TextConversion(num));




            // //update the Allotment
            num = $("#allotment").val();

            $("#allotment-label").text(number2TextConversion(num));
            num = $("#remaining_allotment").val();
            $("#remaining_allotment-label").text(number2TextConversion(num));


            // //update the Confirmation
            num = $("#confirmation").val();

            $("#confirmation-label").text(number2TextConversion(num));
            num = $("#remaining_confirmation").val();

            $("#remaining_confirmation-label").text(number2TextConversion(num));


            // //update the Booking
            num = $("#booking").val();

            $("#booking-label").text(number2TextConversion(num));


            num = $("#remaining_booking").val();

            $("#remaining_booking-label").text(number2TextConversion(num));
            //update the Booking

            //update the file_processing
            num = $("#file_processing").val();

            $("#file_processing-label").text(number2TextConversion(num));
            num = $("#remaining_file_processing").val();
            $("#remaining_file_processing-label").text(number2TextConversion(num));




            //update the remaining file_processing
            num = $("#remaining_balloting").val();

            $("#remaining_balloting-label").text(number2TextConversion(num));




            // //update the remaining registration
            num = $("#remaining_registration").val();

            $("#remaining_registration-label").text(number2TextConversion(num));


            // //update the registration
            num = $("#registration").val();

            $("#registration-label").text(number2TextConversion(num));




            // //update the registration
            num = $("#ballon").val();

            $("#ballon-label").text(number2TextConversion(num));
            // update remaining 

            num = $("#remaining_ballon").val();

            $("#remaining_ballon-label").text(number2TextConversion(num));

            // //update the balloting
            num = $("#balloting").val();

            $("#balloting-label").text(number2TextConversion(num));
            // //update remaining balloting
            num = $("#remaining_balloting").val();

            $("#remaining_balloting-label").text(number2TextConversion(num));



        }

        function makeDisable(id, per_id, val, rem_id, rem_per_id, total, adjust_amount_id) {

            if (val === 0) {
                $("#" + id).prop('disabled', true);
                $("#" + per_id).prop('disabled', true);
                $("#" + rem_id).prop('disabled', true);
                $("#" + rem_per_id).prop('disabled', true);
                $("#" + adjust_amount_id).prop('disabled', true);

            } else {
                $("#" + id).prop('disabled', true);
                $("#" + per_id).prop('disabled', true);
                $("#" + rem_id).val(Math.round((parseInt(val))));
                $("#" + rem_per_id).val(costToPercentage(val, total));
                console.log(id, per_id, rem_id, rem_per_id);
            }
        }

        function makeDisableIntstallment(id, per_id, val, rem_id, rem_per_id, total, per_installment, adjust_amount_id) {
            $("#remaining-per_installment").val(Math.round((parseInt(per_installment))));

            $("#remaining-per-total_install").val(Math.round(Math.round(parseInt(val))));
            console.log(val);
            if (val === 0) {
                $("#" + id).prop('readonly', true);
                $("#" + per_id).prop('readonly', true);
                $("#" + rem_id).prop('readonly', true);
                $("#" + rem_per_id).prop('readonly', true);
                $("#" + adjust_amount_id).prop('disabled', true);

            } else {
                $("#" + id).val(Math.round((parseInt(per_installment))));
                $("#" + per_id).val(costToPercentage(per_installment, total));
                $("#" + rem_id).val(Math.round(Math.round(parseInt(val) - $('#remaining-total_extra_install').val())));
                $("#" + rem_per_id).val(costToPercentage(val, total));




            }
        }

        function costToPercentage(cost, total) {

            return ((cost / total) * 100).toFixed(2);
        }

        function manToPer() {
            cost = $('#net_amount').val();
            if (cost) {

                down_payment = $('#down-payment').val();
                if (down_payment) {
                    $('#per_down_payment').val(((down_payment / cost) * 100).toFixed(2));

                }
                possession = $('#possession').val();
                if (possession) {
                    $('#per_possession').val(((possession / cost) * 100).toFixed(2));

                }



                total_months = $('#total-months').val();
                if (total_months) {
                    installment = $('#installment').val();
                    if (installment) {
                        $('#per_installment').val((((installment) / cost) * 100).toFixed(2));

                    }
                    total_installment = $('#total_installment').val();
                    if (total_installment) {
                        $('#per_total_installment').val((((total_installment) / cost) * 100).toFixed(2));

                    }
                }
                updateCurrency();

            }
        }

        function perToMan() {
            cost = $('#net_amount').val();
            if (cost) {

                down_payment = $('#down-payment').val();
                if (down_payment) {
                    $('#down-payment').val(((down_payment * cost) / 100).toFixed(0));

                }
                possession = $('#possession').val();
                if (possession) {
                    $('#possession').val(((possession * cost) / 100).toFixed(0));

                }


                annual_installment = $('#annual-installment').val();
                if (annual_installment) {
                    $('#annual-installment').val(((annual_installment * cost) / 100).toFixed(0));

                }
                total_annual_installment = $('#total_annual_installment').val();
                if (total_annual_installment) {
                    $('#total_annual_installment').val(((total_annual_installment * cost) / 100).toFixed(0));

                }
                total_months = $('#total-months').val();
                if (total_months) {
                    installment = $('#installment').val();
                    if (installment) {
                        $('#installment').val(((installment * cost) / 100).toFixed(0));

                        total_installment = $('#total_installment').val();
                        if (total_installment) {
                            $('#total_installment').val(((total_installment * cost) / 100).toFixed(0));

                        }
                    }
                }
                updateCurrency();

            }
        }
    </script>
    @include('statement.update-statement-schedule-type-events');
    <script>
        function percentage(num, per) {
            return (num / 100) * per;
        }
    </script>


    @include('statement.update-statement-payment-head-events')

    <script>
        function setDefaultValueForSchedule() {

            if ({{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_mon_w_quar }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_mon_exclude_quar }}) {
                // enableQuar();
                document.getElementById('custom').style.display = 'none';
                document.getElementById('auto').style.display = 'block';

                $('#remaining_amount').val(0);
                document.getElementById('quar_div').style.display = 'block';
                document.getElementById('bi_mon_div').style.display = 'none';
                document.getElementById('semi_div').style.display = 'none';
                document.getElementById('ann_div').style.display = 'none';
                if ({{ $remaining_installment_count }} != 0) {

                    $('#quarterly-installment').val(Math.round({{ $per_insta }}));
                    $('#total_quarterly_installment_count').val(Math.round(parseInt({{ $remaining_installment_count }})));

                    $('#total_quarterly_installment').val(Math.round({{ $per_insta }} *
                        {{ $remaining_installment_count }}));
                } else {
                    $('#quarterly-installment').val(0);
                    $('#quarterly-installment').prop('disabled', true);
                    $('#total_quarterly_installment_count').val(Math.round(parseInt({{ $remaining_installment_count }})));

                    $('#total_quarterly_installment').val(Math.round({{ $per_insta }} *
                        {{ $remaining_installment_count }}));
                }

            } else if ({{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_mon }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_bi_mon }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_quar }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_semi }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_ann }}) {
                // disableAnn({{ $property->schedular_type }});
                document.getElementById('custom').style.display = 'none';
                document.getElementById('auto').style.display = 'block';
                $('#remaining_amount').val(0);
                document.getElementById('semi_div').style.display = 'none';
                document.getElementById('ann_div').style.display = 'none';
                document.getElementById('quar_div').style.display = 'none';
                document.getElementById('bi_mon_div').style.display = 'none';
            } else if ({{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_mon_w_semi }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_quar_w_semi }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_mon_exclude_semi }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_quar_exclude_semi }}) {
                // enableSemi();
                document.getElementById('custom').style.display = 'none';
                document.getElementById('auto').style.display = 'block';
                $('#remaining_amount').val(0);
                document.getElementById('semi_div').style.display = 'block';
                document.getElementById('ann_div').style.display = 'none';
                document.getElementById('quar_div').style.display = 'none';
                document.getElementById('bi_mon_div').style.display = 'none';
                if ({{ $remaining_installment_count }} != 0) {
                    $('#semi-installment').val(Math.round({{ $per_insta }}));

                    $('#total_semi_installment_count').val(Math.round(parseInt({{ $remaining_installment_count }})));

                    $('#total_semi_installment').val(Math.round({{ $per_insta }} *
                        {{ $remaining_installment_count }}));
                } else {
                    $('#semi-installment').val(Math.round(0));
                    $("#semi-installment").prop('disabled', true);

                    $('#total_semi_installment_count').val(Math.round(parseInt({{ $remaining_installment_count }})));

                    $('#total_semi_installment').val(Math.round({{ $per_insta }} *
                        {{ $remaining_installment_count }}));
                }

            } else if ({{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_mon_w_ann }} ||
                {{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_mon_exclude_ann }}) {
                // enableAnn();
                document.getElementById('custom').style.display = 'none';
                document.getElementById('auto').style.display = 'block';

                $('#remaining_amount').val(0);
                document.getElementById('ann_div').style.display = 'block';
                document.getElementById('semi_div').style.display = 'none';
                document.getElementById('quar_div').style.display = 'none';
                document.getElementById('bi_mon_div').style.display = 'none';
                if ({{ $remaining_installment_count }} != 0) {
                    $('#annual-installment').val(Math.round({{ $per_insta }}));
                    $('#total_annual_installment_count').val(Math.round(parseInt({{ $remaining_installment_count }})));
                    $('#total_annual_installment').val(Math.round({{ $per_insta }} *
                        {{ $remaining_installment_count }}));
                } else {
                    $('#annual-installment').val(0);
                    $('#annual-installment').prop('disabled', true);
                    $('#total_annual_installment_count').val(Math.round(parseInt({{ $remaining_installment_count }})));
                    $('#total_annual_installment').val(Math.round({{ $per_insta }} *
                        {{ $remaining_installment_count }}));
                }
            } else if ({{ $property->schedular_type }} === {{ \App\CustomerProperty::inst_custom }}) {
                // enableCustom();
                document.getElementById('custom').style.display = 'block';
                document.getElementById('auto').style.display = 'none';
            }

        }





        // setDefaultValueForSchedule();



        function adjustAmount(val) {

            amount = parseInt($('#remaining_amount').val());



            if (amount) {
                if (val == 1) { //amount adjustment to per installment
                    $('#remaining_total_installment').val(parseInt($('#remaining_total_installment').val()) + amount);
                    val = $('#remaining_single_installment').val(Math.round((parseInt($('#remaining_total_installment')
                        .val())) / parseInt($(
                        '#remaining-total-months').val())));

                    $('#remaining_per_installment').val(((parseInt($('#remaining_single_installment').val()) / net_amount) *
                        100).toFixed(
                        2));
                    $('#remaining_per_total_installment').val(Math.round(parseFloat($("#remaining_per_installment").val()) *
                        parseFloat($('#remaining-total-months').val())));
                }
                // else if (val == 2) {
                //     val = parseInt($('input[name="schedule_type"]:checked').val());
                //     if (val == {{ \App\CustomerProperty::inst_mon_w_semi }}) {
                //         $('#total_semi_installment').val(parseInt($('#total_semi_installment').val()) + amount);
                //         $('#semi-installment').val(Math.round((parseInt($('#total_semi_installment').val())) /
                //             parseInt($('#total_semi_installment_count').val())));
                //     } else if (val == {{ \App\CustomerProperty::inst_mon_w_ann }}) {
                //         $('#total_annual_installment').val(parseInt($('#total_annual_installment').val()) +
                //             amount);
                //         $('#annual-installment').val(Math.round((parseInt($('#total_annual_installment')
                //             .val())) / parseInt($('#total_annual_installment_count').val())));
                //     } else if (val == {{ \App\CustomerProperty::inst_mon_w_quar }}) {

                //         $('#total_quarterly_installment').val(parseInt($('#total_quarterly_installment')
                //             .val()) + amount);
                //         $('#quarterly-installment').val(Math.round((parseInt($('#total_quarterly_installment')
                //             .val())) / parseInt($('#total_quarterly_installment_count').val())));
                //     }

                // } 
                else if (val == 3) {


                    $('#remaining_down-payment').val(parseInt($('#remaining_down-payment').val()) + amount);


                    $('#remaining_per_down_payment').val(((parseInt($('#remaining_down-payment').val()) /
                            net_amount) * 100)
                        .toFixed(2));

                } else if (val == 4) {
                    $('#remaining_possession').val(parseInt($('#remaining_possession').val()) + amount);

                    $('#remaining_per_possession').val(((parseInt($('#remaining_possession').val()) / net_amount) * 100)
                        .toFixed(
                            2));
                } else if (val == 5) {
                    $('#remaining_allotment').val(parseInt($('#remaining_allotment').val()) + amount);

                    $('#remaining_per_allotment').val(((parseInt($('#remaining_allotment').val()) / net_amount) * 100)
                        .toFixed(2));
                } else if (val == 6) {
                    $('#remaining_confirmation').val(parseInt($('#remaining_confirmation').val()) + amount);

                    $('#remaining_per_confirmation').val(((parseInt($('#remaining_confirmation').val()) / net_amount) * 100)
                        .toFixed(2));
                } else if (val == 7) {
                    $('#remaining_booking').val(parseInt($('#remaining_booking').val()) + amount);

                    $('#remaining_per_booking').val(((parseInt($('#remaining_booking').val()) / net_amount) * 100).toFixed(
                        2));
                } else if (val == 8) {
                    $('#remaining_development').val(parseInt($('#remaining_development').val()) + amount);

                    $('#remaining_per_development').val(((parseInt($('#remaining_development').val()) / net_amount) * 100)
                        .toFixed(
                            2));
                } else if (val == 9) {
                    $('#remaining_file_processing').val(parseInt($('#remaining_file_processing').val()) + amount);

                    $('#remaining_per_file_processing').val(((parseInt($('#remaining_file_processing').val()) /
                            net_amount) * 100)
                        .toFixed(2));
                } else if (val == 10) {
                    $('#remaining_registration').val(parseInt($('#remaining_registration').val()) + amount);
                    $('#remaining_per_registration').val(((parseInt($('#remaining_registration').val()) / net_amount) * 100)
                        .toFixed(2));
                }
                $('#remaining_amount').val(0);
                $("input:radio[name='adjust']").each(function(i) {
                    this.checked = false;
                });
                updateCurrency();
            }
        }

        function validateForm() {

            val = $('#remaining_amount').val();


            if (parseInt(val) > 0 || parseInt(val) < 0) {
                Swal.fire('Remaining Amount Exists');

                return false;
            }
        }
        $(document).ready(function() {
            var max_fields = 100; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap2"); //Fields wrapper
            var wrapper1 = $(".input_fields_wrap2"); //Fields wrapper
            var add_button = $(".add_field_button2"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Installment-' +
                        x +
                        '<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 43%;margin-right: 4px;" type="date" class="form-control" name="custom_date[]" placeholder="Date"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount"></div> </div><a href="#" class="remove_field">Remove</a>'
                    ); //add input box
                    $(".bdpk").datepicker({
                        dateFormat: "dd-mm-yy"
                    });
                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
            $(wrapper1).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
        });

        function customPayment() {

            remaining_net_amount = parseInt($('#remianing_payable').val());
            // net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#remaining_down-payment').val());
            possession = parseInt($('#remaining_possession').val());
            allotment = parseInt($('#remaining_allotment').val());
            confirmation = parseInt($('#remaining_confirmation').val());
            booking = parseInt($('#remaining_booking').val());
            development = parseInt($('#remaining_development').val());
            file_processing = parseInt($('#remaining_file_processing').val());
            registration = parseInt($('#remaining_registration').val());
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            remaining_amount = remaining_net_amount - remaining_down_payment - remaining_possession - remaining_allotment -
                remaining_confirmation - remaining_booking - remaining_development - remaining_file_processing -
                remaining_registration - cus_amount;
            $('#custome_rem').val(Math.round(remaining_amount));
        }
    </script>

@stop
