@extends('layouts.app')

@section('title')
Edit SMTP Setting
@stop

@section('breadcrumb')
    
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
       
            <li><a href="{{ route('stmp.index') }}"> SMTP Setting List</a></li>
           
        <li class="active">Edit</li>
        
    </ol>
@stop

@section('css')

    <link href="{{ asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet">

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <style type="text/css">
    .placeholder-box {
  border: 2px solid #ccc;
  background-color: #f5f5f5;
  padding: 10px;
  margin: 10px 0;
  display: flex;
  flex-wrap: wrap;
}

.placeholder {
  border: 1px solid #ccc;
  background-color: #fff;
  padding: 5px 10px;
  margin: 5px;
  cursor: move;
}

    .placeholder-non-editable {
  pointer-events: none;
  user-select: none;
  -webkit-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
}
.placeholder-box h2 {
  font-size: 24px;
  font-weight: bold;
  margin: 0 0 10px;
}
.placeholder-non-editable {
  display: inline-block;
  background-color: yellow;
  color: black;
  pointer-events: none;
}

        .h30 {
            /* height: 30px;*/
        }

        .table>tbody>tr>td,
        .table>tbody>tr>th {
            font-size: 14px;
            text-align: left;
        }
        




        .swal2-popup {
            font-size: 2.0rem !important;
        }

        .bg-color {
            background-color: #1c3752;
        }

        .anchor-link {
            display: none;
        }

        body {
            font-weight: bold;
        }

        #slider {
            height: 34px;
            -webkit-appearance: none;
            appearance: none;
            background-color: #ddd;
            outline: none;
            padding: 0;
            margin: 0;
            border-radius: 0px;
        }

        #slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #555;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        #slider::-moz-range-thumb {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #555;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        #switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        #switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        #slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        #slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked+#slider {
            background-color: #2196F3;
        }

        input:focus+#slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked+#slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        #slider.round {
            border-radius: 34px;
        }

        #slider.round:before {
            border-radius: 50%;
        }
    </style>

@endsection

@section('content')

 

    <div class="container-fluid">
        <!--.row-->
        <div class="row">
            <div class="col-md-12">
                @if ($errors->any())
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul>


                    </div>
                @endif
                <div class="white-box">
                    <div class="pull-right">
                       
                       
                    

                </div>
                    <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Edit SMTP Setting</h3>
                    <hr>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body" style="    margin-bottom: 36px;">
                            {{-- <h3>Add Detail</h3> --}}
                            {{-- <hr> --}}
                            <form id="form-div" method="post" action="{{ route('stmp.update') }}" class="form-horizontal"  onsubmit="disableSubmitButton()"> 
                                @csrf
                                <input type='hidden' name='id' value="{{$smtp->id}}">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>Setting Name:</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" id="name" type="text" name='name'
                                                style='width:30%' placeholder="Add..." value="{{$smtp->name}}">
                                                @if ($errors->has('name'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('name') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div> 
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>SMTP Host:</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" id="host" type="text" name='host'
                                                style='width:30%' placeholder="Add..." value="{{$smtp->smtp_host }}">
                                                @if ($errors->has('host'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('host') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                 
                                    <div class="form-group">
                                       
                                        <label class="col-sm-2 control-label" style='font-size:medium'>	STMP User Name:</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" id="username" type="text" name='username'
                                                style='width:30%' placeholder="Add..." value="{{$smtp->smtp_username}}">
                                                @if ($errors->has('username'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('username') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>Password:</label>
                                        <div class="col-sm-10"    >
                                             <input class="form-control" id="password" type="text" name='password'
                                             style='width:30%' placeholder="Add..." value="{{$smtp->smtp_password}}">
                                             @if ($errors->has('password'))
                                             <span class="help-block">
                                                 <strong>{{ $errors->first('password') }}</strong>
                                             </span>
                                         @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>From User Name:</label>
                                        <div class="col-sm-10"    >
                                             <input class="form-control" id="fromusername" type="text" name='fromusername'
                                             style='width:30%' placeholder="Add..." value="{{$smtp->from_name}}">
                                             @if ($errors->has('fromusername'))
                                             <span class="help-block">
                                                 <strong>{{ $errors->first('fromusername') }}</strong>
                                             </span>
                                         @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>From Email:</label>
                                        <div class="col-sm-10"    >
                                             <input class="form-control" id="fromemail" type="text" name='fromemail'
                                             style='width:30%' placeholder="Add..." value="{{$smtp->from_email}}">
                                             @if ($errors->has('fromemail'))
                                             <span class="help-block">
                                                 <strong>{{ $errors->first('fromemail') }}</strong>
                                             </span>
                                         @endif
                                        </div>
                                    </div>

                                    
                                
                                   
                                   
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>Status:</label>
                                        <div class="col-sm-10"    >
                                            <label class="switch" id='switch'>
                                                <input type="checkbox" id='status' name='status' {{($smtp->status == 1)?'checked':''}} >
                                                <span class="slider round" id='slider'></span>
                                            </label>
                                            @if ($errors->has('status'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('status') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>

                                   
                                   

                                </div>
                                
                                <div class="form-actions">

                                    <button style="float: right;margin-right: 20px;" type="submit"
                                        class="btn btn-success search-customer" id="submit_button"  > <i
                                            class="fa fa-check"></i> Save </button>


                                </div>
                            </form>


                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
 
    <script>
    

 



        </script>
@stop
