@extends('layouts.app')


@section('title')
STMP Setting
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
       
        <li class="active">SMTP Setting List</li>
        
    </ol>
@stop

@section('content')
    <!-- .container-fluid -->
        <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">
                       
                            <a href="{{ route('stmp.add') }}" class="btn  btn-primary">
                                <i class="fa fa-plus-square"></i>&nbsp; Add Setting
                            </a>
                        

                    </div>
                    <h3 class="box-title">STMP Setting List</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Setting Name</th> 
                                    <th>STMP Host</th>
                                    <th>STMP User Name</th>
                                    <th>STMP Password</th>
                                    <th>From User Name</th>
                                    <th>From Email</th>
                                    <th>Status</th>
                                     
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                @foreach ($smtps as $smtp)
                                <tr>
                                    <td>{{ $count++ }}</td>
                                    <td>{{ $smtp->name }}</td>
                                    <td>{{ $smtp->smtp_host }}</td>
                                    <td>{{ $smtp->smtp_username }}</td>
                                    <td>{{ $smtp->smtp_password }}</td>
                                    <td>{{ $smtp->from_name }}</td>
                                    <td>{{ $smtp->from_email }}</td>
                                    <td>
                                        
                                        @if( $smtp->status == 1)
                                        <span class="label label-success">Active</span>
                                        @elseif( $smtp->status == 0)
                                        <span class="label label-danger">InActive</span>
                                        @endif
                                    </td>
                                    <td class="text-nowrap">
                                        
                                            <a href="{{route('stmp.testSmtpSetting',$smtp->id)}}"
                                                data-toggle="tooltip" data-original-title="Test Setting"> <i
                                                    class="fa fa-angellist text-inverse m-r-10"></i>&nbsp;&nbsp;</a>

                                                    <a href="{{route('stmp.edit',$smtp->id)}}"
                                                        data-toggle="tooltip" data-original-title="Edit"> <i
                                                            class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                    </td> 
                                </tr>
                            @endforeach
                              

                             
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- ./container-fluid -->
@stop

@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script></script>
@stop