@extends('layouts.app')

@section('title')
    Projects List
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active"> Society </li>
    </ol>
@stop
@section('css')
<style type="text/css">
    @import url('https://fonts.googleapis.com/css2?family=Poppins&family=Rubik:wght@300&family=Varela+Round&family=Work+Sans&display=swap');

    .box-title {
        text-align: center;
        color: black !important
    }

    .container-fluid {
        margin-left: 50px;
    }

    .h2 {
        text-align: center;
        color: #273019 !important;
        font-weight: 400px;
        text-shadow: 0 1px 0 #ccc,
               0 2px 0 #C9C9C9,
               0 3px 0 #bbb,
               0 4px 0 #B9B9B9,
               0 5px 0 #aaa,
               0 6px 1px rgba(0,0,0,.1),
               0 0 5px rgba(0,0,0,.1),
               0 1px 3px rgba(0,0,0,.3),
               0 3px 5px rgba(0,0,0,.2),
               0 5px 10px rgba(0,0,0,.25),
               0 10px 10px rgba(0,0,0,.2),
               0 20px 20px rgba(0,0,0,.15);
    }

   

    /* img{
    width: 20%;
    height: 20%;
   } */
    .cards {
        width: 20%;
        height: auto;
        /* display: inline-block; */
        background-color: white;
        border-radius: 10px;
        /* margin: 40px; */
        margin-top: 100px;
        margin-left: 45px;
        border: 1px solid gray;

    }
    .card-wrapper {
    display: flex;
    justify-content: center;
    background: white;
    margin-left: 10px;
    margin-right: 10px;
   }

    .activ,
    .cards:hover {
        box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;
        /* box-shadow: 2px 2px 10px black; */
        cursor: pointer;
        border: 1px solid LightGray;
        transition: all 1s ease;
        transform: scale(1.03);
    }

    .image img {
        width: 100%;
        border-radius: 5px;
        height: 150px;
        object-fit: cover;

    }

    .title {
        text-align: center;
        color: black;
        font-size: 16px;
        font-weight: bold;
        font-family: Arial, Helvetica, sans-serif;
        padding: 10px
    }
    body{
        background: red;
    }

    /* button{
    margin-top: 10%;
    margin-bottom: 10%;
    background-color: white;
    border: 1px solid black;
    padding: 5px;
    border-radius: 5px;
    color: black;
    cursor: pointer;
   } */
    button:hover {
        background-color: black;
        color: white;
        transition: 0.5s;
    }
    .head {
    display: flex;
    justify-content: space-around;
    background: white;
    border-radius: 10px;
    margin-left: 10px;
    margin-right: 10px;
   }
    .pimg > img{
        height: 370px;
    }
    .texts{
        margin-top: 105px;
    }
    .texts > h4{
        font-size: 20px;
        font-family: 'georgia';
        letter-spacing: 0.5px;
    }
    h2{
        position: relative;
        font-size: 20px;
        color: transparent;
        -webkit-text-stroke: 0.3vw transparent;
        text-transform: uppercase;
    }
    h2::before{
        content: attr(data-text);
        position: absolute;
        top: 0;
        left: 0;
        width: 0%;
        height: 100%;
        color: #f2a225;
        -webkit-text-stroke: 0vw #383d52;
        border-right: 2px solid #f2a225;
        overflow: hidden;
        animation: animate 6s linear infinite;
    }
    @keyframes animate 
    {
        0%, 10%, 100%{
            width: 0;
        }   
        70%,100%
        {
            width: 100%;
        }
    }
</style>
@stop
@section('content')

<div class="head">
    <div class="texts">
        <h4>𝐏𝐑𝐎𝐉𝐄𝐂𝐓𝐒</h4>
        <h2 data-text="Ｓｏｃｉｅｔｙ ａｎｄ ＨｉｇｈＲｉｓｅ">Ｓｏｃｉｅｔｙ ａｎｄ Ｈｉｇｈ Ｒｉｓｅ</h2>
    </div>

    <div class="pimg">
        <img src="images/high.jpg">
    </div>
    </div>
  
    <div class="card-wrapper">
        <div class="cards">
        <a href="#">
          <div class="image"> <img src="images/metrocity.jpg"></div>
          <div class="title">Metro City
                </div>
            </a>
        </div>
       <div class="cards">
        <a href="#">
          <div class="image"> <img src="images/logo.png"></div>
          <div class="title">Prism City
                </div>
        </a>    
       </div>
       <div class="cards">
        <a href="#">
          <div class="image"> <img src="images/pac.png"></div>
          <div class="title">Metro City
                </div>
        </a>    
       </div>
   </div>

   



@stop

@section('js')
    <script>
        $(function() {

            // Order by the grouping
            $('#example tbody').on('click', 'tr.group', function() {
                var currentOrder = table.order()[0];
                if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                    table.order([2, 'desc']).draw();
                } else {
                    table.order([2, 'asc']).draw();
                }
            });
        });
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
        let card = document.querySelectorAll('.cards')
        card.forEach(cards => {
            cards.addEventListener('click', function() {
                card.forEach(cd => cd.classList.remove('activ'));
                this.classList.add('activ');

            })
        })
    </script>

    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
        // $("#postbutton").click(function() {

        function callFunction(val) {

            $('.preloader').fadeIn();
            $.ajax({
                /* the route pointing to the post function */
                url: '{{ route('projectswitch.create') }}',
                type: 'POST',
                /* send the csrf-token and the input to the controller */
                data: {
                    _token: CSRF_TOKEN,
                    project: val
                },
                dataType: 'JSON',
                /* remind that 'data' is the response of the AjaxController */
                success: function(data) {

                    $('.preloader').fadeOut();
                    //  localStorage.setItem('project_id', data.session);
                    Swal.fire({

                            icon: 'success',
                            title: 'Your Project Switched Successfully!',
                            confirmButtonColor: '#3085d6',

                            confirmButtonText: 'ok!',
                            showCancelButton: false,
                            allowOutsideClick: false
                        })
                        .then((result) => {
                            if (result.isConfirmed) {
                               
                                location.href = "{{ route('home') }}";

                            }
                        });


                },
                error: function(xhr, status, error) {
                    // handle error response here
                    if (xhr.status == 422) {
                        var errors = xhr.responseJSON.errors;
                        //   console.log(errors);
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Something went wrong!',

                        })

                    } else {
                        //   console.log(xhr.responseText);
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Something went wrong!',

                        })
                    }
                }
            });




        }
    </script>

@stop
