@extends('layouts.app')

@section('title')
    Projects List
@stop
@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active"> Project(s) </li>
    </ol>
@stop

@section('css')

    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Poppins&family=Rubik:wght@300&family=Varela+Round&family=Work+Sans&display=swap');

        .stories-container {
            max-width: 900px;
            margin: 90px auto;
            position: relative;
        }

        .stories-container .previous-btn,
        .stories-container .next-btn {
            width: 30px;
            position: absolute;
            z-index: 2;
            top: 50%;
            transform: translateY(-50%);
            background: #444;
            color: #fff;
            padding: 10px;
            display: flex;
            cursor: pointer;
        }

        .stories-container .previous-btn,
        .stories-container .next-btn {
            pointer-events: none;
            transition: all 400ms ease;
        }

        .stories-container .previous-btn.active,
        .stories-container .next-btn.active {
            opacity: 1;
            pointer-events: auto;
        }

        .stories-container .previous-btn {
            left: 89%;
            top: 308px;
        }

        .stories-container .next-btn {
            right: 3px;
            top: 308px;
        }

        .stories-container .story {
            height: 270px;
            background: white;
            width: 260px;
            flex-shrink: 0;
            border-radius: 5px;
            overflow: hidden;
            position: relative;
            border-radius: 5%;
            box-shadow: 0px 5px 10px 0px rgba(0, 0, 0, 0.5);
        }

        .stories-container .activ,
        .story:hover {
            transform: scale(1.05);
            transition: ease-in-out all .2s;
            box-shadow: rgb(38, 57, 77) 0px 20px 30px -10px;
        }

        .activ {
            transform: scale(1.05);
            transition: ease-in-out all .2s;
            box-shadow: 0 0 2rem rgba(0, 0, 0, .2);
        }

        .stories-container .socities_name {
            position: absolute;
            text-align: center;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 15px;
            font-size: 15px;
            font-family: "Roboto", sans-serif;
            font-weight: 500;
            color: black;
            background: white;
        }

        .stories-container .story img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            padding: 10px;
        }

        .stories-container .story:hover {
            cursor: pointer;
        }

        .stories-container .stories {
            display: flex;
            gap: 35px;
            flex-wrap: wrap;
        }

        .stories-container .inside_content {
            scroll-behavior: smooth;
        }

        .stories-container .inside_content::-webkit-scrollbar {
            display: none;
        }

        .box-title {
            text-align: center;
            color: black !important
        }

        .whitebox3 {
            background: whitesmoke;
            padding: 18px 25px 10px 25px;
            margin-bottom: 30px;
            border-radius: 4px;
        }

        .cards {
            width: 20%;
            height: auto;
            background-color: white;
            border-radius: 10px;
            margin-top: 100px;
            margin-left: 45px;
            border: 1px solid gray;
        }

        .card-wrapper {
            display: flex;
            justify-content: center;
            background: white;
            margin-left: 10px;
            margin-right: 10px;
        }

        .cards:hover {
            box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;
            cursor: pointer;
            border: 1px solid LightGray;
            transition: all 1s ease;
            transform: scale(1.03);
        }

        .image img {
            width: 100%;
            border-radius: 5px;
            height: 150px;
            object-fit: cover;

        }

        .title {
            text-align: center;
            color: black;
            font-size: 16px;
            font-weight: bold;
            font-family: Arial, Helvetica, sans-serif;
            padding: 10px
        }
        .head img {
            width: 20%;
        }

        .texts {
            margin-top: 105px;
        }

        .texts>h4 {
            font-size: 20px;
            font-family: 'georgia';
            letter-spacing: 0.5px;
        }

        h2 {
            position: relative;
            font-size: 20px;
            color: transparent;
            -webkit-text-stroke: 0.3vw transparent;
            text-transform: uppercase;
        }

        .check {
            margin-top: -28px;
            margin-right: 10px;
            margin-left: 10px;
            padding: 50px;
        }

        h2::before {
            position: absolute;
            top: 0;
            left: 0;
            width: 0%;
            height: 100%;
            color: #f2a225;
            -webkit-text-stroke: 0vw #383d52;
            border-right: 2px solid #f2a225;
            overflow: hidden;
            animation: animate 6s linear infinite;
        }

        #imag {
            width: 17%;
            position: absolute;
            left: 65%;
            top: 10px;
        }
        .high{
            font-size: 30px;
            color: #fcedd8;
            background: #0078bc;
            font-family: 'Niconne', cursive;
            font-weight: 600;
            margin-left: 80px;
            padding: 5px;
        }
    </style>

@stop

@section('content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 col-sm-12 col-xs-12">
                <div class="whitebox3">
                    <div class="check">
                        <h4 style="font-size: 21px; font-weight: 500; margin-top: 60px; margin-left: 80px;">𝐏𝐑𝐎𝐉𝐄𝐂𝐓𝐒</h4>
                    {{--    <span class="high">Highrise</span> --}}

                        <img src="images/building.jpg" id="imag">
                        <div class="stories-container">

                            <div class="inside_content">

                                <div class="stories-container">

                                    <div class="inside_content">

                                    </div>

                                    <div class="stories">

                                      <!-- 5 -->
                                        
                                            @foreach ($projects as $project)
                                                @php
                                                    $id = Crypt::encrypt($project->id);
                                                @endphp

                                                <div class="story  ">
                                                    <a href="#" onclick="callFunction('{{ $id }}')">
                                                        <img src="{{ asset('images/' . $project->image) }}">
                                                        <div class="socities_name">{{ $project->name }}</div>
                                                    </a>
                                                </div>
                                                
                                            @endforeach
                                       <!--  -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@stop
@section('js')
    <script>
        $(function() {

            // Order by the grouping
            $('#example tbody').on('click', 'tr.group', function() {
                var currentOrder = table.order()[0];
                if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                    table.order([2, 'desc']).draw();
                } else {
                    table.order([2, 'asc']).draw();
                }
            });
        });
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
        let card = document.querySelectorAll('.story')
        card.forEach(story => {
            story.addEventListener('click', function() {
                card.forEach(cd => cd.classList.remove('activ'));
                this.classList.add('activ');

            })
        })




        createStories();
        nextBtn.addEventListener("click", () => {
            storiesContent.scrollLeft += 300;
        });
        previousBtn.addEventListener("click", () => {
            storiesContent.scrollLeft -= 300;
        });
        storiesContent.addEventListener("scroll", () => {
            if (storiesContent.scrollLeft <= 24) {
                previousBtn.classList.remove("active");
            } else {
                previousBtn.classList.add("active");
            }


            let maxScrollValue = storiesContent.scrollWidth - storiesContent.clientWidth - 24;
            if (storiesContent.scrollLeft >= maxScrollValue) {
                nextBtn.classList.remove("active");
            } else {
                nextBtn.classList.add("active");
            }
        });

        // End Here
    </script>

    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
        // $("#postbutton").click(function() {

        function callFunction(val) {
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to switch the project.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, switch it!',
                cancelButtonText: 'No, cancel!',
            }).then(function(result) {
                if (result.value) {
                    $('.preloader').fadeIn();
                    $.ajax({
                        /* the route pointing to the post function */
                        url: '{{ route('projectswitch.create') }}',
                        type: 'POST',
                        /* send the csrf-token and the input to the controller */
                        data: {
                            _token: CSRF_TOKEN,
                            project: val
                        },
                        dataType: 'JSON',
                        /* remind that 'data' is the response of the AjaxController */
                        success: function(data) {

                            $('.preloader').fadeOut();
                            //  localStorage.setItem('project_id', data.session);
                            Swal.fire({

                                    icon: 'success',
                                    title: 'Your Project Switched Successfully!',
                                    confirmButtonColor: '#3085d6',

                                    confirmButtonText: 'ok!',
                                    showCancelButton: false,
                                    allowOutsideClick: false
                                })
                                .then((result) => {
                                    if (result.isConfirmed) {

                                        location.href = "{{ route('home') }}";

                                    }
                                });


                        },
                        error: function(xhr, status, error) {
                            // handle error response here
                            if (xhr.status == 422) {
                                var errors = xhr.responseJSON.errors;
                                //   console.log(errors);
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: 'Something went wrong!',

                                })

                            } else {
                                //   console.log(xhr.responseText);
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: 'Something went wrong!',

                                })
                            }
                        }
                    });
                } else {


                }
            });
        }
    </script>

@stop
